/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.br;

import com.aspose.imaging.IObjectWithBounds;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.br.cB;
import com.aspose.imaging.internal.kv.b;
import com.aspose.imaging.internal.ky.a;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.au;

public class bR
extends com.aspose.imaging.internal.ld.b
implements IPartialRawDataLoader {
    private final IPartialRawDataLoader a;
    private final RawDataSettings b;

    public bR(RasterImage rasterImage, Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        super(rasterImage, rectangle.Clone());
        if (rawDataSettings == null) {
            throw new ArgumentNullException("rawDataSettings");
        }
        this.a = iPartialRawDataLoader;
        this.b = rawDataSettings;
    }

    @Override
    public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
        if (byArray == null) {
            throw new ArgumentNullException("data");
        }
        if (Point.op_Inequality(point, rectangle.getLocation())) {
            throw new ArgumentOutOfRangeException("start", "Start point should correspond to rectangle location. Other values currently not supported.");
        }
        if (Point.op_Inequality(point2, new Point(rectangle.getRight(), rectangle.getBottom()))) {
            throw new ArgumentOutOfRangeException("end", "End point should correspond to rectangle right bottom point. Other values currently not supported.");
        }
        RawDataSettings rawDataSettings = this.b;
        int n2 = rectangle.getLeft() * rawDataSettings.getPixelDataFormat().getBitsPerPixel() / 8;
        int n3 = (rectangle.getRight() * rawDataSettings.getPixelDataFormat().getBitsPerPixel() - 1) / 8;
        int n4 = n3 - n2 + 1;
        if (rawDataSettings.getLineSize() < n4) {
            throw new ArgumentOutOfRangeException("rawDataSettings", aV.a(new String[]{"The line size for raw data settings is incorrect. Expected ", au.b(n4), " bytes at least."}));
        }
        int n5 = rawDataSettings.getLineSize() * rectangle.getHeight();
        if (rectangle.getHeight() == 1) {
            n5 = n4;
        }
        if (byArray.length < n5) {
            throw new ArgumentOutOfRangeException("data", aV.a(new String[]{"The raw data array cannot have less values than specified rectangle. Expected at least ", au.b(n5), " raw data values."}));
        }
        RasterImage rasterImage = this.e();
        a a2 = cB.a(rasterImage, rasterImage.hashCode() ^ cB.a.hashCode());
        if (a2 != null) {
            a2.a(this.e().getBounds(), byArray, rectangle, rawDataSettings);
        }
        Object t2 = rawDataSettings.copy();
        bR.a(t2);
        com.aspose.imaging.internal.kv.b.a(this).a((IObjectWithBounds)this, rectangle, byArray, (RawDataSettings)t2, a2);
        IPartialRawDataLoader iPartialRawDataLoader = this.a;
        while (iPartialRawDataLoader instanceof bR) {
            iPartialRawDataLoader = ((bR)iPartialRawDataLoader).a;
        }
        iPartialRawDataLoader.process(rectangle, byArray, point, point2);
    }

    @Override
    public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
        this.process(rectangle, byArray, point, point2);
    }
}

