/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.magicwand.imagemasks;

import com.aspose.imaging.Rectangle;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.magicwand.imagemasks.ImageMask;

public class RectangleMask
extends ImageMask {
    private final Rectangle a = new Rectangle();

    public RectangleMask(int n2, int n3, int n4, int n5) {
        super(n2 + n4, n3 + n5);
        this.a.setX(n2);
        this.a.setY(n3);
        this.a.setWidth(n4);
        this.a.setHeight(n5);
    }

    public RectangleMask(Rectangle rectangle) {
        super(rectangle.getRight(), rectangle.getBottom());
        rectangle.CloneTo(this.a);
    }

    @Override
    public Rectangle getSelectionBounds() {
        int n2 = Math.max(this.a.getX(), 0);
        int n3 = Math.max(this.a.getY(), 0);
        return new Rectangle(n2, n3, this.a.getRight() - n2, this.a.getBottom() - n3);
    }

    @Override
    public boolean get_Item(int n2, int n3) {
        if (n2 >= this.getWidth() || n2 < 0) {
            throw new ArgumentOutOfRangeException("x");
        }
        if (n3 >= this.getHeight() || n3 < 0) {
            throw new ArgumentOutOfRangeException("y");
        }
        return n2 < this.a.getRight() && n3 < this.a.getBottom() && n2 >= this.a.getLeft() && n3 >= this.a.getTop();
    }

    @Override
    public ImageMask inflate(int n2) {
        this.a.inflate(n2, n2);
        this.setWidth(this.a.getRight());
        this.setHeight(this.a.getBottom());
        return this;
    }

    @Override
    public ImageMask crop(Rectangle rectangle) {
        this.a.setX(this.a.getX() - rectangle.getX());
        this.a.setY(this.a.getY() - rectangle.getY());
        this.setWidth(rectangle.getWidth());
        this.setHeight(rectangle.getHeight());
        this.a.intersect(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        return this;
    }

    @Override
    public Object deepClone() {
        RectangleMask rectangleMask = new RectangleMask(this.a);
        rectangleMask.setSource(this.getSource());
        return rectangleMask;
    }
}

