/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.system.Threading.Tasks;

import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.system.Threading.ManualResetEvent;
import com.aspose.imaging.system.Threading.Tasks.ParallelLoopResult;
import com.aspose.imaging.system.Threading.Tasks.ParallelLoopState;
import com.aspose.imaging.system.Threading.Tasks.ParallelOptions;
import com.aspose.imaging.system.Threading.Tasks.a;
import com.aspose.imaging.system.Threading.Tasks.b;
import com.aspose.imaging.system.Threading.Tasks.c;
import com.aspose.imaging.system.Threading.Tasks.d;
import com.aspose.imaging.system.Threading.ThreadPool;
import com.aspose.imaging.system.Threading.WaitHandle;
import java.util.concurrent.atomic.AtomicLong;

public class Parallel {
    public static ParallelLoopResult forLoop(int fromInclusive, int toExclusive, com.aspose.imaging.internal.ns.a<Integer> body) {
        return Parallel.forLoop(fromInclusive, toExclusive, new ParallelOptions(), new a(body));
    }

    public static ParallelLoopResult forLoop(int fromInclusive, int toExclusive, Action2<Integer, ParallelLoopState> body) {
        return Parallel.forLoop(fromInclusive, toExclusive, new ParallelOptions(), body);
    }

    public static ParallelLoopResult forLoop(int fromInclusive, int toExclusive, ParallelOptions parallelOptions, Action2<Integer, ParallelLoopState> body) {
        if (body == null) {
            throw new ArgumentNullException("body");
        }
        ParallelLoopState parallelLoopState = new ParallelLoopState();
        AtomicLong atomicLong = new AtomicLong(toExclusive - fromInclusive);
        for (int i2 = fromInclusive; i2 < toExclusive && !parallelLoopState.isShouldExitCurrentIteration(); ++i2) {
            if (parallelOptions.getCancellationToken().isCancellationRequested()) {
                parallelLoopState.stop();
                atomicLong.addAndGet(toExclusive - i2);
                break;
            }
            Integer n2 = i2;
            ThreadPool.queueUserWorkItem(new b(parallelLoopState, body, n2, atomicLong));
        }
        do {
            Thread.yield();
        } while (atomicLong.get() > 0L && !parallelLoopState.isShouldExitCurrentIteration());
        if (parallelOptions.getCancellationToken().isCancellationRequested()) {
            WaitHandle.signalAndWait(parallelOptions.getCancellationToken().getWaitHandle(), new ManualResetEvent(true));
        }
        return new ParallelLoopResult(parallelLoopState.isShouldExitCurrentIteration(), parallelLoopState.getLowestBreakIteration());
    }

    public static <TSource> ParallelLoopResult forEach(Iterable<TSource> source, com.aspose.imaging.internal.ns.a<TSource> body) {
        return Parallel.forEach(source, new ParallelOptions(), new c(body));
    }

    public static <TSource> ParallelLoopResult forEach(Iterable<TSource> source, ParallelOptions parallelOptions, Action2<TSource, ParallelLoopState> body) {
        if (source == null) {
            throw new ArgumentNullException("source");
        }
        if (body == null) {
            throw new ArgumentNullException("body");
        }
        ParallelLoopState parallelLoopState = new ParallelLoopState();
        AtomicLong atomicLong = new AtomicLong();
        long l2 = 0L;
        for (TSource TSource : source) {
            if (parallelOptions.getCancellationToken().isCancellationRequested()) {
                parallelLoopState.stop();
                break;
            }
            Long l3 = l2;
            atomicLong.incrementAndGet();
            ThreadPool.queueUserWorkItem(new d(body, TSource, parallelLoopState, atomicLong, l3));
            ++l2;
        }
        do {
            Thread.yield();
        } while (atomicLong.get() > 0L && !parallelLoopState.isShouldExitCurrentIteration());
        if (parallelOptions.getCancellationToken().isCancellationRequested()) {
            WaitHandle.signalAndWait(parallelOptions.getCancellationToken().getWaitHandle(), new ManualResetEvent(true));
        }
        return new ParallelLoopResult(parallelLoopState.isShouldExitCurrentIteration(), parallelLoopState.getLowestBreakIteration());
    }

    public static interface Action2<T1, T2> {
        public void invoke(T1 var1, T2 var2);
    }
}

