/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.system.io;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.IO.DirectoryNotFoundException;
import com.aspose.imaging.internal.nH.d;
import com.aspose.imaging.internal.nH.k;
import com.aspose.imaging.internal.nH.u;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.of.l;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerable;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.system.io.StreamReader;
import com.aspose.imaging.system.io.StreamWriter;
import com.aspose.imaging.system.io.a;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class File {
    public static void appendAllText(String path, String contents) {
        StreamWriter streamWriter = new StreamWriter(path, true);
        try {
            ((u)streamWriter).write(contents);
        }
        finally {
            streamWriter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAllText(String path, String contents, l encoding) {
        StreamWriter streamWriter = new StreamWriter(path, true, encoding);
        try {
            ((u)streamWriter).write(contents);
        }
        finally {
            streamWriter.dispose();
        }
    }

    public static StreamWriter appendText(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        return new StreamWriter(path, true);
    }

    public static void copy(String sourceFileName, String destFileName) {
        File.copy(sourceFileName, destFileName, false);
    }

    public static void copy(String sourceFileName, String destFileName, boolean overwrite) {
        Object object;
        Object object2;
        if (sourceFileName == null) {
            throw new ArgumentNullException("sourceFileName");
        }
        if (destFileName == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (sourceFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "sourceFileName");
        }
        if (aV.c(sourceFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        if (destFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destFileName");
        }
        if (aV.c(destFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        java.io.File file = new java.io.File(sourceFileName);
        java.io.File file2 = new java.io.File(destFileName);
        if (!file.exists()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException("FileCopy: no such source file: " + sourceFileName, sourceFileName);
        }
        if (!file.isFile()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("FileCopy: can't copy directory: " + sourceFileName);
        }
        if (!file.canRead()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("FileCopy: source file is unreadable: " + sourceFileName);
        }
        if (sourceFileName.equals(destFileName)) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("Can't copy file to itsalf : " + sourceFileName);
        }
        if (file2.isDirectory()) {
            file2 = new java.io.File(file2, file.getName());
        }
        if (file2.exists()) {
            if (!overwrite) {
                throw new com.aspose.imaging.internal.Exceptions.IO.IOException("Destination file alresdy exist :" + file2.getAbsolutePath());
            }
        } else {
            object2 = file2.getParent();
            if (object2 == null) {
                object2 = System.getProperty("user.dir");
            }
            if (!((java.io.File)(object = new java.io.File((String)object2))).exists()) {
                throw new com.aspose.imaging.internal.Exceptions.IO.IOException("FileCopy: destination directory doesn't exist: " + (String)object2);
            }
            if (((java.io.File)object).isFile()) {
                throw new com.aspose.imaging.internal.Exceptions.IO.IOException("FileCopy: destination is not a directory: " + (String)object2);
            }
            if (!((java.io.File)object).canWrite()) {
                throw new com.aspose.imaging.internal.Exceptions.IO.IOException("FileCopy: destination directory is unwriteable: " + (String)object2);
            }
        }
        object2 = null;
        object = null;
        try {
            int n2;
            object2 = new FileInputStream(file);
            object = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n2 = ((FileInputStream)object2).read(byArray)) != -1) {
                ((FileOutputStream)object).write(byArray, 0, n2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException(iOException.getMessage());
        }
        finally {
            if (object2 != null) {
                try {
                    ((FileInputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
            if (object != null) {
                try {
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static FileStream create(String path) {
        return new FileStream(path, 2, 3);
    }

    public static StreamWriter createText(String path) {
        return new StreamWriter(path, false);
    }

    public static void delete(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (aV.c(path).length() == 0) {
            throw new ArgumentException("path");
        }
        String string = k.f(path);
        if (!aV.b(string) && !d.c(string)) {
            throw new DirectoryNotFoundException(aV.a("Could not find a part of the path \"{0}\".", new Object[]{path}));
        }
        java.io.File file = new java.io.File(path);
        if (file.isFile() && file.exists() && !file.delete()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("File was not deleted: " + path);
        }
    }

    public static boolean exists(String path) {
        boolean bl2;
        if (path == null || path.isEmpty()) {
            return false;
        }
        java.io.File file = new java.io.File(path);
        try {
            bl2 = file.isFile() && file.exists();
        }
        catch (SecurityException securityException) {
            return false;
        }
        return bl2;
    }

    public static void move(String sourceFileName, String destFileName) {
        if (sourceFileName == null) {
            throw new ArgumentNullException("sourceFileName");
        }
        if (destFileName == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (sourceFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "sourceFileName");
        }
        if (aV.c(sourceFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        if (destFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destFileName");
        }
        if (aV.c(destFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        java.io.File file = new java.io.File(sourceFileName);
        java.io.File file2 = new java.io.File(destFileName);
        if (!file.exists()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException("No such source file: " + sourceFileName, sourceFileName);
        }
        if (!file.isFile()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("Can't move directory: " + sourceFileName);
        }
        if (file2.exists()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("Such directory already exist: " + file2.getAbsolutePath());
        }
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("File was not moved");
        }
    }

    public static FileStream open(String path, int mode) {
        return new FileStream(path, mode, mode == 6 ? 2 : 3, 0);
    }

    public static FileStream open(String path, int mode, int access) {
        return new FileStream(path, mode, access, 0);
    }

    public static FileStream open(String path, int mode, int access, int share) {
        return new FileStream(path, mode, access, share);
    }

    public static FileStream openRead(String path) {
        return new FileStream(path, 3, 1, 1);
    }

    public static StreamReader openText(String path) {
        return new StreamReader(path);
    }

    public static FileStream openWrite(String path) {
        return new FileStream(path, 4, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String path) {
        FileStream fileStream = File.openRead(path);
        try {
            int n2;
            long l2 = fileStream.getLength();
            if (l2 > Integer.MAX_VALUE) {
                throw new com.aspose.imaging.internal.Exceptions.IO.IOException("Reading more than 2GB with this call is not supported");
            }
            int n3 = 0;
            byte[] byArray = new byte[(int)l2];
            for (int i2 = (int)l2; i2 > 0; i2 -= n2) {
                n2 = fileStream.read(byArray, n3, i2);
                if (n2 == 0) {
                    throw new com.aspose.imaging.internal.Exceptions.IO.IOException("Unexpected end of stream");
                }
                n3 += n2;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            fileStream.dispose();
        }
    }

    public static String[] readAllLines(String path) {
        StreamReader streamReader = File.openText(path);
        try {
            String[] stringArray = File.readAllLines(streamReader);
            return stringArray;
        }
        finally {
            streamReader.dispose();
        }
    }

    public static String[] readAllLines(String path, l encoding) {
        return new List<String>(File.readLines(path, encoding)).toArray((String[])new String[0]);
    }

    static String[] readAllLines(StreamReader reader) {
        List<String> list = new List<String>();
        while (!reader.getEndOfStream()) {
            list.addItem(reader.readLine());
        }
        return list.toArray(new String[0]);
    }

    public static String readAllText(String path) {
        StreamReader streamReader = new StreamReader(path);
        try {
            String string = streamReader.readToEnd();
            return string;
        }
        finally {
            streamReader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAllText(String path, l encoding) {
        StreamReader streamReader = new StreamReader(path, encoding);
        try {
            String string = streamReader.readToEnd();
            return string;
        }
        finally {
            streamReader.dispose();
        }
    }

    public static IGenericEnumerable<String> readLines(String path) {
        return File.readLines(path, l.x());
    }

    public static IGenericEnumerable<String> readLines(String path, l encoding) {
        return new a(path, encoding);
    }

    public static void replace(String sourceFileName, String destinationFileName, String destinationBackupFileName) {
        File.replace(sourceFileName, destinationFileName, destinationBackupFileName, false);
    }

    public static void replace(String sourceFileName, String destinationFileName, String destinationBackupFileName, boolean ignoreMetadataErrors) {
        if (sourceFileName == null) {
            throw new ArgumentNullException("sourceFileName");
        }
        if (destinationFileName == null) {
            throw new ArgumentNullException("destinationFileName");
        }
        if (aV.c(sourceFileName).length() == 0) {
            throw new ArgumentException("sourceFileName");
        }
        if (aV.c(destinationFileName).length() == 0) {
            throw new ArgumentException("destinationFileName");
        }
        java.io.File file = new java.io.File(sourceFileName);
        java.io.File file2 = new java.io.File(destinationFileName);
        java.io.File file3 = new java.io.File(destinationBackupFileName);
        if (file.isDirectory()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException(aV.a("{0} is a directory", new Object[]{sourceFileName}));
        }
        if (file2.isDirectory()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException(aV.a("{0} is a directory", new Object[]{destinationFileName}));
        }
        if (file3.isDirectory()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException(aV.a("{0} is a directory", new Object[]{destinationBackupFileName}));
        }
        if (!file.exists()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException(aV.a("{0} does not exist", new Object[]{sourceFileName}), sourceFileName);
        }
        if (!file2.exists()) {
            throw new com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException(aV.a("{0} does not exist", new Object[]{destinationFileName}), destinationFileName);
        }
        if (aV.e(file.getAbsolutePath(), file2.getAbsolutePath())) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException(aV.a("Source and destination arguments are the same file.", new Object[0]));
        }
        File.copy(destinationFileName, destinationBackupFileName);
        File.copy(sourceFileName, destinationFileName);
        File.delete(sourceFileName);
    }

    public static void writeAllBytes(String path, byte[] bytes) {
        FileStream fileStream = File.create(path);
        try {
            ((Stream)fileStream).write(bytes, 0, bytes.length);
        }
        finally {
            fileStream.dispose();
        }
    }

    public static void writeAllLines(String path, String[] contents) {
        File.writeAllLines(path, contents, l.y());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllLines(String path, String[] contents, l encoding) {
        StreamWriter streamWriter = new StreamWriter(path, false, encoding);
        try {
            for (String string : contents) {
                streamWriter.writeLine(string);
            }
        }
        finally {
            streamWriter.dispose();
        }
    }

    public static void writeAllLines(String path, IGenericEnumerable<String> contents) {
        File.writeAllLines(path, contents, l.y());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllLines(String path, IGenericEnumerable<String> contents, l encoding) {
        StreamWriter streamWriter = new StreamWriter(path, false, encoding);
        try {
            for (String string : contents) {
                streamWriter.writeLine(string);
            }
        }
        finally {
            streamWriter.dispose();
        }
    }

    public static void writeAllText(String path, String contents) {
        File.writeAllText(path, contents, l.y());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllText(String path, String contents, l encoding) {
        StreamWriter streamWriter = new StreamWriter(path, false, encoding);
        try {
            streamWriter.write(contents);
        }
        finally {
            streamWriter.dispose();
        }
    }
}

