/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IImageLoader;
import com.aspose.imaging.IImageLoaderDescriptor;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.extensions.FileFormatExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.br.aL;
import com.aspose.imaging.internal.br.ct;
import com.aspose.imaging.internal.br.cu;
import com.aspose.imaging.internal.kA.A;
import com.aspose.imaging.internal.kA.C;
import com.aspose.imaging.internal.kA.E;
import com.aspose.imaging.internal.kA.H;
import com.aspose.imaging.internal.kA.J;
import com.aspose.imaging.internal.kA.M;
import com.aspose.imaging.internal.kA.Q;
import com.aspose.imaging.internal.kA.S;
import com.aspose.imaging.internal.kA.U;
import com.aspose.imaging.internal.kA.Z;
import com.aspose.imaging.internal.kA.ab;
import com.aspose.imaging.internal.kA.c;
import com.aspose.imaging.internal.kA.e;
import com.aspose.imaging.internal.kA.g;
import com.aspose.imaging.internal.kA.i;
import com.aspose.imaging.internal.kA.k;
import com.aspose.imaging.internal.kA.m;
import com.aspose.imaging.internal.kA.o;
import com.aspose.imaging.internal.kA.q;
import com.aspose.imaging.internal.kA.s;
import com.aspose.imaging.internal.kA.u;
import com.aspose.imaging.internal.kA.w;
import com.aspose.imaging.internal.kA.y;
import com.aspose.imaging.internal.le.a;
import com.aspose.imaging.internal.le.b;
import com.aspose.imaging.internal.nj.aV;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericCollection;
import com.aspose.imaging.system.collections.Generic.KeyValuePair;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.collections.Generic.SortedList;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public final class ImageLoadersRegistry {
    private static volatile SortedList<Long, IImageLoaderDescriptor> a = new SortedList(24, new b());

    private ImageLoadersRegistry() {
    }

    public static long getRegisteredFormats() {
        long l2 = 0L;
        for (IImageLoaderDescriptor iImageLoaderDescriptor : a.getValues()) {
            l2 |= iImageLoaderDescriptor.getSupportedFormat();
        }
        return l2;
    }

    public static IImageLoaderDescriptor[] getRegisteredDescriptors() {
        IGenericCollection iGenericCollection = a.getValues();
        IImageLoaderDescriptor[] iImageLoaderDescriptorArray = new IImageLoaderDescriptor[iGenericCollection.size()];
        iGenericCollection.copyToTArray(iImageLoaderDescriptorArray, 0);
        return iImageLoaderDescriptorArray;
    }

    public static synchronized void register(IImageLoaderDescriptor iImageLoaderDescriptor) {
        if (iImageLoaderDescriptor == null) {
            throw new NullPointerException("imageLoaderDescriptor");
        }
        if (!a.containsKey(iImageLoaderDescriptor.getSupportedFormat())) {
            SortedList<Long, IImageLoaderDescriptor> sortedList = new SortedList<Long, IImageLoaderDescriptor>(a, new b());
            sortedList.addItem(iImageLoaderDescriptor.getSupportedFormat(), iImageLoaderDescriptor);
            a = sortedList;
        }
    }

    public static IImageLoaderDescriptor getFirstSupportedDescriptorByTypeName(String string) {
        IImageLoaderDescriptor iImageLoaderDescriptor = null;
        for (IImageLoaderDescriptor iImageLoaderDescriptor2 : a.getValues()) {
            if (!aV.e(iImageLoaderDescriptor2.getClass().getName(), string)) continue;
            iImageLoaderDescriptor = iImageLoaderDescriptor2;
        }
        return iImageLoaderDescriptor;
    }

    public static IImageLoaderDescriptor getFirstSupportedDescriptorByFileFormat(long l2) {
        Object[] objectArray = new IImageLoaderDescriptor[]{null};
        a.tryGetValue(l2, objectArray);
        return objectArray[0];
    }

    public static IImageLoaderDescriptor getFirstSupportedDescriptor(InputStream inputStream, LoadOptions loadOptions) {
        LoadOptions loadOptions2 = loadOptions;
        Stream stream = Stream.fromJava(inputStream);
        return ImageLoadersRegistry.a(stream, loadOptions2, true);
    }

    public static IImageLoaderDescriptor a(Stream stream, LoadOptions loadOptions) {
        return ImageLoadersRegistry.a(stream, loadOptions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageLoaderDescriptor a(Stream stream, LoadOptions loadOptions, boolean bl2) {
        if (loadOptions != null && loadOptions.getConcurrentImageProcessing()) {
            Object object;
            Object object2 = object = ct.a(stream);
            synchronized (object2) {
                return ImageLoadersRegistry.c(stream, loadOptions, bl2);
            }
        }
        return ImageLoadersRegistry.c(stream, loadOptions, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IImageLoaderDescriptor c(Stream stream, LoadOptions loadOptions, boolean bl2) {
        IImageLoaderDescriptor iImageLoaderDescriptor;
        block16: {
            IDisposable iDisposable;
            String string = null;
            ct[] ctArray = new ct[]{null};
            boolean bl3 = ct.a((Object)stream, ctArray);
            ct ct2 = ctArray[0];
            if (bl3 && ct2.b() instanceof FileStream && !ct2.c()) {
                iDisposable = (FileStream)ct2.b();
                string = com.aspose.imaging.internal.ny.k.e(((FileStream)iDisposable).getName());
                stream.seek(0L, 0);
            }
            iDisposable = new StreamContainer(stream);
            List<Long> list = com.aspose.imaging.internal.le.a.a(string);
            boolean bl4 = list != null && !list.isEmpty();
            try {
                IImageLoaderDescriptor iImageLoaderDescriptor2;
                LoadOptions loadOptions2 = loadOptions;
                IDisposable iDisposable2 = iDisposable;
                List<Long> list2 = list;
                if (list2 == null) {
                    iImageLoaderDescriptor2 = null;
                } else {
                    IImageLoaderDescriptor iImageLoaderDescriptor3 = null;
                    Iterator iterator = list2.iterator();
                    Object[] objectArray = new IImageLoaderDescriptor[]{null};
                    while (iterator.hasNext() && iImageLoaderDescriptor3 == null) {
                        boolean bl5 = a.tryGetValue((Long)iterator.next(), objectArray);
                        Object object = objectArray[0];
                        if (!bl5) continue;
                        iImageLoaderDescriptor3 = ImageLoadersRegistry.a((IImageLoaderDescriptor)object, (StreamContainer)iDisposable2, loadOptions2);
                    }
                    iImageLoaderDescriptor2 = iImageLoaderDescriptor = iImageLoaderDescriptor3;
                }
                if (iImageLoaderDescriptor != null) break block16;
                for (KeyValuePair keyValuePair : a) {
                    if (bl4 && list.contains(keyValuePair.getKey()) || (iImageLoaderDescriptor = ImageLoadersRegistry.a((IImageLoaderDescriptor)keyValuePair.getValue(), (StreamContainer)iDisposable, loadOptions)) == null) continue;
                    break;
                }
            }
            finally {
                Object object = ((StreamContainer)iDisposable).getSyncRoot();
                synchronized (object) {
                    if (!((StreamContainer)iDisposable).isStreamDisposedOnClose() && bl2) {
                        ctArray[0] = ct2;
                        boolean bl6 = ct.a(iDisposable, ctArray);
                        ct2 = ctArray[0];
                        if (bl6) {
                            cu.a().a(ct2);
                        }
                    }
                }
                ((StreamContainer)iDisposable).seekBegin();
                ((DisposableObject)iDisposable).close();
            }
        }
        return iImageLoaderDescriptor;
    }

    public static synchronized void a(java.util.List<IImageLoaderDescriptor> list) {
        SortedList<Long, IImageLoaderDescriptor> sortedList = new SortedList<Long, IImageLoaderDescriptor>(a, new b());
        boolean bl2 = false;
        for (IImageLoaderDescriptor iImageLoaderDescriptor : list) {
            if (sortedList.containsKey(iImageLoaderDescriptor.getSupportedFormat())) continue;
            sortedList.addItem(iImageLoaderDescriptor.getSupportedFormat(), iImageLoaderDescriptor);
            bl2 = true;
        }
        if (bl2) {
            a = sortedList;
        }
    }

    public static synchronized void b(java.util.List<IImageLoaderDescriptor> list) {
        boolean bl2 = false;
        SortedList<Long, IImageLoaderDescriptor> sortedList = new SortedList<Long, IImageLoaderDescriptor>(a, new b());
        for (IImageLoaderDescriptor iImageLoaderDescriptor : list) {
            if (iImageLoaderDescriptor == null) continue;
            bl2 |= sortedList.removeItemByKey(iImageLoaderDescriptor.getSupportedFormat());
        }
        if (bl2) {
            a = sortedList;
        }
    }

    public static IImageLoader a(long l2) {
        Object[] objectArray = new IImageLoaderDescriptor[]{null};
        a.tryGetValue(l2, objectArray);
        return objectArray[0] != null ? objectArray[0].createInstance() : null;
    }

    private static IImageLoaderDescriptor a(IImageLoaderDescriptor iImageLoaderDescriptor, StreamContainer streamContainer, LoadOptions loadOptions) {
        streamContainer.seekBegin();
        IImageLoaderDescriptor iImageLoaderDescriptor2 = null;
        if (iImageLoaderDescriptor instanceof aL) {
            aL aL2 = (aL)iImageLoaderDescriptor;
            iImageLoaderDescriptor2 = aL2.a(streamContainer, loadOptions);
        } else if (iImageLoaderDescriptor.canLoad(streamContainer, loadOptions)) {
            iImageLoaderDescriptor2 = iImageLoaderDescriptor;
        }
        return iImageLoaderDescriptor2;
    }

    private static IImageLoaderDescriptor a(java.util.List<Long> list, StreamContainer streamContainer, LoadOptions loadOptions) {
        if (list == null) {
            return null;
        }
        IImageLoaderDescriptor iImageLoaderDescriptor = null;
        Iterator<Long> iterator = list.iterator();
        Object[] objectArray = new IImageLoaderDescriptor[]{null};
        while (iterator.hasNext() && iImageLoaderDescriptor == null) {
            boolean bl2 = a.tryGetValue(iterator.next(), objectArray);
            Object object = objectArray[0];
            if (!bl2) continue;
            iImageLoaderDescriptor = ImageLoadersRegistry.a((IImageLoaderDescriptor)object, streamContainer, loadOptions);
        }
        return iImageLoaderDescriptor;
    }

    public static IImageLoader createFirstSupportedLoader(InputStream inputStream, LoadOptions loadOptions) {
        return ImageLoadersRegistry.b(Stream.fromJava(inputStream), loadOptions, true);
    }

    public static IImageLoader b(Stream stream, LoadOptions loadOptions, boolean bl2) {
        IImageLoader iImageLoader = null;
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, loadOptions, bl2);
        if (iImageLoaderDescriptor != null) {
            iImageLoader = iImageLoaderDescriptor.createInstance();
        }
        return iImageLoader;
    }

    public static void registerLoader(IImageLoaderDescriptor iImageLoaderDescriptor) {
        if (iImageLoaderDescriptor == null) {
            throw new NullPointerException("loaderDescriptor");
        }
        if (!FileFormatExtensions.isSingleFormatDefined(iImageLoaderDescriptor.getSupportedFormat())) {
            throw new ArgumentException("Loader should support only single file format.", "loaderDescriptor");
        }
        ImageLoadersRegistry.register(iImageLoaderDescriptor);
    }

    public static synchronized void unregisterLoader(IImageLoaderDescriptor iImageLoaderDescriptor) {
        SortedList<Long, IImageLoaderDescriptor> sortedList;
        if (iImageLoaderDescriptor == null) {
            throw new NullPointerException("loaderDescriptor");
        }
        int n2 = a.indexOfValue(iImageLoaderDescriptor);
        if (n2 >= 0 && (n2 = (sortedList = new SortedList<Long, IImageLoaderDescriptor>(a, new b())).indexOfValue(iImageLoaderDescriptor)) >= 0) {
            sortedList.removeAt(n2);
            a = sortedList;
        }
    }

    static {
        ArrayList<IImageLoaderDescriptor> arrayList = new ArrayList<IImageLoaderDescriptor>(31);
        arrayList.add(new Q());
        arrayList.add(new o());
        arrayList.add(new M());
        arrayList.add(new S());
        arrayList.add(new c());
        arrayList.add(new E());
        arrayList.add(new U());
        arrayList.add(new g());
        arrayList.add(new i());
        arrayList.add(new A());
        arrayList.add(new y());
        arrayList.add(new C());
        arrayList.add(new q());
        arrayList.add(new Z());
        arrayList.add(new u());
        arrayList.add(new s());
        arrayList.add(new w());
        arrayList.add(new ab());
        arrayList.add(new H());
        arrayList.add(new k());
        arrayList.add(new m());
        arrayList.add(new J());
        arrayList.add(new e());
        ImageLoadersRegistry.a(arrayList);
    }
}

