/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.PointF;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.SizeF;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.nj.aV;
import com.aspose.imaging.internal.nj.bE;
import com.aspose.imaging.internal.sm.i;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class RectangleF
extends i<RectangleF> {
    private float a;
    private float b;
    private float c;
    private float d;

    public RectangleF() {
        this.c = 0.0f;
        this.d = 0.0f;
        this.b = 0.0f;
        this.a = 0.0f;
    }

    public RectangleF(float f2, float f3, float f4, float f5) {
        this.c = f2;
        this.d = f3;
        this.b = f4;
        this.a = f5;
    }

    public RectangleF(PointF pointF, SizeF sizeF) {
        this.c = pointF.getX();
        this.d = pointF.getY();
        this.b = sizeF.getWidth();
        this.a = sizeF.getHeight();
    }

    public static RectangleF getEmpty() {
        return new RectangleF();
    }

    public PointF getLocation() {
        return new PointF(this.c, this.d);
    }

    public void setLocation(PointF pointF) {
        this.c = pointF.getX();
        this.d = pointF.getY();
    }

    public SizeF getSize() {
        return new SizeF(this.b, this.a);
    }

    public void setSize(SizeF sizeF) {
        this.b = sizeF.getWidth();
        this.a = sizeF.getHeight();
    }

    public float getX() {
        return this.c;
    }

    public void setX(float f2) {
        this.c = f2;
    }

    public float getY() {
        return this.d;
    }

    public void setY(float f2) {
        this.d = f2;
    }

    public float getWidth() {
        return this.b;
    }

    public void setWidth(float f2) {
        this.b = f2;
    }

    public float getHeight() {
        return this.a;
    }

    public void setHeight(float f2) {
        this.a = f2;
    }

    public float getLeft() {
        return this.c;
    }

    public void setLeft(float f2) {
        float f3 = f2 - this.c;
        this.c = f2;
        this.b -= f3;
    }

    public float getTop() {
        return this.d;
    }

    public void setTop(float f2) {
        float f3 = f2 - this.d;
        this.d = f2;
        this.a -= f3;
    }

    public float getRight() {
        return this.c + this.b;
    }

    public void setRight(float f2) {
        float f3 = f2 - this.getRight();
        this.b += f3;
    }

    public float getBottom() {
        return this.d + this.a;
    }

    public void setBottom(float f2) {
        float f3 = f2 - this.getBottom();
        this.a += f3;
    }

    public boolean isEmpty() {
        if (this.b > 0.0f) {
            return this.a <= 0.0f;
        }
        return true;
    }

    public final boolean a() {
        return this.a > 0.0f && this.b > 0.0f && (this.c + this.b > 0.0f || this.d + this.a > 0.0f);
    }

    public static RectangleF fromPoints(PointF pointF, PointF pointF2) {
        float f2 = bE.b(pointF.getX(), pointF2.getX());
        float f3 = bE.a(pointF.getX(), pointF2.getX());
        float f4 = bE.b(pointF.getY(), pointF2.getY());
        float f5 = bE.a(pointF.getY(), pointF2.getY());
        return RectangleF.fromLeftTopRightBottom(f2, f4, f3, f5);
    }

    public static RectangleF inflate(RectangleF rectangleF, float f2, float f3) {
        RectangleF rectangleF2 = rectangleF.Clone();
        rectangleF2.inflate(f2, f3);
        return rectangleF2;
    }

    public static RectangleF intersect(RectangleF rectangleF, RectangleF rectangleF2) {
        float f2 = bE.a(rectangleF.c, rectangleF2.c);
        float f3 = bE.b(rectangleF.c + rectangleF.b, rectangleF2.c + rectangleF2.b);
        float f4 = bE.a(rectangleF.d, rectangleF2.d);
        float f5 = bE.b(rectangleF.d + rectangleF.a, rectangleF2.d + rectangleF2.a);
        if (f3 >= f2 && f5 >= f4) {
            return new RectangleF(f2, f4, f3 - f2, f5 - f4);
        }
        return new RectangleF();
    }

    public static RectangleF union(RectangleF rectangleF, RectangleF rectangleF2) {
        float f2 = bE.b(rectangleF.c, rectangleF2.c);
        float f3 = bE.a(rectangleF.c + rectangleF.b, rectangleF2.c + rectangleF2.b);
        float f4 = bE.b(rectangleF.d, rectangleF2.d);
        float f5 = bE.a(rectangleF.d + rectangleF.a, rectangleF2.d + rectangleF2.a);
        return new RectangleF(f2, f4, f3 - f2, f5 - f4);
    }

    public static boolean op_Equality(RectangleF rectangleF, RectangleF rectangleF2) {
        return rectangleF.c == rectangleF2.c && rectangleF.d == rectangleF2.d && rectangleF.b == rectangleF2.b && rectangleF.a == rectangleF2.a;
    }

    public static boolean op_Inequality(RectangleF rectangleF, RectangleF rectangleF2) {
        return !RectangleF.op_Equality(rectangleF, rectangleF2);
    }

    public static RectangleF op_Multiply(RectangleF rectangleF, float f2) {
        return new RectangleF(rectangleF.c * f2, rectangleF.d * f2, rectangleF.b * f2, rectangleF.a * f2);
    }

    public static RectangleF op_Division(RectangleF rectangleF, float f2) {
        if (f2 == 0.0f) {
            throw new ArgumentOutOfRangeException("divider", "Division by zero is not allowed.");
        }
        return new RectangleF(rectangleF.c / f2, rectangleF.d / f2, rectangleF.b / f2, rectangleF.a / f2);
    }

    public static RectangleF to_RectangleF(Rectangle rectangle) {
        return new RectangleF(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static RectangleF fromLeftTopRightBottom(float f2, float f3, float f4, float f5) {
        return new RectangleF(f2, f3, f4 - f2, f5 - f3);
    }

    public void normalize() {
        if (this.b < 0.0f) {
            this.c += this.b;
            this.b = -this.b;
        }
        if (this.a < 0.0f) {
            this.d += this.a;
            this.a = -this.a;
        }
    }

    public boolean contains(float f2, float f3) {
        return this.c <= f2 && f2 < this.c + this.b && this.d <= f3 && f3 < this.d + this.a;
    }

    public boolean contains(PointF pointF) {
        return this.contains(pointF.getX(), pointF.getY());
    }

    public boolean contains(RectangleF rectangleF) {
        return this.c <= rectangleF.c && rectangleF.c + rectangleF.b <= this.c + this.b && this.d <= rectangleF.d && rectangleF.d + rectangleF.a <= this.d + this.a;
    }

    public void inflate(float f2, float f3) {
        this.c -= f2;
        this.d -= f3;
        this.b += 2.0f * f2;
        this.a += 2.0f * f3;
    }

    public void inflate(SizeF sizeF) {
        this.inflate(sizeF.getWidth(), sizeF.getHeight());
    }

    public void intersect(RectangleF rectangleF) {
        RectangleF rectangleF2 = RectangleF.intersect(rectangleF, this);
        this.c = rectangleF2.c;
        this.d = rectangleF2.d;
        this.b = rectangleF2.b;
        this.a = rectangleF2.a;
    }

    public boolean intersectsWith(RectangleF rectangleF) {
        return rectangleF.c < this.c + this.b && this.c < rectangleF.c + rectangleF.b && rectangleF.d < this.d + this.a && this.d < rectangleF.d + rectangleF.a;
    }

    public void offset(PointF pointF) {
        this.offset(pointF.getX(), pointF.getY());
    }

    public void offset(float f2, float f3) {
        this.c += f2;
        this.d += f3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RectangleF)) {
            return false;
        }
        RectangleF rectangleF = (RectangleF)object;
        return rectangleF.c == this.c && rectangleF.d == this.d && rectangleF.b == this.b && rectangleF.a == this.a;
    }

    public int hashCode() {
        return (int)((long)this.c ^ ((long)this.d << 13 | (long)this.d >> 19) ^ ((long)this.b << 26 | (long)this.b >> 6) ^ ((long)this.a << 7 | (long)this.a >> 25));
    }

    public String toString() {
        return aV.a(com.aspose.imaging.internal.nx.i.h(), "{{X={0}, Y={1}, Width={2}, Height={3}}}", Float.valueOf(this.c), Float.valueOf(this.d), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    @Override
    public void CloneTo(RectangleF rectangleF) {
        rectangleF.a = this.a;
        rectangleF.b = this.b;
        rectangleF.c = this.c;
        rectangleF.d = this.d;
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public static boolean isEquals(RectangleF rectangleF, RectangleF rectangleF2) {
        return rectangleF.equals(rectangleF2);
    }
}

