/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.EmbeddedImage;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImage;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.PageExportingAction;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.RemoveBackgroundSettings;
import com.aspose.imaging.VectorImage;
import com.aspose.imaging.internal.Exceptions.IndexOutOfRangeException;
import com.aspose.imaging.internal.kt.o;
import com.aspose.imaging.internal.mK.g;
import com.aspose.imaging.internal.mz.D;
import com.aspose.imaging.internal.mz.t;
import com.aspose.imaging.internal.mz.z;
import com.aspose.imaging.internal.sm.d;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import java.util.ArrayList;
import java.util.Collections;

public abstract class VectorMultipageImage
extends VectorImage
implements IMultipageImage {
    private PageExportingAction k;

    @Override
    public boolean isCached() {
        Image[] imageArray = this.getPages();
        return imageArray != null && imageArray.length > 0 && imageArray[0].isCached();
    }

    @Override
    public int getBitsPerPixel() {
        Image[] imageArray = this.getPages();
        return imageArray != null && imageArray.length > 0 ? imageArray[0].getBitsPerPixel() : 0;
    }

    @Override
    public int getWidth() {
        Image[] imageArray = this.getPages();
        return imageArray != null && imageArray.length > 0 ? imageArray[0].getWidth() : 0;
    }

    @Override
    public int getHeight() {
        Image[] imageArray = this.getPages();
        return imageArray != null && imageArray.length > 0 ? imageArray[0].getHeight() : 0;
    }

    @Deprecated
    public abstract Image getDefaultPage();

    @Override
    public PageExportingAction getPageExportingAction() {
        return this.k;
    }

    @Override
    public void setPageExportingAction(PageExportingAction pageExportingAction) {
        this.k = pageExportingAction;
    }

    @Override
    public D a(ImageOptionsBase imageOptionsBase, int n2, Rectangle rectangle) {
        if (this.getPageCount() == 0) {
            throw new IndexOutOfRangeException("Page with index 0 not found");
        }
        return this.getDefaultPage().a(imageOptionsBase, n2, rectangle);
    }

    @Override
    public void cacheData() {
        Image[] imageArray = this.getPages();
        if (imageArray != null && imageArray.length > 0) {
            imageArray[0].cacheData();
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        int n2 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n2; ++i2) {
            imageArray[i2].crop(rectangle);
        }
        this.widthF = rectangle.getWidth();
        this.heightF = rectangle.getHeight();
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        int n5 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n5; ++i2) {
            imageArray[i2].resize(n2, n3, n4);
        }
        this.widthF = n2;
        this.heightF = n3;
    }

    @Override
    public void rotate(float f2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n4; ++i2) {
            imageArray[i2].rotate(f2);
            n2 = Math.max(imageArray[i2].getWidth(), n2);
            n3 = Math.max(imageArray[i2].getHeight(), n3);
        }
        this.widthF = n2;
        this.heightF = n3;
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        int n4 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n4; ++i2) {
            imageArray[i2].resize(n2, n3, imageResizeSettings);
        }
    }

    @Override
    public void rotateFlip(int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n5; ++i2) {
            imageArray[i2].rotateFlip(n2);
            n3 = Math.max(imageArray[i2].getWidth(), n3);
            n4 = Math.max(imageArray[i2].getHeight(), n4);
        }
        this.widthF = n3;
        this.heightF = n4;
    }

    @Override
    public void removeBackground(RemoveBackgroundSettings removeBackgroundSettings) {
        for (Image image : this.getPages()) {
            VectorImage vectorImage = (VectorImage)((Object)com.aspose.imaging.internal.sm.d.a(image, VectorImage.class));
            if (vectorImage == null) continue;
            if (removeBackgroundSettings != null) {
                vectorImage.removeBackground(removeBackgroundSettings);
                continue;
            }
            vectorImage.removeBackground();
        }
        super.removeBackground();
    }

    @Override
    public void removeBackground() {
        this.removeBackground(null);
    }

    @Override
    public void setPalette(IColorPalette iColorPalette, boolean bl2) {
        int n2 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n2; ++i2) {
            imageArray[i2].setPalette(iColorPalette, bl2);
        }
    }

    @Override
    public void a(Object object) {
        super.a(object);
        Object object2 = this.j();
        for (Image image : this.getPages()) {
            image.a(object2);
        }
    }

    @Override
    public boolean a(o o2) {
        if (!super.a(o2)) {
            return false;
        }
        Image[] imageArray = this.getPages();
        if (imageArray == null) {
            return false;
        }
        for (Image image : imageArray) {
            image.a(o2);
        }
        return true;
    }

    @Override
    protected void saveData(Stream stream) {
        int n2 = this.getPageCount();
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n2; ++i2) {
            imageArray[i2].a(stream);
        }
    }

    @Override
    public Stream a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, int[] nArray) {
        t t2 = new t();
        for (Image image : this.getPages()) {
            D d2 = image.a(imageOptionsBase, 2, rectangle);
            t2.a(d2);
        }
        g g2 = new g();
        MemoryStream memoryStream = new MemoryStream(8096);
        g2.a(memoryStream, (z)t2);
        nArray[0] = -1;
        return memoryStream;
    }

    @Override
    public EmbeddedImage[] getEmbeddedImages() {
        int n2 = this.getPageCount();
        ArrayList arrayList = new ArrayList(n2);
        Image[] imageArray = this.getPages();
        for (int i2 = 0; i2 < n2; ++i2) {
            VectorImage vectorImage = (VectorImage)((Object)com.aspose.imaging.internal.sm.d.a(imageArray[i2], VectorImage.class));
            if (vectorImage == null) continue;
            Collections.addAll(arrayList, vectorImage.getEmbeddedImages());
        }
        return arrayList.toArray(new EmbeddedImage[0]);
    }

    @Override
    protected void releaseManagedResources() {
        this.k = null;
        Image[] imageArray = this.getPages();
        if (imageArray != null) {
            for (Image image : imageArray) {
                if (image == null) continue;
                image.dispose();
            }
        }
        super.releaseManagedResources();
    }

    @Override
    public void a(z z2, RectangleF rectangleF) {
        ((VectorImage)this.getPages()[0]).a(z2, rectangleF);
        super.a(z2, rectangleF);
    }
}

