/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.extensions;

import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.awt.GraphicsRenderer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.internal.br.aG;
import com.aspose.imaging.internal.br.aa;
import com.aspose.imaging.sources.StreamSource;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public final class ImageExtensions {
    private ImageExtensions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RasterImage fromJava(BufferedImage bufferedImage, Rectangle rectangle) {
        int[] nArray = bufferedImage.getRGB(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), null, 0, rectangle.getWidth());
        ImageOptionsBase imageOptionsBase = aa.a(16L, 2L, 8L);
        if (imageOptionsBase == null) {
            throw new FrameworkException("PNG/BMP/JPEG image are unsupported.");
        }
        imageOptionsBase.setSource(new StreamSource());
        RasterImage rasterImage = (RasterImage)Image.create(imageOptionsBase, rectangle.getWidth(), rectangle.getHeight());
        boolean bl2 = true;
        try {
            rasterImage.saveArgb32Pixels(new Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight()), nArray);
            bl2 = false;
        }
        finally {
            if (bl2) {
                rasterImage.close();
            }
        }
        return rasterImage;
    }

    public static RasterImage fromJava(BufferedImage bufferedImage) {
        return ImageExtensions.fromJava(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public static BufferedImage toJava(Image image) {
        return ImageExtensions.toJava(image, image.getBounds(), 2);
    }

    public static BufferedImage toJava(Image image, int n2) {
        return ImageExtensions.toJava(image, image.getBounds(), n2);
    }

    public static BufferedImage toJava(Image image, Rectangle rectangle) {
        return ImageExtensions.toJava(image, rectangle, 2);
    }

    public static RasterImage wrap(BufferedImage bufferedImage) {
        ImageOptionsBase imageOptionsBase = aa.a(16L, 2L, 8L, 0x1000000L, 32L);
        if (imageOptionsBase == null) {
            throw new FrameworkException("Non-raster images is unsupported.");
        }
        imageOptionsBase.setSource(new StreamSource());
        RasterImage rasterImage = (RasterImage)Image.create(imageOptionsBase, bufferedImage.getWidth(), bufferedImage.getHeight());
        rasterImage.a((IRasterImageArgb32PixelLoader)null);
        rasterImage.a(new a(bufferedImage));
        return rasterImage;
    }

    public static BufferedImage toJava(Image image, Rectangle rectangle, int n2) {
        if (image == null) {
            throw new NullPointerException("Parameter image must be not null!");
        }
        if (!(image instanceof RasterImage)) {
            ImageOptionsBase imageOptionsBase = aa.a(16L, 2L, 8L);
            if (imageOptionsBase == null) {
                throw new FrameworkException("Non-raster images is unsupported.");
            }
            ImageOptionsBase imageOptionsBase2 = image.getDefaultOptions(new Object[]{image.getBackgroundColor(), image.getWidth(), image.getHeight()});
            if (imageOptionsBase2 != null) {
                imageOptionsBase.setVectorRasterizationOptions(imageOptionsBase2.getVectorRasterizationOptions());
            }
            BufferedImage bufferedImage = new BufferedImage(rectangle.getWidth(), rectangle.getHeight(), n2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GraphicsRenderer graphicsRenderer = new GraphicsRenderer(image, imageOptionsBase);
            graphicsRenderer.render(graphics2D);
            graphicsRenderer.close();
            return bufferedImage;
        }
        RasterImage rasterImage = (RasterImage)image;
        BufferedImage bufferedImage = new BufferedImage(rectangle.getWidth(), rectangle.getHeight(), n2);
        b b2 = new b(bufferedImage);
        rasterImage.loadPartialArgb32Pixels(rectangle, b2);
        return bufferedImage;
    }

    public static BufferedImage toJava(Image image, Rectangle rectangle, BufferedImage bufferedImage) {
        if (image == null) {
            throw new NullPointerException("Parameter image must be not null!");
        }
        if (rectangle.isEmpty()) {
            rectangle = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        }
        if (!(image instanceof RasterImage)) {
            ImageOptionsBase imageOptionsBase = aa.a(16L, 2L, 8L);
            if (imageOptionsBase == null) {
                throw new FrameworkException("Non-raster images is unsupported.");
            }
            ImageOptionsBase imageOptionsBase2 = image.getDefaultOptions(new Object[]{image.getBackgroundColor(), image.getWidth(), image.getHeight()});
            if (imageOptionsBase2 != null) {
                imageOptionsBase.setVectorRasterizationOptions(imageOptionsBase2.getVectorRasterizationOptions());
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GraphicsRenderer graphicsRenderer = new GraphicsRenderer(image, imageOptionsBase);
            graphicsRenderer.render(graphics2D);
            graphicsRenderer.close();
            return bufferedImage;
        }
        RasterImage rasterImage = (RasterImage)image;
        b b2 = new b(bufferedImage);
        if (rectangle.getWidth() > bufferedImage.getWidth() || rectangle.getHeight() > bufferedImage.getHeight()) {
            rectangle.setWidth(bufferedImage.getWidth());
            rectangle.setHeight(bufferedImage.getHeight());
        }
        rasterImage.loadPartialArgb32Pixels(rectangle, b2);
        return bufferedImage;
    }

    private static class a
    implements IRasterImageArgb32PixelLoader,
    aG {
        private final BufferedImage a;
        private int[] b;

        public a(BufferedImage bufferedImage) {
            this.a = bufferedImage;
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            if (this.b != null && this.b.length < rectangle.getWidth() * rectangle.getHeight()) {
                this.b = null;
            }
            this.b = this.a.getRGB(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), this.b, 0, rectangle.getWidth());
            iPartialArgb32PixelLoader.process(rectangle, this.b, rectangle.getLocation(), new Point(rectangle.getRight(), rectangle.getBottom()));
        }

        @Override
        public boolean isRawDataAvailable() {
            return false;
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return null;
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void saveArgb32Pixels(Rectangle rectangle, int[] nArray) {
            this.a.setRGB(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), nArray, 0, rectangle.getWidth());
        }
    }

    static class b
    implements IPartialArgb32PixelLoader {
        private final BufferedImage a;

        public b(BufferedImage bufferedImage) {
            this.a = bufferedImage;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.a.getWidth();
            int n3 = this.a.getHeight();
            if (point.getY() == rectangle.getY() && point.getX() == rectangle.getX() && point2.getX() - point.getX() == n2 && point2.getY() - point.getY() == n3) {
                this.a.setRGB(0, 0, n2, n3, nArray, 0, n2);
            } else {
                int n4 = point.getX() - rectangle.getX();
                int n5 = point.getY() - rectangle.getY();
                n2 = point2.getX() - point.getX();
                n3 = point2.getY() - point.getY();
                this.a.setRGB(n4, n5, n2, n3, nArray, 0, n2);
            }
        }
    }
}

