/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.dicom;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.DicomImageException;
import com.aspose.imaging.fileformats.dicom.DicomImageInfo;
import com.aspose.imaging.fileformats.dicom.DicomPage;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.DicomOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aG.c;
import com.aspose.imaging.internal.aG.g;
import com.aspose.imaging.internal.cb.D;
import com.aspose.imaging.internal.dt.d;
import com.aspose.imaging.internal.kt.m;
import com.aspose.imaging.internal.kt.o;
import com.aspose.imaging.internal.nj.aV;
import com.aspose.imaging.internal.nj.au;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public final class DicomImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private static final String j = "pageIndex";
    private DicomImageInfo k = DicomImageInfo.a();
    private List<DicomPage> l;
    private DicomPage m;
    private DicomPage[] n;
    private com.aspose.imaging.internal.au.a o;

    public DicomImage(DicomOptions dicomOptions, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        DicomImage dicomImage = this;
        dicomImage.k = DicomImageInfo.a();
        dicomImage.k.e(n5);
        dicomImage.k.f(n4);
        dicomImage.k.h(1);
        dicomImage.m = DicomPage.a(dicomImage);
        dicomImage.m.setIndex_internalized(0);
        List<DicomPage> list = new List<DicomPage>();
        list.addItem(dicomImage.m);
        dicomImage.l = list;
        this.a(new a(this));
        this.a(DicomImage.class, com.aspose.imaging.internal.kt.m.c());
    }

    public DicomImage(InputStream inputStream, LoadOptions loadOptions) {
        this(Stream.fromJava(inputStream), loadOptions);
    }

    DicomImage(Stream stream, LoadOptions loadOptions) {
        this(new StreamContainer(stream), loadOptions);
    }

    public DicomImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    DicomImage(Stream stream) {
        this(stream, new LoadOptions());
    }

    private DicomImage(StreamContainer streamContainer, LoadOptions loadOptions) {
        if (loadOptions == null) {
            loadOptions = new LoadOptions();
        } else {
            this.a((Object)loadOptions);
        }
        this.a(new a(this));
        this.a(streamContainer);
        LoadOptions loadOptions2 = loadOptions;
        DicomImage dicomImage = this;
        if (dicomImage.getDataStreamContainer().a() == null) {
            throw new ArgumentNullException("The stream is null.");
        }
        dicomImage.k = DicomImageInfo.a();
        dicomImage.k.h(1);
        d d2 = new d(dicomImage.getDataStreamContainer().a(), dicomImage.k);
        d2.b();
        dicomImage.o = d2.a();
        int n2 = 1;
        if (dicomImage.k.getNumberOfFrames() > 0) {
            n2 = dicomImage.k.getNumberOfFrames();
        }
        dicomImage.l = new List(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dicomImage.l.addItem(new DicomPage(dicomImage, i2, loadOptions2));
        }
        dicomImage.m = dicomImage.l.get_Item(0);
        this.a((Object)loadOptions);
    }

    @Override
    public int getPageCount() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.k.getNumberOfFrames();
    }

    @Override
    public Image[] getPages() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getDicomPages();
    }

    @Override
    public Image s() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getActivePage();
    }

    public DicomImageInfo getFileInfo() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.k;
    }

    public DicomPage[] getDicomPages() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        if (this.n == null && this.l != null) {
            this.n = this.l.toArray((DicomPage[])new DicomPage[0]);
        }
        return this.n;
    }

    public DicomPage getActivePage() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.m;
    }

    public void setActivePage(DicomPage dicomPage) {
        this.verifyNotDisposed();
        if (dicomPage == null) {
            throw new ArgumentNullException("ActivePage");
        }
        if (dicomPage.getContainer() != this) {
            throw new DicomImageException("The active page cannot be set as it belongs to another image.");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        this.m = dicomPage;
    }

    public int getActivePageIndex() {
        this.verifyNotDisposed();
        DicomPage dicomPage = this.getActivePage();
        return dicomPage != null ? dicomPage.getIndex() : -1;
    }

    @Override
    public long getFileFormat() {
        return 8192L;
    }

    @Override
    public boolean hasAlpha() {
        return super.hasAlpha();
    }

    public com.aspose.imaging.internal.au.a A() {
        return this.o;
    }

    @Override
    public void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        DicomPage dicomPage = this.addPage();
        b b2 = new b(dicomPage);
        rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds(), b2);
    }

    public void saveAll(String string, ImageOptionsBase imageOptionsBase) {
        this.verifyNotDisposed();
        int n2 = 1;
        this.a(DicomImage.class, com.aspose.imaging.internal.kt.m.c());
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.save(aV.a(new String[]{au.b(n2), string}), imageOptionsBase);
        }
        this.b(this.getDataStreamContainer().a());
    }

    @Override
    public void setResolution(double d2, double d3) {
        throw new NotImplementedException("The method is not implemented");
    }

    public void resizeProportional(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        for (DicomPage dicomPage : this.getDicomPages()) {
            int n5 = com.aspose.imaging.internal.sm.d.e(d2 * (double)dicomPage.getWidth() + 0.5);
            int n6 = com.aspose.imaging.internal.sm.d.e(d3 * (double)dicomPage.getHeight() + 0.5);
            dicomPage.resize(n5, n6, n4);
        }
    }

    public DicomPage addPage() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        DicomPage dicomPage = DicomPage.a(this);
        dicomPage.setIndex_internalized(this.k.getNumberOfFrames());
        this.k.h(this.k.getNumberOfFrames() + 1);
        this.l.addItem(dicomPage);
        this.n = this.l.toArray((DicomPage[])new DicomPage[0]);
        return dicomPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicomPage insertPage(int n2) {
        this.verifyNotDisposed();
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException(j, "Page index is less than 0.");
        }
        if (n2 > this.getPageCount()) {
            throw new ArgumentOutOfRangeException(j, "Page index is greater than PageCount.");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        DicomPage dicomPage = DicomPage.a(this);
        this.l.insertItem(n2, dicomPage);
        int n3 = 0;
        IGenericEnumerator iGenericEnumerator = this.l.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                DicomPage dicomPage2 = (DicomPage)iGenericEnumerator.next();
                if (n3 >= n2) {
                    dicomPage2.setIndex_internalized(n3);
                }
                ++n3;
            }
        }
        finally {
            if (com.aspose.imaging.internal.sm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.k.h(this.k.getNumberOfFrames() + 1);
        this.n = this.l.toArray((DicomPage[])new DicomPage[0]);
        return dicomPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(int n2) {
        this.verifyNotDisposed();
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException(j, "Page index is less than 0.");
        }
        if (n2 >= this.getPageCount()) {
            throw new ArgumentOutOfRangeException(j, "Page index is equal to or greater than PageCount.");
        }
        int n3 = this.getActivePageIndex();
        this.l.get_Item(n2).dispose();
        this.l.removeAt(n2);
        this.k.h(this.k.getNumberOfFrames() - 1);
        int n4 = 0;
        IGenericEnumerator iGenericEnumerator = this.l.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                DicomPage dicomPage = (DicomPage)iGenericEnumerator.next();
                if (n4 >= n2) {
                    dicomPage.setIndex_internalized(n4);
                }
                ++n4;
            }
        }
        finally {
            if (com.aspose.imaging.internal.sm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        if (n3 == n2) {
            this.m = this.k.getNumberOfFrames() > 0 ? this.l.get_Item(0) : null;
        }
        this.n = this.l.toArray((DicomPage[])new DicomPage[0]);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        super.rotate(f2, bl2, color);
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        super.resize(n2, n3, n4);
    }

    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        super.resizeWidthProportionally(n2, n3);
    }

    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        super.resizeHeightProportionally(n2, n3);
    }

    @Override
    public void rotateFlip(int n2) {
        super.rotateFlip(n2);
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    @Override
    public void crop(Rectangle rectangle) {
        super.crop(rectangle);
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void binarizeFixed(byte by2) {
        super.binarizeFixed(by2);
    }

    @Override
    public void binarizeOtsu() {
        super.binarizeOtsu();
    }

    @Override
    public void binarizeBradley(double d2, int n2) {
        super.binarizeBradley(d2, n2);
    }

    @Override
    public void grayscale() {
        super.grayscale();
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        super.adjustGamma(f2, f3, f4);
    }

    @Override
    public void adjustBrightness(int n2) {
        super.adjustBrightness(n2);
    }

    @Override
    public void adjustContrast(float f2) {
        super.adjustContrast(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle, filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }

    @Override
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        super.a(stream, imageOptionsBase, rectangle);
    }

    @Override
    public void cacheData() {
        super.cacheData();
    }

    public static DicomImage a(StreamContainer streamContainer, LoadOptions loadOptions) {
        return new DicomImage(streamContainer, loadOptions);
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    @Override
    protected void a(Rectangle rectangle, int[] nArray) {
        this.verifyNotDisposed();
        DicomPage dicomPage = this.getActivePage();
        if (dicomPage == null) {
            return;
        }
        dicomPage.saveArgb32Pixels(rectangle, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        try (DicomOptions dicomOptions = com.aspose.imaging.internal.aD.b.a();){
            List<c> list = com.aspose.imaging.internal.aD.b.a(this.xmpData);
            List<c> list2 = new List<c>();
            if (!list.isEmpty()) {
                list2.addRange(list);
            }
            for (c object2 : this.getFileInfo().c()) {
                list2.addItem(object2);
            }
            g g2 = new g(stream, this.getBounds(), this.h(), dicomOptions, this.getPageCount(), list2);
            g2.a();
            D d2 = new D();
            int n2 = 0;
            for (DicomPage dicomPage : this.l) {
                d2.a(n2++, dicomPage);
                g2.a(dicomPage);
                d2.a();
                com.aspose.imaging.internal.kt.o.a(this.h, dicomPage.h);
            }
            g2.b();
        }
    }

    @Override
    protected void releaseManagedResources() {
        if (this.o != null) {
            this.o.dispose();
        }
        super.releaseManagedResources();
    }

    private void a(LoadOptions loadOptions) {
        if (this.getDataStreamContainer().a() == null) {
            throw new ArgumentNullException("The stream is null.");
        }
        this.k = DicomImageInfo.a();
        this.k.h(1);
        d d2 = new d(this.getDataStreamContainer().a(), this.k);
        d2.b();
        this.o = d2.a();
        int n2 = 1;
        if (this.k.getNumberOfFrames() > 0) {
            n2 = this.k.getNumberOfFrames();
        }
        this.l = new List(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.l.addItem(new DicomPage(this, i2, loadOptions));
        }
        this.m = this.l.get_Item(0);
    }

    private void a(int n2, int n3) {
        this.k = DicomImageInfo.a();
        this.k.e(n2);
        this.k.f(n3);
        this.k.h(1);
        this.m = DicomPage.a(this);
        this.m.setIndex_internalized(0);
        List<DicomPage> list = new List<DicomPage>();
        list.addItem(this.m);
        this.l = list;
    }

    private static final class b
    implements IPartialArgb32PixelLoader {
        private final DicomPage a;

        public b(DicomPage dicomPage) {
            this.a = dicomPage;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            this.a.saveArgb32Pixels(rectangle, nArray);
        }
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final WeakReference<DicomImage> a;

        public a(DicomImage dicomImage) {
            this.a = new WeakReference<DicomImage>(dicomImage);
        }

        @Override
        public final boolean isRawDataAvailable() {
            DicomImage dicomImage = (DicomImage)this.a.get();
            if (dicomImage == null) {
                return false;
            }
            DicomPage dicomPage = dicomImage.m;
            return dicomPage != null && dicomPage.isRawDataAvailable();
        }

        @Override
        public final RawDataSettings getRawDataSettings() {
            DicomImage dicomImage = (DicomImage)this.a.get();
            if (dicomImage == null) {
                return null;
            }
            DicomPage dicomPage = dicomImage.m;
            return dicomPage != null ? dicomPage.getRawDataSettings() : null;
        }

        @Override
        public final void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            DicomImage dicomImage = (DicomImage)this.a.get();
            if (dicomImage == null) {
                return;
            }
            dicomImage.verifyNotDisposed();
            DicomPage dicomPage = dicomImage.m;
            if (dicomPage == null) {
                return;
            }
            dicomPage.loadPartialArgb32Pixels(rectangle, iPartialArgb32PixelLoader);
        }

        @Override
        public final void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            DicomImage dicomImage = (DicomImage)this.a.get();
            if (dicomImage == null) {
                return;
            }
            dicomImage.verifyNotDisposed();
            DicomPage dicomPage = dicomImage.m;
            if (dicomPage == null) {
                return;
            }
            dicomPage.loadRawData(rectangle, rawDataSettings, iPartialRawDataLoader);
        }
    }
}

