/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IAdvancedBufferProcessor;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialArgb64PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.TiffImage;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.enums.TiffCompressions;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.pathresources.PathResource;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.imaging.imageoptions.TiffOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.br.aA;
import com.aspose.imaging.internal.br.aQ;
import com.aspose.imaging.internal.br.aw;
import com.aspose.imaging.internal.br.bB;
import com.aspose.imaging.internal.br.bQ;
import com.aspose.imaging.internal.br.bt;
import com.aspose.imaging.internal.br.bv;
import com.aspose.imaging.internal.br.cw;
import com.aspose.imaging.internal.br.m;
import com.aspose.imaging.internal.iG.e;
import com.aspose.imaging.internal.iG.f;
import com.aspose.imaging.internal.iG.h;
import com.aspose.imaging.internal.iH.o;
import com.aspose.imaging.internal.iH.r;
import com.aspose.imaging.internal.iH.v;
import com.aspose.imaging.internal.iK.d;
import com.aspose.imaging.internal.iS.g;
import com.aspose.imaging.internal.iS.j;
import com.aspose.imaging.internal.iS.k;
import com.aspose.imaging.internal.kO.i;
import com.aspose.imaging.internal.nj.aD;
import com.aspose.imaging.internal.nj.aV;
import com.aspose.imaging.internal.nj.bd;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class TiffFrame
extends RasterCachedImage
implements aA {
    private TiffOptions j;
    private int k;
    private int l;
    private final com.aspose.imaging.internal.jh.b m;

    public TiffFrame(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    TiffFrame(Stream stream) {
        this(stream, new TiffOptions(0));
    }

    public static TiffFrame g(Stream stream) {
        return new TiffFrame(stream);
    }

    public TiffFrame(InputStream inputStream, TiffOptions tiffOptions) {
        this(Stream.fromJava(inputStream), tiffOptions);
    }

    TiffFrame(Stream stream, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bQ(stream), tiffOptions);
    }

    public TiffFrame(String string) {
        this(string, new TiffOptions(0));
    }

    public TiffFrame(String string, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bQ(string), tiffOptions);
    }

    public TiffFrame(RasterImage rasterImage) {
        this(rasterImage, new TiffOptions(0));
    }

    public TiffFrame(RasterImage rasterImage, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bQ(rasterImage), tiffOptions);
    }

    public TiffFrame(TiffOptions tiffOptions, int n2, int n3) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.j = tiffOptions;
        this.l = n2;
        this.k = n3;
    }

    private TiffFrame(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.j = tiffOptions;
        this.l = n2;
        this.k = n3;
        if (iRasterImageArgb32PixelLoader != null) {
            this.setDataLoader(iRasterImageArgb32PixelLoader);
        }
    }

    private TiffFrame(TiffOptions tiffOptions) {
        this.setUseRawData(false);
        this.a(new com.aspose.imaging.internal.je.a(this));
        this.m = new com.aspose.imaging.internal.jh.b(tiffOptions);
    }

    @Override
    public Color getBackgroundColor() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getFrameOptions().f();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getFrameOptions().a(color);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public boolean hasAlpha() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        TiffOptions tiffOptions = this.getFrameOptions();
        return tiffOptions.isExtraSamplesPresent() && tiffOptions.getAlphaStorage() != 0;
    }

    @Override
    public boolean hasTransparentColor() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        TiffOptions tiffOptions = this.getFrameOptions();
        return tiffOptions.isExtraSamplesPresent() && tiffOptions.getAlphaStorage() == 1;
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getFrameOptions().getXmpData();
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.getFrameOptions().setXmpData(xmpPacketWrapper);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getFrameOptions().getBitsPerPixel();
    }

    public TiffOptions getFrameOptions() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.j;
    }

    @Override
    public int getHeight() {
        return this.k;
    }

    @Override
    public int getWidth() {
        return this.l;
    }

    @Override
    public ExifData getExifData() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getFrameOptions().getExifData();
    }

    @Override
    public void setExifData(ExifData exifData) {
        this.b(com.aspose.imaging.internal.kt.m.c());
        this.getFrameOptions().setExifData(exifData);
    }

    @Override
    public double getHorizontalResolution() {
        TiffRational tiffRational = null;
        if (this.j != null) {
            tiffRational = this.j.getXresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        if (this.j != null) {
            this.j.setXresolution(TiffRational.approximateFraction(d2));
        } else {
            super.setHorizontalResolution(d2);
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public double getVerticalResolution() {
        TiffRational tiffRational = null;
        if (this.j != null) {
            tiffRational = this.j.getYresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        return super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double d2) {
        if (this.j != null) {
            this.j.setYresolution(TiffRational.approximateFraction(d2));
        } else {
            super.setVerticalResolution(d2);
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public java.util.List<PathResource> getPathResources() {
        return List.toJava(this.s());
    }

    public List<PathResource> s() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.m.a();
    }

    public void setPathResources(java.util.List<PathResource> list) {
        this.a(List.fromJava(list));
    }

    public void a(List<PathResource> list) {
        this.b(com.aspose.imaging.internal.kt.m.c());
        this.m.a(list);
    }

    @Override
    public i h() {
        return this.getContainer() != null ? this.getContainer().h() : super.h();
    }

    @Override
    public void removeMetadata() {
        this.setExifData(null);
        super.removeMetadata();
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        return this.getFrameOptions();
    }

    public void alignResolutions() {
        TiffDataType tiffDataType = this.getFrameOptions().getTagByType(282);
        TiffDataType tiffDataType2 = this.getFrameOptions().getTagByType(283);
        if (tiffDataType != null && tiffDataType2 != null) {
            TiffRational[] tiffRationalArray = com.aspose.imaging.internal.sm.d.c(tiffDataType.getValue(), TiffRational[].class);
            TiffRational[] tiffRationalArray2 = com.aspose.imaging.internal.sm.d.c(tiffDataType2.getValue(), TiffRational[].class);
            TiffRational tiffRational = tiffRationalArray[0];
            TiffRational tiffRational2 = tiffRationalArray2[0];
            if ((tiffRational.getNominator() & 0xFFFFFFFFL) != (tiffRational2.getNominator() & 0xFFFFFFFFL) || (tiffRational.getDenominator() & 0xFFFFFFFFL) != (tiffRational2.getDenominator() & 0xFFFFFFFFL)) {
                if (tiffRational.getValue() > tiffRational2.getValue()) {
                    double d2 = tiffRational.getValueD() / tiffRational2.getValueD();
                    int n2 = com.aspose.imaging.internal.sm.d.e((double)this.k * d2);
                    this.resize(this.l, n2, 6);
                    tiffRationalArray2[0] = new TiffRational(tiffRational.getNominator(), tiffRational.getDenominator());
                } else {
                    double d3 = tiffRational2.getValueD() / tiffRational.getValueD();
                    int n3 = com.aspose.imaging.internal.sm.d.e((double)this.l * d3);
                    this.resize(n3, this.k, 6);
                    tiffRationalArray[0] = new TiffRational(tiffRational2.getNominator(), tiffRational2.getDenominator());
                }
                this.d(true);
            }
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public static TiffFrame copyFrame(TiffFrame tiffFrame) {
        Object object;
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        TiffOptions tiffOptions = (TiffOptions)((Object)com.aspose.imaging.internal.sm.d.a(tiffFrame.getFrameOptions().deepClone(), TiffOptions.class));
        i i2 = tiffFrame.getFrameOptions().b();
        if (i2 == null) {
            i2 = tiffFrame.h();
        }
        i i3 = com.aspose.imaging.internal.kO.i.a(i2);
        tiffOptions.a(i3);
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.l, tiffFrame.k);
        tiffFrame2.a(i3, false);
        tiffFrame2.a(tiffFrame.h);
        IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader = tiffFrame.getDataLoader();
        if (iRasterImageArgb32PixelLoader instanceof f) {
            object = (f)iRasterImageArgb32PixelLoader;
            f f2 = ((f)object).c();
            f2.a(tiffFrame2);
            tiffFrame2.setDataLoader(f2);
        } else {
            tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds(), new bB(tiffFrame2));
        }
        object = tiffFrame.getXmpData();
        if (object != null) {
            tiffFrame2.setXmpData(((XmpPacketWrapper)object).c());
        }
        tiffFrame.b(com.aspose.imaging.internal.kt.m.c());
        tiffFrame2.a(tiffFrame);
        return tiffFrame2;
    }

    public static TiffFrame createFrameFrom(TiffFrame tiffFrame, TiffOptions tiffOptions) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        i i2 = tiffOptions.b();
        if (i2 == null) {
            i2 = com.aspose.imaging.internal.kO.i.a(tiffFrame.h());
        }
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.l, tiffFrame.k);
        tiffFrame2.a(i2, false);
        tiffFrame2.a(tiffFrame.h);
        tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds(), new bB(tiffFrame2));
        tiffFrame.b(com.aspose.imaging.internal.kt.m.c());
        tiffFrame2.a(tiffFrame);
        return tiffFrame2;
    }

    public void A() {
        IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader = this.getDataLoader();
        if (iRasterImageArgb32PixelLoader instanceof f) {
            f f2 = (f)iRasterImageArgb32PixelLoader;
            f2.a((TiffOptions)((Object)com.aspose.imaging.internal.sm.d.a(this.getFrameOptions().deepClone(), TiffOptions.class)));
        }
    }

    public static TiffFrame a(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new TiffFrame(tiffOptions, n2, n3, iRasterImageArgb32PixelLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void a(RasterImage var0, TiffStreamWriter var1_1, boolean var2_2, TiffOptions var3_3, Rectangle var4_4) {
        var3_3 = (TiffOptions)var3_3.deepClone();
        try {
            block75: {
                var3_3.validate();
                if (var4_4.isEmpty()) {
                    var4_4 = var0.getBounds();
                }
                var5_5 = var4_4.getWidth();
                var3_3.setImageWidth(var5_5);
                var7_6 = var4_4.getHeight();
                var3_3.setImageLength(var7_6);
                var9_7 = var3_3.isTiled();
                if (var9_7) {
                    var10_8 = var3_3.getTileWidth();
                    var3_3.setTileWidth((var10_8 & 0xFFFFFFFFL) > 0L ? var10_8 : var5_5);
                    var12_10 = var3_3.getTileLength();
                    var3_3.setTileLength((var12_10 & 0xFFFFFFFFL) > 0L ? var12_10 : var7_6);
                    var3_3.setTileOffsets(new long[]{0L});
                    var3_3.setTileByteCounts(new long[]{0L});
                } else {
                    var10_8 = var3_3.getRowsPerStrip();
                    var3_3.setRowsPerStrip((var10_8 & 0xFFFFFFFFL) > 0L && (var10_8 & 0xFFFFFFFFL) <= (var7_6 & 0xFFFFFFFFL) ? var10_8 : var7_6);
                    var3_3.setStripByteCounts(new long[]{0L});
                    var3_3.setStripOffsets(new long[]{0L});
                }
                var10_9 = var3_3.getPhotometric();
                var11_12 = var3_3.getCompression();
                if (var11_12 == 7 || var11_12 == 6) {
                    if (com.aspose.imaging.internal.br.m.a(var0)) {
                        if (var9_7) {
                            var3_3.setTileWidth(var5_5);
                            var3_3.setTileLength(var7_6);
                        } else {
                            var3_3.setRowsPerStrip(var7_6);
                        }
                    }
                    if (!var3_3.isTagPresent(530)) {
                        if (var10_9 == 6) {
                            v0 = new int[2];
                            v0[0] = 2;
                            v1 = v0;
                            v0[1] = 2;
                        } else {
                            v2 = new int[2];
                            v2[0] = 1;
                            v1 = v2;
                            v2[1] = 1;
                        }
                        var3_3.setYCbCrSubsampling(v1);
                    }
                }
                if (var10_9 == 6 && !var3_3.isTagPresent(530)) {
                    var3_3.setYCbCrSubsampling(new int[]{2, 2});
                }
                if ((var36_13 = var3_3) == null) {
                    throw new ArgumentNullException("options");
                }
                switch (var36_13.getFileStandard()) {
                    case 0: {
                        var37_14 = new com.aspose.imaging.internal.iK.b(var36_13.isTiled());
                        break;
                    }
                    case 1: {
                        var37_14 = new d(var36_13.isTiled());
                        break;
                    }
                    default: {
                        var37_14 = new com.aspose.imaging.internal.iK.c();
                    }
                }
                var12_11 = var37_14;
                var38_15 = var4_4.Clone();
                var37_14 = var0;
                var36_13 = var3_3;
                if (var36_13 == null) {
                    throw new ArgumentNullException("options");
                }
                var39_16 /* !! */  = new v((RasterImage)var37_14, var36_13, var38_15);
                if (var36_13.getFileStandard() != 0) break block75;
                var41_17 = var36_13;
                if (var41_17 == null) {
                    throw new ArgumentNullException("options");
                }
                if (var41_17.getFileStandard() != 0) ** GOTO lbl-1000
                var42_18 = var41_17.getPhotometric();
                var43_19 = var41_17.getCompression();
                var44_20 = var41_17.getBitsPerSample();
                if (!(var42_18 != 0 && var42_18 != 1 || var43_19 != 1 && var43_19 != 32773 && var43_19 != 2 || var44_20.length != 1 || (var44_20[0] & 65535) != 1)) {
                    v3 = 1;
                } else if (!(var42_18 != 0 && var42_18 != 1 || var43_19 != 1 && var43_19 != 32773 || var44_20.length != 1 || (var44_20[0] & 65535) != 4 && (var44_20[0] & 65535) != 8)) {
                    v3 = 2;
                } else if (!(var42_18 != 3 || var43_19 != 1 && var43_19 != 32773 || var44_20.length != 1 || (var44_20[0] & 65535) != 4 && (var44_20[0] & 65535) != 8)) {
                    v3 = 3;
                } else if (var42_18 == 2 && (var43_19 == 1 || var43_19 == 32773) && var44_20.length >= 3 && (var44_20[0] & 65535) == 8 && (var44_20[1] & 65535) == 8 && (var44_20[2] & 65535) == 8 && (var41_17.getSamplesPerPixel() & 65535) >= 3 && var41_17.getColorMap() == null) {
                    v3 = 4;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = 0;
                }
                var40_21 = v3;
                switch (var40_21) {
                    case 1: {
                        var39_16 /* !! */  = new com.aspose.imaging.internal.iH.a((RasterImage)var37_14, var36_13, var38_15);
                        break;
                    }
                    case 2: {
                        var39_16 /* !! */  = new com.aspose.imaging.internal.iH.m((RasterImage)var37_14, var36_13, var38_15);
                        break;
                    }
                    case 3: {
                        var39_16 /* !! */  = new o((RasterImage)var37_14, var36_13, var38_15);
                        break;
                    }
                    case 4: {
                        var39_16 /* !! */  = new r((RasterImage)var37_14, var36_13, var38_15);
                        break;
                    }
                }
            }
            var13_22 = var39_16 /* !! */ ;
            var14_23 = new com.aspose.imaging.internal.iJ.a(var13_22, var12_11, true);
            var14_23.a(var3_3);
            var3_3.setTags(var13_22.a(false));
            var15_24 = aQ.a((Image)var0, var3_3);
            var16_25 = new h(var3_3.getTags(), var15_24, var3_3.isDisableIccExport(), true);
            var17_26 = var1_1.getPosition();
            var19_27 = var16_25.a(var1_1);
            var21_28 = new a(var3_3, var17_26 + var19_27 & 0xFFFFFFFFL, var1_1, var4_4.getWidth(), var4_4.getHeight(), var0.h(), var0.h);
            var22_29 = null;
            try {
                var23_30 = Rectangle.intersect(var4_4, var0.getBounds());
                var24_33 = var0.getBitsPerPixel() >= 48 && var3_3.getBitsPerPixel() >= 48;
                var25_34 = var24_33 != false ? new bv(var0, var4_4, var21_28, var3_3.e(), true) : new bt(var0, var4_4, var21_28, var3_3.e(), true);
                var26_35 = null;
                try {
                    if (var23_30.getWidth() > 0 && var23_30.getHeight() > 0) {
                        v4 = var27_37 = var0.isRawDataAvailable() != false && var0.getUseRawData() != false && var10_9 == 5 && var0.getRawDataFormat() != null && (PixelDataFormat.op_Equality(var0.getRawDataFormat(), PixelDataFormat.getCmyka()) != false || PixelDataFormat.op_Equality(var0.getRawDataFormat(), PixelDataFormat.getCmyk()) != false);
                        if (var27_37) {
                            var28_40 = new RawDataSettings();
                            var28_40.setPixelDataFormat(PixelDataFormat.getCmyk());
                            var28_40.setLineSize(var28_40.getPixelDataFormat().getChannelsCount() * var0.getWidth());
                            var29_41 = new b(var21_28, (RawDataSettings)var28_40);
                            var0.loadRawData(var0.getBounds(), (RawDataSettings)var28_40, var29_41);
                        } else {
                            var28_40 = (IPartialArgb32PixelLoader)var25_34;
                            if (var0.hasTransparentColor()) {
                                v5 = var28_40 = var24_33 != false ? new com.aspose.imaging.internal.hw.a(var0.getTransparentColor().toArgb(), var0.getBackgroundColor().toArgb(), (IPartialArgb32PixelLoader)var28_40) : new cw(var0.getTransparentColor().toArgb(), var0.getBackgroundColor().toArgb(), (IPartialArgb32PixelLoader)var28_40);
                            }
                            if (var0.hasAlpha() && var3_3.getAlphaStorage() == 0) {
                                v6 = var28_40 = var24_33 != false ? new com.aspose.imaging.internal.bw.b(var3_3.f().toArgb(), (IPartialArgb32PixelLoader)var28_40) : new com.aspose.imaging.internal.bw.c(var3_3.f().toArgb(), (IPartialArgb32PixelLoader)var28_40);
                            }
                            if (var24_33) {
                                var0.loadPartialArgb64Pixels(var23_30, (IPartialArgb64PixelLoader)com.aspose.imaging.internal.sm.d.a(var28_40, IPartialArgb64PixelLoader.class));
                            } else {
                                var0.a(var23_30, (IPartialArgb32PixelLoader)var28_40);
                            }
                        }
                    }
                    var25_34.b();
                }
                catch (Throwable var27_39) {
                    var26_35 = var27_39;
                    throw var27_39;
                }
                finally {
                    if (var25_34 != null) {
                        if (var26_35 != null) {
                            try {
                                var25_34.close();
                            }
                            catch (Throwable var27_38) {
                                var26_35.addSuppressed(var27_38);
                            }
                        } else {
                            var25_34.close();
                        }
                    }
                }
                var25_34 = new List<T>();
                if (var9_7) {
                    var3_3.setTileByteCounts(var21_28.b());
                    var3_3.setTileOffsets(var21_28.a());
                    var25_34.addItem(var3_3.getTagByType(322));
                    var25_34.addItem(var3_3.getTagByType(323));
                    var25_34.addItem(var3_3.getTagByType(325));
                    var25_34.addItem(var3_3.getTagByType(324));
                } else {
                    var3_3.setStripByteCounts(var21_28.b());
                    var3_3.setStripOffsets(var21_28.a());
                    var3_3.setRowsPerStrip(var21_28.c().c());
                    var25_34.addItem(var3_3.getTagByType(278));
                    var25_34.addItem(var3_3.getTagByType(279));
                    var25_34.addItem(var3_3.getTagByType(273));
                }
                if (var10_9 == 5 && var3_3.isTagPresent(317)) {
                    var26_35 = (TiffShortType)com.aspose.imaging.internal.sm.d.a(var3_3.getTagByType(317), TiffShortType.class);
                    var26_35.getValues()[0] = 1;
                    var25_34.addItem(var26_35);
                }
                if (var11_12 == 6) {
                    var3_3.setCompression(7);
                }
                var16_25.a((List<TiffDataType>)var25_34);
                var26_36 = var21_28.c().d();
                var28_40 = var1_1.getSyncRoot();
                synchronized (var28_40) {
                    var1_1.setPosition(var17_26);
                    var16_25.a(var1_1, var26_36, var2_2);
                }
            }
            catch (Throwable var23_32) {
                var22_29 = var23_32;
                throw var23_32;
            }
            finally {
                if (var21_28 != null) {
                    if (var22_29 != null) {
                        try {
                            var21_28.close();
                        }
                        catch (Throwable var23_31) {
                            var22_29.addSuppressed(var23_31);
                        }
                    } else {
                        var21_28.close();
                    }
                }
            }
        }
        finally {
            var3_3.close();
        }
    }

    @Override
    public void a(i i2, boolean bl2) {
        if (this.getContainer() != null) {
            throw new NotSupportedException("Setting a memory manager for an image-related frame is not allowed.");
        }
        super.a(i2, bl2);
    }

    @Override
    public IColorPalette t() {
        TiffOptions tiffOptions = this.getFrameOptions();
        IColorPalette iColorPalette = super.t();
        if (iColorPalette == null && tiffOptions != null) {
            return tiffOptions.getPalette();
        }
        return null;
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2 = super.a(iColorPalette);
        if (!bl2) {
            TiffOptions tiffOptions = this.getFrameOptions();
            boolean bl3 = bl2 = tiffOptions.getPalette() != null;
            if (bl2) {
                tiffOptions.setPalette(iColorPalette);
            }
        }
        return bl2;
    }

    private void B() {
        f f2 = (f)((Object)com.aspose.imaging.internal.sm.d.a(this.getDataLoader(), f.class));
        if (f2 != null) {
            f2.close();
        }
    }

    @Override
    protected void releaseReferences() {
        this.B();
        super.releaseReferences();
    }

    @Override
    protected void releaseManagedResources() {
        this.B();
        super.releaseManagedResources();
        this.j = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        TiffImage tiffImage = (TiffImage)((Object)com.aspose.imaging.internal.sm.d.a(this.getContainer(), TiffImage.class));
        int n2 = tiffImage == null ? 18761 : tiffImage.getByteOrder();
        bd bd2 = tiffImage == null ? com.aspose.imaging.internal.sm.d.a(TiffImage.class) : aD.b(tiffImage);
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            TiffStreamWriter tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, n2, bd2 != com.aspose.imaging.internal.sm.d.a(TiffImage.class));
            TiffFrame.a(this, tiffStreamWriter, true, this.j, this.getBounds());
        }
        finally {
            streamContainer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int n2, int n3, int n4) {
        try {
            Object object = this.c;
            synchronized (object) {
                try {
                    aw aw2 = this.a();
                    if (aw2 != null) {
                        aw2.a(n2, n3, n4);
                    } else {
                        this.a(n2, n3, n4);
                        this.b(com.aspose.imaging.internal.kt.m.c());
                    }
                    this.d(true);
                }
                finally {
                    this.d(true);
                }
            }
        }
        finally {
            this.c(true);
        }
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        aw aw2 = this.a();
        if (aw2 != null) {
            aw2.a(f2, bl2, color);
        } else {
            this.a(f2, bl2, color, false);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        if (this.a() != null) {
            this.a().a(rectangle.Clone());
        } else {
            this.a(rectangle.Clone());
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.l = n2;
        this.k = n3;
        this.d(true);
    }

    private void a(bQ bQ2, TiffOptions tiffOptions) {
        this.setDataLoader(bQ2);
        this.j = tiffOptions;
        this.l = bQ2.a().getWidth();
        this.k = bQ2.a().getHeight();
        this.setPalette(bQ2.a().getPalette());
        TiffImage tiffImage = (TiffImage)((Object)com.aspose.imaging.internal.sm.d.a(bQ2.a(), TiffImage.class));
        if (tiffImage != null) {
            this.setExifData(tiffImage.getExifData());
            this.xmpData = tiffImage.getXmpData();
            this.a(tiffImage.h);
        }
    }

    private void a(TiffFrame tiffFrame) {
        if (!com.aspose.imaging.internal.kt.o.a(this.h, tiffFrame.h)) {
            this.h = tiffFrame.h;
        }
    }

    private static class b
    implements IPartialRawDataLoader {
        private final a a;
        private final RawDataSettings b;

        public b(a a2, RawDataSettings rawDataSettings) {
            this.a = a2;
            this.b = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.process(rectangle, byArray, point, point2, null);
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            PixelDataFormat pixelDataFormat = this.b.getPixelDataFormat();
            if (!PixelDataFormat.op_Equality(pixelDataFormat, PixelDataFormat.getCmyk()) && !PixelDataFormat.op_Equality(pixelDataFormat, PixelDataFormat.getCmyka())) {
                throw new NotSupportedException(aV.a("PixelDataFormat {0} does not support raw data loading.", new Object[]{this.b.getPixelDataFormat()}));
            }
            this.a.a(rectangle, byArray, this.b);
        }
    }

    private static class a
    extends DisposableObject
    implements IPartialArgb64PixelLoader {
        private final c a;
        private e b;

        public a(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3, i i2, com.aspose.imaging.internal.kt.o o2) {
            e e2;
            com.aspose.imaging.internal.kt.o o3 = o2;
            i i3 = i2;
            int n4 = n3;
            int n5 = n2;
            TiffOptions tiffOptions2 = tiffOptions;
            switch (tiffOptions2.getCompression()) {
                case 1: {
                    e2 = new k(tiffOptions2, n5, n4);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    e2 = new com.aspose.imaging.internal.iS.f(tiffOptions2, n5, n4);
                    break;
                }
                case 5: {
                    com.aspose.imaging.internal.iS.i i4 = new com.aspose.imaging.internal.iS.i(tiffOptions2, n5, n4);
                    i4.c(tiffOptions2.getPredictor());
                    i4.e(tiffOptions2.getSamplesPerPixel() & 0xFFFF);
                    i4.a(tiffOptions2.getBitsPerSample()[0] & 0xFFFF);
                    i4.d(n5 * (tiffOptions2.getSamplesPerPixel() & 0xFFFF));
                    i4.b(8);
                    e2 = i4;
                    break;
                }
                case 8: 
                case 32946: {
                    g g2 = new g(tiffOptions2, n5, n4, true);
                    g2.c(tiffOptions2.getSamplesPerPixel() & 0xFFFF);
                    g2.a(tiffOptions2.getBitsPerSample()[0] & 0xFFFF);
                    g2.b(n5 * (tiffOptions2.getSamplesPerPixel() & 0xFFFF));
                    e2 = g2;
                    break;
                }
                case 6: 
                case 7: {
                    e2 = new com.aspose.imaging.internal.iS.h(tiffOptions2, n5, n4);
                    break;
                }
                case 32773: {
                    e2 = new j(tiffOptions2, n5, n4);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException(aV.a(new String[]{"Compression codec is not supported: ", TiffCompressions.toString(TiffCompressions.class, tiffOptions2.getCompression())}));
                }
            }
            e2.a(i3);
            e2.a(o3);
            this.b = e2;
            long l3 = tiffOptions.getRowsPerStrip();
            this.a = new c(tiffOptions, tiffStreamWriter, l2, (long)this.b.i() & 0xFFFFFFFFL, l3, this.b.j().getFillOrder() == 2);
        }

        public long[] a() {
            return this.a.a();
        }

        public long[] b() {
            return this.a.b();
        }

        public c c() {
            return this.a;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            try {
                this.b.a(nArray, rectangle, (IAdvancedBufferProcessor)this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        @Override
        public final void process64(Rectangle rectangle, long[] lArray, Point point, Point point2) {
            try {
                this.b.a(lArray, rectangle, (IAdvancedBufferProcessor)this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        public void a(Rectangle rectangle, byte[] byArray, RawDataSettings rawDataSettings) {
            try {
                this.b.a(byArray, rectangle, this.a, rawDataSettings);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        @Override
        protected void releaseManagedResources() {
            if (this.b != null) {
                this.b.dispose();
                this.b = null;
            }
            super.releaseManagedResources();
        }
    }

    private static class c
    implements com.aspose.imaging.internal.kn.a {
        private final TiffStreamWriter a;
        private final long b;
        private final long[] c;
        private final long[] d;
        private final long e;
        private final boolean f;
        private long g;
        private long h;
        private long i;
        private long j;

        public c(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            long l5;
            this.f = bl2;
            this.a = tiffStreamWriter;
            this.g = l2;
            if (tiffOptions.isTiled()) {
                this.b = tiffOptions.getTileLength();
                int n2 = com.aspose.imaging.internal.jd.f.a(tiffOptions.getImageWidth() & 0xFFFFFFFFL, tiffOptions.getTileWidth() & 0xFFFFFFFFL);
                int n3 = com.aspose.imaging.internal.jd.f.a(tiffOptions.getImageLength() & 0xFFFFFFFFL, tiffOptions.getTileLength() & 0xFFFFFFFFL);
                l5 = (long)n2 * (long)n3 & 0xFFFFFFFFL;
            } else {
                this.b = l4 = (l4 & 0xFFFFFFFFL) == 0L ? l3 : l4;
                l5 = (l3 & 0xFFFFFFFFL) / (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                if (((l3 & 0xFFFFFFFFL) % (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL) != 0L) {
                    ++l5;
                }
            }
            l5 = tiffOptions.getPlanarConfiguration() == 1 ? l5 : (l5 & 0xFFFFFFFFL) * (long)(tiffOptions.getSamplesPerPixel() & 0xFFFF) & 0xFFFFFFFFL;
            this.c = new long[(int)(l5 & 0xFFFFFFFFL)];
            this.d = new long[(int)(l5 & 0xFFFFFFFFL)];
            this.a()[0] = com.aspose.imaging.internal.sm.d.h(l2, 10);
            this.e = tiffOptions.isTiled() ? (long)com.aspose.imaging.internal.jd.f.d(l3 & 0xFFFFFFFFL, tiffOptions.getTileLength() & 0xFFFFFFFFL) & 0xFFFFFFFFL : l3;
        }

        public long[] a() {
            return this.c;
        }

        public long[] b() {
            return this.d;
        }

        public long c() {
            return this.b;
        }

        public long d() {
            return this.g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processBuffer(byte[] byArray, int n2) {
            if (this.f) {
                com.aspose.imaging.internal.iG.b.a(byArray, 0, n2);
            }
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setPosition(this.g);
                this.a.write(byArray, 0, n2);
            }
            this.g = this.g + (long)n2 & 0xFFFFFFFFL;
            this.j = (this.j & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void a(MemoryStream memoryStream) {
            int n2 = (int)memoryStream.getLength();
            if (this.f) {
                byte[] byArray = new byte[n2];
                memoryStream.read(byArray, 0, n2);
                com.aspose.imaging.internal.iG.b.a(byArray, 0, n2);
                Object object = this.a.getSyncRoot();
                synchronized (object) {
                    this.a.setPosition(this.g);
                    this.a.write(byArray, 0, n2);
                }
            }
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setPosition(this.g);
                this.a.a(memoryStream);
            }
            this.g += (long)n2;
            this.j = (this.j & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }

        @Override
        public void finishRow() {
            this.finishRows(1);
        }

        @Override
        public void finishRows(int n2) {
            this.h = (this.h & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            if (((this.h & 0xFFFFFFFFL) % (this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L || ((this.h & 0xFFFFFFFFL) % (this.e & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L) {
                this.d[(int)this.i++] = this.j;
                if ((this.i & 0xFFFFFFFFL) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }
    }
}

