/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.tiff.TiffFrame;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.TiffOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.br.aA;
import com.aspose.imaging.internal.cb.D;
import com.aspose.imaging.internal.kt.m;
import com.aspose.imaging.internal.kt.o;
import com.aspose.imaging.internal.nj.I;
import com.aspose.imaging.internal.nj.aD;
import com.aspose.imaging.internal.nj.g;
import com.aspose.imaging.internal.sm.d;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.Stream;
import java.lang.ref.WeakReference;

public class TiffImage
extends RasterCachedMultipageImage
implements IMultipageImageExt,
aA {
    private static final String j = "frame";
    private static final String k = "Frame belongs to other image";
    private final List<TiffFrame> l;
    private int m = 18761;
    private TiffFrame n;
    private TiffFrame[] o;

    public TiffImage(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException(j);
        }
        this.l = new List();
        this.addFrame(tiffFrame);
        this.m = tiffFrame.getFrameOptions().getByteOrder();
        this.setActiveFrame(tiffFrame);
        this.setDataLoader(new a(this));
        this.setUseRawData(false);
    }

    public TiffImage(TiffFrame[] tiffFrameArray) {
        if (tiffFrameArray == null) {
            throw new ArgumentNullException("frames");
        }
        this.l = new List();
        if (tiffFrameArray.length > 0) {
            this.addFrames(tiffFrameArray);
            this.setActiveFrame(tiffFrameArray[0]);
            this.m = this.getActiveFrame().getFrameOptions().getByteOrder();
        }
        this.setDataLoader(new a(this));
        this.setUseRawData(false);
    }

    @Override
    public long getFileFormat() {
        return 32L;
    }

    @Override
    public boolean getPremultiplyComponents() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getActiveFrame().getFrameOptions().getPremultiplyComponents();
    }

    @Override
    public void setPremultiplyComponents(boolean bl2) {
        TiffFrame tiffFrame = this.getActiveFrame();
        tiffFrame.getFrameOptions().setPremultiplyComponents(bl2);
        tiffFrame.A();
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public final int getByteOrder() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.m;
    }

    public final void setByteOrder(int n2) {
        this.verifyNotDisposed();
        this.m = n2;
        this.d(true);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public double getHorizontalResolution() {
        TiffRational tiffRational = this.getActiveFrame().getFrameOptions().getXresolution();
        if (tiffRational == null) {
            return super.getHorizontalResolution();
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        return tiffRational.getValue();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        TiffRational tiffRational = this.getActiveFrame().getFrameOptions().getYresolution();
        if (tiffRational == null) {
            this.setResolution(d2, super.getVerticalResolution());
        } else {
            this.setResolution(d2, tiffRational.getValue());
        }
        this.d(true);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public double getVerticalResolution() {
        TiffRational tiffRational = this.getActiveFrame().getFrameOptions().getYresolution();
        if (tiffRational == null) {
            return super.getVerticalResolution();
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        return tiffRational.getValue();
    }

    @Override
    public void setVerticalResolution(double d2) {
        TiffRational tiffRational = this.getActiveFrame().getFrameOptions().getXresolution();
        if (tiffRational == null) {
            this.setResolution(super.getHorizontalResolution(), d2);
        } else {
            this.setResolution(tiffRational.getValue(), d2);
        }
        this.d(true);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public final TiffFrame getActiveFrame() {
        this.verifyNotDisposed();
        if (this.n == null) {
            if (this.l.isEmpty()) {
                throw new TiffImageException("There is no active frame selected.");
            }
            this.n = this.l.get(0);
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.n;
    }

    public final void setActiveFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame != null && tiffFrame.getContainer() != this) {
            throw new TiffImageException("The active frame cannot be set as it belongs to another image.");
        }
        this.n = tiffFrame;
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public final TiffFrame[] getFrames() {
        this.verifyNotDisposed();
        if (this.l == null) {
            return new TiffFrame[0];
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        if (this.o == null) {
            this.o = this.l.toArray((TiffFrame[])new TiffFrame[0]);
        }
        return this.o;
    }

    @Override
    public final ExifData getExifData() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        TiffFrame tiffFrame = this.getActiveFrame();
        if (tiffFrame != null) {
            return tiffFrame.getExifData();
        }
        return null;
    }

    @Override
    public final void setExifData(ExifData exifData) {
        TiffFrame tiffFrame = this.getActiveFrame();
        if (tiffFrame != null) {
            tiffFrame.setExifData(exifData);
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public int getPageCount() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.l.size();
    }

    @Override
    public Image[] getPages() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getFrames();
    }

    @Override
    public Image s() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.getActiveFrame();
    }

    @Override
    public boolean hasAlpha() {
        return super.hasAlpha();
    }

    @Override
    public void removeMetadata() {
        for (TiffFrame tiffFrame : this.l) {
            tiffFrame.removeMetadata();
        }
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        TiffFrame tiffFrame = this.getActiveFrame();
        if (tiffFrame != null) {
            return tiffFrame.getFrameOptions();
        }
        throw new TiffImageException("There is no original options that can be extracted from image");
    }

    @Override
    public void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.addFrame(new TiffFrame(rasterImage));
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public final void alignResolutions() {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.alignResolutions();
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    public void setResolution(double d2, double d3) {
        TiffOptions tiffOptions = this.getActiveFrame().getFrameOptions();
        tiffOptions.setXresolution(new TiffRational(I.h(d2)));
        tiffOptions.setYresolution(new TiffRational(I.h(d3)));
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalizeAngle(boolean bl2, Color color) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.e();
                for (TiffFrame tiffFrame : this.l) {
                    tiffFrame.normalizeAngle(bl2, color);
                }
            }
            finally {
                this.f();
            }
        }
    }

    public final void addFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.kt.m.c());
        Image image = tiffFrame.getContainer();
        if (image == null || image == this) {
            if (tiffFrame.getContainer() == null) {
                tiffFrame.a(this.h(), false);
            }
        } else {
            throw new TiffImageException(k);
        }
        tiffFrame.a(this);
        this.l.addItem(tiffFrame);
        this.o = this.l.toArray((TiffFrame[])new TiffFrame[0]);
    }

    public final void add(TiffImage tiffImage) {
        this.b(com.aspose.imaging.internal.kt.m.c());
        int n2 = tiffImage.l.size();
        List<TiffFrame> list = new List<TiffFrame>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = tiffImage.l.get_Item(i2);
            if (tiffFrame == null) continue;
            TiffFrame tiffFrame2 = TiffFrame.copyFrame(tiffFrame);
            list.add(tiffFrame2);
        }
        if (!list.isEmpty()) {
            this.addFrames(list.toArray(new TiffFrame[0]));
        }
    }

    public final void addFrames(TiffFrame[] tiffFrameArray) {
        this.verifyNotDisposed();
        if (tiffFrameArray == null) {
            throw new TiffImageException("Frames parameter is null");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        for (TiffFrame tiffFrame : tiffFrameArray) {
            if (tiffFrame == null) {
                throw new TiffImageException("Frame is null or not TiffFrame type");
            }
            if (tiffFrame.getContainer() == this || tiffFrame.getContainer() == null) continue;
            throw new TiffImageException(k);
        }
        for (TiffFrame tiffFrame : tiffFrameArray) {
            tiffFrame.a(this);
        }
        this.l.addRange(com.aspose.imaging.internal.nj.g.a(tiffFrameArray));
        this.o = this.l.toArray((TiffFrame[])new TiffFrame[0]);
    }

    public final void insertFrame(int n2, TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new TiffImageException("Frame Is NULL");
        }
        Image image = tiffFrame.getContainer();
        if (image != this && image != null) {
            throw new TiffImageException(k);
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        if (this.l.size() <= n2 || n2 < 0) {
            throw new TiffImageException("Invalid index or Frame is null");
        }
        this.l.insertItem(n2, tiffFrame);
        tiffFrame.a(this);
        this.o = this.l.toArray((TiffFrame[])new TiffFrame[0]);
    }

    public final TiffFrame replaceFrame(int n2, TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new TiffImageException("Frame Is NULL");
        }
        if (tiffFrame.getContainer() != this && tiffFrame.getContainer() != null) {
            throw new TiffImageException(k);
        }
        if (this.l.size() <= n2 || n2 < 0) {
            throw new TiffImageException("Invalid index");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        tiffFrame.a(this);
        TiffFrame tiffFrame2 = this.l.get_Item(n2);
        this.l.removeAt(n2);
        this.l.insertItem(n2, tiffFrame);
        if (this.getActiveFrame() == tiffFrame2) {
            this.setActiveFrame(this.l.get_Item(0));
        }
        tiffFrame2.a(null);
        return tiffFrame2;
    }

    public final TiffFrame removeFrame(int n2) {
        TiffFrame tiffFrame;
        this.verifyNotDisposed();
        if (n2 >= 0 && n2 < this.l.size()) {
            tiffFrame = this.l.get_Item(n2);
            if (this.getActiveFrame() == tiffFrame) {
                throw new TiffImageException("Unable to remove current frame");
            }
            if (this.l.size() <= 1) {
                throw new TiffImageException("Unable to remove last frame");
            }
            this.l.removeAt(n2);
            this.o = this.l.toArray((TiffFrame[])new TiffFrame[0]);
        } else {
            throw new TiffImageException("Invalid index");
        }
        tiffFrame.a(null);
        this.b(com.aspose.imaging.internal.kt.m.c());
        return tiffFrame;
    }

    public final void removeFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new ArgumentNullException(j);
        }
        if (tiffFrame.getContainer() != this) {
            throw new ArgumentOutOfRangeException(j, "The frame does not belong to the current TIFF image.");
        }
        if (this.getActiveFrame() == tiffFrame) {
            throw new TiffImageException("Unable to remove current frame");
        }
        if (this.l.size() <= 1) {
            throw new TiffImageException("Unable to remove last frame");
        }
        this.l.removeItem(tiffFrame);
        tiffFrame.a(null);
        this.o = this.l.toArray((TiffFrame[])new TiffFrame[0]);
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public final void resizeProportional(int n2, int n3, int n4) {
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        for (TiffFrame tiffFrame : this.l) {
            int n5 = com.aspose.imaging.internal.sm.d.e(d2 * (double)tiffFrame.getWidth() + 0.5);
            int n6 = com.aspose.imaging.internal.sm.d.e(d3 * (double)tiffFrame.getHeight() + 0.5);
            tiffFrame.resize(n5, n6, n4);
        }
    }

    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        super.resizeWidthProportionally(n2, n3);
    }

    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        super.resizeHeightProportionally(n2, n3);
    }

    @Override
    public void rotateFlip(int n2) {
        super.rotateFlip(n2);
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    @Override
    public void crop(Rectangle rectangle) {
        super.crop(rectangle);
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void binarizeFixed(byte by2) {
        super.binarizeFixed(by2);
    }

    @Override
    public void binarizeOtsu() {
        super.binarizeOtsu();
    }

    @Override
    public void binarizeBradley(double d2, int n2) {
        super.binarizeBradley(d2, n2);
    }

    @Override
    public void grayscale() {
        super.grayscale();
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        super.adjustGamma(f2, f3, f4);
    }

    @Override
    public void adjustBrightness(int n2) {
        super.adjustBrightness(n2);
    }

    @Override
    public void adjustContrast(float f2) {
        super.adjustContrast(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle, filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }

    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        this.updateMetadata();
        try (StreamContainer streamContainer = new StreamContainer(stream);){
            TiffStreamWriter tiffStreamWriter;
            TiffFrame[] tiffFrameArray = this.getFrames();
            TiffFrame tiffFrame = this.getActiveFrame();
            if (tiffFrame != null) {
                this.m = tiffFrame.getFrameOptions().getByteOrder();
            } else if (tiffFrameArray.length > 0) {
                this.m = tiffFrameArray[tiffFrameArray.length - 1].getFrameOptions().getByteOrder();
            }
            boolean bl2 = aD.b(this) != com.aspose.imaging.internal.sm.d.a(TiffImage.class);
            TiffStreamWriter tiffStreamWriter2 = tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, this.m, bl2);
            TiffImage tiffImage = this;
            tiffImage.verifyNotDisposed();
            tiffStreamWriter2.setPosition(0L);
            tiffStreamWriter2.d();
            D d2 = new D();
            List<TiffFrame> list = tiffImage.l;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TiffFrame tiffFrame2 = (TiffFrame)list.get(i2);
                d2.a(i2, tiffFrame2);
                try (TiffOptions tiffOptions = (TiffOptions)((Object)com.aspose.imaging.internal.sm.d.a(tiffFrame2.getFrameOptions().deepClone(), TiffOptions.class));){
                    TiffFrame.a(tiffFrame2, tiffStreamWriter2, i2 == list.size() - 1, tiffOptions, tiffFrame2.getBounds());
                }
                d2.a();
            }
        }
    }

    @Override
    protected void releaseManagedResources() {
        this.l.clear();
        this.setActiveFrame(null);
        super.releaseManagedResources();
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    @Override
    public void a(Object object) {
        super.a(object);
        for (TiffFrame tiffFrame : this.l) {
            tiffFrame.a(object);
        }
    }

    @Override
    public boolean a(o o2) {
        if (!super.a(o2)) {
            return false;
        }
        if (this.l == null) {
            return false;
        }
        for (TiffFrame tiffFrame : this.l) {
            tiffFrame.a(o2);
        }
        return true;
    }

    private void a(TiffStreamWriter tiffStreamWriter) {
        this.verifyNotDisposed();
        tiffStreamWriter.setPosition(0L);
        tiffStreamWriter.d();
        D d2 = new D();
        List<TiffFrame> list = this.l;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = (TiffFrame)list.get(i2);
            d2.a(i2, tiffFrame);
            try (TiffOptions tiffOptions = (TiffOptions)((Object)com.aspose.imaging.internal.sm.d.a(tiffFrame.getFrameOptions().deepClone(), TiffOptions.class));){
                TiffFrame.a(tiffFrame, tiffStreamWriter, i2 == list.size() - 1, tiffOptions, tiffFrame.getBounds());
            }
            d2.a();
        }
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final WeakReference<TiffImage> a;

        public a(TiffImage tiffImage) {
            this.a = new WeakReference<TiffImage>(tiffImage);
        }

        @Override
        public final boolean isRawDataAvailable() {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                return tiffImage.getActiveFrame().isRawDataAvailable();
            }
            return false;
        }

        @Override
        public final RawDataSettings getRawDataSettings() {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                return tiffImage.getActiveFrame().getRawDataSettings();
            }
            return null;
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                tiffImage.verifyNotDisposed();
                tiffImage.getActiveFrame().loadPartialArgb32Pixels(rectangle, iPartialArgb32PixelLoader);
            }
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                tiffImage.verifyNotDisposed();
                tiffImage.getActiveFrame().loadRawData(rectangle, rawDataSettings, iPartialRawDataLoader);
            }
        }
    }
}

