/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.webp;

import com.aspose.imaging.Color;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IRasterImagePixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.fileformats.webp.IFrame;
import com.aspose.imaging.fileformats.webp.WebPFrameBlock;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.WebPOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NullReferenceException;
import com.aspose.imaging.internal.cb.D;
import com.aspose.imaging.internal.jn.d;
import com.aspose.imaging.internal.jn.g;
import com.aspose.imaging.internal.jo.a;
import com.aspose.imaging.internal.kO.i;
import com.aspose.imaging.internal.kP.f;
import com.aspose.imaging.internal.kt.m;
import com.aspose.imaging.internal.kt.o;
import com.aspose.imaging.internal.nk.p;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public final class WebPImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private final List<WebPFrameBlock> j = new List();
    private final WebPOptions k;
    private WebPFrameBlock l;
    private g m;

    public WebPImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    WebPImage(Stream stream) {
        this(stream, null);
    }

    public WebPImage(InputStream inputStream, LoadOptions loadOptions) {
        this(Stream.fromJava(inputStream), loadOptions);
    }

    WebPImage(Stream stream, LoadOptions loadOptions) {
        this(new WebPOptions(), loadOptions);
        this.d(stream, loadOptions);
        this.A();
    }

    public WebPImage(String string) {
        this(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebPImage(String string, LoadOptions loadOptions) {
        this(new WebPOptions(), loadOptions);
        try (FileStream fileStream = new FileStream(string, 3);){
            this.d(fileStream, loadOptions);
        }
        this.A();
    }

    public WebPImage(RasterImage rasterImage) {
        this(rasterImage, null);
    }

    public WebPImage(RasterImage rasterImage, LoadOptions loadOptions) {
        this(new WebPOptions(), loadOptions);
        WebPImage webPImage = (WebPImage)((Object)com.aspose.imaging.internal.sm.d.a(rasterImage, WebPImage.class));
        if (webPImage != null) {
            for (Image image : webPImage.getPages()) {
                RasterCachedImage rasterCachedImage = (RasterCachedImage)((Object)com.aspose.imaging.internal.sm.d.a(image, RasterCachedImage.class));
                if (rasterCachedImage == null) continue;
                this.addBlock(new WebPFrameBlock(rasterCachedImage));
            }
        } else {
            WebPFrameBlock webPFrameBlock = new WebPFrameBlock(rasterImage);
            this.addBlock(webPFrameBlock);
        }
        this.A();
    }

    public WebPImage(int n2, int n3, WebPOptions webPOptions) {
        this(n2, n3, webPOptions, null);
    }

    public WebPImage(int n2, int n3, WebPOptions webPOptions, LoadOptions loadOptions) {
        this(webPOptions, loadOptions);
        WebPFrameBlock webPFrameBlock = new WebPFrameBlock(n2, n3);
        this.addBlock(webPFrameBlock);
        this.A();
    }

    WebPImage(Stream stream, LoadOptions loadOptions, i i2) {
        this(new WebPOptions(), loadOptions);
        this.a(i2, true);
        this.d(stream, loadOptions);
        this.A();
    }

    private WebPImage(int n2, int n3, int n4, IRasterImagePixelLoader iRasterImagePixelLoader) {
        this(n2, n3, new WebPOptions());
    }

    private WebPImage(WebPOptions webPOptions, LoadOptions loadOptions) {
        WebPOptions webPOptions2 = webPOptions;
        if (webPOptions2 == null) {
            webPOptions2 = new WebPOptions();
        }
        this.k = webPOptions2;
        if (loadOptions != null) {
            this.a(loadOptions);
        }
    }

    public static WebPImage a(Stream stream, LoadOptions loadOptions, i i2) {
        return new WebPImage(stream, loadOptions, i2);
    }

    public static WebPImage a(int n2, int n3, int n4, IRasterImagePixelLoader iRasterImagePixelLoader) {
        return new WebPImage(n2, n3, n4, iRasterImagePixelLoader);
    }

    public WebPOptions getOptions() {
        return this.k;
    }

    @Override
    public Image[] getPages() {
        if (this.j == null) {
            return new WebPFrameBlock[0];
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.j.toArray((WebPFrameBlock[])new WebPFrameBlock[0]);
    }

    @Override
    public int getPageCount() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.j == null ? 0 : this.j.size();
    }

    @Override
    public Image s() {
        this.b(com.aspose.imaging.internal.kt.m.c());
        return this.l;
    }

    @Override
    public long getFileFormat() {
        return 2048L;
    }

    @Override
    public boolean hasAlpha() {
        return super.hasAlpha();
    }

    @Override
    public void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        if (rasterImage instanceof WebPFrameBlock) {
            this.addBlock((WebPFrameBlock)rasterImage);
        } else {
            this.addBlock(new WebPFrameBlock(rasterImage));
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public void addBlock(IFrame iFrame) {
        this.verifyNotDisposed();
        if (iFrame == null) {
            throw new ArgumentNullException("block");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.sm.d.a(iFrame, WebPFrameBlock.class));
        if (webPFrameBlock != null) {
            this.j.addItem(webPFrameBlock);
            webPFrameBlock.a(this);
        }
    }

    public void clearBlocks() {
        this.verifyNotDisposed();
        if (this.j != null) {
            this.j.clear();
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    public void insertBlock(int n2, IFrame iFrame) {
        this.verifyNotDisposed();
        if (iFrame == null) {
            throw new ArgumentNullException("block");
        }
        WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.sm.d.a(iFrame, WebPFrameBlock.class));
        if (webPFrameBlock != null && webPFrameBlock.getContainer() != null && webPFrameBlock.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this WebP image.");
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
        this.j.insertItem(n2, webPFrameBlock);
        if (webPFrameBlock != null) {
            webPFrameBlock.a(this);
        }
    }

    public void removeBlock(IFrame iFrame) {
        this.verifyNotDisposed();
        if (iFrame == null) {
            throw new ArgumentNullException("block");
        }
        WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.sm.d.a(iFrame, WebPFrameBlock.class));
        if (webPFrameBlock != null && webPFrameBlock.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.j.removeItem(webPFrameBlock);
        if (webPFrameBlock != null) {
            webPFrameBlock.a(null);
        }
        this.b(com.aspose.imaging.internal.kt.m.c());
    }

    @Override
    protected boolean c(int n2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        g g2 = this.m == null ? new g() : this.m;
        WebPOptions webPOptions = this.k;
        g2.a(webPOptions.getLossless());
        g2.a(this.getWidth());
        g2.b(this.getHeight());
        g2.f(this.getPageCount() > 1);
        g2.a(webPOptions.getQuality());
        g2.k(webPOptions.f());
        g2.a(webPOptions.g());
        g2.b(webPOptions.f() > 0);
        if (g2.b() || g2.f()) {
            g2.c(1448097880);
        }
        if (g2.f()) {
            g2.g((int)webPOptions.getAnimBackgroundColor());
            g2.a((short)webPOptions.getAnimLoopCount());
        }
        com.aspose.imaging.internal.jn.i i2 = new com.aspose.imaging.internal.jn.i(stream, g2, this.h());
        i2.c();
        int n2 = 0;
        DisposableObject disposableObject = null;
        IGenericEnumerator iGenericEnumerator = this.j.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                WebPFrameBlock webPFrameBlock = (WebPFrameBlock)iGenericEnumerator.next();
                if (webPFrameBlock == null) continue;
                D d2 = new D();
                d2.a(n2++, webPFrameBlock);
                try (a a2 = new a(this.h());){
                    a2.a((f)disposableObject);
                    a2.a(webPFrameBlock, false);
                    i2.a(a2);
                    disposableObject = a2.a();
                    a2.a((f)null);
                }
                d2.a();
                o.a(this.h, webPFrameBlock.h);
            }
        }
        finally {
            if (com.aspose.imaging.internal.sm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
            if (disposableObject != null) {
                disposableObject.close();
            }
        }
        i2.d();
    }

    @Override
    protected void releaseManagedResources() {
        super.releaseManagedResources();
        this.j.clear();
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    private void A() {
        if (this.j == null || this.j.isEmpty()) {
            throw new NullReferenceException("The image don't contain frames");
        }
        this.l = this.j.get_Item(0);
        this.setDataLoader(new d(this.l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(Stream stream, LoadOptions loadOptions) {
        DisposableObject disposableObject;
        g g2 = new g();
        p p2 = new com.aspose.imaging.internal.bc.a(stream, this, g2, loadOptions).iterator();
        try {
            while (p2.hasNext()) {
                disposableObject = (a)p2.next();
                WebPFrameBlock webPFrameBlock = new WebPFrameBlock((a)disposableObject);
                this.addBlock(webPFrameBlock);
                if (loadOptions != null) {
                    webPFrameBlock.a(loadOptions);
                }
                webPFrameBlock.cacheData();
            }
        }
        finally {
            if (com.aspose.imaging.internal.sm.d.a(p2, IDisposable.class) != false) {
                ((IDisposable)((Object)p2)).dispose();
            }
        }
        this.m = g2;
        disposableObject = this.k;
        ((WebPOptions)disposableObject).setAnimBackgroundColor((long)g2.q() & 0xFFFFFFFFL);
        ((WebPOptions)disposableObject).setAnimLoopCount(g2.r() & 0xFFFF);
        ((WebPOptions)disposableObject).setLossless(g2.a());
        ((WebPOptions)disposableObject).setQuality(g2.z());
        ((WebPOptions)disposableObject).a(g2.v());
        ((WebPOptions)disposableObject).a(g2.w());
        Image.a(this.d, stream);
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        super.rotate(f2, bl2, color.Clone());
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        super.resize(n2, n3, n4);
    }

    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        super.resizeWidthProportionally(n2, n3);
    }

    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        super.resizeHeightProportionally(n2, n3);
    }

    @Override
    public void rotateFlip(int n2) {
        super.rotateFlip(n2);
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    @Override
    public void crop(Rectangle rectangle) {
        super.crop(rectangle);
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void binarizeFixed(byte by2) {
        super.binarizeFixed(by2);
    }

    @Override
    public void binarizeOtsu() {
        super.binarizeOtsu();
    }

    @Override
    public void binarizeBradley(double d2, int n2) {
        super.binarizeBradley(d2, n2);
    }

    @Override
    public void grayscale() {
        super.grayscale();
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        super.adjustGamma(f2, f3, f4);
    }

    @Override
    public void adjustBrightness(int n2) {
        super.adjustBrightness(n2);
    }

    @Override
    public void adjustContrast(float f2) {
        super.adjustContrast(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle.Clone(), filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }
}

