/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.AsposeOCRException;
import com.aspose.ocr.CarPlateRecognitionSettings;
import com.aspose.ocr.DefectOutput;
import com.aspose.ocr.IDCardRecognitionSettings;
import com.aspose.ocr.InvoiceRecognitionSettings;
import com.aspose.ocr.License;
import com.aspose.ocr.Logging;
import com.aspose.ocr.OcrInput;
import com.aspose.ocr.OcrOutput;
import com.aspose.ocr.OcrSessionSingltone;
import com.aspose.ocr.PassportRecognitionSettings;
import com.aspose.ocr.PreprocessingFilter;
import com.aspose.ocr.ReceiptRecognitionSettings;
import com.aspose.ocr.RecognitionResult;
import com.aspose.ocr.RecognitionSettings;
import com.aspose.ocr.RectangleOutput;
import com.aspose.ocr.SpellCheck.SpellCheckLanguage;
import com.aspose.ocr.TableGrouper;
import com.aspose.ocr.a;
import com.aspose.ocr.ac;
import com.aspose.ocr.ad;
import com.aspose.ocr.ae;
import com.aspose.ocr.af;
import com.aspose.ocr.ag;
import com.aspose.ocr.ah;
import com.aspose.ocr.ai;
import com.aspose.ocr.aj;
import com.aspose.ocr.ak;
import com.aspose.ocr.al;
import com.aspose.ocr.ar;
import com.aspose.ocr.as;
import com.aspose.ocr.bs;
import com.aspose.ocr.e0cd0c1d77;
import com.aspose.ocr.e0cd0c6d17;
import com.aspose.ocr.e0cd0c6d55;
import com.aspose.ocr.e0cd0c6d66;
import com.aspose.ocr.e0cd0c7d77;
import com.aspose.ocr.edf;
import com.aspose.ocr.m;
import com.aspose.ocr.metered.MeteredHelper;
import com.aspose.ocr.models.AreasType;
import com.aspose.ocr.models.CharacterRecognitionResult;
import com.aspose.ocr.models.DefectType;
import com.aspose.ocr.models.DetectAreasMode;
import com.aspose.ocr.models.Format;
import com.aspose.ocr.models.Language;
import com.aspose.ocr.models.LanguageDetectionOutput;
import com.aspose.ocr.models.LayoutOutput;
import com.aspose.ocr.models.PdfOptimizationMode;
import com.aspose.ocr.models.RegionTypes;
import com.aspose.ocr.models.SkewOutput;
import com.aspose.ocr.t;
import com.aspose.ocr.z;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class AsposeOCR
implements AutoCloseable {
    private OcrSessionSingltone f = null;
    public static boolean DebugMode = false;
    public static String DebugModeSaveDirectory = "";

    public AsposeOCR() {
        try {
            ad.c0ad = ad.e0cd0c3d77();
            this.f = new OcrSessionSingltone();
        }
        catch (Exception exception) {
            ad.c0ad = "";
        }
    }

    public boolean ImageHasText(String string, String string2, RecognitionSettings recognitionSettings, boolean bl2) {
        af af2 = new af();
        String string3 = "";
        recognitionSettings = af2.f(recognitionSettings);
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            ac ac2 = new ac(this.f, recognitionSettings);
            af2.f(bufferedImage, recognitionSettings, ac2, false);
            RecognitionResult recognitionResult = af2.f(recognitionSettings, ac2);
            af2.c0ad();
            if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count(bufferedImage);
            }
            string3 = bl2 ? recognitionResult.recognitionText.toLowerCase() : recognitionResult.recognitionText;
            string2 = bl2 ? string2.toLowerCase() : string2;
        }
        catch (AsposeOCRException | IOException exception) {
            Logging.f(t.e0cd0c6d11);
        }
        return string3.contains(string2);
    }

    public boolean ImageHasText(String string, String string2, RecognitionSettings recognitionSettings) {
        return this.ImageHasText(string, string2, recognitionSettings, true);
    }

    public boolean ImageHasText(String string, String string2) {
        return this.ImageHasText(string, string2, new RecognitionSettings(), true);
    }

    public boolean ImageHasText(String string, Pattern pattern, RecognitionSettings recognitionSettings) {
        Object object;
        af af2 = new af();
        String string2 = "";
        recognitionSettings = af2.f(recognitionSettings);
        try {
            object = ImageIO.read(new File(string));
            ac ac2 = new ac(this.f, recognitionSettings);
            af2.f((BufferedImage)object, recognitionSettings, ac2, false);
            RecognitionResult recognitionResult = af2.f(recognitionSettings, ac2);
            af2.c0ad();
            if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count((BufferedImage)object);
            }
            string2 = recognitionResult.recognitionText;
        }
        catch (AsposeOCRException | IOException exception) {
            Logging.f(t.e0cd0c6d11);
        }
        object = pattern.matcher(string2);
        boolean bl2 = ((Matcher)object).find();
        return bl2;
    }

    public boolean ImageHasText(String string, Pattern pattern) {
        return this.ImageHasText(string, pattern, new RecognitionSettings());
    }

    public boolean CompareImageTexts(String string, String string2, RecognitionSettings recognitionSettings, boolean bl2) {
        float f2 = this.ImageTextDiff(string, string2, recognitionSettings, bl2);
        return (double)f2 > 0.9;
    }

    public boolean CompareImageTexts(String string, String string2, RecognitionSettings recognitionSettings) {
        return this.CompareImageTexts(string, string2, recognitionSettings, true);
    }

    public boolean CompareImageTexts(String string, String string2) {
        return this.CompareImageTexts(string, string2, new RecognitionSettings(), true);
    }

    public float ImageTextDiff(String string, String string2, RecognitionSettings recognitionSettings, boolean bl2) {
        af af2 = new af();
        String string3 = "";
        String string4 = "";
        recognitionSettings = af2.f(recognitionSettings);
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            ac ac2 = new ac(this.f, recognitionSettings);
            af2.f(bufferedImage, recognitionSettings, ac2, false);
            RecognitionResult recognitionResult = af2.f(recognitionSettings, ac2);
            af2.c0ad();
            string3 = bl2 ? recognitionResult.recognitionText.toLowerCase() : recognitionResult.recognitionText;
            bufferedImage = ImageIO.read(new File(string2));
            af2.f(bufferedImage, recognitionSettings, ac2, false);
            recognitionResult = af2.f(recognitionSettings, ac2);
            af2.c0ad();
            String string5 = string4 = bl2 ? recognitionResult.recognitionText.toLowerCase() : recognitionResult.recognitionText;
            if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count(bufferedImage);
            }
        }
        catch (AsposeOCRException | IOException exception) {
            Logging.f(t.e0cd0c6d11);
        }
        int n2 = Math.max(string3.length(), string4.length());
        int n3 = as.f(string3, string4, n2);
        return 1.0f - (float)n3 / (float)n2;
    }

    public float ImageTextDiff(String string, String string2, RecognitionSettings recognitionSettings) {
        return this.ImageTextDiff(string, string2, recognitionSettings, true);
    }

    public float ImageTextDiff(String string, String string2) {
        return this.ImageTextDiff(string, string2, new RecognitionSettings(), true);
    }

    public static void SaveMultipageDocument(String string, Format format, ArrayList<RecognitionResult> arrayList) {
        RecognitionResult.f(string, null, format, arrayList, null, PdfOptimizationMode.MAXIMUM_QUALITY);
    }

    public static void SaveMultipageDocument(String string, Format format, ArrayList<RecognitionResult> arrayList, String string2) {
        RecognitionResult.f(string, null, format, arrayList, string2, PdfOptimizationMode.MAXIMUM_QUALITY);
    }

    public static void SaveMultipageDocument(String string, Format format, ArrayList<RecognitionResult> arrayList, String string2, PdfOptimizationMode pdfOptimizationMode) {
        RecognitionResult.f(string, null, format, arrayList, string2, pdfOptimizationMode);
    }

    public static void SaveMultipageDocument(String string, Format format, ArrayList<RecognitionResult> arrayList, SpellCheckLanguage spellCheckLanguage) {
        RecognitionResult.f(string, null, format, arrayList, spellCheckLanguage, null, PdfOptimizationMode.MAXIMUM_QUALITY);
    }

    public static void SaveMultipageDocument(OutputStream outputStream, Format format, ArrayList<RecognitionResult> arrayList) {
        RecognitionResult.f(null, outputStream, format, arrayList, null, PdfOptimizationMode.MAXIMUM_QUALITY);
    }

    public static void SaveMultipageDocument(OutputStream outputStream, Format format, ArrayList<RecognitionResult> arrayList, String string) {
        RecognitionResult.f(null, outputStream, format, arrayList, string, PdfOptimizationMode.MAXIMUM_QUALITY);
    }

    public static void SaveMultipageDocument(OutputStream outputStream, Format format, ArrayList<RecognitionResult> arrayList, String string, PdfOptimizationMode pdfOptimizationMode) {
        RecognitionResult.f(null, outputStream, format, arrayList, string, pdfOptimizationMode);
    }

    public String CorrectSpelling(String string, SpellCheckLanguage spellCheckLanguage) {
        return ar.f(string, spellCheckLanguage);
    }

    public String CorrectSpelling(String string, SpellCheckLanguage spellCheckLanguage, String string2) {
        ar.f(string2);
        return ar.f(string, spellCheckLanguage);
    }

    public OcrOutput Recognize(OcrInput ocrInput, RecognitionSettings recognitionSettings) throws AsposeOCRException {
        ac ac2 = new ac(this.f, recognitionSettings);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new ag());
        ArrayList arrayList = ae2.f;
        if (recognitionSettings.e0cd0c6d18() == DetectAreasMode.TABLE) {
            for (RecognitionResult recognitionResult : arrayList) {
                List<String[]> list = TableGrouper.f(recognitionResult.recognitionLinesResult);
                recognitionResult.recognitionText = list.stream().map(stringArray -> String.join((CharSequence)"\t", stringArray)).collect(Collectors.joining("\n"));
                if (License.isValid()) continue;
                bs.f(recognitionResult);
            }
        }
        return new OcrOutput(ae2.f, ocrInput);
    }

    public OcrOutput Recognize(OcrInput ocrInput) throws AsposeOCRException {
        return this.Recognize(ocrInput, new RecognitionSettings());
    }

    public ArrayList<String> RecognizeFast(OcrInput ocrInput) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setLanguage(Language.ExtLatin);
        ac ac2 = new ac(this.f, recognitionSettings);
        ae ae2 = new ae();
        ae2.f(ocrInput, null, ac2, new ai());
        return ae2.f;
    }

    public OcrOutput RecognizeReceipt(OcrInput ocrInput, ReceiptRecognitionSettings receiptRecognitionSettings) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(receiptRecognitionSettings);
        ac ac2 = new ac(this.f, recognitionSettings);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new al());
        return new OcrOutput(ae2.f, ocrInput);
    }

    public OcrOutput RecognizeInvoice(OcrInput ocrInput, InvoiceRecognitionSettings invoiceRecognitionSettings) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(invoiceRecognitionSettings);
        ac ac2 = new ac(this.f, recognitionSettings);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new al());
        return new OcrOutput(ae2.f, ocrInput);
    }

    public OcrOutput RecognizeIDCard(OcrInput ocrInput, IDCardRecognitionSettings iDCardRecognitionSettings) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(iDCardRecognitionSettings);
        ac ac2 = new ac(this.f, recognitionSettings);
        ac2.e0cd0c6d14.add(PreprocessingFilter.Scale(2.0f));
        ac2.e0cd0c6d14.add(PreprocessingFilter.AutoSkew());
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new ag());
        return new OcrOutput(ae2.f, ocrInput);
    }

    public OcrOutput RecognizeCarPlate(OcrInput ocrInput, CarPlateRecognitionSettings carPlateRecognitionSettings) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(carPlateRecognitionSettings);
        ac ac2 = new ac(this.f, recognitionSettings);
        recognitionSettings.setThreadsCount(1);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new ah());
        return new OcrOutput(ae2.f, ocrInput);
    }

    public OcrOutput RecognizePassport(OcrInput ocrInput, PassportRecognitionSettings passportRecognitionSettings) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(passportRecognitionSettings);
        ac ac2 = new ac(this.f, recognitionSettings);
        recognitionSettings.setDetectAreasMode(DetectAreasMode.UNIVERSAL);
        recognitionSettings.setLanguage(Language.Latin);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new ak("RecognizePassport"));
        ArrayList<RecognitionResult> arrayList = ae2.f;
        z.f(arrayList, passportRecognitionSettings.getCountry());
        for (RecognitionResult recognitionResult : arrayList) {
            recognitionResult.recognitionText = "";
            recognitionResult.recognitionAreasRectangles.clear();
            recognitionResult.recognitionAreasText.clear();
            for (RecognitionResult.LinesResult linesResult : recognitionResult.recognitionLinesResult) {
                if (linesResult.textInLine == null) continue;
                recognitionResult.recognitionText = recognitionResult.recognitionText + linesResult.textInLine;
                recognitionResult.recognitionAreasRectangles.add(linesResult.line);
                recognitionResult.recognitionAreasText.add(linesResult.textInLine);
            }
            if (License.isValid()) continue;
            bs.f(recognitionResult);
        }
        return new OcrOutput(ae2.f, ocrInput);
    }

    public OcrOutput RecognizeHandwrittenText(OcrInput ocrInput) throws AsposeOCRException {
        ae ae2 = new ae();
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setThreadsCount(1);
        ac ac2 = new ac(this.f, recognitionSettings);
        ae2.f(ocrInput, recognitionSettings, ac2, new aj());
        return new OcrOutput(ae2.f, ocrInput);
    }

    public ArrayList<SkewOutput> CalculateSkew(OcrInput ocrInput) throws AsposeOCRException {
        ac ac2 = new ac(this.f, null);
        ae ae2 = new ae();
        ae2.f(ocrInput, null, ac2, new e0cd0c6d17());
        return ae2.f;
    }

    @Deprecated
    public ArrayList<RectangleOutput> DetectRectangles(OcrInput ocrInput, AreasType areasType, boolean bl2) throws AsposeOCRException {
        ac ac2 = new ac(this.f, null);
        ac2.e0cd0c6d11 = areasType;
        ac2.e0cd0c6d12 = bl2;
        ae ae2 = new ae();
        ae2.f(ocrInput, null, ac2, new e0cd0c1d77());
        return ae2.f;
    }

    public ArrayList<DefectOutput> DetectDefects(OcrInput ocrInput, DefectType defectType) throws AsposeOCRException {
        int n2 = 0;
        switch (defectType) {
            case SALT_PEPPER_NOISE: {
                n2 = 1;
                break;
            }
            case LOW_CONTRAST: {
                n2 = 2;
                break;
            }
            case BLUR: {
                n2 = 3;
                break;
            }
            case GLARE: {
                n2 = 4;
                break;
            }
            case ALL: {
                n2 = 9999;
            }
        }
        ac ac2 = new ac(this.f, null);
        ac2.e0cd0c6d13 = n2;
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setThreadsCount(1);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new e0cd0c6d55());
        return ae2.f;
    }

    public ArrayList<LanguageDetectionOutput> DetectLanguages(OcrInput ocrInput) throws AsposeOCRException {
        boolean bl2 = false;
        if (ocrInput.edf.c0ad.stream().anyMatch(preprocessingFilter -> preprocessingFilter instanceof edf)) {
            bl2 = true;
        } else {
            ocrInput.edf.add(PreprocessingFilter.AutoSkew());
        }
        ac ac2 = new ac(this.f, null);
        ae ae2 = new ae();
        ae2.f(ocrInput, null, ac2, new e0cd0c6d66());
        if (!bl2) {
            ocrInput.edf.ac8a();
        }
        return ae2.f;
    }

    public ArrayList<LayoutOutput> DetectDocumentLayout(OcrInput ocrInput) throws AsposeOCRException {
        boolean bl2 = false;
        if (ocrInput.edf.c0ad.stream().anyMatch(preprocessingFilter -> preprocessingFilter instanceof edf)) {
            bl2 = true;
        } else {
            ocrInput.edf.add(PreprocessingFilter.AutoSkew());
        }
        ac ac2 = new ac(this.f, null);
        ae ae2 = new ae();
        ae2.f(ocrInput, null, ac2, new e0cd0c7d77());
        if (!bl2) {
            ocrInput.edf.ac8a();
        }
        return ae2.f;
    }

    public ArrayList<CharacterRecognitionResult> RecognizeCharacters(OcrInput ocrInput, DetectAreasMode detectAreasMode, Language language) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setDetectAreasMode(detectAreasMode);
        recognitionSettings.setLanguage(language);
        ac ac2 = new ac(this.f, recognitionSettings);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new a());
        return ae2.f;
    }

    public ArrayList<CharacterRecognitionResult> RecognizeCharacters(OcrInput ocrInput) throws AsposeOCRException {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setDetectAreasMode(DetectAreasMode.UNIVERSAL);
        recognitionSettings.setLanguage(Language.ExtLatin);
        ac ac2 = new ac(this.f, recognitionSettings);
        ae ae2 = new ae();
        ae2.f(ocrInput, recognitionSettings, ac2, new a());
        return ae2.f;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void debugModeCheckAndExecute(BufferedImage bufferedImage, String string, List<Rectangle> list) {
        if (DebugMode) {
            if (DebugModeSaveDirectory.isEmpty()) {
                DebugModeSaveDirectory = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
            String string2 = Paths.get(DebugModeSaveDirectory, string).toString();
            try {
                if (list != null) {
                    BufferedImage bufferedImage2 = m.e0cd0c6d14(bufferedImage);
                    for (Rectangle rectangle : list) {
                        m.f(bufferedImage2, rectangle, Color.RED);
                    }
                    ImageIO.write((RenderedImage)bufferedImage2, "png", new File(string2));
                } else {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void debugModeCheckAndExecuteForResult(BufferedImage bufferedImage, String string, RecognitionResult recognitionResult) {
        if (DebugMode) {
            if (DebugModeSaveDirectory.isEmpty()) {
                DebugModeSaveDirectory = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
            String string2 = Paths.get(DebugModeSaveDirectory, string).toString();
            try {
                BufferedImage bufferedImage2 = m.e0cd0c6d14(bufferedImage);
                for (Rectangle rectangle : recognitionResult.recognitionLinesResult.stream().map(linesResult -> linesResult.line).collect(Collectors.toList())) {
                    m.f(bufferedImage2, rectangle, Color.RED);
                }
                ImageIO.write((RenderedImage)bufferedImage2, "png", new File(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void debugModeCheckAndDrawDsr(BufferedImage bufferedImage, int n2, ArrayList<Map.Entry<RegionTypes, Rectangle>> arrayList) {
        if (DebugMode) {
            if (DebugModeSaveDirectory.isEmpty()) {
                DebugModeSaveDirectory = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
            Map map = arrayList.stream().collect(Collectors.groupingBy(entry -> (RegionTypes)((Object)((Object)entry.getKey())), Collectors.mapping(entry -> (Rectangle)entry.getValue(), Collectors.toList())));
            for (Map.Entry entry2 : map.entrySet()) {
                String string = AsposeOCR.f(entry2.getKey().toString());
                String string2 = Paths.get(DebugModeSaveDirectory, string + n2 + ".png").toString();
                try {
                    BufferedImage bufferedImage2 = m.e0cd0c6d14(bufferedImage);
                    for (Object t2 : entry2.getValue()) {
                        m.f(bufferedImage2, (Rectangle)t2, Color.WHITE);
                    }
                    ImageIO.write((RenderedImage)bufferedImage2, "png", new File(string2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static String f(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }
}

