/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.System.Text;

import com.aspose.omr.System.Text.BaseCodePageEncoding;
import com.aspose.omr.System.Text.DBCSCodePageEncoding;
import com.aspose.omr.System.Text.EUCJPEncoding;
import com.aspose.omr.System.Text.Encoding;
import com.aspose.omr.System.Text.EncodingNLSCP;
import com.aspose.omr.System.Text.EncodingProvider;
import com.aspose.omr.System.Text.EncodingTableCP;
import com.aspose.omr.System.Text.GB18030Encoding;
import com.aspose.omr.System.Text.ISCIIEncoding;
import com.aspose.omr.System.Text.ISO2022Encoding;
import com.aspose.omr.System.Text.SBCSCodePageEncoding;
import com.aspose.omr.l9y.lf;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CodePagesEncodingProvider
extends EncodingProvider {
    private static final EncodingProvider lI = new CodePagesEncodingProvider();
    private lf<Integer, Encoding> lf = new lf();
    private ReentrantReadWriteLock lj = new ReentrantReadWriteLock();
    private static final int lt = 57006;
    private static final int lb = 57003;
    private static final int ld = 57002;
    private static final int lu = 57010;
    private static final int le = 57008;
    private static final int lh = 57009;
    private static final int lk = 57007;
    private static final int lv = 57011;
    private static final int lc = 57004;
    private static final int ly = 57005;
    private static final int l0if = 50225;
    private static final int l0l = 52936;
    private static final int l0t = 50220;
    private static final int l0v = 50221;
    private static final int l0p = 50222;
    private static final int l0u = 50227;
    private static final int l0j = 51932;
    private static final int l0h = 10008;
    private static final int l0y = 10003;
    private static final int l0n = 20936;
    private static final int l0k = 20949;
    private static final int l0f = 54936;
    private static final int l1if = 51936;
    private static final int l1l = 51949;
    private static final int l1t = 936;
    private static final int l1v = 38598;
    private static final int l1p = 28598;

    public static EncodingProvider lI() {
        return lI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Encoding lI(int n) {
        if (n < 0 || n > 65535) {
            return null;
        }
        if (n == 0) {
            int n2 = CodePagesEncodingProvider.lf();
            return n2 != 0 ? this.lI(n2) : null;
        }
        Object object = null;
        this.lj.readLock().lock();
        try {
            Object[] objectArray = new Encoding[]{object};
            boolean bl = this.lf.lI((Integer)n, objectArray);
            object = objectArray[0];
            if (bl) {
                Object object2 = object;
                return object2;
            }
            int n3 = BaseCodePageEncoding.lj(n);
            if (n3 == 1) {
                object = new SBCSCodePageEncoding(n);
            } else if (n3 == 2) {
                object = new DBCSCodePageEncoding(n);
            } else {
                object = CodePagesEncodingProvider.lj(n);
                if (object == null) {
                    Encoding encoding = null;
                    return encoding;
                }
            }
            this.lj.readLock().unlock();
            this.lj.writeLock().lock();
            try {
                Object object3 = null;
                Object[] objectArray2 = new Encoding[]{object3};
                boolean bl2 = this.lf.lI((Integer)n, objectArray2);
                object3 = objectArray2[0];
                if (bl2) {
                    Object object4 = object3;
                    return object4;
                }
                this.lf.lb(n, (Encoding)object);
            }
            finally {
                this.lj.readLock().lock();
                this.lj.writeLock().unlock();
            }
        }
        finally {
            this.lj.readLock().unlock();
        }
        return object;
    }

    @Override
    public Encoding lI(String string) {
        int n = EncodingTableCP.lf(string);
        if (n == 0) {
            return null;
        }
        return this.lI(n);
    }

    private static Encoding lj(int n) {
        EncodingNLSCP encodingNLSCP = null;
        switch (n) {
            case 57002: 
            case 57003: 
            case 57004: 
            case 57005: 
            case 57006: 
            case 57007: 
            case 57008: 
            case 57009: 
            case 57010: 
            case 57011: {
                encodingNLSCP = new ISCIIEncoding(n);
                break;
            }
            case 10008: {
                encodingNLSCP = new DBCSCodePageEncoding(10008, 20936);
                break;
            }
            case 10003: {
                encodingNLSCP = new DBCSCodePageEncoding(10003, 20949);
                break;
            }
            case 54936: {
                encodingNLSCP = new GB18030Encoding();
                break;
            }
            case 50220: 
            case 50221: 
            case 50222: 
            case 50225: 
            case 52936: {
                encodingNLSCP = new ISO2022Encoding(n);
                break;
            }
            case 50227: 
            case 51936: {
                encodingNLSCP = new DBCSCodePageEncoding(n, 936);
                break;
            }
            case 51932: {
                encodingNLSCP = new EUCJPEncoding();
                break;
            }
            case 51949: {
                encodingNLSCP = new DBCSCodePageEncoding(n, 20949);
                break;
            }
            case 38598: {
                encodingNLSCP = new SBCSCodePageEncoding(n, 28598);
            }
        }
        return encodingNLSCP;
    }

    private static int lf() {
        return 0;
    }
}

