/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.System.Text;

import com.aspose.omr.System.Text.ASCIIEncoding;
import com.aspose.omr.System.Text.CodePageDataItem;
import com.aspose.omr.System.Text.Decoder;
import com.aspose.omr.System.Text.DecoderFallback;
import com.aspose.omr.System.Text.DecoderFallbackBuffer;
import com.aspose.omr.System.Text.DecoderNLS;
import com.aspose.omr.System.Text.Encoder;
import com.aspose.omr.System.Text.EncoderFallback;
import com.aspose.omr.System.Text.EncoderFallbackBuffer;
import com.aspose.omr.System.Text.EncoderNLS;
import com.aspose.omr.System.Text.EncodingInfo;
import com.aspose.omr.System.Text.EncodingProvider;
import com.aspose.omr.System.Text.EncodingTable;
import com.aspose.omr.System.Text.InternalDecoderBestFitFallback;
import com.aspose.omr.System.Text.InternalEncoderBestFitFallback;
import com.aspose.omr.System.Text.Latin1Encoding;
import com.aspose.omr.System.Text.SR;
import com.aspose.omr.System.Text.UTF32Encoding;
import com.aspose.omr.System.Text.UTF7Encoding;
import com.aspose.omr.System.Text.UTF8Encoding;
import com.aspose.omr.System.Text.UnicodeEncoding;
import com.aspose.omr.System.l10p;
import com.aspose.omr.System.l5f;
import com.aspose.omr.System.l6f;
import com.aspose.omr.System.l6h;
import com.aspose.omr.System.l8if;
import com.aspose.omr.System.l8p;
import com.aspose.omr.System.lh;
import com.aspose.omr.System.lk;
import com.aspose.omr.System.lv;
import com.aspose.omr.l12if.l2t;
import com.aspose.omr.l42if.lb;
import java.nio.charset.Charset;

public abstract class Encoding
implements l5f,
Cloneable {
    private static final UTF8Encoding.UTF8EncodingSealed lI = new UTF8Encoding.UTF8EncodingSealed(false);
    public static final int l0v = 1;
    public static final int l0p = 2;
    public static final int l0u = 256;
    public static final int l0j = 512;
    private static final int lf = 0;
    private static final int lj = 1;
    private static final int lt = 2;
    private static final int lb = 3;
    private static final int ld = 42;
    private static final int lu = 1200;
    private static final int le = 1201;
    private static final int lh = 1252;
    private static final int lk = 10008;
    private static final int lv = 20936;
    private static final int lc = 10003;
    private static final int ly = 20949;
    private static final int l0if = 50220;
    private static final int l0l = 50221;
    private static final int l0t = 50222;
    private static final int l1l = 50225;
    private static final int l1t = 50227;
    private static final int l1v = 51932;
    private static final int l1p = 52936;
    private static final int l1u = 51936;
    private static final int l1j = 936;
    private static final int l1h = 51949;
    public static final int l0h = 20127;
    public static final int l0y = 28591;
    private static final int l1y = 57006;
    private static final int l1n = 57003;
    private static final int l1k = 57002;
    private static final int l1f = 57010;
    private static final int l2if = 57008;
    private static final int l2l = 57009;
    private static final int l2t = 57007;
    private static final int l2v = 57011;
    private static final int l2p = 57004;
    private static final int l2u = 57005;
    private static final int l2j = 54936;
    private static final int l2h = 38598;
    private static final int l2y = 28598;
    private static final int l2n = 50229;
    private static final int l2k = 65000;
    private static final int l2f = 65001;
    private static final int l3if = 12000;
    private static final int l3l = 12001;
    public int l0n = 0;
    public CodePageDataItem l0k = null;
    private boolean l3t = true;
    public EncoderFallback l0f = null;
    public DecoderFallback l1if = null;

    public static Encoding lh() {
        return lI;
    }

    protected Encoding() {
        this(0);
    }

    protected Encoding(int codePage) {
        if (codePage < 0) {
            throw new lv("codePage");
        }
        this.l0n = codePage;
        this.lI();
    }

    protected Encoding(int codePage, EncoderFallback encoderFallback, DecoderFallback decoderFallback) {
        if (codePage < 0) {
            throw new lv("codePage");
        }
        this.l0n = codePage;
        this.l0f = encoderFallback != null ? encoderFallback : new InternalEncoderBestFitFallback(this);
        this.l1if = decoderFallback != null ? decoderFallback : new InternalDecoderBestFitFallback(this);
    }

    public void lI() {
        this.l0f = new InternalEncoderBestFitFallback(this);
        this.l1if = new InternalDecoderBestFitFallback(this);
    }

    public static byte[] lI(Encoding encoding, Encoding encoding2, byte[] byArray) {
        if (byArray == null) {
            throw new lk("bytes");
        }
        return Encoding.lI(encoding, encoding2, byArray, 0, byArray.length);
    }

    public static byte[] lI(Encoding encoding, Encoding encoding2, byte[] byArray, int n, int n2) {
        if (encoding == null || encoding2 == null) {
            throw new lk(encoding == null ? "srcEncoding" : "dstEncoding", "Array cannot be null.");
        }
        if (byArray == null) {
            throw new lk("bytes", "Array cannot be null.");
        }
        if (n < 0 || n > byArray.length) {
            throw new lv("index", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (n2 < 0 || byArray.length - n < n2) {
            throw new lv("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        return encoding2.lj(encoding.lj(byArray, n, n2));
    }

    public static void lI(EncodingProvider encodingProvider) {
        EncodingProvider.lI(encodingProvider);
    }

    public static Encoding lt(int n) {
        if (n < 0 || n > 65535) {
            throw new lv("codepage", SR.lI("Valid values are between {0} and {1}, inclusive.", (Object)0, (Object)65535));
        }
        switch (n) {
            case 0: {
                return Encoding.lh();
            }
            case 1200: {
                return Encoding.l1t();
            }
            case 1201: {
                return Encoding.l1v();
            }
            case 12000: {
                return Encoding.l1h();
            }
            case 12001: {
                return Encoding.lu();
            }
            case 65000: {
                return Encoding.l1p();
            }
            case 65001: {
                return Encoding.l1u();
            }
            case 20127: {
                return Encoding.l0f();
            }
            case 28591: {
                return Encoding.ld();
            }
            case 1: 
            case 2: 
            case 3: 
            case 42: {
                throw new lh(SR.lI("{0} is not a supported code page.", (Object)n), "codepage");
            }
        }
        Encoding encoding = EncodingProvider.lf(n);
        if (encoding != null) {
            return encoding;
        }
        if (EncodingTable.lI(n) == null) {
            throw new l8if(SR.lI("No data is available for encoding {0}. For information on defining a custom encoding, see the documentation for the Encoding.RegisterProvider method.", (Object)n));
        }
        return Encoding.l1u();
    }

    public static Encoding lI(int n, EncoderFallback encoderFallback, DecoderFallback decoderFallback) {
        Encoding encoding = EncodingProvider.lf(n, encoderFallback, decoderFallback);
        if (encoding != null) {
            return encoding;
        }
        encoding = Encoding.lt(n);
        Encoding encoding2 = (Encoding)encoding.deepClone();
        encoding2.lI(encoderFallback);
        encoding2.lI(decoderFallback);
        return encoding2;
    }

    public static Encoding lj(String string) {
        Encoding encoding = EncodingProvider.lf(string);
        if (encoding != null) {
            return encoding;
        }
        return Encoding.lt(EncodingTable.lI(string));
    }

    public static Encoding lI(String string, EncoderFallback encoderFallback, DecoderFallback decoderFallback) {
        Encoding encoding = EncodingProvider.lf(string, encoderFallback, decoderFallback);
        if (encoding != null) {
            return encoding;
        }
        return Encoding.lI(EncodingTable.lI(string), encoderFallback, decoderFallback);
    }

    public static EncodingInfo[] lk() {
        return EncodingTable.lI();
    }

    public byte[] lv() {
        return new byte[0];
    }

    public byte[] lc() {
        return this.lv();
    }

    private void lb() {
        if (this.l0k == null) {
            this.l0k = EncodingTable.lI(this.l0n);
            if (this.l0k == null) {
                throw new l8if(SR.lI("No data is available for encoding {0}. For information on defining a custom encoding, see the documentation for the Encoding.RegisterProvider method.", (Object)this.l0n));
            }
        }
    }

    public String ly() {
        if (this.l0k == null) {
            this.lb();
        }
        return this.l0k.lb();
    }

    public String l0if() {
        return SR.lf(l10p.lI(new String[]{"Globalization_cp_", l6h.lf(this.l0n)}));
    }

    public String l0l() {
        if (this.l0k == null) {
            this.lb();
        }
        return this.l0k.lt();
    }

    public String l0t() {
        if (this.l0k == null) {
            this.lb();
        }
        return this.l0k.lj();
    }

    public int l0v() {
        if (this.l0k == null) {
            this.lb();
        }
        return this.l0k.lf();
    }

    public boolean l0p() {
        if (this.l0k == null) {
            this.lb();
        }
        return (this.l0k.lu() & 0xFFFFFFFFL & 2L & 0xFFFFFFFFL) != 0L;
    }

    public boolean l0u() {
        if (this.l0k == null) {
            this.lb();
        }
        return (this.l0k.lu() & 0xFFFFFFFFL & 0x200L & 0xFFFFFFFFL) != 0L;
    }

    public boolean l0j() {
        if (this.l0k == null) {
            this.lb();
        }
        return (this.l0k.lu() & 0xFFFFFFFFL & 1L & 0xFFFFFFFFL) != 0L;
    }

    public boolean l0h() {
        if (this.l0k == null) {
            this.lb();
        }
        return (this.l0k.lu() & 0xFFFFFFFFL & 0x100L & 0xFFFFFFFFL) != 0L;
    }

    public boolean lf() {
        return false;
    }

    public final EncoderFallback l0y() {
        return this.l0f;
    }

    public final void lI(EncoderFallback encoderFallback) {
        if (this.l0k()) {
            throw new l6f("Instance is read-only.");
        }
        if (encoderFallback == null) {
            throw new lk("value");
        }
        this.l0f = encoderFallback;
    }

    public final DecoderFallback l0n() {
        return this.l1if;
    }

    public final void lI(DecoderFallback decoderFallback) {
        if (this.l0k()) {
            throw new l6f("Instance is read-only.");
        }
        if (decoderFallback == null) {
            throw new lk("value");
        }
        this.l1if = decoderFallback;
    }

    @Override
    public Object deepClone() {
        Encoding encoding = (Encoding)this.l2l();
        encoding.l3t = false;
        return encoding;
    }

    public final boolean l0k() {
        return this.l3t;
    }

    public static Encoding l0f() {
        return ASCIIEncoding.lI;
    }

    private static Encoding ld() {
        return Latin1Encoding.lI;
    }

    public int lf(char[] cArray) {
        if (cArray == null) {
            throw new lk("chars", "Array cannot be null.");
        }
        return this.lI(cArray, 0, cArray.length);
    }

    public int lI(String string) {
        if (string == null) {
            throw new lk("s");
        }
        char[] cArray = l10p.lv(string);
        return this.lI(cArray, 0, cArray.length);
    }

    public abstract int lI(char[] var1, int var2, int var3);

    public final int lI(String string, int n, int n2) {
        if (string == null) {
            throw new lk("s", "String reference not set to an instance of a String.");
        }
        if (n < 0) {
            throw new lv("index", "Non-negative number required.");
        }
        if (n2 < 0) {
            throw new lv("count", "Non-negative number required.");
        }
        if (n > string.length() - n2) {
            throw new lv("index", "Index and count must refer to a location within the string.");
        }
        char[] cArray = l10p.lv(string);
        return this.lI(cArray, n, n2);
    }

    public int lI(char[] cArray, int n, int n2, EncoderNLS encoderNLS) {
        return this.lI(cArray, n, n2);
    }

    public byte[] lj(char[] cArray) {
        if (cArray == null) {
            throw new lk("chars", "Array cannot be null.");
        }
        return this.lf(cArray, 0, cArray.length);
    }

    public byte[] lf(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[this.lI(cArray, n, n2)];
        this.lI(cArray, n, n2, byArray, 0);
        return byArray;
    }

    public abstract int lI(char[] var1, int var2, int var3, byte[] var4, int var5);

    public byte[] lt(String string) {
        if (string == null) {
            throw new lk("s", "String reference not set to an instance of a String.");
        }
        int n = this.lI(string);
        byte[] byArray = new byte[n];
        int n2 = this.lI(string, 0, string.length(), byArray, 0);
        return byArray;
    }

    public final byte[] lf(String string, int n, int n2) {
        if (string == null) {
            throw new lk("s", "String reference not set to an instance of a String.");
        }
        if (n < 0) {
            throw new lv("index", "Non-negative number required.");
        }
        if (n2 < 0) {
            throw new lv("count", "Non-negative number required.");
        }
        if (n > string.length() - n2) {
            throw new lv("index", "Index and count must refer to a location within the string.");
        }
        char[] cArray = l10p.lv(string);
        int n3 = this.lI(cArray, n, n2);
        if (n3 == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n3];
        int n4 = this.lI(cArray, n, n2, byArray, n3);
        return byArray;
    }

    public int lI(String string, int n, int n2, byte[] byArray, int n3) {
        if (string == null) {
            throw new lk("s");
        }
        return this.lI(l10p.lv(string), n, n2, byArray, n3);
    }

    public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, EncoderNLS encoderNLS) {
        return this.lI(cArray, n, n2, byArray, n3, n4);
    }

    public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        if (byArray == null || cArray == null) {
            throw new lk(byArray == null ? "bytes" : "chars", "Array cannot be null.");
        }
        if (n2 < 0 || n4 < 0) {
            throw new lv(n2 < 0 ? "charCount" : "byteCount", "Non-negative number required.");
        }
        char[] cArray2 = new char[n2];
        for (n5 = 0; n5 < n2; ++n5) {
            cArray2[n5] = cArray[n5 + n];
        }
        byte[] byArray2 = new byte[n4];
        int n6 = this.lI(cArray2, 0, n2, byArray2, 0);
        if (n6 < n4) {
            n4 = n6;
        }
        for (n5 = 0; n5 < n4; ++n5) {
            byArray[n5] = byArray2[n5 + n3];
        }
        return n4;
    }

    public int lI(char[] cArray, byte[] byArray) {
        return this.lI(cArray, 0, cArray.length, byArray, 0, byArray.length);
    }

    public int lI(byte[] byArray) {
        if (byArray == null) {
            throw new lk("bytes", "Array cannot be null.");
        }
        return this.lI(byArray, 0, byArray.length);
    }

    public abstract int lI(byte[] var1, int var2, int var3);

    public int lI(byte[] byArray, int n, int n2, DecoderNLS decoderNLS) {
        return this.lI(byArray, n, n2);
    }

    public char[] lf(byte[] byArray) {
        if (byArray == null) {
            throw new lk("bytes", "Array cannot be null.");
        }
        return this.lj(byArray, 0, byArray.length);
    }

    public char[] lj(byte[] byArray, int n, int n2) {
        char[] cArray = new char[this.lI(byArray, n, n2)];
        this.lI(byArray, n, n2, cArray, 0);
        return cArray;
    }

    public abstract int lI(byte[] var1, int var2, int var3, char[] var4, int var5);

    public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) {
        int n5;
        if (cArray == null || byArray == null) {
            throw new lk(cArray == null ? "chars" : "bytes", "Array cannot be null.");
        }
        if (n2 < 0 || n4 < 0) {
            throw new lv(n2 < 0 ? "byteCount" : "charCount", "Non-negative number required.");
        }
        byte[] byArray2 = new byte[n2];
        for (n5 = 0; n5 < n2; ++n5) {
            byArray2[n5] = byArray[n5 + n];
        }
        char[] cArray2 = new char[n4];
        int n6 = this.lI(byArray2, 0, n2, cArray2, 0);
        if (n6 < n4) {
            n4 = n6;
        }
        for (n5 = 0; n5 < n4; ++n5) {
            cArray[n5] = cArray2[n5];
        }
        return n4;
    }

    public int lI(byte[] byArray, char[] cArray) {
        return this.lI(byArray, 0, byArray.length, cArray, 0, cArray.length);
    }

    public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, DecoderNLS decoderNLS) {
        return this.lI(byArray, n, n2, cArray, n3, n4);
    }

    public int l1if() {
        return this.l0n;
    }

    public final boolean l1l() {
        return this.lb(1);
    }

    public boolean lb(int n) {
        return false;
    }

    public Decoder lj() {
        return new DefaultDecoder(this);
    }

    public Encoder lt() {
        return new DefaultEncoder(this);
    }

    public abstract int lI(int var1);

    public abstract int lf(int var1);

    public String lj(byte[] byArray) {
        if (byArray == null) {
            throw new lk("bytes", "Array cannot be null.");
        }
        return this.lf(byArray, 0, byArray.length);
    }

    public String lf(byte[] byArray, int n, int n2) {
        return l10p.lI(this.lj(byArray, n, n2));
    }

    public static Encoding l1t() {
        return UnicodeEncoding.lf;
    }

    public static Encoding l1v() {
        return UnicodeEncoding.lI;
    }

    public static Encoding l1p() {
        return UTF7Encoding.lI;
    }

    public static Encoding l1u() {
        return UTF8Encoding.lI;
    }

    public static Encoding l1j() {
        return UTF8Encoding.lf;
    }

    public static Encoding l1h() {
        return UTF32Encoding.lI;
    }

    public static Encoding l1y() {
        return Encoding.lu();
    }

    private static Encoding lu() {
        return UTF32Encoding.lf;
    }

    public boolean equals(Object value) {
        Encoding encoding = (Encoding)((Object)com.aspose.omr.l42if.lb.lI(value, Encoding.class));
        if (encoding != null) {
            return this.l0n == encoding.l0n && this.l0y().equals(encoding.l0y()) && this.l0n().equals(encoding.l0n());
        }
        return false;
    }

    public int hashCode() {
        return this.l0n + this.l0y().hashCode() + this.l0n().hashCode();
    }

    public char[] l1n() {
        return new char[0];
    }

    public char[] l1k() {
        return new char[0];
    }

    public final void l1f() {
        throw new lh(SR.lI("The output byte buffer is too small to contain the encoded data, encoding '{0}' fallback '{1}'.", (Object)this.l0if(), (Object)l8p.lI(this.l0y())), "bytes");
    }

    public final void lI(EncoderNLS encoderNLS, boolean bl) {
        if (encoderNLS == null || encoderNLS.lt || bl) {
            if (encoderNLS != null && encoderNLS.lj()) {
                encoderNLS.lf().lb();
            }
            this.l1f();
        }
        encoderNLS.le();
    }

    public final void l2if() {
        throw new lh(SR.lI("The output char buffer is too small to contain the decoded characters, encoding '{0}' fallback '{1}'.", (Object)this.l0if(), (Object)l8p.lI(this.l0n())), "chars");
    }

    public final void lI(DecoderNLS decoderNLS, boolean bl) {
        if (decoderNLS == null || decoderNLS.lt || bl) {
            if (decoderNLS != null && decoderNLS.lb()) {
                decoderNLS.lt().lb();
            }
            this.l2if();
        }
        decoderNLS.lu();
    }

    public final String lt(byte[] byArray, int n, int n2) {
        int n3 = this.lI(byArray, n, n2);
        if (n3 == 0) {
            return l10p.lI;
        }
        char[] cArray = new char[n3];
        this.lI(byArray, n, n2, cArray, 0);
        return l10p.lI(cArray);
    }

    protected Object l2l() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public static Encoding lI(Charset charset) {
        if (charset == null) {
            return null;
        }
        Encoding encoding = null;
        try {
            encoding = Encoding.lj(charset.displayName());
        }
        catch (lh lh2) {
            // empty catch block
        }
        if (encoding != null) {
            return encoding;
        }
        for (String string : charset.aliases()) {
            try {
                encoding = Encoding.lj(string);
            }
            catch (lh lh3) {
                // empty catch block
            }
            if (encoding == null) continue;
            return encoding;
        }
        if (encoding == null) {
            throw new lh(SR.lI("'{0}' is not a supported encoding name. For information on defining a custom encoding, see the documentation for the Encoding.RegisterProvider method.", (Object)charset.displayName()), "name");
        }
        return encoding;
    }

    public static Charset lI(Encoding encoding) {
        Charset charset;
        if (encoding == null) {
            return null;
        }
        if (l10p.lf(encoding.l0t())) {
            throw new IllegalStateException("Encoding missed in java CodePage:" + encoding.l1if());
        }
        try {
            charset = Charset.forName(encoding.l0t());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("Encoding missed in java CodePage:" + encoding.l1if(), illegalArgumentException);
        }
        return charset;
    }

    public static class EncodingByteBuffer {
        private byte[] lf;
        private int lj;
        private int lt;
        private int lb;
        private char[] ld;
        private int[] lu = new int[1];
        private int le;
        private int lh;
        private int lk = 0;
        private Encoding lv;
        private EncoderNLS lc;
        public EncoderFallbackBuffer lI;

        public EncodingByteBuffer(Encoding inEncoding, EncoderNLS inEncoder, byte[] bytes, int inByteStart, int inByteCount, char[] chars, int inCharStart, int inCharCount) {
            this.lv = inEncoding;
            this.lc = inEncoder;
            this.le = inCharStart;
            this.ld = chars;
            this.lu[0] = inCharStart;
            this.lh = inCharStart + inCharCount;
            this.lf = bytes;
            this.lj = inByteStart;
            this.lt = inByteStart;
            this.lb = inByteStart + inByteCount;
            if (this.lc == null) {
                this.lI = this.lv.l0y().lI();
            } else {
                this.lI = this.lc.lf();
                if (this.lc.lt && this.lc.lj() && this.lI.lj() > 0) {
                    throw new lh(SR.lI("Must complete Convert() operation or call Encoder.Reset() before calling GetBytes() or GetByteCount(). Encoder '{0}' fallback '{1}'.", (Object)this.lc.lb().l0if(), (Object)l8p.lI(this.lc.lI())));
                }
            }
            this.lI.lI(this.lu[0], this.lh, this.lc, this.lf != null);
        }

        public final boolean lI(byte by, int n) {
            if (this.lf != null) {
                if (this.lj >= this.lb - n) {
                    this.lI(true);
                    return false;
                }
                this.lf[this.lj++] = by;
            }
            ++this.lk;
            return true;
        }

        public final boolean lI(byte by) {
            return this.lI(by, 0);
        }

        public final boolean lI(byte by, byte by2) {
            return this.lI(by, by2, 0);
        }

        public final boolean lI(byte by, byte by2, int n) {
            return this.lI(by, 1 + n) && this.lI(by2, n);
        }

        public final boolean lI(byte by, byte by2, byte by3) {
            return this.lI(by, by2, by3, 0);
        }

        public final boolean lI(byte by, byte by2, byte by3, int n) {
            return this.lI(by, 2 + n) && this.lI(by2, 1 + n) && this.lI(by3, n);
        }

        public final boolean lI(byte by, byte by2, byte by3, byte by4) {
            return this.lI(by, 3) && this.lI(by2, 2) && this.lI(by3, 1) && this.lI(by4, 0);
        }

        public final void lI(boolean bl) {
            if (this.lI.ld) {
                this.lI.lf();
            } else if (this.lu[0] > this.le) {
                this.lu[0] = this.lu[0] - 1;
            }
            if (bl) {
                this.lv.lI(this.lc, this.lj == this.lt);
            }
        }

        public final boolean lI(char c) {
            return this.lI.lI(c, this.ld, new int[]{this.lu[0]});
        }

        public final boolean lI() {
            return this.lI.lj() > 0 || this.lu[0] < this.lh;
        }

        public final char lf() {
            char c = this.lI.ld();
            if (c == '\u0000' && this.lu[0] < this.lh) {
                int n = this.lu[0];
                this.lu[0] = n + 1;
                c = this.ld[n];
            }
            return c;
        }

        public final int lj() {
            return this.lu[0] - this.le;
        }

        public final int lt() {
            return this.lk;
        }
    }

    public static class EncodingCharBuffer {
        private char[] lI;
        private int[] lf = new int[1];
        private int lj;
        private int lt;
        private int lb = 0;
        private Encoding ld;
        private DecoderNLS lu;
        private int le;
        private int lh;
        private byte[] lk;
        private int lv;
        private DecoderFallbackBuffer lc;

        public EncodingCharBuffer(Encoding enc, DecoderNLS decoder, char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex, int byteCount) {
            this.ld = enc;
            this.lu = decoder;
            this.lI = chars;
            this.lf[0] = charIndex;
            this.lj = charIndex;
            this.lt = charIndex + charCount;
            this.le = byteIndex;
            this.lv = byteIndex;
            this.lk = bytes;
            this.lh = byteIndex + byteCount;
            this.lc = this.lu == null ? enc.l0n().lI() : this.lu.lt();
            this.lc.lI(this.lv, this.lt);
        }

        public final boolean lI(char c, int n) {
            if (this.lI != null) {
                if (this.lf[0] >= this.lt) {
                    this.lv -= n;
                    this.ld.lI(this.lu, this.lv <= this.le);
                    return false;
                }
                int n2 = this.lf[0];
                this.lf[0] = n2 + 1;
                this.lI[n2] = c;
            }
            ++this.lb;
            return true;
        }

        public final boolean lI(char c) {
            return this.lI(c, 1);
        }

        public final boolean lI(char c, char c2, int n) {
            if (this.lf[0] >= this.lt - 1) {
                this.lv -= n;
                this.ld.lI(this.lu, this.lv <= this.le);
                return false;
            }
            return this.lI(c, n) && this.lI(c2, n);
        }

        public final void lI(int n) {
            this.lv += n;
        }

        public final boolean lI() {
            return this.lv < this.lh;
        }

        public final boolean lf(int n) {
            return this.lv <= this.lh - n;
        }

        public final byte lf() {
            if (this.lv >= this.lh) {
                return 0;
            }
            return this.lk[this.lv++];
        }

        public final int lj() {
            return this.lv - this.le;
        }

        public final boolean lI(byte by) {
            byte[] byArray = new byte[]{by};
            return this.lI(byArray);
        }

        public final boolean lI(byte by, byte by2) {
            byte[] byArray = new byte[]{by, by2};
            return this.lI(byArray);
        }

        public final boolean lI(byte by, byte by2, byte by3, byte by4) {
            byte[] byArray = new byte[]{by, by2, by3, by4};
            return this.lI(byArray);
        }

        public final boolean lI(byte[] byArray) {
            if (this.lI != null) {
                int n = this.lf[0];
                if (!this.lc.lI(byArray, this.lv, this.lI, this.lf)) {
                    this.lv -= byArray.length;
                    this.lc.lb();
                    this.ld.lI(this.lu, this.lf[0] == this.lj);
                    return false;
                }
                this.lb += this.lf[0] - n;
            } else {
                this.lb += this.lc.lf(byArray, this.lv);
            }
            return true;
        }

        public final int lt() {
            return this.lb;
        }
    }

    public static final class DefaultDecoder
    extends Decoder
    implements com.aspose.omr.l12if.lv {
        private Encoding lI;

        public DefaultDecoder(Encoding encoding) {
            this.lI = encoding;
        }

        @Override
        public final Object lI(l2t l2t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lI(byte[] byArray, int n, int n2) {
            return this.lI(byArray, n, n2, false);
        }

        @Override
        public int lI(byte[] byArray, int n, int n2, boolean bl) {
            return this.lI.lI(byArray, n, n2);
        }

        @Override
        public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3) {
            return this.lI(byArray, n, n2, cArray, n3, false);
        }

        @Override
        public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, boolean bl) {
            return this.lI.lI(byArray, n, n2, cArray, n3);
        }

        @Override
        public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, boolean bl) {
            return this.lI.lI(byArray, n, n2, cArray, n3, n4);
        }
    }

    public static final class DefaultEncoder
    extends Encoder
    implements com.aspose.omr.l12if.lv {
        private Encoding lj;

        public DefaultEncoder(Encoding encoding) {
            this.lj = encoding;
        }

        @Override
        public final Object lI(l2t l2t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lI(char[] cArray, int n, int n2, boolean bl) {
            return this.lj.lI(cArray, n, n2);
        }

        @Override
        public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, boolean bl) {
            return this.lj.lI(cArray, n, n2, byArray, n3);
        }

        @Override
        public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, boolean bl) {
            return this.lj.lI(cArray, n, n2, byArray, n3, n4);
        }
    }
}

