/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.System.Text;

import com.aspose.omr.System.Text.DBCSCodePageEncoding;
import com.aspose.omr.System.Text.Decoder;
import com.aspose.omr.System.Text.DecoderNLS;
import com.aspose.omr.System.Text.Encoder;
import com.aspose.omr.System.Text.EncoderNLS;
import com.aspose.omr.System.Text.Encoding;
import com.aspose.omr.System.Text.EncodingNLS;
import com.aspose.omr.System.l4j;
import com.aspose.omr.System.lv;

public class ISO2022Encoding
extends DBCSCodePageEncoding {
    private static final byte l1l = 14;
    private static final byte l1t = 15;
    private static final byte l1v = 27;
    private static final byte l1p = 16;
    private static int[] l1u = new int[]{932, 932, 932, 0, 0, 949, 936, 0, 0, 0, 0, 0};
    private static int[] l1j = new int[]{41379, 41430, 41431, 41378, 41382, 42482, 42401, 42403, 42405, 42407, 42409, 42467, 42469, 42471, 42435, 41404, 42402, 42404, 42406, 42408, 42410, 42411, 42413, 42415, 42417, 42419, 42421, 42423, 42425, 42427, 42429, 42431, 42433, 42436, 42438, 42440, 42442, 42443, 42444, 42445, 42446, 42447, 42450, 42453, 42456, 42459, 42462, 42463, 42464, 42465, 42466, 42468, 42470, 42472, 42473, 42474, 42475, 42476, 42477, 42479, 42483, 41387, 41388};

    public ISO2022Encoding(int codePage) {
        super(codePage, l1u[codePage % 10]);
    }

    @Override
    protected boolean lI(int[] nArray) {
        switch (this.l1if()) {
            case 50220: 
            case 50221: 
            case 50222: {
                if (nArray[0] >= 256) {
                    byte by;
                    if (nArray[0] >= 64064 && nArray[0] <= 64587) {
                        if (nArray[0] >= 64064 && nArray[0] <= 64091) {
                            if (nArray[0] <= 64073) {
                                nArray[0] = nArray[0] - 2897;
                            } else if (nArray[0] >= 64074 && nArray[0] <= 64083) {
                                nArray[0] = nArray[0] - 29430;
                            } else if (nArray[0] >= 64084 && nArray[0] <= 64087) {
                                nArray[0] = nArray[0] - 2907;
                            } else if (nArray[0] == 64088) {
                                nArray[0] = 34698;
                            } else if (nArray[0] == 64089) {
                                nArray[0] = 34690;
                            } else if (nArray[0] == 64090) {
                                nArray[0] = 34692;
                            } else if (nArray[0] == 64091) {
                                nArray[0] = 34714;
                            }
                        } else if (nArray[0] >= 64092 && nArray[0] <= 64587) {
                            by = (byte)nArray[0];
                            nArray[0] = (by & 0xFF) < 92 ? nArray[0] - 3423 : ((by & 0xFF) >= 128 && (by & 0xFF) <= 155 ? nArray[0] - 3357 : nArray[0] - 3356);
                        }
                    }
                    by = (byte)(nArray[0] >> 8);
                    byte by2 = (byte)nArray[0];
                    by = (byte)((by & 0xFF) - (((by & 0xFF) > 159 ? -79 : 113) & 0xFF));
                    by = (byte)(((by & 0xFF) << 1) + 1);
                    if ((by2 & 0xFF) > 158) {
                        by2 = (byte)((by2 & 0xFF) - 126);
                        by = (byte)(by + 1);
                    } else {
                        if ((by2 & 0xFF) > 126) {
                            by2 = (byte)(by2 - 1);
                        }
                        by2 = (byte)((by2 & 0xFF) - 31);
                    }
                    nArray[0] = (by & 0xFF) << 8 | by2 & 0xFF;
                    break;
                }
                if (nArray[0] >= 161 && nArray[0] <= 223) {
                    nArray[0] = nArray[0] + 3968;
                }
                if (nArray[0] < 129 || nArray[0] > 159 && (nArray[0] < 224 || nArray[0] > 252)) break;
                return false;
            }
            case 50225: {
                if (nArray[0] >= 128 && nArray[0] <= 255) {
                    return false;
                }
                if (nArray[0] >= 256 && ((nArray[0] & 0xFF) < 161 || (nArray[0] & 0xFF) == 255 || (nArray[0] & 0xFF00) < 41216 || (nArray[0] & 0xFF00) == 65280)) {
                    return false;
                }
                nArray[0] = nArray[0] & 0x7F7F;
                break;
            }
            case 52936: {
                if (nArray[0] < 129 || nArray[0] > 254) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public int lI(char[] cArray, int n, int n2, EncoderNLS encoderNLS) {
        return this.lI(cArray, n, n2, null, 0, 0, encoderNLS);
    }

    @Override
    public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, EncoderNLS encoderNLS) {
        ISO2022Encoder iSO2022Encoder = (ISO2022Encoder)encoderNLS;
        int n5 = 0;
        switch (this.l1if()) {
            case 50220: 
            case 50221: 
            case 50222: {
                n5 = this.lI(cArray, n, n2, byArray, n3, n4, iSO2022Encoder);
                break;
            }
            case 50225: {
                n5 = this.lf(cArray, n, n2, byArray, n3, n4, iSO2022Encoder);
                break;
            }
            case 52936: {
                n5 = this.lj(cArray, n, n2, byArray, n3, n4, iSO2022Encoder);
            }
        }
        return n5;
    }

    @Override
    public int lI(byte[] byArray, int n, int n2, DecoderNLS decoderNLS) {
        return this.lI(byArray, n, n2, null, 0, 0, decoderNLS);
    }

    @Override
    public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, DecoderNLS decoderNLS) {
        ISO2022Decoder iSO2022Decoder = (ISO2022Decoder)decoderNLS;
        int n5 = 0;
        switch (this.l1if()) {
            case 50220: 
            case 50221: 
            case 50222: {
                n5 = this.lI(byArray, n, n2, cArray, n3, n4, iSO2022Decoder);
                break;
            }
            case 50225: {
                n5 = this.lf(byArray, n, n2, cArray, n3, n4, iSO2022Decoder);
                break;
            }
            case 52936: {
                n5 = this.lj(byArray, n, n2, cArray, n3, n4, iSO2022Decoder);
                break;
            }
        }
        return n5;
    }

    private int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, ISO2022Encoder iSO2022Encoder) {
        char c;
        Encoding.EncodingByteBuffer encodingByteBuffer = new Encoding.EncodingByteBuffer(this, iSO2022Encoder, byArray, n3, n4, cArray, n, n2);
        int n5 = 11;
        int n6 = 11;
        if (iSO2022Encoder != null) {
            c = iSO2022Encoder.lj;
            n5 = iSO2022Encoder.ld;
            n6 = iSO2022Encoder.lu;
            if (c > '\u0000') {
                encodingByteBuffer.lI(c);
            }
        }
        block0: while (encodingByteBuffer.lI()) {
            byte by;
            byte by2;
            int n7;
            block23: {
                c = encodingByteBuffer.lf();
                n7 = this.lc[c];
                while (true) {
                    by2 = (byte)((n7 & 0xFFFF) >> 8);
                    by = (byte)(n7 & 0xFFFF & 0xFF);
                    if (by2 != 16) break block23;
                    if (this.l1if() != 50220) break;
                    if ((by & 0xFF) < 33 || (by & 0xFF) >= 33 + l1j.length) {
                        encodingByteBuffer.lI(c);
                        continue block0;
                    }
                    n7 = l1j[(by & 0xFF) - 33] & 0xFFFF & 0x7F7F & 0xFFFF;
                }
                if (n5 != 0) {
                    if (this.l1if() == 50222) {
                        if (!encodingByteBuffer.lI((byte)14)) break;
                        n6 = n5;
                        n5 = 0;
                    } else {
                        if (!encodingByteBuffer.lI((byte)27, (byte)40, (byte)73)) break;
                        n5 = 0;
                    }
                }
                if (encodingByteBuffer.lI((byte)(by & 0xFF & 0x7F))) continue;
                break;
            }
            if ((by2 & 0xFF) != 0) {
                if (this.l1if() == 50222 && n5 == 0) {
                    if (!encodingByteBuffer.lI((byte)15)) break;
                    n5 = n6;
                }
                if (n5 != 1) {
                    if (!encodingByteBuffer.lI((byte)27, (byte)36, (byte)66)) break;
                    n5 = 1;
                }
                if (encodingByteBuffer.lI(by2, by)) continue;
                break;
            }
            if ((n7 & 0xFFFF) != 0 || c == '\u0000') {
                if (this.l1if() == 50222 && n5 == 0) {
                    if (!encodingByteBuffer.lI((byte)15)) break;
                    n5 = n6;
                }
                if (n5 != 11) {
                    if (!encodingByteBuffer.lI((byte)27, (byte)40, (byte)66)) break;
                    n5 = 11;
                }
                if (encodingByteBuffer.lI(by)) continue;
                break;
            }
            encodingByteBuffer.lI(c);
        }
        if (n5 != 11 && (iSO2022Encoder == null || iSO2022Encoder.ld())) {
            if (this.l1if() == 50222 && n5 == 0) {
                if (encodingByteBuffer.lI((byte)15)) {
                    n5 = n6;
                } else {
                    encodingByteBuffer.lf();
                }
            }
            if (n5 != 11 && (this.l1if() != 50222 || n5 != 0)) {
                if (encodingByteBuffer.lI((byte)27, (byte)40, (byte)66)) {
                    n5 = 11;
                } else {
                    encodingByteBuffer.lf();
                }
            }
        }
        if (byArray != null && iSO2022Encoder != null) {
            iSO2022Encoder.ld = n5;
            iSO2022Encoder.lu = n6;
            if (!encodingByteBuffer.lI.lb) {
                iSO2022Encoder.lj = '\u0000';
            }
            iSO2022Encoder.lb = encodingByteBuffer.lj();
        }
        return encodingByteBuffer.lt();
    }

    private int lf(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, ISO2022Encoder iSO2022Encoder) {
        char c;
        Encoding.EncodingByteBuffer encodingByteBuffer = new Encoding.EncodingByteBuffer(this, iSO2022Encoder, byArray, n3, n4, cArray, n, n2);
        int n5 = 11;
        int n6 = 11;
        if (iSO2022Encoder != null) {
            c = iSO2022Encoder.lj;
            n5 = iSO2022Encoder.ld;
            n6 = iSO2022Encoder.lu;
            if (c > '\u0000') {
                encodingByteBuffer.lI(c);
            }
        }
        while (encodingByteBuffer.lI()) {
            c = encodingByteBuffer.lf();
            int n7 = this.lc[c];
            byte by = (byte)((n7 & 0xFFFF) >> 8);
            byte by2 = (byte)(n7 & 0xFFFF & 0xFF);
            if ((by & 0xFF) != 0) {
                if (n6 != 5) {
                    if (!encodingByteBuffer.lI((byte)27, (byte)36, (byte)41, (byte)67)) break;
                    n6 = 5;
                }
                if (n5 != 5) {
                    if (!encodingByteBuffer.lI((byte)14)) break;
                    n5 = 5;
                }
                if (encodingByteBuffer.lI(by, by2)) continue;
                break;
            }
            if ((n7 & 0xFFFF) != 0 || c == '\u0000') {
                if (n5 != 11) {
                    if (!encodingByteBuffer.lI((byte)15)) break;
                    n5 = 11;
                }
                if (encodingByteBuffer.lI(by2)) continue;
                break;
            }
            encodingByteBuffer.lI(c);
        }
        if (n5 != 11 && (iSO2022Encoder == null || iSO2022Encoder.ld())) {
            if (encodingByteBuffer.lI((byte)15)) {
                n5 = 11;
            } else {
                encodingByteBuffer.lf();
            }
        }
        if (byArray != null && iSO2022Encoder != null) {
            if (!encodingByteBuffer.lI.lb) {
                iSO2022Encoder.lj = '\u0000';
            }
            iSO2022Encoder.ld = n5;
            iSO2022Encoder.lu = !iSO2022Encoder.ld() || iSO2022Encoder.lj != '\u0000' ? n6 : 11;
            iSO2022Encoder.lb = encodingByteBuffer.lj();
        }
        return encodingByteBuffer.lt();
    }

    private int lj(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, ISO2022Encoder iSO2022Encoder) {
        char c;
        Encoding.EncodingByteBuffer encodingByteBuffer = new Encoding.EncodingByteBuffer(this, iSO2022Encoder, byArray, n3, n4, cArray, n, n2);
        int n5 = 11;
        if (iSO2022Encoder != null) {
            c = iSO2022Encoder.lj;
            n5 = iSO2022Encoder.ld;
            if (c > '\u0000') {
                encodingByteBuffer.lI(c);
            }
        }
        while (encodingByteBuffer.lI()) {
            c = encodingByteBuffer.lf();
            int n6 = this.lc[c];
            if ((n6 & 0xFFFF) == 0 && c != '\u0000') {
                encodingByteBuffer.lI(c);
                continue;
            }
            byte by = (byte)((n6 & 0xFFFF) >> 8);
            byte by2 = (byte)(n6 & 0xFFFF & 0xFF);
            if ((by & 0xFF) != 0 && ((by & 0xFF) < 161 || (by & 0xFF) > 247 || (by2 & 0xFF) < 161 || (by2 & 0xFF) > 254) || (by & 0xFF) == 0 && (by2 & 0xFF) > 128 && (by2 & 0xFF) != 255) {
                encodingByteBuffer.lI(c);
                continue;
            }
            if ((by & 0xFF) != 0) {
                if (n5 != 6) {
                    if (!encodingByteBuffer.lI((byte)126, (byte)123, 2)) break;
                    n5 = 6;
                }
                if (encodingByteBuffer.lI((byte)(by & 0xFF & 0x7F), (byte)(by2 & 0xFF & 0x7F))) continue;
                break;
            }
            if (n5 != 11) {
                if (!encodingByteBuffer.lI((byte)126, (byte)125, (by2 & 0xFF) == 126 ? 2 : 1)) break;
                n5 = 11;
            }
            if (((by2 & 0xFF) != 126 || encodingByteBuffer.lI((byte)126, 1)) && encodingByteBuffer.lI(by2)) continue;
            break;
        }
        if (n5 != 11 && (iSO2022Encoder == null || iSO2022Encoder.ld())) {
            if (encodingByteBuffer.lI((byte)126, (byte)125)) {
                n5 = 11;
            } else {
                encodingByteBuffer.lf();
            }
        }
        if (iSO2022Encoder != null && byArray != null) {
            iSO2022Encoder.ld = n5;
            if (!encodingByteBuffer.lI.lb) {
                iSO2022Encoder.lj = '\u0000';
            }
            iSO2022Encoder.lb = encodingByteBuffer.lj();
        }
        return encodingByteBuffer.lt();
    }

    private int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, ISO2022Decoder iSO2022Decoder) {
        int n5;
        Encoding.EncodingCharBuffer encodingCharBuffer = new Encoding.EncodingCharBuffer(this, iSO2022Decoder, cArray, n3, n4, byArray, n, n2);
        int n6 = 11;
        int n7 = 11;
        byte[] byArray2 = new byte[4];
        int n8 = 0;
        if (iSO2022Decoder != null) {
            n6 = iSO2022Decoder.lu;
            n7 = iSO2022Decoder.le;
            n8 = iSO2022Decoder.ld;
            for (n5 = 0; n5 < n8; ++n5) {
                byArray2[n5] = iSO2022Decoder.lI[n5];
            }
        }
        while (encodingCharBuffer.lI() || n8 > 0) {
            char c;
            if (n8 > 0) {
                if (byArray2[0] == 27) {
                    if (!encodingCharBuffer.lI()) {
                        if (iSO2022Decoder != null && !iSO2022Decoder.ld()) {
                            break;
                        }
                    } else {
                        byArray2[n8++] = encodingCharBuffer.lf();
                        int n9 = this.lI(byArray2, n8);
                        if (n9 != -2) {
                            if (n9 == -1) continue;
                            n8 = 0;
                            n7 = n9;
                            n6 = n9;
                            continue;
                        }
                    }
                }
                byte[][] byArrayArray = new byte[][]{byArray2};
                int[] nArray = new int[]{n8};
                n5 = this.lI(byArrayArray, nArray);
                byArray2 = byArrayArray[0];
                n8 = nArray[0];
            } else {
                n5 = encodingCharBuffer.lf();
                if (n5 == 27) {
                    if (n8 == 0) {
                        byArray2[0] = n5;
                        n8 = 1;
                        continue;
                    }
                    encodingCharBuffer.lI(-1);
                }
            }
            if (n5 == 14) {
                n7 = n6;
                n6 = 0;
                continue;
            }
            if (n5 == 15) {
                n6 = n7;
                continue;
            }
            int n10 = n5 & 0xFF;
            boolean bl = false;
            if (n6 == 1) {
                if (n8 > 0) {
                    if ((byArray2[0] & 0xFF) != 27) {
                        n10 = (n10 & 0xFFFF) << 8 & 0xFFFF;
                        byte[][] byArrayArray = new byte[][]{byArray2};
                        int[] nArray = new int[]{n8};
                        n10 = (n10 & 0xFFFF | this.lI(byArrayArray, nArray) & 0xFF) & 0xFFFF;
                        byArray2 = byArrayArray[0];
                        n8 = nArray[0];
                        bl = true;
                    }
                } else if (encodingCharBuffer.lI()) {
                    n10 = (n10 & 0xFFFF) << 8 & 0xFFFF;
                    n10 = (n10 & 0xFFFF | encodingCharBuffer.lf() & 0xFF) & 0xFFFF;
                    bl = true;
                } else {
                    if (iSO2022Decoder == null || iSO2022Decoder.ld()) {
                        encodingCharBuffer.lI((byte)n5);
                        break;
                    }
                    if (cArray == null) break;
                    byArray2[0] = n5;
                    n8 = 1;
                    break;
                }
                if (bl && (n10 & 0xFFFF & 0xFF00) == 10752) {
                    n10 = n10 & 0xFFFF & 0xFF & 0xFFFF;
                    n10 = (n10 & 0xFFFF | 0x1000) & 0xFFFF;
                }
            } else if ((n10 & 0xFFFF) >= 161 && (n10 & 0xFFFF) <= 223) {
                n10 = (n10 & 0xFFFF | 0x1000) & 0xFFFF;
                n10 = n10 & 0xFFFF & 0xFF7F & 0xFFFF;
            } else if (n6 == 0) {
                n10 = (n10 & 0xFFFF | 0x1000) & 0xFFFF;
            }
            if (!((c = this.lv[n10 & 0xFFFF]) == '\u0000' && (n10 & 0xFFFF) != 0 ? (bl ? !encodingCharBuffer.lI((byte)((n10 & 0xFFFF) >> 8), (byte)n10) : !encodingCharBuffer.lI((byte)n5)) : !encodingCharBuffer.lI(c, bl ? 2 : 1))) continue;
            break;
        }
        if (cArray != null && iSO2022Decoder != null) {
            if (!iSO2022Decoder.ld() || n8 != 0) {
                iSO2022Decoder.lu = n6;
                iSO2022Decoder.le = n7;
                iSO2022Decoder.ld = n8;
                iSO2022Decoder.lI = byArray2;
            } else {
                iSO2022Decoder.lu = 11;
                iSO2022Decoder.le = 11;
                iSO2022Decoder.ld = 0;
            }
            iSO2022Decoder.lb = encodingCharBuffer.lj();
        }
        return encodingCharBuffer.lt();
    }

    private int lI(byte[] byArray, int n) {
        if ((byArray[0] & 0xFF) != 27) {
            return -2;
        }
        if (n < 3) {
            return -1;
        }
        if ((byArray[1] & 0xFF) == 40) {
            if ((byArray[2] & 0xFF) == 66) {
                return 11;
            }
            if ((byArray[2] & 0xFF) == 72) {
                return 11;
            }
            if ((byArray[2] & 0xFF) == 74) {
                return 11;
            }
            if ((byArray[2] & 0xFF) == 73) {
                return 0;
            }
        } else if ((byArray[1] & 0xFF) == 36) {
            if ((byArray[2] & 0xFF) == 64 || (byArray[2] & 0xFF) == 66) {
                return 1;
            }
            if (n < 4) {
                return -1;
            }
            if ((byArray[2] & 0xFF) == 40 && (byArray[3] & 0xFF) == 68) {
                return 1;
            }
        } else if ((byArray[1] & 0xFF) == 38 && (byArray[2] & 0xFF) == 64) {
            return -3;
        }
        return -2;
    }

    private byte lI(byte[][] byArray, int[] nArray) {
        nArray[0] = nArray[0] - 1;
        byte by = byArray[0][0];
        for (int i = 0; i < nArray[0]; ++i) {
            byArray[0][i] = byArray[0][i + 1];
        }
        byArray[0][nArray[0]] = 0;
        return by;
    }

    private int lf(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, ISO2022Decoder iSO2022Decoder) {
        int n5;
        Encoding.EncodingCharBuffer encodingCharBuffer = new Encoding.EncodingCharBuffer(this, iSO2022Decoder, cArray, n3, n4, byArray, n, n2);
        int n6 = 11;
        byte[] byArray2 = new byte[4];
        int n7 = 0;
        if (iSO2022Decoder != null) {
            n6 = iSO2022Decoder.lu;
            n7 = iSO2022Decoder.ld;
            for (n5 = 0; n5 < n7; ++n5) {
                byArray2[n5] = iSO2022Decoder.lI[n5];
            }
        }
        while (encodingCharBuffer.lI() || n7 > 0) {
            char c;
            if (n7 > 0) {
                if (byArray2[0] == 27) {
                    if (!encodingCharBuffer.lI()) {
                        if (iSO2022Decoder != null && !iSO2022Decoder.ld()) {
                            break;
                        }
                    } else {
                        byArray2[n7++] = encodingCharBuffer.lf();
                        int n8 = this.lf(byArray2, n7);
                        if (n8 != -2) {
                            if (n8 == -1) continue;
                            n7 = 0;
                            continue;
                        }
                    }
                }
                byte[][] byArrayArray = new byte[][]{byArray2};
                int[] nArray = new int[]{n7};
                n5 = this.lI(byArrayArray, nArray);
                byArray2 = byArrayArray[0];
                n7 = nArray[0];
            } else {
                n5 = encodingCharBuffer.lf();
                if (n5 == 27) {
                    if (n7 == 0) {
                        byArray2[0] = n5;
                        n7 = 1;
                        continue;
                    }
                    encodingCharBuffer.lI(-1);
                }
            }
            if (n5 == 14) {
                n6 = 5;
                continue;
            }
            if (n5 == 15) {
                n6 = 11;
                continue;
            }
            int n9 = n5 & 0xFF;
            boolean bl = false;
            if (n6 == 5 && (n5 & 0xFF) != 32 && (n5 & 0xFF) != 9 && (n5 & 0xFF) != 10) {
                if (n7 > 0) {
                    if ((byArray2[0] & 0xFF) != 27) {
                        n9 = (n9 & 0xFFFF) << 8 & 0xFFFF;
                        byte[][] byArrayArray = new byte[][]{byArray2};
                        int[] nArray = new int[]{n7};
                        n9 = (n9 & 0xFFFF | this.lI(byArrayArray, nArray) & 0xFF) & 0xFFFF;
                        byArray2 = byArrayArray[0];
                        n7 = nArray[0];
                        bl = true;
                    }
                } else if (encodingCharBuffer.lI()) {
                    n9 = (n9 & 0xFFFF) << 8 & 0xFFFF;
                    n9 = (n9 & 0xFFFF | encodingCharBuffer.lf() & 0xFF) & 0xFFFF;
                    bl = true;
                } else {
                    if (iSO2022Decoder == null || iSO2022Decoder.ld()) {
                        encodingCharBuffer.lI((byte)n5);
                        break;
                    }
                    if (cArray == null) break;
                    byArray2[0] = n5;
                    n7 = 1;
                    break;
                }
            }
            if (!((c = this.lv[n9 & 0xFFFF]) == '\u0000' && (n9 & 0xFFFF) != 0 ? (bl ? !encodingCharBuffer.lI((byte)((n9 & 0xFFFF) >> 8), (byte)n9) : !encodingCharBuffer.lI((byte)n5)) : !encodingCharBuffer.lI(c, bl ? 2 : 1))) continue;
            break;
        }
        if (cArray != null && iSO2022Decoder != null) {
            if (!iSO2022Decoder.ld() || n7 != 0) {
                iSO2022Decoder.lu = n6;
                iSO2022Decoder.ld = n7;
                iSO2022Decoder.lI = byArray2;
            } else {
                iSO2022Decoder.lu = 11;
                iSO2022Decoder.le = 11;
                iSO2022Decoder.ld = 0;
            }
            iSO2022Decoder.lb = encodingCharBuffer.lj();
        }
        return encodingCharBuffer.lt();
    }

    private int lf(byte[] byArray, int n) {
        if ((byArray[0] & 0xFF) != 27) {
            return -2;
        }
        if (n < 4) {
            return -1;
        }
        if ((byArray[1] & 0xFF) == 36 && (byArray[2] & 0xFF) == 41 && (byArray[3] & 0xFF) == 67) {
            return 5;
        }
        return -2;
    }

    private int lj(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, ISO2022Decoder iSO2022Decoder) {
        Encoding.EncodingCharBuffer encodingCharBuffer = new Encoding.EncodingCharBuffer(this, iSO2022Decoder, cArray, n3, n4, byArray, n, n2);
        int n5 = 11;
        int n6 = -1;
        boolean bl = false;
        if (iSO2022Decoder != null) {
            n5 = iSO2022Decoder.lu;
            if (iSO2022Decoder.ld != 0) {
                n6 = iSO2022Decoder.lI[0] & 0xFF;
            }
        }
        while (encodingCharBuffer.lI() || n6 >= 0) {
            char c;
            int n7;
            if (n6 >= 0) {
                n7 = n6;
                n6 = -1;
            } else {
                n7 = encodingCharBuffer.lf();
            }
            if ((n7 & 0xFF) == 126) {
                if (!encodingCharBuffer.lI()) {
                    if (iSO2022Decoder == null || iSO2022Decoder.ld()) {
                        encodingCharBuffer.lI((byte)n7);
                        break;
                    }
                    if (iSO2022Decoder != null) {
                        iSO2022Decoder.lu();
                    }
                    if (cArray == null) break;
                    iSO2022Decoder.ld = 1;
                    iSO2022Decoder.lI[0] = 126;
                    bl = true;
                    break;
                }
                n7 = encodingCharBuffer.lf();
                if ((n7 & 0xFF) == 126 && n5 == 11) {
                    if (encodingCharBuffer.lI((char)(n7 & 0xFF), 2)) continue;
                    break;
                }
                if ((n7 & 0xFF) == 123) {
                    n5 = 6;
                    continue;
                }
                if ((n7 & 0xFF) == 125) {
                    n5 = 11;
                    continue;
                }
                if ((n7 & 0xFF) == 10) continue;
                encodingCharBuffer.lI(-1);
                n7 = 126;
            }
            if (n5 != 11 && (n7 & 0xFF) >= 32) {
                if (!encodingCharBuffer.lI()) {
                    if (iSO2022Decoder == null || iSO2022Decoder.ld()) {
                        encodingCharBuffer.lI((byte)n7);
                        break;
                    }
                    if (iSO2022Decoder != null) {
                        iSO2022Decoder.lu();
                    }
                    if (cArray == null) break;
                    iSO2022Decoder.ld = 1;
                    iSO2022Decoder.lI[0] = n7;
                    bl = true;
                    break;
                }
                byte by = encodingCharBuffer.lf();
                int n8 = ((n7 & 0xFF) << 8 | by & 0xFF) & 0xFFFF;
                if ((n7 & 0xFF) == 32 && (by & 0xFF) != 0) {
                    c = (char)(by & 0xFF);
                } else {
                    if (!((n7 & 0xFF) >= 33 && (n7 & 0xFF) <= 119 && (by & 0xFF) >= 33 && (by & 0xFF) <= 126 || (n7 & 0xFF) >= 161 && (n7 & 0xFF) <= 247 && (by & 0xFF) >= 161 && (by & 0xFF) <= 254)) {
                        if ((by & 0xFF) == 32 && 33 <= (n7 & 0xFF) && (n7 & 0xFF) <= 125) {
                            n8 = 8481;
                        } else {
                            if (encodingCharBuffer.lI((byte)((n8 & 0xFFFF) >> 8), (byte)n8)) continue;
                            break;
                        }
                    }
                    n8 = (n8 & 0xFFFF | 0x8080) & 0xFFFF;
                    c = this.lv[n8 & 0xFFFF];
                }
                if (!(c == '\u0000' && (n8 & 0xFFFF) != 0 ? !encodingCharBuffer.lI((byte)((n8 & 0xFFFF) >> 8), (byte)n8) : !encodingCharBuffer.lI(c, 2))) continue;
                break;
            }
            c = this.lv[n7 & 0xFF];
            if (!((c == '\u0000' || c == '\u0000') && (n7 & 0xFF) != 0 ? !encodingCharBuffer.lI((byte)n7) : !encodingCharBuffer.lI(c))) continue;
            break;
        }
        if (cArray != null && iSO2022Decoder != null) {
            if (!bl) {
                iSO2022Decoder.ld = 0;
            }
            iSO2022Decoder.lu = iSO2022Decoder.ld() && iSO2022Decoder.ld == 0 ? 11 : n5;
            iSO2022Decoder.lb = encodingCharBuffer.lj();
        }
        return encodingCharBuffer.lt();
    }

    @Override
    public int lI(int n) {
        if (n < 0) {
            throw new lv("charCount", "Non-negative number required.");
        }
        long l = (long)n + 1L;
        if (this.l0y().lf() > 1) {
            l *= (long)this.l0y().lf();
        }
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        switch (this.l1if()) {
            case 50220: 
            case 50221: {
                n2 = 5;
                n4 = 3;
                break;
            }
            case 50222: {
                n2 = 5;
                n4 = 4;
                break;
            }
            case 50225: {
                n2 = 3;
                n3 = 4;
                n4 = 1;
                break;
            }
            case 52936: {
                n2 = 4;
                n4 = 2;
            }
        }
        l *= (long)n2;
        if ((l += (long)(n3 + n4)) > Integer.MAX_VALUE) {
            throw new lv("charCount", "Too many characters. The resulting number of bytes is larger than what can be returned as an int.");
        }
        return (int)l;
    }

    @Override
    public int lf(int n) {
        if (n < 0) {
            throw new lv("byteCount", "Non-negative number required.");
        }
        int n2 = 1;
        int n3 = 1;
        switch (this.l1if()) {
            case 50220: 
            case 50221: 
            case 50222: 
            case 50225: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 52936: {
                n2 = 1;
                n3 = 1;
            }
        }
        long l = (long)n * (long)n2 + (long)n3;
        if (this.l0n().lf() > 1) {
            l *= (long)this.l0n().lf();
        }
        if (l > Integer.MAX_VALUE) {
            throw new lv("byteCount", "Too many bytes. The resulting number of chars is larger than what can be returned as an int.");
        }
        return (int)l;
    }

    @Override
    public Encoder lt() {
        return new ISO2022Encoder(this);
    }

    @Override
    public Decoder lj() {
        return new ISO2022Decoder(this);
    }

    public static class ISO2022Decoder
    extends DecoderNLS {
        public byte[] lI;
        public int ld;
        public int lu;
        public int le;

        public ISO2022Decoder(EncodingNLS encoding) {
            super(encoding);
        }

        @Override
        public void lI() {
            this.ld = 0;
            this.lI = new byte[4];
            this.lu = 11;
            this.le = 11;
            if (this.lj != null) {
                this.lj.lt();
            }
        }

        @Override
        public boolean lf() {
            return this.ld != 0 || this.lu != 11;
        }
    }

    public static class ISO2022Encoder
    extends EncoderNLS {
        public int ld;
        public int lu;

        public ISO2022Encoder(EncodingNLS encoding) {
            super(encoding);
        }

        @Override
        public void lt() {
            this.ld = 11;
            this.lu = 11;
            this.lj = '\u0000';
            if (this.lf != null) {
                this.lf.lt();
            }
        }

        @Override
        public boolean lu() {
            return this.lj != '\u0000' || this.ld != 11;
        }
    }

    public static final class ISO2022Modes
    extends l4j {
        public static final int lI = 0;
        public static final int lf = 1;
        public static final int lj = 5;
        public static final int lt = 6;
        public static final int lb = 7;
        public static final int ld = 9;
        public static final int lu = 10;
        public static final int le = 11;
        public static final int lh = -1;
        public static final int lk = -2;
        public static final int lv = -3;

        private ISO2022Modes() {
        }

        static {
            l4j.register(new l4j.lb(ISO2022Modes.class, Integer.class){
                {
                    this.lI("ModeHalfwidthKatakana", 0L);
                    this.lI("ModeJIS0208", 1L);
                    this.lI("ModeKR", 5L);
                    this.lI("ModeHZ", 6L);
                    this.lI("ModeGB2312", 7L);
                    this.lI("ModeCNS11643_1", 9L);
                    this.lI("ModeCNS11643_2", 10L);
                    this.lI("ModeASCII", 11L);
                    this.lI("ModeIncompleteEscape", -1L);
                    this.lI("ModeInvalidEscape", -2L);
                    this.lI("ModeNOOP", -3L);
                }
            });
        }
    }
}

