/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.System.Text;

import com.aspose.omr.System.Text.DecoderFallback;
import com.aspose.omr.System.Text.DecoderFallbackBuffer;
import com.aspose.omr.System.Text.DecoderNLS;
import com.aspose.omr.System.Text.EncoderNLS;
import com.aspose.omr.System.Text.EncoderReplacementFallback;
import com.aspose.omr.System.Text.Encoding;
import com.aspose.omr.System.l10p;
import com.aspose.omr.System.lh;
import com.aspose.omr.System.lk;
import com.aspose.omr.System.lv;
import com.aspose.omr.l42if.lb;

public class UTF7Encoding
extends Encoding {
    private static final String lf = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String lj = "\t\n\r '(),-./0123456789:?ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String lt = "!\"#$%&*;<=>@[]^_`{|}";
    public static final UTF7Encoding lI = new UTF7Encoding();
    private byte[] lb;
    private byte[] ld;
    private boolean[] lu;
    private boolean le;
    private static final int lh = 65000;

    public UTF7Encoding() {
        this(false);
    }

    public UTF7Encoding(boolean allowOptionals) {
        super(65000);
        this.le = allowOptionals;
        this.lb();
    }

    private void lb() {
        int n;
        int n2;
        this.lb = new byte[64];
        for (n2 = 0; n2 < 64; ++n2) {
            this.lb[n2] = (byte)lf.charAt(n2);
        }
        this.ld = new byte[128];
        for (n2 = 0; n2 < 128; ++n2) {
            this.ld[n2] = -1;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            this.ld[this.lb[n2] & 0xFF] = (byte)n2;
        }
        this.lu = new boolean[128];
        n2 = lj.length();
        for (n = 0; n < n2; ++n) {
            this.lu[lj.charAt((int)n)] = true;
        }
        if (this.le) {
            n2 = lt.length();
            for (n = 0; n < n2; ++n) {
                this.lu[lt.charAt((int)n)] = true;
            }
        }
    }

    @Override
    public void lI() {
        this.l0f = new EncoderReplacementFallback(l10p.lI);
        this.l1if = new DecoderUTF7Fallback();
    }

    @Override
    public boolean equals(Object value) {
        UTF7Encoding uTF7Encoding = (UTF7Encoding)((Object)com.aspose.omr.l42if.lb.lI(value, UTF7Encoding.class));
        if (uTF7Encoding != null) {
            return this.le == uTF7Encoding.le && this.l0y().equals(uTF7Encoding.l0y()) && this.l0n().equals(uTF7Encoding.l0n());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.l1if() + this.l0y().hashCode() + this.l0n().hashCode();
    }

    @Override
    public int lI(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new lk("chars", "Array cannot be null.");
        }
        if (n2 < 0) {
            throw new lv("count", "Non-negative number required.");
        }
        if (n < 0 || n2 < 0) {
            throw new lv(n < 0 ? "index" : "count", "Non-negative number required.");
        }
        if (cArray.length - n < n2) {
            throw new lv("chars", "Index and count must refer to a location within the buffer.");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.lI(cArray, n, n2, null);
    }

    @Override
    public int lI(String string) {
        if (string == null) {
            throw new lk("s");
        }
        char[] cArray = l10p.lv(string);
        return this.lI(cArray, 0, string.length(), null);
    }

    @Override
    public int lI(String string, int n, int n2, byte[] byArray, int n3) {
        if (string == null || byArray == null) {
            throw new lk(string == null ? "s" : "bytes", "Array cannot be null.");
        }
        if (n < 0 || n2 < 0) {
            throw new lv(n < 0 ? "charIndex" : "charCount", "Non-negative number required.");
        }
        if (string.length() - n < n2) {
            throw new lv("s", "Index and count must refer to a location within the string.");
        }
        if (n3 < 0 || n3 > byArray.length) {
            throw new lv("byteIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n4 = byArray.length - n3;
        char[] cArray = l10p.lv(string);
        return this.lI(cArray, n, n2, byArray, n3, n4, null);
    }

    @Override
    public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        if (cArray == null || byArray == null) {
            throw new lk(cArray == null ? "chars" : "bytes", "Array cannot be null.");
        }
        if (n < 0 || n2 < 0) {
            throw new lv(n < 0 ? "charIndex" : "charCount", "Non-negative number required.");
        }
        if (cArray.length - n < n2) {
            throw new lv("chars", "Index and count must refer to a location within the buffer.");
        }
        if (n3 < 0 || n3 > byArray.length) {
            throw new lv("byteIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = byArray.length - n3;
        return this.lI(cArray, n, n2, byArray, n3, n4, null);
    }

    @Override
    public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        if (byArray == null || cArray == null) {
            throw new lk(byArray == null ? "bytes" : "chars", "Array cannot be null.");
        }
        if (n2 < 0 || n4 < 0) {
            throw new lv(n2 < 0 ? "charCount" : "byteCount", "Non-negative number required.");
        }
        return this.lI(cArray, n, n2, byArray, n3, n4, null);
    }

    @Override
    public int lI(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new lk("bytes", "Array cannot be null.");
        }
        if (n2 < 0) {
            throw new lv("count", "Non-negative number required.");
        }
        if (n < 0 || n2 < 0) {
            throw new lv(n < 0 ? "index" : "count", "Non-negative number required.");
        }
        if (byArray.length - n < n2) {
            throw new lv("bytes", "Index and count must refer to a location within the buffer.");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.lI(byArray, n, n2, null);
    }

    @Override
    public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        if (byArray == null || cArray == null) {
            throw new lk(byArray == null ? "bytes" : "chars", "Array cannot be null.");
        }
        if (n < 0 || n2 < 0) {
            throw new lv(n < 0 ? "byteIndex" : "byteCount", "Non-negative number required.");
        }
        if (byArray.length - n < n2) {
            throw new lv("bytes", "Index and count must refer to a location within the buffer.");
        }
        if (n3 < 0 || n3 > cArray.length) {
            throw new lv("charIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = cArray.length - n3;
        return this.lI(byArray, n, n2, cArray, n3, n4, null);
    }

    @Override
    public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) {
        if (byArray == null || cArray == null) {
            throw new lk(byArray == null ? "bytes" : "chars", "Array cannot be null.");
        }
        if (n4 < 0 || n2 < 0) {
            throw new lv(n4 < 0 ? "charCount" : "byteCount", "Non-negative number required.");
        }
        return this.lI(byArray, n, n2, cArray, n3, n4, null);
    }

    @Override
    public String lf(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new lk("bytes", "Array cannot be null.");
        }
        if (n < 0 || n2 < 0) {
            throw new lv(n < 0 ? "index" : "count", "Non-negative number required.");
        }
        if (byArray.length - n < n2) {
            throw new lv("bytes", "Index and count must refer to a location within the buffer.");
        }
        if (n2 == 0) {
            return l10p.lI;
        }
        return this.lt(byArray, n, n2);
    }

    @Override
    public int lI(char[] cArray, int n, int n2, EncoderNLS encoderNLS) {
        return this.lI(cArray, n, n2, null, 0, 0, encoderNLS);
    }

    @Override
    public int lI(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, EncoderNLS encoderNLS) {
        Encoder encoder = (Encoder)encoderNLS;
        int n5 = 0;
        int n6 = -1;
        Encoding.EncodingByteBuffer encodingByteBuffer = new Encoding.EncodingByteBuffer(this, encoder, byArray, n3, n4, cArray, n, n2);
        if (encoder != null) {
            n5 = encoder.ld;
            n6 = encoder.lu;
            while (n6 >= 6) {
                if (encodingByteBuffer.lI(this.lb[n5 >> (n6 -= 6) & 0x3F])) continue;
                this.lI(encoder, encodingByteBuffer.lt() == 0);
            }
        }
        while (encodingByteBuffer.lI()) {
            char c = encodingByteBuffer.lf();
            if (c < '\u0080' && this.lu[c]) {
                if (n6 >= 0) {
                    if (n6 > 0) {
                        if (!encodingByteBuffer.lI(this.lb[n5 << 6 - n6 & 0x3F])) break;
                        n6 = 0;
                    }
                    if (!encodingByteBuffer.lI((byte)45)) break;
                    n6 = -1;
                }
                if (encodingByteBuffer.lI((byte)c)) continue;
                break;
            }
            if (n6 < 0 && c == '+') {
                if (encodingByteBuffer.lI((byte)43, (byte)45)) continue;
                break;
            }
            if (n6 < 0) {
                if (!encodingByteBuffer.lI((byte)43)) break;
                n6 = 0;
            }
            n5 = n5 << 16 | c;
            n6 += 16;
            while (n6 >= 6) {
                if (encodingByteBuffer.lI(this.lb[n5 >> (n6 -= 6) & 0x3F])) continue;
                n6 += 6;
                c = encodingByteBuffer.lf();
                break;
            }
            if (n6 < 6) continue;
            break;
        }
        if (n6 >= 0 && (encoder == null || encoder.ld())) {
            if (n6 > 0 && encodingByteBuffer.lI(this.lb[n5 << 6 - n6 & 0x3F])) {
                n6 = 0;
            }
            if (encodingByteBuffer.lI((byte)45)) {
                n5 = 0;
                n6 = -1;
            } else {
                encodingByteBuffer.lf();
            }
        }
        if (byArray != null && encoder != null) {
            encoder.ld = n5;
            encoder.lu = n6;
            encoder.lb = encodingByteBuffer.lj();
        }
        return encodingByteBuffer.lt();
    }

    @Override
    public int lI(byte[] byArray, int n, int n2, DecoderNLS decoderNLS) {
        return this.lI(byArray, n, n2, null, 0, 0, decoderNLS);
    }

    @Override
    public int lI(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, DecoderNLS decoderNLS) {
        Decoder decoder = (Decoder)decoderNLS;
        Encoding.EncodingCharBuffer encodingCharBuffer = new Encoding.EncodingCharBuffer(this, decoder, cArray, n3, n4, byArray, n, n2);
        int n5 = 0;
        int n6 = -1;
        boolean bl = false;
        if (decoder != null) {
            n5 = decoder.lI;
            n6 = decoder.ld;
            bl = decoder.lu;
        }
        if (n6 >= 16) {
            if (!encodingCharBuffer.lI((char)(n5 >> n6 - 16 & 0xFFFF))) {
                this.lI(decoder, true);
            }
            n6 -= 16;
        }
        while (encodingCharBuffer.lI()) {
            int n7;
            byte by = encodingCharBuffer.lf();
            if (n6 >= 0) {
                byte by2;
                if ((by & 0xFF) < 128 && (by2 = this.ld[by & 0xFF]) >= 0) {
                    bl = false;
                    n5 = n5 << 6 | by2 & 0xFF;
                    if ((n6 += 6) < 16) continue;
                    n7 = n5 >> n6 - 16 & 0xFFFF;
                    n6 -= 16;
                } else {
                    n6 = -1;
                    if ((by & 0xFF) != 45) {
                        if (encodingCharBuffer.lI(by)) continue;
                        break;
                    }
                    if (!bl) continue;
                    n7 = 43;
                }
            } else {
                if ((by & 0xFF) == 43) {
                    n6 = 0;
                    bl = true;
                    continue;
                }
                if ((by & 0xFF) >= 128) {
                    if (encodingCharBuffer.lI(by)) continue;
                    break;
                }
                n7 = by & 0xFF;
            }
            if (n7 < 0 || encodingCharBuffer.lI((char)n7)) continue;
            if (n6 < 0) break;
            encodingCharBuffer.lI(1);
            n6 += 16;
            break;
        }
        if (cArray != null && decoder != null) {
            if (decoder.ld()) {
                decoder.lI = 0;
                decoder.ld = -1;
                decoder.lu = false;
            } else {
                decoder.lI = n5;
                decoder.ld = n6;
                decoder.lu = bl;
            }
            decoder.lb = encodingCharBuffer.lj();
        }
        return encodingCharBuffer.lt();
    }

    @Override
    public com.aspose.omr.System.Text.Decoder lj() {
        return new Decoder(this);
    }

    @Override
    public com.aspose.omr.System.Text.Encoder lt() {
        return new Encoder(this);
    }

    @Override
    public int lI(int n) {
        if (n < 0) {
            throw new lv("charCount", "Non-negative number required.");
        }
        long l = (long)n * 3L + 2L;
        if (l > Integer.MAX_VALUE) {
            throw new lv("charCount", "Too many characters. The resulting number of bytes is larger than what can be returned as an int.");
        }
        return (int)l;
    }

    @Override
    public int lf(int n) {
        if (n < 0) {
            throw new lv("byteCount", "Non-negative number required.");
        }
        int n2 = n;
        if (n2 == 0) {
            n2 = 1;
        }
        return n2;
    }

    private static final class DecoderUTF7FallbackBuffer
    extends DecoderFallbackBuffer {
        private char lj = '\u0000';
        private int lt = -1;
        private int lb;

        public DecoderUTF7FallbackBuffer(DecoderUTF7Fallback fallback) {
        }

        @Override
        public boolean lI(byte[] byArray, int n) {
            this.lj = (char)(byArray[0] & 0xFF);
            if (this.lj == '\u0000') {
                return false;
            }
            this.lb = 1;
            this.lt = 1;
            return true;
        }

        @Override
        public char lI() {
            if (this.lt-- > 0) {
                return this.lj;
            }
            return '\u0000';
        }

        @Override
        public boolean lf() {
            if (this.lt >= 0) {
                ++this.lt;
            }
            return this.lt >= 0 && this.lt <= this.lb;
        }

        @Override
        public int lj() {
            return this.lt > 0 ? this.lt : 0;
        }

        @Override
        public void lt() {
            this.lt = -1;
            this.lI = 0;
        }

        @Override
        public int lf(byte[] byArray, int n) {
            if (byArray.length != 1) {
                throw new lh("String contains invalid Unicode code points.");
            }
            return (byArray[0] & 0xFF) == 0 ? 0 : 1;
        }
    }

    private static final class DecoderUTF7Fallback
    extends DecoderFallback {
        @Override
        public DecoderFallbackBuffer lI() {
            return new DecoderUTF7FallbackBuffer(this);
        }

        @Override
        public int lf() {
            return 1;
        }

        public boolean equals(Object value) {
            DecoderUTF7Fallback decoderUTF7Fallback = (DecoderUTF7Fallback)((Object)com.aspose.omr.l42if.lb.lI(value, DecoderUTF7Fallback.class));
            return decoderUTF7Fallback != null;
        }

        public int hashCode() {
            return 984;
        }
    }

    private static final class Encoder
    extends EncoderNLS {
        public int ld;
        public int lu;

        public Encoder(UTF7Encoding encoding) {
            super(encoding);
        }

        @Override
        public void lt() {
            this.lu = -1;
            this.ld = 0;
            if (this.lf != null) {
                this.lf.lt();
            }
        }

        @Override
        public boolean lu() {
            return this.ld != 0 || this.lu != -1;
        }
    }

    private static final class Decoder
    extends DecoderNLS {
        public int lI;
        public int ld;
        public boolean lu;

        public Decoder(UTF7Encoding encoding) {
            super(encoding);
        }

        @Override
        public void lI() {
            this.lI = 0;
            this.ld = -1;
            this.lu = false;
            if (this.lj != null) {
                this.lj.lt();
            }
        }

        @Override
        public boolean lf() {
            return this.ld != -1;
        }
    }
}

