/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr;

import com.aspose.omr.BarcodeElement;
import com.aspose.omr.BarcodeType;
import com.aspose.omr.OmrPage;
import com.aspose.omr.OmrTemplate;
import com.aspose.omr.RecognitionResult;
import com.aspose.omr.RotationPointPosition;
import com.aspose.omr.System.l5v;
import com.aspose.omr.System.l6h;
import com.aspose.omr.System.lh;
import com.aspose.omr.l0h;
import com.aspose.omr.l0l;
import com.aspose.omr.l0p;
import com.aspose.omr.l0v;
import com.aspose.omr.l0y;
import com.aspose.omr.l10n.l0if;
import com.aspose.omr.l10n.l0j;
import com.aspose.omr.l10n.l2v;
import com.aspose.omr.l10t.l3if;
import com.aspose.omr.l10t.lf;
import com.aspose.omr.l1f;
import com.aspose.omr.l1if;
import com.aspose.omr.l1k;
import com.aspose.omr.l1y;
import com.aspose.omr.l2h;
import com.aspose.omr.l3u;
import com.aspose.omr.l42if.lb;
import com.aspose.omr.l4h;
import com.aspose.omr.l4if;
import com.aspose.omr.l4k;
import com.aspose.omr.l4n;
import com.aspose.omr.l6l;
import com.aspose.omr.l7n;
import com.aspose.omr.l7p;
import com.aspose.omr.l7u;
import com.aspose.omr.l7y;
import com.aspose.omr.l9y.l0p;
import com.aspose.omr.lc;
import com.aspose.omr.lf.l0t;
import com.aspose.omr.lf.l1t;
import com.aspose.omr.lf.l2j;
import com.aspose.omr.lf.l2t;
import com.aspose.omr.lf.lk;
import com.aspose.omr.lf.lu;
import com.aspose.omr.lt;
import com.aspose.omr.lv;
import com.aspose.omr.ly;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class TemplateProcessor {
    private static final int lI = 45;
    private static final int lf = 5;
    private static final int lj = 4;
    private final OmrTemplate lt;
    private final l7p lb;
    private RecognitionResult ld;
    private ly lu;
    private l1k le;
    private l1k lh;
    private double[] lk;
    private int lv;
    private lf lc;

    TemplateProcessor(InputStream stream) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.lt = l7u.lI(stringBuilder.toString());
        this.lb = new l7p(this.lt);
    }

    TemplateProcessor(String templatePath) {
        String string;
        try {
            string = l0if.lv(templatePath);
        }
        catch (RuntimeException runtimeException) {
            throw new l0j("Could not load the specified file.", templatePath, runtimeException);
        }
        this.lt = l7u.lI(string);
        this.lb = new l7p(this.lt);
    }

    public final RecognitionResult recognizeImage(String imagePath) throws FileNotFoundException {
        return this.recognizeImage(imagePath, -100);
    }

    public final RecognitionResult recognizeImage(String imagePath, int recognitionThreshold) throws FileNotFoundException {
        this.lI(new FileInputStream(imagePath));
        RecognitionResult recognitionResult = this.lI(imagePath, recognitionThreshold);
        l4if.lI().lI(1L);
        return recognitionResult;
    }

    public final RecognitionResult recognizeImage(InputStream inputStream) {
        return this.recognizeImage(inputStream, -100);
    }

    public final RecognitionResult recognizeImage(InputStream inputStream, int recognitionThreshold) {
        this.lI(inputStream);
        RecognitionResult recognitionResult = this.lI("stream", recognitionThreshold);
        l4if.lI().lI(1L);
        return recognitionResult;
    }

    public final RecognitionResult recognizeImage(BufferedImage bufferedImage) {
        return this.recognizeImage(bufferedImage, -100);
    }

    public final RecognitionResult recognizeImage(BufferedImage bufferedImage, int recognitionThreshold) {
        this.lI(bufferedImage);
        RecognitionResult recognitionResult = this.lI("stream", recognitionThreshold);
        l4if.lI().lI(1L);
        return recognitionResult;
    }

    final RecognitionResult lI(String string, int n) {
        int n2 = n == -100 ? 45 : n;
        lc[] lcArray = this.lI(n2);
        RecognitionResult recognitionResult = l7u.lj(lcArray);
        this.lI(recognitionResult);
        recognitionResult.setImagePath(string);
        recognitionResult.setTemplateName(this.lt.getName());
        this.ld = recognitionResult;
        return recognitionResult;
    }

    private void lI(RecognitionResult recognitionResult) {
        OmrPage omrPage = this.lt.getPages().lf(0);
        com.aspose.omr.l9y.l0p<BarcodeElement> l0p2 = new com.aspose.omr.l9y.l0p<BarcodeElement>(10);
        for (int i = 0; i < omrPage.getElements().size(); ++i) {
            if (!(omrPage.getElements().lf(i) instanceof BarcodeElement)) continue;
            BarcodeElement barcodeElement = (BarcodeElement)omrPage.getElements().lf(i);
            l0p2.add(barcodeElement);
        }
        if (l0p2.size() == 0) {
            return;
        }
        BufferedImage bufferedImage = this.lI(com.aspose.omr.l10t.l1y.lI(this.le.lt()));
        for (int i = 0; i < l0p2.size(); ++i) {
            if (!l3u.lh() && this.lb.lI >= l3u.lI.length()) continue;
            ++this.lb.lI;
            BarcodeElement barcodeElement = (BarcodeElement)l0p2.lf(i);
            lu lu2 = new lu();
            l0t l0t2 = this.lI(barcodeElement.BarcodeType);
            lu2.lI(l0t2);
            lu2.lI(l2t.lj());
            l3if l3if2 = barcodeElement.getRect();
            com.aspose.omr.lk lk2 = com.aspose.omr.lk.lI(l3if2);
            l4h[] l4hArray = lk2.ld();
            l4h[] l4hArray2 = l7n.lI(l4hArray, this.lk);
            Rectangle rectangle = com.aspose.omr.lk.lI(l4hArray2);
            lu2.lI(bufferedImage, rectangle);
            lt lt2 = new lt();
            lt2.setQuestionName(barcodeElement.getName());
            lk[] lkArray = lu2.ld();
            if (lkArray != null || lkArray.length != 0) {
                for (int j = 0; j < lkArray.length; ++j) {
                    lt2.lI(lkArray[j].lj());
                }
            }
            recognitionResult.getOmrElements().add(lt2);
        }
    }

    private BufferedImage lI(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    final l0t lI(BarcodeType barcodeType) {
        String string = barcodeType.toString().toLowerCase();
        l2j[] l2jArray = l1t.lf();
        for (int i = 0; i < l2jArray.length; ++i) {
            if (!l2jArray[i].lf().toLowerCase().equals(string)) continue;
            return l2jArray[i];
        }
        return l1t.l5f;
    }

    public final void recalculate(RecognitionResult result) {
        this.lI(result, -100);
        l4if.lI().lI(1L);
    }

    public final void recalculate(RecognitionResult result, int recognitionThreshold) {
        this.lI(result, recognitionThreshold);
        l4if.lI().lI(1L);
    }

    final void lI(RecognitionResult recognitionResult, int n) {
        int n2;
        if (n < 0 || n > 100) {
            throw new lh("The Recognition Threshold parameter must be in range (0..100).", l6h.lf(n));
        }
        RecognitionResult recognitionResult2 = this.ld;
        int n3 = n2 = n == -100 ? 45 : n;
        if (recognitionResult2 == null || !this.lI(recognitionResult2, recognitionResult)) {
            lc[] lcArray = l7u.lI(recognitionResult);
            l7u.lf(lcArray);
            this.lu.lI(lcArray);
            this.lI(lcArray, n2);
            l7u.lI(lcArray);
        } else {
            lc[] lcArray = l7u.lI(recognitionResult);
            this.lf(lcArray, n2);
        }
        this.ld = recognitionResult;
    }

    private lc[] lI(int n) {
        com.aspose.omr.l9y.l0p<l0h> l0p2 = this.lI(this.lu);
        OmrPage omrPage = this.lt.getPages().lf(0);
        RotationPointPosition rotationPointPosition = RotationPointPosition.undefined;
        if (omrPage != null && omrPage.getRotationPointPosition() != RotationPointPosition.undefined) {
            rotationPointPosition = omrPage.getRotationPointPosition();
        }
        if (rotationPointPosition == RotationPointPosition.undefined) {
            throw new l5v("Unable to determine position of rotation reference point inside .omr file.  Since version 25.8 we use 5 reference points. Please generate template using latest version.");
        }
        l4k l4k2 = new l4k(this.lu);
        l4n l4n2 = l4k2.lI(l0p2);
        if (l4n2.ld == null) {
            throw new l5v("Unable to detect rotation rectangle. Since version 25.8 we use 5 reference points. Please generate template using latest version.");
        }
        l1y l1y2 = new l1y();
        l6l l6l2 = l1y2.lI(l4n2.ld, rotationPointPosition);
        l6l l6l3 = l1y2.lI(l6l2);
        if (l6l3.l0v != l6l.lf.l0v) {
            this.lc.lh(l6l3.l0v);
            this.lI(this.lc);
            l0p2 = this.lI(this.lu);
            l4k2 = new l4k(this.lu);
            l4n2 = l4k2.lI(l0p2);
            l1y2 = new l1y();
            l6l2 = l1y2.lI(l4n2.ld, rotationPointPosition);
            l6l3 = l1y2.lI(l6l2);
        }
        if (l6l3.l0v != l6l.lf.l0v) {
            throw new RuntimeException("Unable to rotate template");
        }
        com.aspose.omr.l9y.l0p<l0h> l0p3 = l4n2.lI();
        lc[] lcArray = this.lI(l0p3, this.lu.lf(), this.lu.lj());
        this.lu.lI(lcArray);
        this.lI(lcArray, n);
        l7u.lI(lcArray);
        return lcArray;
    }

    private void lI(lc[] lcArray, int n) {
        l7y l7y2 = new l7y();
        l2h l2h2 = l7y2.lI();
        l2h2.lI(lcArray, n);
    }

    private void lf(lc[] lcArray, int n) {
        l7y l7y2 = new l7y();
        l2h l2h2 = l7y2.lI();
        l2h2.lf(lcArray, n);
    }

    final void lI(BufferedImage bufferedImage) {
        lf lf2 = this.lf(bufferedImage);
        this.lI(lf2);
    }

    final void lI(InputStream inputStream) {
        lf lf2 = this.lf(inputStream);
        this.lI(lf2);
    }

    final void lI(lf lf2) {
        long l = this.lf(lf2);
        this.lc = lf2;
        this.lh = l1k.lI(lf2, l);
        this.le = l1if.lj(this.lh);
        this.lu = com.aspose.omr.lv.lI(this.le, 8);
    }

    final long lf(lf lf2) {
        int n = com.aspose.omr.l10t.lf.lI(lf2.ly());
        int n2 = n / 8;
        return (long)(lf2.l0u() * lf2.lh() * n2) / 66L;
    }

    final lf lf(BufferedImage bufferedImage) {
        return com.aspose.omr.l10t.lf.lI(bufferedImage);
    }

    final lf lf(InputStream inputStream) {
        l2v l2v2 = l2v.lf(inputStream);
        return (lf)com.aspose.omr.l10t.l1y.lI(l2v2);
    }

    private com.aspose.omr.l9y.l0p<l0h> lI(ly ly2) {
        l0y l0y2 = new l0y();
        com.aspose.omr.l9y.l0p<l0h> l0p2 = l0y2.lI(ly2);
        l0v.lI(l0p2);
        com.aspose.omr.l9y.l0p<l0h> l0p3 = new com.aspose.omr.l9y.l0p<l0h>(l0p2.size());
        l0p.lI<l0h> lI2 = l0p2.l0v();
        while (lI2.hasNext()) {
            l0h l0h2 = (l0h)lI2.next();
            if (l0h2.l0if() < 0.8) continue;
            l0p3.add(l0h2);
        }
        return l0p3;
    }

    private com.aspose.omr.l9y.l0p<l0h> lI(com.aspose.omr.l9y.l0p<l0h> l0p2) {
        l0p l0p3 = new l0p();
        com.aspose.omr.l2v l2v2 = l0p3.lI();
        l2v2.lI(l0p2);
        com.aspose.omr.l9y.l0p<l0h> l0p4 = new com.aspose.omr.l9y.l0p<l0h>();
        for (int i = 0; i < l0p2.size(); ++i) {
            if (!l0p2.lf(i).l0t()) continue;
            l0p4.a_(l0p2.lf(i));
        }
        return l0p4;
    }

    private lc[] lI(com.aspose.omr.l9y.l0p<l0h> l0p2, int n, int n2) {
        double d;
        double d2;
        double d3 = this.lt.getPages().lf(0).getWidth();
        double d4 = d3 / (double)n;
        boolean bl = this.lb.lI(l0p2, d4, d2 = (d = this.lt.getPages().lf(0).getHeight()) / (double)n2);
        if (!bl) {
            throw new l5v("Failed to find matching between the template and the image!");
        }
        this.lk = this.lb.lI(l0p2, this.le);
        lc[] lcArray = this.lb.lI(this.lt, this.lk);
        return lcArray;
    }

    private boolean lI(RecognitionResult recognitionResult, RecognitionResult recognitionResult2) {
        if (recognitionResult.lI().size() != recognitionResult2.lI().size()) {
            return false;
        }
        for (int i = 0; i < recognitionResult.lI().size(); ++i) {
            l0l l0l2 = (l0l)((Object)com.aspose.omr.l42if.lb.lI(recognitionResult.lI().lf(i), l0l.class));
            l0l l0l3 = (l0l)((Object)com.aspose.omr.l42if.lb.lI(recognitionResult2.lI().lf(i), l0l.class));
            if (l0l2 != null && l0l3 != null) {
                for (int j = 0; j < l0l2.lI().size(); ++j) {
                    if (l0l2.lI().lf(j).lf().lI(l0l3.lI().lf(j).lf().lb())) continue;
                    return false;
                }
                continue;
            }
            l1f l1f2 = (l1f)((Object)com.aspose.omr.l42if.lb.lI(recognitionResult.lI().lf(i), l1f.class));
            l1f l1f3 = (l1f)((Object)com.aspose.omr.l42if.lb.lI(recognitionResult2.lI().lf(i), l1f.class));
            if (l1f2 == null || l1f3 == null) continue;
            for (int j = 0; j < l1f2.lI().size(); ++j) {
                for (int k = 0; k < l1f2.lI().lf(j).lI().size(); ++k) {
                    if (l1f2.lI().lf(j).lI().lf(k).lf().lI(l1f3.lI().lf(j).lI().lf(k).lf().lb())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

