/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.page.font;

import com.aspose.page.font.TTFont;
import com.aspose.page.internal.l17l.I57;
import com.aspose.page.internal.l197.I04;
import com.aspose.page.internal.l197.I164;
import com.aspose.page.internal.l197.I21l;
import com.aspose.page.internal.l197.I254;
import com.aspose.page.internal.l197.I257;
import com.aspose.page.internal.l197.I51;
import com.aspose.page.internal.l201.I367;
import com.aspose.page.internal.l41.I3l;
import com.aspose.page.internal.l47.I1l;
import com.aspose.page.internal.l47.I34;
import com.aspose.page.internal.l837.I07;

public class DrFont {
    private TTFont lif;
    private float ll;
    private int lI;
    private float l1;
    private float lIF;
    private float llf;
    private int liF;
    private short lIf;
    private float lf;

    public DrFont(float sizePoints, int style, TTFont trueTypeFont, int capitals) {
        if (trueTypeFont == null) {
            throw new I04("trueTypeFont");
        }
        this.lif = trueTypeFont;
        this.ll = sizePoints;
        this.lI = style;
        this.l1 = this.lif.designUnitsToPoints(this.lif.getAscent(), this.ll);
        this.lIF = this.lif.designUnitsToPoints(this.lif.getDescent(), this.ll);
        this.llf = this.lif.designUnitsToPoints(this.lif.getLineSpacing(), this.ll);
        this.liF = capitals;
        if (capitals == 2) {
            float f = I57.lif(this.lif) * 1000;
            float f2 = I57.ll(this.lif) * 1000;
            this.lf = (f2 *= 1.1f) / f;
        }
    }

    public DrFont(float sizePoints, int style, TTFont trueTypeFont) {
        this(sizePoints, style, trueTypeFont, 1);
    }

    public void replace(DrFont font) {
        this.lif = font.lif;
        this.ll = font.ll;
        this.lI = font.lI;
        this.l1 = font.l1;
        this.lIF = font.lIF;
        this.llf = font.llf;
    }

    public TTFont getTrueTypeFont() {
        return this.lif;
    }

    public int getStyle() {
        return this.lI;
    }

    public boolean isBold() {
        return (this.lI & 1) != 0;
    }

    public boolean isItalic() {
        return (this.lI & 2) != 0;
    }

    public int getCapitals() {
        return this.liF;
    }

    public float getSmallCapsScaleFactor() {
        return this.lf;
    }

    public String getFamilyName() {
        return this.lif.lif();
    }

    public float getSizePoints() {
        return this.ll;
    }

    public void setSizePoints(float value) {
        this.ll = value;
    }

    public float getAscentPoints() {
        return this.l1;
    }

    public float getDescentPoints() {
        return this.lIF;
    }

    public float getCellHeightPoints() {
        return this.l1 + this.lIF;
    }

    public int getAscentLis() {
        return I1l.l1If(this.l1);
    }

    public int getDescentLis() {
        return I1l.l1If(this.lIF);
    }

    public int getCellHeightLis() {
        return this.getAscentLis() + this.getDescentLis();
    }

    public int getLeadingLis() {
        return this.getLineSpacingLis() - this.getCellHeightLis();
    }

    public float getLeadingPoints() {
        return this.getLineSpacingPoints() - this.getCellHeightPoints();
    }

    public int getLineSpacingLis() {
        return I1l.l1If(this.llf);
    }

    public float getLineSpacingPoints() {
        return this.llf;
    }

    public float getCharWidthPoints(char c) {
        if (this.liF == 2 && I51.lf(c)) {
            c = I51.l11(c);
            float f = this.lif.getCharWidthPoints(c, this.ll);
            f *= 1000.0f;
            f *= this.lf;
            return f /= 1000.0f;
        }
        return this.lif.getCharWidthPoints(c, this.ll);
    }

    public float getTextWidthPoints(String text) {
        if (this.liF == 1) {
            return this.lif.getTextWidthPoints(text, this.ll);
        }
        return this.getTextWidthPoints(text, 0, text.length());
    }

    public float getTextWidthPoints(String text, int startIndex, int charCount) {
        if (this.liF == 1) {
            return this.lif.getTextWidthPoints(text, startIndex, charCount, this.ll);
        }
        float f = 0.0f;
        I3l i3l = new I3l(I254.ll(text, startIndex, charCount));
        while (i3l.hasNext()) {
            if (!i3l.ll().lif()) {
                f += this.lif.getTextWidthPoints(i3l.ll().ll(), this.ll) * 1000.0f;
                continue;
            }
            float f2 = this.lif.getTextWidthPoints(I254.l0IF(i3l.ll().ll()), this.ll);
            f2 *= 1000.0f;
            f += (f2 *= this.lf);
        }
        return f / 1000.0f;
    }

    public I367 getTextSizePoints_OLD(String text) {
        float f = this.getTextWidthPoints(text);
        if (!I254.ll(text) && f == 0.0f) {
            return new I367(f, this.getSizePoints() * 1.33f);
        }
        return new I367(f, (double)this.getSizePoints() * 0.5 > (double)this.getCellHeightPoints() ? this.getSizePoints() : (float)this.getCellHeightLis());
    }

    public I367 getTextSizePoints(String text) {
        float f = this.getTextWidthPoints(text);
        if (!I254.ll(text) && f == 0.0f) {
            return new I367(f, this.getSizePoints() * 1.33f);
        }
        return new I367(f, (double)this.getSizePoints() * 0.5 > (double)this.getCellHeightPoints() ? this.getSizePoints() : this.getCellHeightPoints());
    }

    public int getCharWidthLis(char c) {
        return I1l.l1If(this.getCharWidthPoints(c));
    }

    public int getTextWidthLis(String text) {
        return I1l.l1If(this.getTextWidthPoints(text));
    }

    public static boolean isPoorlyRenderedByGdiPlus(String fontName) {
        return I34.ll(fontName, "Microsoft Sans Serif");
    }

    public short getStyleEx() {
        return this.lIf;
    }

    public void setStyleEx(short value) {
        this.lIf = value;
    }

    protected boolean lif(DrFont drFont) {
        return I21l.lif(this.lif, drFont.lif) && I257.ll(this.ll, drFont.ll) && this.lI == drFont.lI && I257.ll(this.l1, drFont.l1) && I257.ll(this.lIF, drFont.lIF) && I257.ll(this.llf, drFont.llf) && this.liF == drFont.liF && this.lIf == drFont.lIf && I257.ll(this.lf, drFont.lf);
    }

    public boolean equals(Object obj) {
        DrFont drFont = (DrFont)((Object)I07.lif(obj, DrFont.class));
        if (I21l.ll(null, drFont)) {
            return false;
        }
        if (I21l.ll(this, drFont)) {
            return true;
        }
        return this.lif(drFont);
    }

    public int hashCode() {
        int n = this.lif != null ? this.lif.hashCode() : 0;
        n = n * 397 ^ I257.lif(this.ll);
        n = n * 397 ^ this.lI;
        n = n * 397 ^ I257.lif(this.l1);
        n = n * 397 ^ I257.lif(this.lIF);
        n = n * 397 ^ I257.lif(this.llf);
        n = n * 397 ^ this.liF;
        n = n * 397 ^ I164.lif(this.lIf);
        n = n * 397 ^ I257.lif(this.lf);
        return n;
    }
}

