/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.xps.metadata;

import com.aspose.page.internal.l197.I254;
import com.aspose.xps.metadata.Feature;
import com.aspose.xps.metadata.IFeatureItem;
import com.aspose.xps.metadata.IOptionItem;
import com.aspose.xps.metadata.IPrintTicketElementChild;
import com.aspose.xps.metadata.IPropertyItem;
import com.aspose.xps.metadata.IScoredPropertyItem;
import com.aspose.xps.metadata.IntegerValue;
import com.aspose.xps.metadata.Option;
import com.aspose.xps.metadata.Property;
import com.aspose.xps.metadata.ScoredProperty;
import com.aspose.xps.metadata.SelectionType;
import com.aspose.xps.metadata.StringValue;

public abstract class InputBin
extends Feature {
    InputBin(String name, IInputBinItem ... items) {
        super(name, items);
        this.lif(0, (IPrintTicketElementChild)SelectionType.PickOne);
    }

    public static final class InputBinOption
    extends Option
    implements IInputBinItem {
        private static final String[] lif = new String[]{"psk:BinType", "psk:FeedType", "psk:MediaCapacity", "psk:MediaSizeAutoSense", "psk:MediaTypeAutoSense", "psk:MediaSheetCapacity", "psk:MediaPath", "psk:FeedFace", "psk:FeedDirection"};
        public static final InputBinOption AutoSelect = new InputBinOption("psk:AutoSelect");
        public static final InputBinOption Manual = (InputBinOption)new InputBinOption("psk:Manual", FeedType.Manual).makeConst();
        public static final InputBinOption Cassette = (InputBinOption)new InputBinOption("psk:Cassette", BinType.SheetFeed).makeConst();
        public static final InputBinOption Tractor = (InputBinOption)new InputBinOption("psk:Tractor", BinType.ContinuousFeed).makeConst();
        public static final InputBinOption AutoSheetFeeder = new InputBinOption("psk:AutoSheetFeeder");

        public InputBinOption(String optionName, IInputBinOptionItem ... items) {
            super(optionName, (IOptionItem[])items);
        }

        private InputBinOption(InputBinOption option) {
            super(option);
        }

        private InputBinOption(String name) {
            super(name, new IOptionItem[0]);
            this.makeConst();
        }

        public InputBinOption add(IInputBinOptionItem ... items) {
            super.add(items);
            return this;
        }

        public InputBinOption clone() {
            return new InputBinOption(this);
        }

        @Override
        String[] aj_() {
            return lif;
        }
    }

    public static final class FeedDirection
    extends Property
    implements IInputBinOptionItem {
        public static final FeedDirection LongEdgeFirst = new FeedDirection("LongEdgeFirst");
        public static final FeedDirection ShortEdgeFirst = new FeedDirection("ShortEdgeFirst");

        private FeedDirection(String value) {
            super("psk:FeedDirection", new StringValue(value), new IPropertyItem[0]);
        }
    }

    public static final class FeedFace
    extends Property
    implements IInputBinOptionItem {
        public static final FeedFace FaceUp = new FeedFace("FaceUp");
        public static final FeedFace FaceDown = new FeedFace("FaceDown");

        private FeedFace(String value) {
            super("psk:FeedFace", new StringValue(value), new IPropertyItem[0]);
        }
    }

    public static final class MediaPath
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static final MediaPath Straight = new MediaPath("Straight");
        public static final MediaPath Serpentine = new MediaPath("Serpentine");

        private MediaPath(String value) {
            super("psk:MediaPath", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class MediaSheetCapacity
    extends ScoredProperty
    implements IInputBinOptionItem {
        public MediaSheetCapacity(int mediaSheetCapacity) {
            super("psk:MediaSheetCapacity", new IntegerValue(mediaSheetCapacity), new IScoredPropertyItem[0]);
            if (mediaSheetCapacity <= 0) {
                throw new IllegalArgumentException(I254.lif("Invalid value: {0}.", new Object[]{mediaSheetCapacity}));
            }
        }
    }

    public static final class MediaTypeAutoSense
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static final MediaTypeAutoSense Supported = new MediaTypeAutoSense("Supported");
        public static final MediaTypeAutoSense None = new MediaTypeAutoSense("None");

        private MediaTypeAutoSense(String value) {
            super("psk:MediaTypeAutoSense", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class MediaSizeAutoSense
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static final MediaSizeAutoSense Supported = new MediaSizeAutoSense("Supported");
        public static final MediaSizeAutoSense None = new MediaSizeAutoSense("None");

        private MediaSizeAutoSense(String value) {
            super("psk:MediaSizeAutoSense", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class MediaCapacity
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static final MediaCapacity High = new MediaCapacity("High");
        public static final MediaCapacity Standard = new MediaCapacity("Standard");

        private MediaCapacity(String value) {
            super("psk:MediaCapacity", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class FeedType
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static final FeedType Automatic = new FeedType("Automatic");
        public static final FeedType Manual = new FeedType("Manual");

        private FeedType(String value) {
            super("psk:FeedType", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class BinType
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static final BinType ContinuousFeed = new BinType("ContinuousFeed");
        public static final BinType SheetFeed = new BinType("SheetFeed");

        private BinType(String value) {
            super("psk:BinType", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static interface IInputBinOptionItem
    extends IOptionItem {
    }

    public static interface IInputBinItem
    extends IFeatureItem {
    }
}

