/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.xps.plugins;

import com.aspose.page.Document;
import com.aspose.page.I0I;
import com.aspose.page.ImageFormat;
import com.aspose.page.internal.l197.I254;
import com.aspose.page.internal.l22l.I51;
import com.aspose.page.plugins.ByteArrayResult;
import com.aspose.page.plugins.FileDataSource;
import com.aspose.page.plugins.FileResult;
import com.aspose.page.plugins.IDataSource;
import com.aspose.page.plugins.IPlugin;
import com.aspose.page.plugins.IPluginOptions;
import com.aspose.page.plugins.Plugin;
import com.aspose.page.plugins.ResultContainer;
import com.aspose.page.plugins.StreamDataSource;
import com.aspose.page.plugins.StreamResult;
import com.aspose.xps.LoadOptions;
import com.aspose.xps.XpsDocument;
import com.aspose.xps.XpsLoadOptions;
import com.aspose.xps.plugins.XpsConverterToImageOptions;
import com.aspose.xps.plugins.XpsConverterToPdfOptions;
import com.aspose.xps.rendering.BmpSaveOptions;
import com.aspose.xps.rendering.ImageSaveOptions;
import com.aspose.xps.rendering.JpegSaveOptions;
import com.aspose.xps.rendering.PdfSaveOptions;
import com.aspose.xps.rendering.PngSaveOptions;
import com.aspose.xps.rendering.TiffSaveOptions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class XpsConverter
implements IPlugin {
    @Override
    public final ResultContainer process(IPluginOptions options) throws Exception {
        if (options == null) {
            throw new IllegalArgumentException("Options must not be null.");
        }
        try {
            if (options instanceof XpsConverterToPdfOptions) {
                return this.lif((XpsConverterToPdfOptions)options);
            }
            if (options instanceof XpsConverterToImageOptions) {
                return this.lif((XpsConverterToImageOptions)options);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Exception caught: ", iOException);
        }
        throw new UnsupportedOperationException("Processing XpsConverter assumes an options object of IPluginOptions type.");
    }

    private ResultContainer lif(XpsConverterToPdfOptions xpsConverterToPdfOptions) throws Exception {
        ResultContainer resultContainer = new ResultContainer();
        InputStream inputStream = null;
        for (int i = 0; i < xpsConverterToPdfOptions.getDataCollection().size(); ++i) {
            String string = "";
            inputStream = xpsConverterToPdfOptions.lif(i);
            XpsDocument xpsDocument = new XpsDocument(inputStream, (LoadOptions)new XpsLoadOptions());
            I0I.lif((Document)xpsDocument, Plugin.XpsConverter);
            PdfSaveOptions pdfSaveOptions = this.ll(xpsConverterToPdfOptions);
            IDataSource iDataSource = xpsConverterToPdfOptions.getSaveTargetsCollection().get(i);
            OutputStream outputStream = null;
            if (iDataSource.getDataType() == 0) {
                string = ((FileDataSource)iDataSource).getPath();
                resultContainer.getResultCollection().add(new FileResult(string));
                outputStream = new FileOutputStream(string);
            } else if (iDataSource.getDataType() == 1) {
                outputStream = ((StreamDataSource)iDataSource).getOutputStream();
                resultContainer.getResultCollection().add(new StreamResult(outputStream));
            } else {
                throw new IllegalArgumentException("Unsupported output DataType: options");
            }
            xpsDocument.saveAsPdf(outputStream, pdfSaveOptions);
            if (xpsConverterToPdfOptions.getSaveTargetsCollection().get(i).getDataType() == 1 || xpsConverterToPdfOptions.getSaveTargetsCollection().get(i).getDataType() != 0) continue;
            outputStream.flush();
            outputStream.close();
        }
        return resultContainer;
    }

    private PdfSaveOptions ll(XpsConverterToPdfOptions xpsConverterToPdfOptions) {
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        xpsConverterToPdfOptions.setPageNumbers(pdfSaveOptions.getPageNumbers());
        pdfSaveOptions.setJpegQualityLevel(xpsConverterToPdfOptions.getJpegQualityLevel());
        return pdfSaveOptions;
    }

    /*
     * WARNING - void declaration
     */
    private ResultContainer lif(XpsConverterToImageOptions xpsConverterToImageOptions) throws Exception {
        ResultContainer resultContainer = new ResultContainer();
        InputStream inputStream = null;
        for (int i = 0; i < xpsConverterToImageOptions.getDataCollection().size(); ++i) {
            int n;
            void var14_17;
            String string = "";
            inputStream = xpsConverterToImageOptions.lif(i);
            XpsDocument xpsDocument = new XpsDocument(inputStream, (LoadOptions)new XpsLoadOptions());
            I0I.lif((Document)xpsDocument, Plugin.XpsConverter);
            ImageSaveOptions imageSaveOptions = this.ll(xpsConverterToImageOptions);
            IDataSource iDataSource = xpsConverterToImageOptions.getSaveTargetsCollection().get(i);
            Object var9_9 = null;
            if (iDataSource.getDataType() == 0) {
                string = ((FileDataSource)iDataSource).getPath();
            }
            if (xpsConverterToImageOptions.getSize() != null) {
                imageSaveOptions.setImageSize(xpsConverterToImageOptions.getSize());
            }
            byte[][][] byArray = xpsDocument.saveAsImageBytes(imageSaveOptions);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            byte[][][] byArray2 = byArray;
            int n2 = byArray2.length;
            boolean bl = false;
            while (var14_17 < n2) {
                byte[][] byArray3 = byArray2[var14_17];
                n = 0;
                for (byte[] byArray4 : byArray3) {
                    arrayList.add(byArray3[n++]);
                }
                ++var14_17;
            }
            byte[][] byArrayArray = new byte[arrayList.size()][];
            byte[][] object = (byte[][])arrayList.toArray((T[])byArrayArray);
            if (xpsConverterToImageOptions.getSaveTargetsCollection().get(i).getDataType() == 2) {
                resultContainer.getResultCollection().add(new ByteArrayResult(object));
                continue;
            }
            resultContainer.getResultCollection().add(new FileResult(string));
            n2 = 0;
            byte[][] byArray5 = object;
            int n3 = byArray5.length;
            for (n = 0; n < n3; ++n) {
                Object object2 = byArray5[n];
                if (xpsConverterToImageOptions.getSaveTargetsCollection().get(i).getDataType() != 0) {
                    throw new IllegalArgumentException("Unsupported output DataType: options");
                }
                String string2 = I254.lif("{0}{1}{2}_{3:D}{4}", I51.llf(string), Character.valueOf(I51.lI), I51.ll(string), n2 + 1, I51.lIF(string));
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                fileOutputStream.write((byte[])object2, 0, ((byte[][])object2).length);
                ++n2;
            }
        }
        return resultContainer;
    }

    private ImageSaveOptions ll(XpsConverterToImageOptions xpsConverterToImageOptions) {
        ImageSaveOptions imageSaveOptions = null;
        if (xpsConverterToImageOptions.getImageFormat().equals((Object)ImageFormat.PNG)) {
            imageSaveOptions = new PngSaveOptions();
        } else if (xpsConverterToImageOptions.getImageFormat().equals((Object)ImageFormat.JPEG)) {
            imageSaveOptions = new JpegSaveOptions();
            imageSaveOptions.setJpegQualityLevel(xpsConverterToImageOptions.getJpegQualityLevel());
        } else if (xpsConverterToImageOptions.getImageFormat().equals((Object)ImageFormat.TIFF)) {
            imageSaveOptions = new TiffSaveOptions();
        } else if (xpsConverterToImageOptions.getImageFormat().equals((Object)ImageFormat.BMP)) {
            imageSaveOptions = new BmpSaveOptions();
        } else {
            throw new IllegalArgumentException("Image format " + xpsConverterToImageOptions.getImageFormat().toString() + " is not supported yet.");
        }
        imageSaveOptions.setPageNumbers(xpsConverterToImageOptions.getPageNumbers());
        imageSaveOptions.setResolution(xpsConverterToImageOptions.getResolution());
        if (xpsConverterToImageOptions.getSmoothingMode() != null) {
            imageSaveOptions.setSmoothingMode(xpsConverterToImageOptions.getSmoothingMode());
        }
        return imageSaveOptions;
    }

    public final void dispose() {
    }
}

