/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.eps.plugins;

import com.aspose.eps.PsDocument;
import com.aspose.eps.device.ImageSaveOptions;
import com.aspose.eps.device.PdfSaveOptions;
import com.aspose.eps.plugins.PsConverterToImageOptions;
import com.aspose.eps.plugins.PsConverterToPdfOptions;
import com.aspose.page.Document;
import com.aspose.page.I0I;
import com.aspose.page.internal.l197.I254;
import com.aspose.page.internal.l22l.I51;
import com.aspose.page.plugins.ByteArrayResult;
import com.aspose.page.plugins.FileDataSource;
import com.aspose.page.plugins.FileResult;
import com.aspose.page.plugins.IDataSource;
import com.aspose.page.plugins.IPlugin;
import com.aspose.page.plugins.IPluginOptions;
import com.aspose.page.plugins.Plugin;
import com.aspose.page.plugins.ResultContainer;
import com.aspose.page.plugins.StreamDataSource;
import com.aspose.page.plugins.StreamResult;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PsConverter
implements IPlugin {
    @Override
    public final ResultContainer process(IPluginOptions options) throws Exception {
        if (options == null) {
            throw new IllegalArgumentException("Options must not be null.");
        }
        try {
            if (options instanceof PsConverterToPdfOptions) {
                return this.lif((PsConverterToPdfOptions)options);
            }
            if (options instanceof PsConverterToImageOptions) {
                return this.lif((PsConverterToImageOptions)options);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Exception caught: ", iOException);
        }
        throw new UnsupportedOperationException("Processing PsConverter assumes an options object of IPluginOptions type.");
    }

    private ResultContainer lif(PsConverterToPdfOptions psConverterToPdfOptions) throws Exception {
        ResultContainer resultContainer = new ResultContainer();
        InputStream inputStream = null;
        for (int i = 0; i < psConverterToPdfOptions.getDataCollection().size(); ++i) {
            String string = "";
            inputStream = psConverterToPdfOptions.lif(i);
            PsDocument psDocument = new PsDocument(inputStream);
            I0I.lif((Document)psDocument, Plugin.PsConverter);
            PdfSaveOptions pdfSaveOptions = this.ll(psConverterToPdfOptions);
            IDataSource iDataSource = psConverterToPdfOptions.getSaveTargetsCollection().get(i);
            OutputStream outputStream = null;
            if (iDataSource.getDataType() == 0) {
                string = ((FileDataSource)iDataSource).getPath();
                resultContainer.getResultCollection().add(new FileResult(string));
                outputStream = new FileOutputStream(string);
            } else if (iDataSource.getDataType() == 1) {
                outputStream = ((StreamDataSource)iDataSource).getOutputStream();
                resultContainer.getResultCollection().add(new StreamResult(outputStream));
            } else {
                throw new IllegalArgumentException("Unsupported output DataType: options");
            }
            psDocument.saveAsPdf(outputStream, pdfSaveOptions);
            if (psConverterToPdfOptions.getSaveTargetsCollection().get(i).getDataType() == 1 || psConverterToPdfOptions.getSaveTargetsCollection().get(i).getDataType() != 0) continue;
            outputStream.flush();
            outputStream.close();
        }
        return resultContainer;
    }

    private PdfSaveOptions ll(PsConverterToPdfOptions psConverterToPdfOptions) {
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        psConverterToPdfOptions.setAdditionalFontsFolders(pdfSaveOptions.getAdditionalFontsFolders());
        pdfSaveOptions.setJpegQualityLevel(psConverterToPdfOptions.getJpegQualityLevel());
        pdfSaveOptions.setSupressErrors(psConverterToPdfOptions.isSupressErrors());
        pdfSaveOptions.setDebug(psConverterToPdfOptions.isDebug());
        psConverterToPdfOptions.lif(pdfSaveOptions.getExceptions());
        return pdfSaveOptions;
    }

    private ResultContainer lif(PsConverterToImageOptions psConverterToImageOptions) throws Exception {
        ResultContainer resultContainer = new ResultContainer();
        InputStream inputStream = null;
        for (int i = 0; i < psConverterToImageOptions.getDataCollection().size(); ++i) {
            String string = "";
            inputStream = psConverterToImageOptions.lif(i);
            PsDocument psDocument = new PsDocument(inputStream);
            I0I.lif((Document)psDocument, Plugin.PsConverter);
            ImageSaveOptions imageSaveOptions = this.ll(psConverterToImageOptions);
            IDataSource iDataSource = psConverterToImageOptions.getSaveTargetsCollection().get(i);
            Object var9_9 = null;
            if (iDataSource.getDataType() == 0) {
                string = ((FileDataSource)iDataSource).getPath();
            } else if (iDataSource.getDataType() != 2) {
                throw new IllegalArgumentException("Unsupported output DataType: options");
            }
            byte[][] byArray = psDocument.saveAsImagesBytes(imageSaveOptions);
            if (psConverterToImageOptions.getSaveTargetsCollection().get(i).getDataType() == 2) {
                resultContainer.getResultCollection().add(new ByteArrayResult(byArray));
                continue;
            }
            resultContainer.getResultCollection().add(new FileResult(string));
            int n = 0;
            for (byte[] byArray2 : byArray) {
                if (psConverterToImageOptions.getSaveTargetsCollection().get(i).getDataType() != 0) {
                    throw new IllegalArgumentException("Unsupported output DataType: options");
                }
                String string2 = I254.lif("{0}{1}{2}{3:D}{4}", I51.llf(string), Character.valueOf(I51.lI), I51.ll(string), n, I51.lIF(string));
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                fileOutputStream.write(byArray2, 0, byArray2.length);
                ++n;
            }
        }
        return resultContainer;
    }

    private ImageSaveOptions ll(PsConverterToImageOptions psConverterToImageOptions) {
        ImageSaveOptions imageSaveOptions = new ImageSaveOptions();
        imageSaveOptions.setSize(psConverterToImageOptions.getSize());
        imageSaveOptions.setImageFormat(psConverterToImageOptions.getImageFormat());
        imageSaveOptions.setResolution(psConverterToImageOptions.getResolution());
        imageSaveOptions.setSmoothingMode(psConverterToImageOptions.getSmoothingMode());
        imageSaveOptions.setAdditionalFontsFolders(psConverterToImageOptions.getAdditionalFontsFolders());
        imageSaveOptions.setJpegQualityLevel(psConverterToImageOptions.getJpegQualityLevel());
        imageSaveOptions.setSupressErrors(psConverterToImageOptions.isSupressErrors());
        imageSaveOptions.setDebug(psConverterToImageOptions.isDebug());
        psConverterToImageOptions.lif(imageSaveOptions.getExceptions());
        return imageSaveOptions;
    }

    public final void dispose() {
    }
}

