/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.page.internal.l661;

import com.aspose.page.internal.l524.I37;
import com.aspose.page.internal.l544.I10I;
import com.aspose.page.internal.l661.I4I;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

class I184I
extends KeyFactorySpi {
    private final I4I lif;

    I184I(I4I i4I) {
        this.lif = i4I;
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                I37 i37 = I37.lif(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                PrivateKey privateKey = this.lif.lif(i37);
                if (privateKey != null) {
                    return privateKey;
                }
                throw new InvalidKeySpecException("no factory found for OID: " + i37.lI().lif());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.getMessage(), exception);
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                I10I i10I = I10I.lif(((X509EncodedKeySpec)keySpec).getEncoded());
                PublicKey publicKey = this.lif.lif(i10I);
                if (publicKey != null) {
                    return publicKey;
                }
                throw new InvalidKeySpecException("no factory found for OID: " + i10I.lif().lif());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.getMessage(), exception);
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("Unable to transform key to KeySpec: " + clazz.getName());
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Unsupported operation: " + key);
    }
}

