/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.xps;

import com.aspose.page.internal.l197.I01;
import com.aspose.page.internal.l197.I254;
import com.aspose.page.internal.l201.I354;
import com.aspose.page.internal.l201.I41;
import com.aspose.xps.I4l;
import com.aspose.xps.ImageMode;
import com.aspose.xps.Size2D;
import com.aspose.xps.XpsArcSegment;
import com.aspose.xps.XpsImage;
import com.aspose.xps.XpsImageBrush;
import com.aspose.xps.XpsPath;
import com.aspose.xps.XpsPathFigure;
import com.aspose.xps.XpsPathGeometry;
import com.aspose.xps.XpsPolyLineSegment;
import com.aspose.xps.XpsSweepDirection;
import com.aspose.xps.XpsTileMode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DocumentUtils {
    private final I4l lif;

    DocumentUtils(I4l context) {
        this.lif = context;
    }

    public XpsPathGeometry createRectangle(Rectangle2D rectangle) {
        XpsPathGeometry xpsPathGeometry = new XpsPathGeometry(this.lif);
        XpsPathFigure xpsPathFigure = xpsPathGeometry.add(new XpsPathFigure(this.lif, (Point2D)new Point2D.Float((float)rectangle.getX(), (float)rectangle.getY()), true));
        xpsPathFigure.add(new XpsPolyLineSegment(this.lif, new Point2D[]{new Point2D.Float((float)(rectangle.getX() + rectangle.getWidth()), (float)rectangle.getY()), new Point2D.Float((float)(rectangle.getX() + rectangle.getWidth()), (float)(rectangle.getY() + rectangle.getHeight())), new Point2D.Float((float)rectangle.getX(), (float)(rectangle.getY() + rectangle.getHeight()))}));
        return xpsPathGeometry;
    }

    public XpsPathGeometry createEllipse(Point2D center, float radiusX, float radiusY) {
        XpsPathGeometry xpsPathGeometry = new XpsPathGeometry(this.lif);
        XpsPathFigure xpsPathFigure = xpsPathGeometry.add(new XpsPathFigure(this.lif, (Point2D)new Point2D.Float((float)(center.getX() - (double)radiusX), (float)center.getY()), true));
        xpsPathFigure.add(new XpsArcSegment(this.lif, new Point2D.Float((float)(center.getX() + (double)radiusX), (float)center.getY()), new Size2D.Float(radiusX, radiusY), 0.0f, true, XpsSweepDirection.Clockwise));
        xpsPathFigure.add(new XpsArcSegment(this.lif, new Point2D.Float((float)(center.getX() - (double)radiusX), (float)center.getY()), new Size2D.Float(radiusX, radiusY), 0.0f, true, XpsSweepDirection.Clockwise));
        return xpsPathGeometry;
    }

    public XpsPathGeometry createCircle(Point2D center, float radius) {
        return this.createEllipse(center, radius, radius);
    }

    public XpsPathGeometry createRegularInscribedNGon(int n, Point2D center, float radius) {
        if (n < 2) {
            throw new IllegalArgumentException("The number of angles must be 2 or greater.");
        }
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        double d = Math.PI * 2 / (double)n;
        for (int i = 1; i < n; ++i) {
            double d2 = -1.5707963267948966 + d * (double)i;
            arrayList.add(new Point2D.Float((float)(center.getX() + (double)((float)((double)radius * Math.cos(d2)))), (float)(center.getY() + (double)((float)((double)radius * Math.sin(d2))))));
        }
        XpsPathGeometry xpsPathGeometry = new XpsPathGeometry(this.lif);
        XpsPathFigure xpsPathFigure = xpsPathGeometry.add(new XpsPathFigure(this.lif, (Point2D)new Point2D.Float((float)center.getX(), (float)(center.getY() - (double)radius)), true));
        xpsPathFigure.add(new XpsPolyLineSegment(this.lif, arrayList.toArray(new Point2D[0])));
        return xpsPathGeometry;
    }

    public XpsPathGeometry createRegularCircumscribedNGon(int n, Point2D center, float radius) {
        if (n < 3) {
            throw new IllegalArgumentException("The number of angles must be 3 or greater.");
        }
        return this.createRegularInscribedNGon(n, center, (float)((double)radius / Math.cos(Math.PI / (double)n)));
    }

    public XpsPathGeometry createPieSlice(Point2D center, float radius, float startAngle, float endAngle) {
        XpsPathGeometry xpsPathGeometry = this.createCircularSegment(center, radius, startAngle, endAngle);
        xpsPathGeometry.getPathFigures().get(0).add(new XpsPolyLineSegment(this.lif, new Point2D[]{center}));
        return xpsPathGeometry;
    }

    public XpsPathGeometry createCircularSegment(Point2D center, float radius, float startAngle, float endAngle) {
        XpsPathGeometry xpsPathGeometry = new XpsPathGeometry(this.lif);
        double d = Math.PI * (double)startAngle;
        XpsPathFigure xpsPathFigure = xpsPathGeometry.add(new XpsPathFigure(this.lif, (Point2D)new Point2D.Float((float)(center.getX() + (double)((float)((double)radius * Math.cos(-d / 180.0)))), (float)(center.getY() + (double)((float)((double)radius * Math.sin(-d / 180.0))))), true));
        d = Math.PI * (double)endAngle;
        xpsPathFigure.add(new XpsArcSegment(this.lif, new Point2D.Float((float)(center.getX() + (double)((float)((double)radius * Math.cos(-d / 180.0)))), (float)(center.getY() + (double)((float)((double)radius * Math.sin(-d / 180.0))))), new Size2D.Float(radius, radius), 0.0f, Math.abs(endAngle - startAngle) > 180.0f, endAngle > startAngle ? XpsSweepDirection.Counterclockwise : XpsSweepDirection.Clockwise));
        return xpsPathGeometry;
    }

    public XpsPath createImage(String fileName, Rectangle2D imageBox) {
        return this.createImage(fileName, imageBox, ImageMode.FitToBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XpsPath createImage(String fileName, Rectangle2D imageBox, ImageMode mode) {
        if (imageBox.getWidth() <= 0.0 && imageBox.getHeight() <= 0.0) {
            throw new IllegalArgumentException("Both image box's width and height must be greater than 0.");
        }
        XpsImage xpsImage = XpsImage.lif(this.lif, fileName);
        float f = 72.0f;
        float f2 = 72.0f;
        I354 i354 = I354.lif.l1();
        I41 i41 = I41.lif(xpsImage.liF());
        try {
            if ((i41.lf() & 0x1000) == 4096) {
                f = i41.l0I();
                f2 = i41.l1l();
            }
            i354 = i41.l1if();
        }
        finally {
            if (i41 != null) {
                i41.lI();
            }
        }
        if (I354.ll(i354, I354.lif)) {
            throw new I01(I254.lif("Cannot determine image size: {0}.", new Object[]{fileName}));
        }
        float f3 = (mode.ordinal() + 1 & ImageMode.FitToWidth.ordinal() + 1) == ImageMode.FitToWidth.ordinal() + 1 ? (float)imageBox.getWidth() : (float)((double)i354.ll() * imageBox.getHeight() / (double)i354.lI());
        float f4 = (mode.ordinal() + 1 & ImageMode.FitToHeight.ordinal() + 1) == ImageMode.FitToHeight.ordinal() + 1 ? (float)imageBox.getHeight() : (float)((double)i354.lI() * imageBox.getWidth() / (double)i354.ll());
        XpsPath xpsPath = new XpsPath(this.lif, this.createRectangle(imageBox));
        XpsImageBrush xpsImageBrush = new XpsImageBrush(this.lif, xpsImage, new Rectangle2D.Float(0.0f, 0.0f, (float)i354.ll() * 96.0f / f, (float)i354.lI() * 96.0f / f2), new Rectangle2D.Float((float)imageBox.getX(), (float)imageBox.getY(), f3, f4));
        xpsImageBrush.setTileMode(XpsTileMode.Tile);
        xpsPath.setFill(xpsImageBrush);
        return xpsPath;
    }
}

