/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.xps.metadata;

import com.aspose.page.internal.l197.I11I;
import com.aspose.page.internal.l197.I254;
import com.aspose.page.internal.l837.I07;
import com.aspose.xps.metadata.IntegerValue;
import com.aspose.xps.metadata.ParameterInit;

public abstract class IntegerParameterInit
extends ParameterInit {
    public IntegerParameterInit(String name, int value) {
        super(name, new IntegerValue(value));
        this.lif(value);
    }

    public int getMinValue() {
        return 1;
    }

    public int getMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int getMultiple() {
        return 1;
    }

    private void lif(int n) {
        if (n < this.getMinValue() || n > this.getMaxValue()) {
            throw new IllegalArgumentException(I254.lif("Parameter value is out of range ({0}-{1}): {2}.", new Object[]{this.getMinValue(), this.getMaxValue(), n}));
        }
        if (this.getMultiple() == 1) {
            return;
        }
        float f = I07.lf(n, 9) / (float)this.getMultiple();
        if (!I11I.ll(Math.ceil(f), Math.floor(f))) {
            throw new IllegalArgumentException(I254.lif("Parameter value is not a multiple of {0}: {1}", new Object[]{this.getMultiple(), n}));
        }
    }
}

