/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.n8;
import com.aspose.slides.ms.System.r3;
import com.aspose.slides.ms.System.y7;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@g1
public class ArrayList
implements IList,
List {
    private Object[] n7;
    private int m5;
    private int m2;
    private static Object[] n8 = new Object[0];

    protected int getVersion() {
        return this.m2;
    }

    public ArrayList() {
        this.n7 = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.n7 = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.n7("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.n7 = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.n7 = null;
    }

    private ArrayList(n8 array, int index, int count) {
        this.n7 = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.n8.n7(array, index, com.aspose.slides.ms.System.n8.n7(this.n7), 0, count);
        this.m5 = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.m5) {
            ArrayList.n7("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.n7[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.m5) {
            ArrayList.n7("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.n7[index] = value;
        ++this.m2;
    }

    @Override
    public int size() {
        return this.m5;
    }

    public int getCapacity() {
        return this.n7.length;
    }

    public void setCapacity(int value) {
        if (value < this.m5) {
            ArrayList.n7("Capacity", (Object)value, "Must be more than count.");
        }
        this.n7 = value > 0 ? Arrays.copyOf(this.n7, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void n7(int n) {
        int n10;
        if (n <= this.n7.length) {
            return;
        }
        int n11 = n10 = this.n7.length == 0 ? 4 : this.n7.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void n7(int n, int n10) {
        if (n10 > 0) {
            if (this.m5 + n10 > this.n7.length) {
                int n11;
                int n12 = n11 = this.n7.length > 0 ? this.n7.length << 1 : 1;
                while (n11 < this.m5 + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.n8.n7(this.n7, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.n8.n7(this.n7, n, objectArray, n + n10, this.m5 - n);
                this.n7 = objectArray;
            } else {
                com.aspose.slides.ms.System.n8.n7(this.n7, n, this.n7, n + n10, this.m5 - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.n8.n7(this.n7, n13, this.n7, n, this.m5 - n13);
            com.aspose.slides.ms.System.n8.n7(this.n7, this.m5 + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.n7.length <= this.m5) {
            this.n7(this.m5 + 1);
        }
        this.n7[this.m5] = value;
        ++this.m2;
        return this.m5++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.n8.n7(this.n7, 0, this.m5);
        this.m5 = 0;
        ++this.m2;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.m5) > -1;
    }

    boolean n7(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.m5 - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.m5) {
            ArrayList.n7("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.n7("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.m5 - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.n8.n7(this.n7, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.m5 - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return y7.n7(this.n7, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.m5) {
            ArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.n7(index, 1);
        this.n7[index] = value;
        ++this.m5;
        ++this.m2;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.m5) {
            ArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.n7.length < this.m5 + n) {
                this.n7(this.m5 + n);
            }
            if (index < this.m5) {
                com.aspose.slides.ms.System.n8.n7(this.n7, index, this.n7, index + n, this.m5 - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.n8.n7(this.n7, 0, this.n7, index, index);
                com.aspose.slides.ms.System.n8.n7(this.n7, index + n, this.n7, index << 1, this.m5 - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.n8.n7(this.n7), index);
            }
            this.m5 += c.size();
            ++this.m2;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.m5) {
            ArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.n7.length < this.m5 + n) {
                this.n7(this.m5 + n);
            }
            if (index < this.m5) {
                com.aspose.slides.ms.System.n8.n7(this.n7, index, this.n7, index + n, this.m5 - index);
            }
            com.aspose.slides.ms.System.n8.n7(c).copyTo(com.aspose.slides.ms.System.n8.n7(this.n7), index);
            this.m5 += c.length;
            ++this.m2;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.m2;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.m5) {
            ArrayList.n7("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.n7(index, -1);
        --this.m5;
        ++this.m2;
    }

    public void removeRange(int index, int count) {
        ArrayList.n7(index, count, this.m5);
        this.n7(index, -count);
        this.m5 -= count;
        ++this.m2;
    }

    public void reverse() {
        y7.n7(this.n7, 0, this.m5);
        ++this.m2;
    }

    public void reverse(int index, int count) {
        ArrayList.n7(index, count, this.m5);
        y7.n7(this.n7, index, count);
        ++this.m2;
    }

    public void copyTo(n8 array) {
        com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7), 0, array, 0, this.m5);
    }

    @Override
    public void copyTo(n8 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.m5);
    }

    public void copyTo(int index, n8 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.n8() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.n7(index, count, this.m5);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.m5, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.m5, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return y7.n7(this.n7, 0, this.m5, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return y7.n7(this.n7, 0, this.m5, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return y7.n7(this.n7, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.n7(index, count, this.m5);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.m5) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.n8.n7(this.n7), index);
        ++this.m2;
    }

    public void trimToSize() {
        this.setCapacity(this.m5);
    }

    public void sort() {
        Arrays.sort(this.n7, 0, this.m5, Comparer.Default);
        ++this.m2;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.n7, 0, this.m5, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.n7(index, count, this.m5);
        Arrays.sort(this.n7, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.m5];
        this.copyTo(com.aspose.slides.ms.System.n8.n7(objectArray));
        return objectArray;
    }

    public n8 toArray(r3 type) {
        n8 n82 = com.aspose.slides.ms.System.n8.n7(type, this.m5);
        this.copyTo(n82);
        return n82;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.n8.n7(this.n7), 0, this.m5);
    }

    static void n7(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.n7("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.n7("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void n7(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.n8.n7(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.m5, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List n7;
        private int m5;

        @Override
        protected int getVersion() {
            return this.n7 instanceof ArrayList ? ((ArrayList)this.n7).getVersion() : this.m5;
        }

        public ArrayListInternalized(List internal) {
            this.n7 = internal;
            if (internal instanceof ArrayList) {
                this.m5 = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.n7.set(index, value);
            ++this.m5;
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.n7.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.n7.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.n7.size(); ++i) {
                this.n7.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.n7.size();
            this.n7.add(value);
            ++this.m5;
            return n;
        }

        @Override
        public void clear() {
            this.n7.clear();
            ++this.m5;
        }

        @Override
        public boolean contains(Object item) {
            return this.n7.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.n7.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.n7.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.n7.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.n7.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.n7.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return y7.n7(this.n7.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.n7.add(index, value);
            ++this.m5;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.n7.add(index++, e);
            }
            ++this.m5;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.n7.add(index++, object);
            }
            ++this.m5;
        }

        @Override
        public void removeItem(Object obj) {
            this.n7.remove(obj);
            ++this.m5;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.n7.remove(index);
            ++this.m5;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.n7.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.n7.remove(index);
            }
            ++this.m5;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.n7.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.n7.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.n7.size() - 1; n < i; ++n, --i) {
                Object e = this.n7.get(n);
                this.n7.set(n, this.n7.get(i));
                this.n7.set(i, e);
            }
            ++this.m5;
        }

        @Override
        public void copyTo(n8 array) {
            com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7.toArray()), 0, array, 0, this.n7.size());
        }

        @Override
        public void copyTo(n8 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.n7.size());
        }

        @Override
        public void copyTo(int index, n8 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.n8() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.n7(index, count, this.n7.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.n7.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return y7.n7(this.n7.toArray(), 0, this.n7.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return y7.n7(this.n7.toArray(), 0, this.n7.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return y7.n7(this.n7.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.n7(index, count, this.n7.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.n7.set(index++, e);
            }
            ++this.m5;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.n7, null);
            ++this.m5;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.n7, comparer);
            ++this.m5;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.n7.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.n7.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.n7.set(i, list.get(i - index));
            }
            ++this.m5;
        }

        @Override
        public Object[] toArray() {
            return this.n7.toArray();
        }

        @Override
        public n8 toArray(r3 type) {
            n8 n82 = com.aspose.slides.ms.System.n8.n7(type, this.n7.size());
            this.copyTo(n82);
            return n82;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.n7.size()];
            com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), 0, objectArray, 0, this.n7.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.n7.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.n7.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.m5;
            return this.n7.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.m5;
            return this.n7.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.n7.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.m5;
            return this.n7.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.m5;
            return this.n7.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.m5;
            return this.n7.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.m5;
            return this.n7.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.n7.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.m5;
            return this.n7.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.n7.add(index, element);
            ++this.m5;
        }

        @Override
        public Object remove(int index) {
            ++this.m5;
            return this.n7.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.n7.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.n7.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.n7.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.n7 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.n7 != 0;
        }

        @Override
        public int nextIndex() {
            return this.n7;
        }

        @Override
        public int previousIndex() {
            return this.n7 - 1;
        }

        public Object previous() {
            int n = this.n7 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.n7;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.n7 = n;
            this.m5 = n;
            return objectArray[this.m5];
        }

        public void set(Object e) {
            if (this.m5 < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).n7[this.m5] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.n7;
                ArrayList.this.add(n, e);
                this.n7 = n + 1;
                this.m5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int n7;
        int m5 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.n7 != ArrayList.this.size();
        }

        public Object next() {
            int n = this.n7;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.n7;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.n7 = n + 1;
            this.m5 = n;
            return objectArray[this.m5];
        }

        @Override
        public void remove() {
            if (this.m5 < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.m5);
                this.n7 = this.m5;
                this.m5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @g1
    private static class ListWrapper
    implements IList {
        protected IList n7;

        public ListWrapper(IList innerList) {
            this.n7 = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.n7.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.n7.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.n7.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.n7.addItem(value);
        }

        @Override
        public void clear() {
            this.n7.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.n7.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.n7.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.n7.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.n7.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.n7.removeAt(index);
        }

        @Override
        public void copyTo(n8 array, int index) {
            this.n7.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.n7.iterator();
        }
    }

    @g1
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String n7() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.n7());
        }
    }

    @g1
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String n7() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.n7());
        }
    }

    @g1
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object m5;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.m5 = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m5;
            synchronized (object) {
                this.n7.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array, int index) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.iterator();
            }
        }
    }

    @g1
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int m5;
        private int m2;
        private int n8;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.m5 = index;
            this.m2 = count;
            this.n8 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.m2) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.n7.get_Item(this.m5 + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.m2) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.n7.set_Item(this.m5 + index, value);
        }

        @Override
        public int size() {
            this.n7();
            return this.m2;
        }

        @Override
        public int getCapacity() {
            return this.n7.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.m2) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void n7() {
            if (this.n8 != this.n7.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.n7();
            this.n7.insertItem(this.m5 + this.m2, value);
            this.n8 = this.n7.getVersion();
            return ++this.m2;
        }

        @Override
        public void clear() {
            this.n7();
            this.n7.removeRange(this.m5, this.m2);
            this.m2 = 0;
            this.n8 = this.n7.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.n7.n7(value, this.m5, this.m2);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.m2 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.m2) {
                RangedArrayList.n7("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.n7("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.m2 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.n7.indexOf(value, this.m5 + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.m5;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.m2 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.n7("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.n7("count", (Object)count, "count is negative.");
            }
            if ((n = this.n7.lastIndexOf(value, this.m5 + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.m5;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.n7();
            if (index < 0 || index > this.m2) {
                RangedArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.n7.insertItem(this.m5 + index, value);
            ++this.m2;
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.n7();
            if (index < 0 || index > this.m2) {
                RangedArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.n7.insertRange(this.m5 + index, c);
            this.m2 += c.size();
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.n7();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.n7();
            if (index < 0 || index > this.m2) {
                RangedArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.n7.removeAt(this.m5 + index);
            --this.m2;
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.n7();
            RangedArrayList.n7(index, count, this.m2);
            this.n7.removeRange(this.m5 + index, count);
            this.m2 -= count;
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.m2);
        }

        @Override
        public void reverse(int index, int count) {
            this.n7();
            RangedArrayList.n7(index, count, this.m2);
            this.n7.reverse(this.m5 + index, count);
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.n7();
            if (index < 0 || index > this.m2) {
                RangedArrayList.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.n7.setRange(this.m5 + index, c);
            this.n8 = this.n7.getVersion();
        }

        @Override
        public void copyTo(n8 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(n8 array, int index) {
            this.copyTo(0, array, index, this.m2);
        }

        @Override
        public void copyTo(int index, n8 array, int arrayIndex, int count) {
            RangedArrayList.n7(index, count, this.m2);
            this.n7.copyTo(this.m5 + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.m2);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.n7(index, count, this.m2);
            return this.n7.iterator(this.m5 + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.n7();
            this.n7.insertRange(this.m2, c);
            this.m2 += c.size();
            this.n8 = this.n7.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.m2, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.m2, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.n7(index, count, this.m2);
            return this.n7.binarySearch(this.m5 + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.n7.deepClone(), this.m5, this.m2);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.n7(index, count, this.m2);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.m2, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.n7();
            RangedArrayList.n7(index, count, this.m2);
            this.n7.sort(this.m5 + index, count, comparer);
            this.n8 = this.n7.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.m2];
            this.n7.copyTo(this.m5, com.aspose.slides.ms.System.n8.n7(objectArray), 0, this.m2);
            return objectArray;
        }

        @Override
        public n8 toArray(r3 elementType) {
            n8 n82 = com.aspose.slides.ms.System.n8.n7(elementType, this.m2);
            this.n7.copyTo(this.m5, n82, 0, this.m2);
            return n82;
        }
    }

    @g1
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String n7() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.n7());
        }
    }

    @g1
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String n7() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.n7());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.n7());
        }
    }

    @g1
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object m5;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.m5 = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.m5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m5;
            synchronized (object) {
                this.n7.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.m5;
            synchronized (object) {
                this.n7.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array, int index) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, n8 array, int arrayIndex, int count) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.m5;
            synchronized (object) {
                this.n7.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.m5;
            synchronized (object) {
                this.n7.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.m5;
            synchronized (object) {
                this.n7.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public n8 toArray(r3 elementType) {
            Object object = this.m5;
            synchronized (object) {
                return this.n7.toArray(elementType);
            }
        }
    }

    @g1
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList n7;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.n7 = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.n7.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public int getCapacity() {
            return this.n7.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.n7.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.n7.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.n7.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.n7.addItem(value);
        }

        @Override
        public void clear() {
            this.n7.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.n7.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.n7.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.n7.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.n7.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.n7.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.n7.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.n7.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.n7.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.n7.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.n7.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.n7.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.n7.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.n7.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.n7.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.n7.setRange(index, c);
        }

        @Override
        public void copyTo(n8 array) {
            this.n7.copyTo(array);
        }

        @Override
        public void copyTo(n8 array, int index) {
            this.n7.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, n8 array, int arrayIndex, int count) {
            this.n7.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.n7.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.n7.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.n7.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.n7.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.n7.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.n7.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.n7.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.n7.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.n7.trimToSize();
        }

        @Override
        public void sort() {
            this.n7.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.n7.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.n7.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.n7.toArray();
        }

        @Override
        public n8 toArray(r3 elementType) {
            return this.n7.toArray(elementType);
        }
    }

    @g1
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList n7;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.n7 = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.n7.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public int getCapacity() {
            return this.n7.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.n7.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.n7.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.n7.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.n7.addItem(value);
        }

        @Override
        public void clear() {
            this.n7.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.n7.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.n7.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.n7.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.n7.size()) {
                ArrayListAdapter.n7("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.n7("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.n7.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.n7.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.n7.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.n7.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.n7("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.n7("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.n7("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.n7.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.n7.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.n7.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.n7.size()) {
                ArrayListAdapter.n7("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.n7.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.n7.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.n7.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.n7(index, count, this.n7.size());
            for (int i = 0; i < count; ++i) {
                this.n7.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.n7.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.n7(index, count, this.n7.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.n7.get_Item(i + index);
                this.n7.set_Item(i + index, this.n7.get_Item(index + count - i + index - 1));
                this.n7.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.n7.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.n7.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(n8 array) {
            this.n7.copyTo(array, 0);
        }

        @Override
        public void copyTo(n8 array, int index) {
            this.n7.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, n8 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.n7("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.n7("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.n7("index", (Object)index, "Can't be less than zero.");
            }
            if (array.n8() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.s8() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.n7.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.m2(this.n7.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.n7.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.n7(index, count, this.n7.size());
            return new EnumeratorWithRange(this.n7.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.n7.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.n7.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.n7(index, count, this.n7.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.n7.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.n7);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.n7(index, count, this.n7.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.n7.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.n7(index, count, this.n7.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.n7(this.n7, index, index + count - 1, comparer);
        }

        private static void n7(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void n7(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.n7(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.n7(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.n7(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.n7(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.n7(iList, n12, n13);
            }
            ArrayListAdapter.n7(iList, n10 - 1, n12);
            ArrayListAdapter.n7(iList, n, n12 - 1, comparator);
            ArrayListAdapter.n7(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.n7.size()];
            this.n7.copyTo(com.aspose.slides.ms.System.n8.n7(objectArray), 0);
            return objectArray;
        }

        @Override
        public n8 toArray(r3 elementType) {
            n8 n82 = com.aspose.slides.ms.System.n8.n7(elementType, this.n7.size());
            this.n7.copyTo(n82, 0);
            return n82;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        b6,
        Cloneable {
            private int n7;
            private int m5;
            private int m2;
            private IEnumerator n8;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.m5 = 0;
                this.n7 = index;
                this.m2 = count;
                this.n8 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.n7();
            }

            @Override
            public Object next() {
                return this.n8.next();
            }

            @Override
            public boolean hasNext() {
                if (this.m5 >= this.m2) {
                    return false;
                }
                ++this.m5;
                return this.n8.hasNext();
            }

            @Override
            public void reset() {
                this.m5 = 0;
                this.n8.reset();
                for (int i = 0; i < this.n7; ++i) {
                    this.n8.hasNext();
                }
            }

            protected Object n7() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.n7 = this.n7;
                enumeratorWithRange.m5 = this.m5;
                enumeratorWithRange.m2 = this.m2;
                enumeratorWithRange.n8 = this.n8;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    b6,
    Cloneable {
        private ArrayList m5;
        private Object m2;
        private int n8;
        private int s8;
        static Object n7 = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.m5 = list;
            this.n8 = -1;
            this.s8 = list.getVersion();
            this.m2 = n7;
        }

        @Override
        public Object deepClone() {
            return this.n7();
        }

        @Override
        public boolean hasNext() {
            if (this.s8 != this.m5.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.n8 < this.m5.size()) {
                this.m2 = this.m5.get_Item(this.n8);
                return true;
            }
            this.m2 = n7;
            return false;
        }

        @Override
        public Object next() {
            if (this.m2 == n7) {
                if (this.n8 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.m2;
        }

        @Override
        public void reset() {
            if (this.s8 != this.m5.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.m2 = n7;
            this.n8 = -1;
        }

        protected Object n7() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.m5 = this.m5;
            simpleEnumerator.m2 = this.m2;
            simpleEnumerator.n8 = this.n8;
            simpleEnumerator.s8 = this.s8;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    b6,
    Cloneable {
        private Object n7;
        private ArrayList m5;
        private int m2;
        private int n8;
        private int s8;
        private int t8;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.n7();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.m5 = list;
            this.n8 = index;
            this.s8 = count;
            this.m2 = this.n8 - 1;
            this.n7 = null;
            this.t8 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.m2 == this.n8 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.n7;
        }

        @Override
        public boolean hasNext() {
            if (this.m5.getVersion() != this.t8) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.m2;
            if (this.m2 - this.n8 < this.s8) {
                this.n7 = this.m5.get_Item(this.m2);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.n7 = null;
            this.m2 = this.n8 - 1;
        }

        protected Object n7() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.n7 = this.n7;
            arrayListEnumerator.m5 = this.m5;
            arrayListEnumerator.m2 = this.m2;
            arrayListEnumerator.n8 = this.n8;
            arrayListEnumerator.s8 = this.s8;
            arrayListEnumerator.t8 = this.t8;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

