/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.n8;

@g1
public final class BitArray
implements ICollection,
b6 {
    private int[] n7;
    private int m5;
    private int m2 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.m5 = bits.m5;
        this.n7 = new int[(this.m5 + 31) / 32];
        if (this.n7.length == 1) {
            this.n7[0] = bits.n7[0];
        } else {
            n8.n7(bits.n7, 0, this.n7, 0, this.n7.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.m5 = values.length;
        this.n7 = new int[(this.m5 + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.m5 = bytes.length * 8;
        this.n7 = new int[(this.m5 + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.n7(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.m5 = n * 32;
        this.n7 = new int[n];
        n8.n7(values, 0, this.n7, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.m5 = length;
        this.n7 = new int[(this.m5 + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.n7.length; ++i) {
                this.n7[i] = -1;
            }
        }
    }

    private byte n7(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.n7[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void n7(int n, byte by) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.n7[n12] = this.n7[n12] & ~(255 << n11);
        int n13 = n10;
        this.n7[n13] = this.n7[n13] | (by & 0xFF) << n11;
        ++this.m2;
    }

    private void m5(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.m5 != this.m5) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.m5;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.m5;
    }

    public void setLength(int value) {
        if (this.m5 == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.m5) {
            int n = (value + 31) / 32;
            int n10 = (this.m5 + 31) / 32;
            if (n > this.n7.length) {
                int[] nArray = new int[n];
                n8.n7(this.n7, 0, nArray, 0, this.n7.length);
                this.n7 = nArray;
            } else {
                n8.n7(n8.n7((Object)this.n7), n10, n - n10);
            }
            int n11 = this.m5 % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.n7[n12] = this.n7[n12] & (1 << n11) - 1;
            }
        }
        this.m5 = value;
        ++this.m2;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(n8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.n8() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.s8() && this.m5 > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = n8.n7(array);
        if (object instanceof Boolean[]) {
            if (array.s8() - index < this.m5) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.m5; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.s8() - index < this.m5) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.m5; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.m5 + 7) / 8;
            if (array.s8() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.n7(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.m5 + 7) / 8;
            if (array.s8() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.n7(i);
            }
        } else if (object instanceof Integer[]) {
            n8.n7(n8.n7((Object)this.n7), 0, array, index, (this.m5 + 31) / 32);
        } else if (object instanceof int[]) {
            n8.n7(n8.n7((Object)this.n7), 0, array, index, (this.m5 + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.m5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.n7[i] = ~this.n7[i];
        }
        ++this.m2;
        return this;
    }

    public BitArray and(BitArray value) {
        this.m5(value);
        int n = (this.m5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.n7[n10] = this.n7[n10] & value.n7[i];
        }
        ++this.m2;
        return this;
    }

    public BitArray or(BitArray value) {
        this.m5(value);
        int n = (this.m5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.n7[n10] = this.n7[n10] | value.n7[i];
        }
        ++this.m2;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.m5(value);
        int n = (this.m5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.n7[n10] = this.n7[n10] ^ value.n7[i];
        }
        ++this.m2;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.m5) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.n7[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.m5) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.n7[n] = this.n7[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.n7[n] = this.n7[n] & ~(1 << (index & 0x1F));
        }
        ++this.m2;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.n7.length; ++i) {
                this.n7[i] = -1;
            }
        } else {
            n8.n7(n8.n7((Object)this.n7), 0, this.n7.length);
        }
        ++this.m2;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @g1
    private static class BitArrayEnumerator
    implements IEnumerator,
    b6,
    Cloneable {
        private BitArray n7;
        private boolean m5;
        private int m2;
        private int n8;

        @Override
        public Object deepClone() {
            return this.n7();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba) {
            this.m2 = -1;
            this.n7 = ba;
            this.n8 = ba.m2;
        }

        @Override
        public Object next() {
            if (this.m2 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.m2 >= this.n7.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.m5;
        }

        @Override
        public boolean hasNext() {
            this.m5();
            if (this.m2 < this.n7.size() - 1) {
                this.m5 = this.n7.get_Item(++this.m2);
                return true;
            }
            this.m2 = this.n7.size();
            return false;
        }

        @Override
        public void reset() {
            this.m5();
            this.m2 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void m5() {
            if (this.n8 != this.n7.m2) {
                throw new InvalidOperationException();
            }
        }

        protected Object n7() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.n7 = this.n7;
            bitArrayEnumerator.m5 = this.m5;
            bitArrayEnumerator.m2 = this.m2;
            bitArrayEnumerator.n8 = this.n8;
            return bitArrayEnumerator;
        }
    }
}

