/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.v4a.l6;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.k3;
import com.aspose.slides.ms.System.l1;
import com.aspose.slides.ms.System.n7;
import com.aspose.slides.ms.System.n8;
import com.aspose.slides.ms.System.r8;
import com.aspose.slides.ms.System.y7;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@g1
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] n7;
    private int m5;
    private int m2;
    private final Object n8 = new Object();
    static Object[] t8 = new Object[0];

    public List() {
        this.n7 = t8;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.n7 = t8;
        this.n7(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.n7 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.n7 = data;
        this.m5 = size;
    }

    protected int getVersion() {
        return this.m2;
    }

    @Override
    public void addItem(T item) {
        if (this.m5 == this.n7.length) {
            this.n7(1);
        }
        this.n7[this.m5++] = item;
        ++this.m2;
    }

    private void n7(int n) {
        int n10 = this.m5 + n;
        if (n10 > this.n7.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void n7(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.m5 & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void n7(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.n7(new List<T>(collection));
        ++this.m2;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.m2;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return y7.n7(this.n7, 0, this.m5, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return y7.n7(this.n7, 0, this.m5, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.n7(index, count);
        return y7.n7(this.n7, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.n8.n7(this.n7, 0, this.n7.length);
        this.m5 = 0;
        ++this.m2;
    }

    public <TOutput> List<TOutput> convertAll(r8<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.m5);
        for (int i = 0; i < this.m5; ++i) {
            list.n7[i] = converter.n7(this.n7[i]);
        }
        list.m5 = this.m5;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.n8.n7(this.n7, 0, array, 0, this.m5);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.n8.n7(this.n7, 0, array, arrayIndex, this.m5);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.n7(index, count);
        com.aspose.slides.ms.System.n8.n7(this.n7, index, array, arrayIndex, count);
    }

    public boolean exists(k3<T> match) {
        List.n7(match);
        return this.n7(0, this.m5, match) != -1;
    }

    public T find(k3<T> match) {
        List.n7(match);
        int n = this.n7(0, this.m5, match);
        return (T)(n != -1 ? this.n7[n] : null);
    }

    static <T> void n7(k3<T> k32) {
        if (k32 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(k3<T> match) {
        List.n7(match);
        return this.m5(match);
    }

    private List<T> m5(k3<T> k32) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.m5; ++i) {
            if (!k32.invoke(this.n7[i])) continue;
            list.addItem(this.n7[i]);
        }
        return list;
    }

    public int findIndex(k3<T> match) {
        List.n7(match);
        return this.n7(0, this.m5, match);
    }

    public int findIndex(int startIndex, k3<T> match) {
        List.n7(match);
        this.m5(startIndex);
        return this.n7(startIndex, this.m5 - startIndex, match);
    }

    public int findIndex(int startIndex, int count, k3<T> match) {
        List.n7(match);
        this.n7(startIndex, count);
        return this.n7(startIndex, count, match);
    }

    private int n7(int n, int n10, k3<T> k32) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!k32.invoke(this.n7[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(k3<T> match) {
        List.n7(match);
        int n = this.m5(0, this.m5, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(k3<T> match) {
        List.n7(match);
        return this.m5(0, this.m5, match);
    }

    public int findLastIndex(int startIndex, k3<T> match) {
        List.n7(match);
        this.m5(startIndex);
        return this.m5(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, k3<T> match) {
        List.n7(match);
        int n = startIndex - count + 1;
        this.n7(n, count);
        return this.m5(n, count, match);
    }

    private int m5(int n, int n10, k3<T> k32) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!k32.invoke(this.n7[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(n7<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.m5; ++i) {
            action.invoke(this.n7[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.n7(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.n8.n7(this.n7, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.n8.n7(this.n7, item, 0, this.m5);
    }

    public int indexOf(T item, int index) {
        this.m5(index);
        return com.aspose.slides.ms.System.n8.n7(this.n7, item, index, this.m5 - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.m5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.n8.n7(this.n7, item, index, count);
    }

    private void m5(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.m5) {
            com.aspose.slides.ms.System.n8.n7(this.n7, n, this.n7, n + n10, this.m5 - n);
        }
        this.m5 += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.n8.n7(this.n7, this.m5, -n10);
        }
    }

    private void m5(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.m5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.m5(index);
        if (this.m5 == this.n7.length) {
            this.n7(1);
        }
        this.m5(index, 1);
        this.n7[index] = item;
        ++this.m2;
    }

    void m2(int n) {
        Object[] objectArray = new Object[this.m5];
        this.copyToTArray(objectArray, 0);
        this.n7(this.m5);
        this.m5(n, objectArray.length);
        com.aspose.slides.ms.System.n8.n7(objectArray, 0, this.n7, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.m5(index);
        if (collection == this) {
            this.m2(index);
        } else {
            this.n7(index, collection);
        }
        ++this.m2;
    }

    private void n7(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.m5 == 0) {
            return -1;
        }
        return y7.n7(this.n7, item, this.m5 - 1, this.m5);
    }

    public int lastIndexOf(T item, int index) {
        this.m5(index);
        return y7.n7(this.n7, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return y7.n7(this.n7, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(k3<T> match) {
        List.n7(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.m5 && !match.invoke(this.n7[n]); ++n) {
        }
        if (n == this.m5) {
            return 0;
        }
        ++this.m2;
        for (n10 = n + 1; n10 < this.m5; ++n10) {
            if (match.invoke(this.n7[n10])) continue;
            this.n7[n++] = this.n7[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.n8.n7(this.n7, n, n10 - n);
        }
        this.m5 = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.m5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.m5(index, -1);
        com.aspose.slides.ms.System.n8.n7(this.n7, this.m5, 1);
        ++this.m2;
    }

    public void removeRange(int index, int count) {
        this.n7(index, count);
        if (count > 0) {
            this.m5(index, -count);
            com.aspose.slides.ms.System.n8.n7(this.n7, this.m5, count);
            ++this.m2;
        }
    }

    public void reverse() {
        y7.n7(this.n7, 0, this.m5);
        ++this.m2;
    }

    public void reverse(int index, int count) {
        this.n7(index, count);
        y7.n7(this.n7, index, count);
        ++this.m2;
    }

    public void sort() {
        Arrays.sort(this.n7, 0, this.m5);
        ++this.m2;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.n7, 0, this.m5, comparer);
        ++this.m2;
    }

    @Override
    public void sort(l1<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.n7, 0, this.m5, new y7.n7<T>(comparison));
        ++this.m2;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.n7(index, count);
        Arrays.sort(this.n7, index, index + count, comparer);
        ++this.m2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.m5) {
            return Arrays.copyOf(this.n7, this.m5, a.getClass());
        }
        System.arraycopy(this.n7, 0, a, 0, this.m5);
        if (a.length > this.m5) {
            a[this.m5] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.m5);
    }

    public boolean trueForAll(k3<T> match) {
        List.n7(match);
        for (int i = 0; i < this.m5; ++i) {
            if (match.invoke(this.n7[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.n7.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.m5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.n7 = Arrays.copyOf(this.n7, value);
    }

    @Override
    public int size() {
        return this.m5;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.m5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.n7[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.m5(index);
        if ((long)index == (long)this.m5) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.n7[index] = value;
        ++this.m2;
    }

    public void copyTo(n8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.n8() > 1 || array.m5(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7), 0, array, arrayIndex, this.m5);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.n8;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.m5 == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.m5; ++i) {
                if (this.n7[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.m5; ++i) {
            if (!this.n7[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.m5; ++i) {
                if (this.n7[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.m5; ++i) {
            if (!this.n7[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.m5];
        System.arraycopy(this.n7, 0, objectArray, 0, this.m5);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.m5;
        this.addItem(t);
        return n != this.m5;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.m5;
        this.removeItem(o);
        return n != this.m5;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.m5; ++i) {
                if (this.n7[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.m5; ++i) {
            if (!o.equals(this.n7[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> n7;
        private int m5;

        public ListInternalized() {
            this.n7 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.n7 = list;
        }

        @Override
        protected int getVersion() {
            return this.m5;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.n7(collection);
            ++this.m5;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.m5;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return y7.n7(this.n7.toArray(), 0, this.n7.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return y7.n7(this.n7.toArray(), 0, this.n7.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.n7(index, count);
            return y7.n7(this.n7.toArray(), index, count, item, comparer);
        }

        @Override
        private void n7(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.n7.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(r8<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.n7.size());
            for (int i = 0; i < this.n7.size(); ++i) {
                list.n7[i] = converter.n7(this.get_Item(i));
            }
            list.m5 = this.n7.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), 0, array, 0, this.n7.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), 0, array, arrayIndex, this.n7.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.n7(index, count);
            com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(k3<T> match) {
            ListInternalized.m5(match);
            return this.n7(0, this.n7.size(), match) != -1;
        }

        @Override
        private int n7(int n, int n10, k3<T> k32) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!k32.invoke(this.n7.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void m5(k3<T> k32) {
            if (k32 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(k3<T> match) {
            ListInternalized.m5(match);
            int n = this.n7(0, this.n7.size(), match);
            return n != -1 ? (T)this.n7.get(n) : null;
        }

        @Override
        public List<T> findAll(k3<T> match) {
            ListInternalized.m5(match);
            return this.m2(match);
        }

        private List<T> m2(k3<T> k32) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!k32.invoke(this.n7.get(i))) continue;
                list.addItem(this.n7.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(k3<T> match) {
            ListInternalized.m5(match);
            return this.n7(0, this.n7.size(), match);
        }

        @Override
        public int findIndex(int startIndex, k3<T> match) {
            ListInternalized.m5(match);
            this.n7(startIndex);
            return this.n7(startIndex, this.n7.size() - startIndex, match);
        }

        @Override
        private void n7(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.n7.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, k3<T> match) {
            ListInternalized.m5(match);
            this.n7(startIndex, count);
            return this.n7(startIndex, count, match);
        }

        @Override
        public T findLast(k3<T> match) {
            ListInternalized.m5(match);
            int n = this.m5(0, this.n7.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int m5(int n, int n10, k3<T> k32) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!k32.invoke(this.n7.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(k3<T> match) {
            ListInternalized.m5(match);
            return this.m5(0, this.n7.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, k3<T> match) {
            ListInternalized.m5(match);
            this.n7(startIndex);
            return this.m5(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, k3<T> match) {
            ListInternalized.m5(match);
            int n = startIndex - count + 1;
            this.n7(n, count);
            return this.m5(n, count, match);
        }

        @Override
        public void forEach(n7<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.n7.size(); ++i) {
                action.invoke(this.n7.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.n7(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.n7.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.n7(index);
            return com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), item, index, this.n7.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.n7.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.n8.n7(this.n7.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.n7.size() == 0) {
                return -1;
            }
            return y7.n7(this.n7.toArray(), item, this.n7.size() - 1, this.n7.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.n7(index);
            return y7.n7(this.n7.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return y7.n7(this.n7.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.n7.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.n7.size());
        }

        @Override
        public boolean trueForAll(k3<T> match) {
            ListInternalized.m5(match);
            for (int i = 0; i < this.n7.size(); ++i) {
                if (match.invoke(this.n7.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.n7.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.n7.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.n7.size(); ++i) {
                this.n7.add(null);
            }
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public T get_Item(int index) {
            return this.n7.get(index);
        }

        @Override
        public void copyTo(n8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.n8() > 1 || array.m5(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7.toArray()), 0, array, arrayIndex, this.n7.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.n7.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.n7.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.n7.size(); ++i) {
                    if (this.n7.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.n7.size(); ++i) {
                if (!this.n7.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.n7.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.m5;
            return this.n7.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.m5;
            return this.n7.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.n7.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.m5;
            return this.n7.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.m5;
            return this.n7.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.m5;
            return this.n7.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.m5;
            return this.n7.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.n7.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.m5;
            return this.n7.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.m5;
            this.n7.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.m5;
            return this.n7.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.n7.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.n7.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.n7.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.n7.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.n7.add(item);
            ++this.m5;
        }

        @Override
        public void clear() {
            this.n7.clear();
            ++this.m5;
        }

        @Override
        public void insertItem(int index, T item) {
            this.n7.add(index, item);
            ++this.m5;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.n7.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.n7.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.n7.add(n++, e);
                }
            }
            ++this.m5;
        }

        @Override
        public int removeAll(k3<T> match) {
            ListInternalized.m5(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.n7.size() && !match.invoke(this.n7.get(n)); ++n) {
            }
            if (n == this.n7.size()) {
                return 0;
            }
            ++this.m5;
            for (n10 = n + 1; n10 < this.n7.size(); ++n10) {
                if (match.invoke(this.n7.get(n10))) continue;
                this.n7.set(n++, this.n7.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.n7.remove(this.n7.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.n7.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.n7.remove(index);
            ++this.m5;
        }

        @Override
        public void removeRange(int index, int count) {
            this.n7(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.n7.remove(index);
                }
                ++this.m5;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.n7(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.n7.get(n);
                this.n7.set(n, this.n7.get(i));
                this.n7.set(i, t);
            }
            ++this.m5;
        }

        @Override
        public void sort() {
            Collections.sort(this.n7, null);
            ++this.m5;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.n7, comparer);
            ++this.m5;
        }

        @Override
        public void sort(final l1<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.n7, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.n7(o12, o22);
                }
            });
            ++this.m5;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.n7(index, count);
            java.util.List<T> list = this.n7.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.n7.set(index + i, list.get(i));
            }
            ++this.m5;
        }

        @Override
        public void set_Item(int index, T value) {
            this.n7(index);
            if ((long)index == (long)this.n7.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.n7.set(index, value);
            ++this.m5;
        }

        @Override
        private void n7(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @g1
    public static class EnumeratorJava<T>
    extends l6<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> m5 = new List();
        private int m2;
        private int n8;
        private T s8;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.m5 = l;
            this.n8 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void n7() {
            if (this.n8 != this.m5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.m2 < 0 || this.m2 >= this.m5.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.n8 != this.m5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.s8 = this.m5.get_Item(this.m2++);
            return this.s8;
        }

        @Override
        public boolean hasNext() {
            if (this.n8 == this.m5.getVersion()) {
                if (this.m2 < 0) {
                    return false;
                }
                return this.m2 < this.m5.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.n7();
            this.m2 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.m5 = this.m5;
            that.m2 = this.m2;
            that.n8 = this.n8;
            that.s8 = this.s8;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean n7(EnumeratorJava enumeratorJava) {
            return b5.n7(enumeratorJava.m5, this.m5) && enumeratorJava.m2 == this.m2 && enumeratorJava.n8 == this.n8 && b5.n7(enumeratorJava.s8, this.s8);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (b5.m5(null, obj)) {
                return false;
            }
            if (b5.m5(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.n7((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.m5 != null ? this.m5.hashCode() : 0;
            n = 31 * n + this.m2;
            n = 31 * n + this.n8;
            n = 31 * n + (this.s8 != null ? this.s8.hashCode() : 0);
            return n;
        }
    }

    @g1
    public static class Enumerator<T>
    extends l6<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> m5 = new List();
        private int m2;
        private int n8;
        private T s8;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.m5 = l;
            this.n8 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void n7() {
            if (this.n8 != this.m5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.n8 == this.m5.getVersion()) {
                if (this.m2 < 0) {
                    return false;
                }
                if (this.m2 < this.m5.size()) {
                    this.s8 = this.m5.get_Item(this.m2++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.m2 = this.m5.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.n7();
            this.m2 = 0;
        }

        @Override
        public T next() {
            if (this.m2 < 0 || this.m2 >= this.m5.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.s8;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.m5 = this.m5;
            that.m2 = this.m2;
            that.n8 = this.n8;
            that.s8 = this.s8;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean n7(Enumerator enumerator) {
            return b5.n7(enumerator.m5, this.m5) && enumerator.m2 == this.m2 && enumerator.n8 == this.n8 && b5.n7(enumerator.s8, this.s8);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (b5.m5(null, obj)) {
                return false;
            }
            if (b5.m5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.n7((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.m5 != null ? this.m5.hashCode() : 0;
            n = 31 * n + this.m2;
            n = 31 * n + this.n8;
            n = 31 * n + (this.s8 != null ? this.s8.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.n7 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.n7 != 0;
        }

        @Override
        public int nextIndex() {
            return this.n7;
        }

        @Override
        public int previousIndex() {
            return this.n7 - 1;
        }

        public T previous() {
            int n = this.n7 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.n7;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.n7 = n;
            this.m5 = n;
            return objectArray[this.m5];
        }

        public void set(T e) {
            if (this.m5 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.m5, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.n7;
                List.this.add(n, e);
                this.n7 = n + 1;
                this.m5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int n7;
        int m5 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.n7 != List.this.m5;
        }

        @Override
        public T next() {
            int n = this.n7;
            if (n >= List.this.m5) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.n7;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.n7 = n + 1;
            this.m5 = n;
            return (T)objectArray[this.m5];
        }

        @Override
        public void remove() {
            if (this.m5 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.m5);
                this.n7 = this.m5;
                this.m5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

