/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.v4a.l6;
import com.aspose.slides.internal.v4a.m2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.n8;
import com.aspose.slides.ms.System.y7;
import java.util.Arrays;

@g1
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] n7;
    private int m5;
    private int m2;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.n7 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.m5 = collection.size();
            this.n7 = new Object[this.m5];
            collection.copyToTArray(this.n7, 0);
        }
    }

    public void clear() {
        if (this.n7 != null) {
            n8.n7(this.n7, 0, this.n7.length);
        }
        this.m5 = 0;
        ++this.m2;
    }

    public boolean contains(T item) {
        return this.n7 != null && n8.n7(this.n7, item, 0, this.m5) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.m5 - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.n7 != null) {
            n8.n7(this.n7, 0, array, arrayIndex, this.m5);
            y7.n7(array, arrayIndex, this.m5);
        }
    }

    public T peek() {
        if (this.m5 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.n7[this.m5 - 1];
    }

    public T pop() {
        if (this.m5 == 0) {
            throw new InvalidOperationException();
        }
        ++this.m2;
        Object object = this.n7[--this.m5];
        this.n7[this.m5] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.n7 == null || this.m5 == this.n7.length) {
            if (this.n7 == null) {
                this.n7 = new Object[16];
            }
            this.n7 = Arrays.copyOf(this.n7, this.m5 == 0 ? 16 : 2 * this.m5);
        }
        ++this.m2;
        this.n7[this.m5++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.m5) {
            this.copyTo(n8.n7(array), 0);
            return array;
        }
        n8 n82 = n8.n7(com.aspose.slides.internal.v4a.m2.n7(array.getClass().getComponentType()), this.m5);
        this.copyTo(n82, 0);
        return (Object[])n8.n7(n82);
    }

    public void trimExcess() {
        if (this.n7 != null && (double)this.m5 < (double)this.n7.length * 0.9) {
            this.n7 = Arrays.copyOf(this.n7, this.m5);
        }
        ++this.m2;
    }

    @Override
    public int size() {
        return this.m5;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(n8 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.n7 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.m5) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.m5 - idx > dest.s8()) {
                    throw new ArgumentException("idx");
                }
                n8.n7(n8.n7(this.n7), 0, dest, idx, this.m5);
                n8.m5(dest, idx, this.m5);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @g1
    public static class Enumerator<T>
    extends l6<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> m5;
        private int m2;
        private int n8;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.m5 = t;
            this.m2 = -2;
            this.n8 = ((Stack)t).m2;
        }

        @Override
        public void dispose() {
            this.m2 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.n8 != ((Stack)this.m5).m2) {
                throw new IllegalStateException();
            }
            if (this.m2 == -2) {
                this.m2 = ((Stack)this.m5).m5;
            }
            return this.m2 != -1 && --this.m2 != -1;
        }

        @Override
        public T next() {
            if (this.m2 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.m5).n7[this.m2];
        }

        @Override
        public void reset() {
            if (this.n8 != ((Stack)this.m5).m2) {
                throw new IllegalStateException();
            }
            this.m2 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.m5 = this.m5;
            that.m2 = this.m2;
            that.n8 = this.n8;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean n7(Enumerator enumerator) {
            return b5.n7(enumerator.m5, this.m5) && enumerator.m2 == this.m2 && enumerator.n8 == this.n8;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (b5.m5(null, obj)) {
                return false;
            }
            if (b5.m5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.n7((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.m5 != null ? this.m5.hashCode() : 0;
            n = 31 * n + this.m2;
            n = 31 * n + this.n8;
            return n;
        }
    }
}

