/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.c5q.m5;
import com.aspose.slides.internal.c5q.n7;
import com.aspose.slides.internal.g1p.a4;
import com.aspose.slides.internal.g1p.l6;
import com.aspose.slides.internal.g1p.p9;
import com.aspose.slides.internal.g1p.w7;
import com.aspose.slides.internal.g1p.y0;
import com.aspose.slides.internal.o2f.o1;
import com.aspose.slides.internal.v4a.m2;
import com.aspose.slides.internal.v4a.t8;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.m9;
import com.aspose.slides.ms.System.n8;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@g1
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
l6,
w7,
b6,
Map {
    private IGenericEqualityComparer n7;
    private final Object m5 = new Object();
    private Bucket[] m2;
    private int n8;
    private volatile boolean s8;
    private ICollection t8;
    private float l6;
    private int g4;
    private a4 o1;
    private int w7;
    private ICollection s5;
    private volatile int b7;
    private static final t8 v0 = new t8("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", m9.n7("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.l6 = 0.72f * loadFactor;
        double d = (float)capacity / this.l6;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.c5q.n7.n7((int)d) : 11;
        this.m2 = this.m5(n);
        this.g4 = (int)(this.l6 * (float)n);
        this.s8 = false;
    }

    protected Hashtable(a4 info, p9 context) {
        this.o1 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.n7 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.n7 = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.n7(key, value, true);
    }

    @Override
    public void clear() {
        if (this.n8 != 0) {
            this.s8 = true;
            for (int i = 0; i < this.m2.length; ++i) {
                this.m2[i].m2 = 0;
                this.m2[i].n7 = null;
                this.m2[i].m5 = null;
            }
            this.n8 = 0;
            this.w7 = 0;
            this.n8();
            this.s8 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.m2;
        Hashtable hashtable = new Hashtable(this.n8, this.n7);
        hashtable.b7 = this.b7;
        hashtable.l6 = this.l6;
        hashtable.n8 = 0;
        int n = this.m2.length;
        while (n > 0) {
            Object object = bucketArray[--n].n7;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].m5);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.m2;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.n7(key, this.m2.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.m2.length);
        do {
            bucketArray[n10].n7(bucket);
            if (bucket.n7 == null) {
                return false;
            }
            if ((long)(bucket.m2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.n7, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.m2.length);
        } while (bucket.m2 < 0 && ++n < this.m2.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.m2.length;
            while (--n >= 0) {
                if (this.m2[n].n7 == null || this.m2[n].n7 == this.m2 || this.m2[n].m5 != null) continue;
                return true;
            }
        } else {
            int n = this.m2.length;
            while (--n >= 0) {
                Object object = this.m2[n].m5;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void m2(n8 n82, int n) {
        Bucket[] bucketArray = this.m2;
        int n10 = this.m2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].n7;
            if (object == null || object == this.m2) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].m5);
            n82.m2(dictionaryEntry.Clone(), n++);
        }
    }

    void n7(n8 n82, int n) {
        Bucket[] bucketArray = this.m2;
        int n10 = this.m2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].n7;
            if (object == null || object == this.m2) continue;
            n82.m2(object, n++);
        }
    }

    @Override
    public void copyTo(n8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.n8() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.s8() - arrayIndex < this.n8) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.m2(array, arrayIndex);
    }

    void m5(n8 n82, int n) {
        Bucket[] bucketArray = this.m2;
        int n10 = this.m2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].n7;
            if (object == null || object == this.m2) continue;
            n82.m2(bucketArray[n10].m5, n++);
        }
    }

    private void m5() {
        int n = com.aspose.slides.internal.c5q.n7.n7(this.m2.length * 2);
        this.n7(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.n7 != null) {
            return this.n7.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(a4 info, p9 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.n7("LoadFactor", this.l6);
        info.n7("Version", this.b7);
        if (this.n7 == null) {
            info.n7("Comparer", null, com.aspose.slides.internal.v4a.m2.n7(Comparator.class));
            info.n7("HashCodeProvider", null, com.aspose.slides.internal.v4a.m2.n7(IHashCodeProvider.class));
        } else if (this.n7 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.v4a.m2.n7(this.n7, CompatibleComparer.class);
            info.n7("Comparer", objectArray.n7(), com.aspose.slides.internal.v4a.m2.n7(Comparator.class));
            info.n7("HashCodeProvider", objectArray.m5(), com.aspose.slides.internal.v4a.m2.n7(IHashCodeProvider.class));
        } else {
            info.n7("KeyComparer", this.n7, com.aspose.slides.internal.v4a.m2.n7(IGenericEqualityComparer.class));
        }
        info.n7("HashSize", this.m2.length);
        objectArray = new Object[this.n8];
        Object[] objectArray2 = new Object[this.n8];
        this.n7(com.aspose.slides.ms.System.n8.n7(objectArray), 0);
        this.m5(com.aspose.slides.ms.System.n8.n7(objectArray2), 0);
        info.n7("Keys", objectArray, com.aspose.slides.internal.v4a.m2.n7(Object[].class));
        info.n7("Values", objectArray2, com.aspose.slides.internal.v4a.m2.n7(Object[].class));
    }

    private long n7(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void n7(Object object, Object object2, boolean bl) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.n8 >= this.g4) {
                this.m5();
            } else if (this.w7 > this.g4 && this.n8 > 100) {
                this.m2();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.n7(object, this.m2.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.m2.length);
            do {
                if (n10 == -1 && this.m2[n11].n7 == this.m2 && this.m2[n11].m2 < 0) {
                    n10 = n11;
                }
                if (this.m2[n11].n7 == null || this.m2[n11].n7 == this.m2 && ((long)this.m2[n11].m2 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.s8 = true;
                    this.m2[n11].m5 = object2;
                    this.m2[n11].n7 = object;
                    this.m2[n11].m2 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.n8;
                    this.n8();
                    this.s8 = false;
                    break block12;
                }
                if ((long)(this.m2[n11].m2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.m2[n11].n7, object)) {
                    if (bl) {
                        throw new ArgumentException(m9.n7("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.m2[n11].n7, object));
                    }
                    this.s8 = true;
                    this.m2[n11].m5 = object2;
                    this.n8();
                    this.s8 = false;
                    break block12;
                }
                if (n10 == -1 && this.m2[n11].m2 >= 0) {
                    this.m2[n11].m2 = (int)((long)this.m2[n11].m2 | Integer.MIN_VALUE);
                    ++this.w7;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.m2.length);
            } while (++n < this.m2.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.s8 = true;
            this.m2[n10].m5 = object2;
            this.m2[n10].n7 = object;
            this.m2[n10].m2 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.n8;
            this.n8();
            this.s8 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (b5.m5(this.m2, item)) {
            return false;
        }
        if (this.n7 != null) {
            return this.n7.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.m2 == null) {
            if (this.o1 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            y0 y02 = this.o1.n8();
            while (y02.hasNext()) {
                switch (v0.n7(y02.m5())) {
                    case 0: {
                        this.l6 = this.o1.m5("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.o1.n7("HashSize");
                        break;
                    }
                    case 2: {
                        this.n7 = (IGenericEqualityComparer)this.o1.n7("KeyComparer", com.aspose.slides.internal.v4a.m2.n7(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.o1.n7("Comparer", com.aspose.slides.internal.v4a.m2.n7(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.o1.n7("HashCodeProvider", com.aspose.slides.internal.v4a.m2.n7(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.o1.n7("Keys", com.aspose.slides.internal.v4a.m2.n7(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.o1.n7("Values", com.aspose.slides.internal.v4a.m2.n7(Object[].class));
                    }
                }
            }
            this.g4 = (int)(this.l6 * (float)n);
            if (this.n7 == null && (comparator != null || iHashCodeProvider != null)) {
                this.n7 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.m2 = this.m5(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.n7(objectArray[i], objectArray2[i], true);
            }
            this.b7 = this.o1.n7("Version");
            this.o1 = null;
        }
    }

    private void n7(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].n7 == null || bucketArray[n10].n7 == this.m2) {
                bucketArray[n10].m5 = object2;
                bucketArray[n10].n7 = object;
                bucketArray[n10].m2 |= n;
                break;
            }
            if (bucketArray[n10].m2 >= 0) {
                bucketArray[n10].m2 = (int)((long)bucketArray[n10].m2 | Integer.MIN_VALUE);
                ++this.w7;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void m2() {
        this.n7(this.m2.length);
    }

    private void n7(int n) {
        this.w7 = 0;
        Bucket[] bucketArray = this.m5(n);
        for (int i = 0; i < this.m2.length; ++i) {
            Bucket bucket = this.m2[i].n7();
            if (bucket.n7 == null || bucket.n7 == this.m2) continue;
            this.n7(bucketArray, bucket.n7, bucket.m5, bucket.m2 & Integer.MAX_VALUE);
        }
        this.s8 = true;
        this.m2 = bucketArray;
        this.g4 = (int)(this.l6 * (float)n);
        this.n8();
        this.s8 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.n7(key, this.m2.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.m2.length);
        do {
            this.m2[n10].n7(bucket);
            if ((long)(bucket.m2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.n7, key)) {
                this.s8 = true;
                this.m2[n10].m2 = (int)((long)this.m2[n10].m2 & Integer.MIN_VALUE);
                this.m2[n10].n7 = this.m2[n10].m2 != 0 ? this.m2 : null;
                this.m2[n10].m5 = null;
                --this.n8;
                this.n8();
                this.s8 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.m2.length);
        } while (bucket.m2 < 0 && ++n < this.m2.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] n7() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.n8];
        int n = 0;
        Bucket[] bucketArray = this.m2;
        int n10 = this.m2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].n7;
            if (object == null || object == this.m2) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].m5);
        }
        return keyValuePairsArray;
    }

    private void n8() {
        ++this.b7;
    }

    private Bucket[] m5(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.n8;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.n7;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.m2;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.n7(key, this.m2.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.m2.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.b7;
                bucketArray[n10].n7(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.o2f.o1.m5(1);
            } while (this.s8 || n11 != this.b7);
            if (bucket.n7 == null) break;
            if ((long)(bucket.m2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.n7, key)) {
                return bucket.m5;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.m2.length);
        } while (bucket.m2 < 0 && ++n < this.m2.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.n7(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.t8 == null) {
            this.t8 = new KeyCollection(this);
        }
        return this.t8;
    }

    @Override
    public Object getSyncRoot() {
        return this.m5;
    }

    @Override
    public ICollection getValues() {
        if (this.s5 == null) {
            this.s5 = new ValueCollection(this);
        }
        return this.s5;
    }

    @Override
    public boolean isEmpty() {
        return this.n8 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        n8 n82 = com.aspose.slides.ms.System.n8.n7(objectArray);
        this.getKeys().copyTo(n82, 0);
        return new ReadOnlyItemCollection(n82);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        n8 n82 = com.aspose.slides.ms.System.n8.n7(objectArray);
        this.getValues().copyTo(n82, 0);
        return new ReadOnlyItemCollection(n82);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.n7();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].n7(), keyValuePairsArray[i].m5());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.n8.n7(entryArray));
    }

    public int getVersion() {
        return this.b7;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new m5(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private n8 m5;

        ReadOnlyItemCollection(n8 items) {
            this.m5 = items;
        }

        @Override
        public int size() {
            return this.m5.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m5.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.m5.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.m5.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            n8 n82 = com.aspose.slides.ms.System.n8.n7(objectArray);
            this.m5.copyTo(n82, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.m5.copyTo(com.aspose.slides.ms.System.n8.n7(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @g1
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable n7;

        SyncHashtable(Hashtable table) {
            super(false);
            this.n7 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.n7.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.n7.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.n7.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array, int arrayIndex) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.n7.iterator();
        }

        @Override
        public void getObjectData(a4 info, p9 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.n7("ParentTable", this.n7, com.aspose.slides.internal.v4a.m2.n7(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] n7() {
            return this.n7.n7();
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.n7.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.n7.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.n7.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.getValues();
            }
        }
    }

    @g1
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable n7;

        ValueCollection(Hashtable hashtable) {
            this.n7 = hashtable;
        }

        @Override
        public void copyTo(n8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.n8() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.s8() - arrayIndex < this.n7.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.n7.m5(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.n7, 2);
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }
    }

    @g1
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable n7;

        KeyCollection(Hashtable hashtable) {
            this.n7 = hashtable;
        }

        @Override
        public void copyTo(n8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.n8() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.s8() - arrayIndex < this.n7.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.n7.n7(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.n7, 1);
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }
    }

    @g1
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int n7;
        private boolean m5;
        private Object m2;
        private Object n8;
        private int s8;
        private Hashtable t8;
        private int l6;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.t8 = hashtable;
            this.n7 = hashtable.m2.length;
            this.l6 = hashtable.b7;
            this.m5 = false;
            this.s8 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.l6 != this.t8.b7) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.n7 > 0) {
                --this.n7;
                Object object = ((Hashtable)this.t8).m2[this.n7].n7;
                if (object == null || object == this.t8.m2) continue;
                this.m2 = object;
                this.n8 = ((Hashtable)this.t8).m2[this.n7].m5;
                this.m5 = true;
                return true;
            }
            this.m5 = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.l6 != this.t8.b7) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.m5 = false;
            this.n7 = this.t8.m2.length;
            this.m2 = null;
            this.n8 = null;
        }

        @Override
        public Object next() {
            if (!this.m5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.s8 == 1) {
                return this.m2;
            }
            if (this.s8 == 2) {
                return this.n8;
            }
            return new DictionaryEntry(this.m2, this.n8);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.m5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.m2, this.n8);
        }

        @Override
        public Object getKey() {
            if (!this.m5) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.m2;
        }

        @Override
        public Object getValue() {
            if (!this.m5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.n8;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object n7;
        private Object m5;

        public KeyValuePairs(Object key, Object value) {
            this.m5 = value;
            this.n7 = key;
        }

        public Object n7() {
            return this.n7;
        }

        public Object m5() {
            return this.m5;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.v4a.l6<Bucket> {
        public Object n7;
        public Object m5;
        public int m2;

        public void n7(Bucket bucket) {
            bucket.n7 = this.n7;
            bucket.m5 = this.m5;
            bucket.m2 = this.m2;
        }

        public Bucket n7() {
            Bucket bucket = new Bucket();
            this.n7(bucket);
            return bucket;
        }

        public Object clone() {
            return this.n7();
        }

        private boolean m5(Bucket bucket) {
            return b5.n7(bucket.n7, this.n7) && b5.n7(bucket.m5, this.m5) && bucket.m2 == this.m2;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (b5.m5(null, obj)) {
                return false;
            }
            if (b5.m5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.m5((Bucket)obj);
        }

        public int hashCode() {
            int n = this.n7 != null ? this.n7.hashCode() : 0;
            n = 31 * n + (this.m5 != null ? this.m5.hashCode() : 0);
            n = 31 * n + this.m2;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.n7();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.n7((Bucket)object);
        }
    }

    @g1
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator n7;
        private IHashCodeProvider m5;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.n7 = comparer;
            this.m5 = hashCodeProvider;
        }

        public int n7(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.n7 != null) {
                return this.n7.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.v4a.m2.n7(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.n7(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.m5 != null) {
                return this.m5.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator n7() {
            return this.n7;
        }

        IHashCodeProvider m5() {
            return this.m5;
        }
    }
}

