/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.n8;
import java.util.Arrays;

@g1
public class Queue
implements ICollection,
IEnumerable,
b6 {
    private Object[] n7;
    private int m5 = 0;
    private int m2 = 0;
    private int n8 = 0;
    private int s8;
    private int t8 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.n7 = new Object[capacity];
        this.s8 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.m2;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(n8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.n8() > 1 || index != 0 && index >= array.s8() || this.m2 > array.s8() - index) {
            throw new ArgumentException();
        }
        int n = this.n7.length;
        int n10 = n - this.m5;
        com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7), this.m5, array, index, Math.min(this.m2, n10));
        if (this.m2 > n10) {
            com.aspose.slides.ms.System.n8.n7(com.aspose.slides.ms.System.n8.n7(this.n7), 0, array, index + n10, this.m2 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.n7.length);
        queue.s8 = this.s8;
        com.aspose.slides.ms.System.n8.n7(this.n7, 0, queue.n7, 0, this.n7.length);
        queue.m5 = this.m5;
        queue.m2 = this.m2;
        queue.n8 = this.n8;
        return queue;
    }

    public void clear() {
        ++this.t8;
        this.m5 = 0;
        this.m2 = 0;
        this.n8 = 0;
        for (int i = this.n7.length - 1; i >= 0; --i) {
            this.n7[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.m5 + this.m2;
        if (obj == null) {
            for (int i = this.m5; i < n; ++i) {
                if (this.n7[i % this.n7.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.m5; i < n; ++i) {
                if (!obj.equals(this.n7[i % this.n7.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.t8;
        if (this.m2 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.n7[this.m5];
        this.n7[this.m5] = null;
        this.m5 = (this.m5 + 1) % this.n7.length;
        --this.m2;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.t8;
        if (this.m2 == this.n7.length) {
            this.n7();
        }
        this.n7[this.n8] = obj;
        this.n8 = (this.n8 + 1) % this.n7.length;
        ++this.m2;
    }

    public Object peek() {
        if (this.m2 < 1) {
            throw new InvalidOperationException();
        }
        return this.n7[this.m5];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.m2) {
            return Arrays.copyOf(this.n7, this.m2, a.getClass());
        }
        System.arraycopy(this.n7, 0, a, 0, this.m2);
        if (a.length > this.m2) {
            a[this.m2] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.t8;
        Object[] objectArray = new Object[this.m2];
        this.copyTo(com.aspose.slides.ms.System.n8.n7(objectArray), 0);
        this.n7 = objectArray;
        this.m5 = 0;
        this.n8 = 0;
    }

    private void n7() {
        int n = this.n7.length * this.s8 / 100;
        if (n < this.n7.length + 1) {
            n = this.n7.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.n8.n7(objectArray), 0);
        this.n7 = objectArray;
        this.m5 = 0;
        this.n8 = this.m5 + this.m2;
    }

    @g1
    private static class QueueEnumerator
    implements IEnumerator,
    b6 {
        private Queue n7;
        private int m5;
        private int m2;

        QueueEnumerator(Queue q) {
            this.n7 = q;
            this.m5 = q.t8;
            this.m2 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.n7);
            queueEnumerator.m5 = this.m5;
            queueEnumerator.m2 = this.m2;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.m5 != this.n7.t8 || this.m2 < 0 || this.m2 >= this.n7.m2) {
                throw new InvalidOperationException();
            }
            return this.n7.n7[(this.n7.m5 + this.m2) % this.n7.n7.length];
        }

        @Override
        public boolean hasNext() {
            if (this.m5 != this.n7.t8) {
                throw new InvalidOperationException();
            }
            if (this.m2 >= this.n7.m2 - 1) {
                this.m2 = Integer.MAX_VALUE;
                return false;
            }
            ++this.m2;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.m5 != this.n7.t8) {
                throw new InvalidOperationException();
            }
            this.m2 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue n7;

        SyncQueue(Queue queue) {
            this.n7 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.n7;
            synchronized (queue) {
                return this.n7.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array, int index) {
            Queue queue = this.n7;
            synchronized (queue) {
                this.n7.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.n7;
            synchronized (queue) {
                return this.n7.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.n7;
            synchronized (queue) {
                return new SyncQueue((Queue)this.n7.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.n7;
            synchronized (queue) {
                this.n7.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.n7;
            synchronized (queue) {
                this.n7.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.n7;
            synchronized (queue) {
                return this.n7.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.n7;
            synchronized (queue) {
                return this.n7.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.n7;
            synchronized (queue) {
                this.n7.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.n7;
            synchronized (queue) {
                return this.n7.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.n7;
            synchronized (queue) {
                return this.n7.toArray(a);
            }
        }
    }
}

