/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.v4a.l6;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.m9;
import com.aspose.slides.ms.System.n8;
import com.aspose.slides.ms.System.x6;
import java.util.Comparator;

@g1
public class SortedList
implements IDictionary,
b6 {
    private final Object n7 = new Object();
    private Slot[] m5;
    private Comparator m2;
    private int n8;
    private int s8;
    private int t8;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.t8 = capacity == 0 ? 0 : 16;
        this.m2 = comparer;
        this.m5(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.m2 = comparer;
        this.m5(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.m5(d.size(), true);
        this.m2 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.n8;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.n7;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.n7(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.m5(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.n7(key, value, true);
    }

    public int getCapacity() {
        return this.m5.length;
    }

    public void setCapacity(int value) {
        int n = this.m5.length;
        if (this.n8 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.n7(this.t8);
            SortedList.n7(this.m5, 0, slotArray, 0, this.n8);
            this.m5 = slotArray;
        } else if (value > this.n8) {
            Slot[] slotArray = SortedList.n7(value);
            SortedList.n7(this.m5, 0, slotArray, 0, this.n8);
            this.m5 = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.n7(value);
            SortedList.n7(this.m5, 0, slotArray, 0, n);
            this.m5 = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.n7(key, value, false);
    }

    @Override
    public void clear() {
        this.t8 = 16;
        this.m5 = SortedList.n7(this.t8);
        this.n8 = 0;
        ++this.s8;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.m5(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(n8 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.n8() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.s8()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.s8() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.m2(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.m2);
        sortedList.s8 = this.s8;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.m5;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.n7(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].n7 = null;
                slotArray[index].m5 = null;
            }
            --this.n8;
            ++this.s8;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.m5(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.n8 == 0) {
            return -1;
        }
        for (int i = 0; i < this.n8; ++i) {
            Slot slot = this.m5[i].Clone();
            if (!b5.n7(value, slot.m5)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.m5[index].m5;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.m5[index].m5 = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.m5[index].n7;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.n7(this.t8, false);
        } else {
            this.n7(this.size(), true);
        }
    }

    private void n7(int n, boolean bl) {
        Slot[] slotArray = this.m5;
        Slot[] slotArray2 = SortedList.n7(n);
        if (bl) {
            SortedList.n7(slotArray, 0, slotArray2, 0, n);
        }
        this.m5 = slotArray2;
    }

    private void n7(int n, int n10) {
        boolean bl;
        Slot[] slotArray = this.m5;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl2 = bl = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.n7(n << 1);
        }
        if (slotArray2 != null) {
            if (bl) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.n7(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.n7(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.n7(slotArray, 0, slotArray2, 0, this.size());
            }
            this.m5 = slotArray2;
        } else if (bl) {
            SortedList.n7(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void n7(Object object, Object object2, boolean bl) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.m5;
        int n = -1;
        try {
            n = this.m5(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl) {
                String string = m9.n7("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].m5 = object2;
            ++this.s8;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(m9.n7(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.n7(this.size() + 1, n);
        slotArray = this.m5;
        slotArray[n].n7 = object;
        slotArray[n].m5 = object2;
        ++this.n8;
        ++this.s8;
    }

    private Object n7(Object object) {
        int n = this.m5(object);
        if (n >= 0) {
            return this.m5[n].m5;
        }
        return null;
    }

    private void m5(int n, boolean bl) {
        if (!bl && n < this.t8) {
            n = this.t8;
        }
        this.m5 = SortedList.n7(n);
        this.n8 = 0;
        this.s8 = 0;
    }

    private void n7(n8 n82, int n, int n10) {
        if (n82 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > n82.s8()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            n82.m2(enumerator.next(), n++);
        }
    }

    private int m5(Object object) {
        Slot[] slotArray = this.m5;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.m2 == null ? Comparer.Default : this.m2;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].n7, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] n7(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean n7(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void n7(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.n7(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList n7;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.n7 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.n7.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.n7.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                iCollection = this.n7.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                iCollection = this.n7.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.n7(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.n7(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array, int arrayIndex) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.n7(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.m5(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.n7);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.n7);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                return this.n7.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.n7.getSyncRoot();
            synchronized (object) {
                this.n7.trimToSize();
            }
        }
    }

    @g1
    private static class ListValues
    implements IList {
        private SortedList n7;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.n7 = host;
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        @Override
        public void copyTo(n8 array, int arrayIndex) {
            this.n7.n7(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.n7.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.n7.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.n7, 1);
        }
    }

    @g1
    private static class ListKeys
    implements IList {
        private SortedList n7;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.n7 = host;
        }

        @Override
        public int size() {
            return this.n7.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.n7.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        @Override
        public void copyTo(n8 array, int arrayIndex) {
            this.n7.n7(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.n7.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.n7.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.n7.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.n7, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    b6 {
        private SortedList n7;
        private Object m5;
        private Object m2;
        private int n8;
        private int s8;
        private int t8;
        private int l6;
        private boolean g4 = false;
        private static String o1 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.n7 = host;
            this.n8 = host.s8;
            this.t8 = host.size();
            this.l6 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.n7.s8 != this.n8 || this.g4) {
                throw new IllegalStateException(o1);
            }
            this.s8 = -1;
            this.m5 = null;
            this.m2 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.n7.s8 != this.n8 || this.g4) {
                throw new InvalidOperationException(o1);
            }
            return ++this.s8 < this.t8;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            return new DictionaryEntry(this.m5, this.m2);
        }

        @Override
        public Object getKey() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            return this.m5;
        }

        @Override
        public Object getValue() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            return this.m2;
        }

        @Override
        public Object next() {
            if (this.n7.s8 != this.n8 || this.g4) {
                throw new InvalidOperationException(o1);
            }
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                if (this.s8 >= this.t8) {
                    this.m5 = null;
                    this.m2 = null;
                }
                throw new IllegalStateException(o1);
            }
            Slot[] slotArray = this.n7.m5;
            Slot slot = slotArray[this.s8].Clone();
            this.m5 = slot.n7;
            this.m2 = slot.m5;
            switch (this.l6) {
                case 0: {
                    return this.m5;
                }
                case 1: {
                    return this.m2;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(m9.n7(new String[]{x6.getName(EnumeratorMode.class, this.l6), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.n7, this.l6);
            enumeratorJava.n8 = this.n8;
            enumeratorJava.s8 = this.s8;
            enumeratorJava.t8 = this.t8;
            enumeratorJava.m5 = this.m5;
            enumeratorJava.m2 = this.m2;
            enumeratorJava.g4 = this.g4;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    b6 {
        private SortedList n7;
        private Object m5;
        private Object m2;
        private int n8;
        private int s8;
        private int t8;
        private int l6;
        private boolean g4 = false;
        private static String o1 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.n7 = host;
            this.n8 = host.s8;
            this.t8 = host.size();
            this.l6 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.n7.s8 != this.n8 || this.g4) {
                throw new IllegalStateException(o1);
            }
            this.s8 = -1;
            this.m5 = null;
            this.m2 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.n7.s8 != this.n8 || this.g4) {
                throw new InvalidOperationException(o1);
            }
            Slot[] slotArray = this.n7.m5;
            if (++this.s8 < this.t8) {
                Slot slot = slotArray[this.s8].Clone();
                this.m5 = slot.n7;
                this.m2 = slot.m5;
                return true;
            }
            this.m5 = null;
            this.m2 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            return new DictionaryEntry(this.m5, this.m2);
        }

        @Override
        public Object getKey() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            return this.m5;
        }

        @Override
        public Object getValue() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            return this.m2;
        }

        @Override
        public Object next() {
            if (this.g4 || this.s8 >= this.t8 || this.s8 == -1) {
                throw new IllegalStateException(o1);
            }
            switch (this.l6) {
                case 0: {
                    return this.m5;
                }
                case 1: {
                    return this.m2;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(m9.n7(new String[]{x6.getName(EnumeratorMode.class, this.l6), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.n7, this.l6);
            enumerator.n8 = this.n8;
            enumerator.s8 = this.s8;
            enumerator.t8 = this.t8;
            enumerator.m5 = this.m5;
            enumerator.m2 = this.m2;
            enumerator.g4 = this.g4;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends x6 {
        private EnumeratorMode() {
        }

        static {
            x6.register(new x6.s8(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @g1
    public static class Slot
    extends l6<Slot> {
        Object n7;
        Object m5;

        @Override
        public void CloneTo(Slot that) {
            that.n7 = this.n7;
            that.m5 = this.m5;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean n7(Slot slot) {
            return b5.n7(slot.n7, this.n7) && b5.n7(slot.m5, this.m5);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (b5.m5(null, obj)) {
                return false;
            }
            if (b5.m5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.n7((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.n7 != null ? this.n7.hashCode() : 0;
            n = 31 * n + (this.m5 != null ? this.m5.hashCode() : 0);
            return n;
        }
    }
}

