/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.n7y.u8;
import com.aspose.slides.internal.v4a.l6;
import com.aspose.slides.internal.v4a.m2;
import com.aspose.slides.ms.System.h7;
import com.aspose.slides.ms.System.r5;

public class BitVector32
extends l6<BitVector32> {
    private int n7;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.n7 = value.n7;
    }

    public BitVector32(int data) {
        this.n7 = data;
    }

    public int getData() {
        return this.n7;
    }

    public int get_Item(Section section) {
        return this.n7 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.n7 &= ~(section.getMask() << section.getOffset());
        this.n7 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.n7 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.n7 = value ? (this.n7 |= bit) : (this.n7 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.n7(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.n7(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(m2.m5((Object)n10, 9), m2.m5((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return m2.m5(o, BitVector32.class) && this.n7 == m2.n8((Object)o, BitVector32.class).n7;
    }

    public int hashCode() {
        return r5.n7(this.n7);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        u8 u82 = new u8();
        u82.n7("BitVector32{");
        for (long i = m2.t8((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            u82.n7(((long)value.n7 & i) == 0L ? (char)'0' : '1');
        }
        u82.n7('}');
        return u82.toString();
    }

    private static int n7(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.n7 = this.n7;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends l6<Section> {
        private short n7;
        private short m5;

        public Section() {
        }

        Section(short mask, short offset) {
            this.n7 = mask;
            this.m5 = offset;
        }

        public short getMask() {
            return this.n7;
        }

        public short getOffset() {
            return this.m5;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.n7 == b.n7 && a.m5 == b.m5;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.n7 != b.n7 || a.m5 != b.m5;
        }

        public boolean equals(Section obj) {
            return this.n7 == obj.n7 && this.m5 == obj.m5;
        }

        public boolean equals(Object o) {
            if (!m2.m5(o, Section.class)) {
                return false;
            }
            Section section = m2.n8(o, Section.class).Clone();
            return this.n7 == section.n7 && this.m5 == section.m5;
        }

        public int hashCode() {
            return this.n7 << this.m5;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            u8 u82 = new u8();
            u82.n7("Section{0x");
            u82.n7(h7.n7(value.getMask(), 16));
            u82.n7(", 0x");
            u82.n7(h7.n7(value.getOffset(), 16));
            u82.n7("}");
            return u82.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.n7 = this.n7;
            that.m5 = this.m5;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

