/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.b6;
import com.aspose.slides.ms.System.g1;
import com.aspose.slides.ms.System.n8;
import com.aspose.slides.ms.System.y7;
import java.util.Arrays;

@g1
public class Stack
implements ICollection,
IEnumerable,
b6 {
    private Object[] n7;
    private int m5 = -1;
    private int m2;
    private int n8;
    private int s8;

    private void n7(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.n8.n7(this.n7, 0, objectArray, 0, this.m2);
        this.n8 = n;
        this.n7 = objectArray;
    }

    public Stack() {
        this.n7 = new Object[16];
        this.n8 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.n8 = initialCapacity;
        this.n7 = new Object[this.n8];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.m2;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.s8;
        for (int i = 0; i < this.m2; ++i) {
            this.n7[i] = null;
        }
        this.m2 = 0;
        this.m5 = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.n8.n7(this.n7));
        stack.m5 = this.m5;
        stack.m2 = this.m2;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.m2 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.m2; ++i) {
                if (this.n7[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.m2; ++i) {
                if (!obj.equals(this.n7[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(n8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.n8() > 1 || array.s8() > 0 && index >= array.s8() || this.m2 > array.s8() - index) {
            throw new ArgumentException();
        }
        for (int i = this.m5; i != -1; --i) {
            array.m2(this.n7[i], this.m2 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.m5 == -1) {
            throw new InvalidOperationException();
        }
        return this.n7[this.m5];
    }

    public Object pop() {
        if (this.m5 == -1) {
            throw new InvalidOperationException();
        }
        ++this.s8;
        Object object = this.n7[this.m5];
        this.n7[this.m5] = null;
        --this.m2;
        --this.m5;
        if (this.m2 <= this.n8 / 4 && this.m2 > 16) {
            this.n7(this.n8 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.s8;
        if (this.n8 == this.m2) {
            this.n7(this.n8 * 2);
        }
        ++this.m2;
        ++this.m5;
        this.n7[this.m5] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.m2) {
            a = Arrays.copyOf(this.n7, this.m2, a.getClass());
            y7.n7(a);
            return a;
        }
        System.arraycopy(this.n7, 0, a, 0, this.m2);
        if (a.length > this.m2) {
            a[this.m2] = null;
        }
        y7.n7(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    b6,
    Cloneable {
        private Stack n7;
        private int m5;
        private int m2;

        Enumerator(Stack s) {
            this.n7 = s;
            this.m5 = s.s8;
            this.m2 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.n7();
        }

        @Override
        public Object next() {
            if (this.m5 != this.n7.s8 || this.m2 == -2 || this.m2 == -1 || this.m2 > this.n7.m2) {
                throw new InvalidOperationException();
            }
            return this.n7.n7[this.m2];
        }

        @Override
        public boolean hasNext() {
            if (this.m5 != this.n7.s8) {
                throw new InvalidOperationException();
            }
            switch (this.m2) {
                case -2: {
                    this.m2 = this.n7.m5;
                    return this.m2 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.m2;
            return this.m2 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.m5 != this.n7.s8) {
                throw new InvalidOperationException();
            }
            this.m2 = -2;
        }

        protected Object n7() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.n7 = this.n7;
            enumerator.m5 = this.m5;
            enumerator.m2 = this.m2;
            return enumerator;
        }
    }

    @g1
    private static class SyncStack
    extends Stack {
        private final Stack n7;

        SyncStack(Stack s) {
            this.n7 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.n7;
            synchronized (stack) {
                return this.n7.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.n7.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.n7;
            synchronized (stack) {
                this.n7.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.n7;
            synchronized (stack) {
                return Stack.sync((Stack)this.n7.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.n7;
            synchronized (stack) {
                return this.n7.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(n8 array, int index) {
            Stack stack = this.n7;
            synchronized (stack) {
                this.n7.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.n7;
            synchronized (stack) {
                return new Enumerator(this.n7);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.n7;
            synchronized (stack) {
                return this.n7.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.n7;
            synchronized (stack) {
                return this.n7.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.n7;
            synchronized (stack) {
                this.n7.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.n7;
            synchronized (stack) {
                return this.n7.toArray(a);
            }
        }
    }
}

