/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.IAIConversation;
import com.aspose.slides.IAIWebClient;
import com.aspose.slides.SlidesAIAgentException;
import com.aspose.slides.c6m;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.p6.g4;
import com.aspose.slides.internal.p6.l6;
import com.aspose.slides.internal.p6.m5;
import com.aspose.slides.internal.p6.n7;
import com.aspose.slides.internal.p6.t8;
import com.aspose.slides.ms.System.m9;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class OpenAIWebClient
implements IAIWebClient,
Closeable {
    private l6 n7;
    private final String m5;
    private final HttpURLConnection m2;
    private boolean n8;

    public OpenAIWebClient(String model, String apiKey, String organizationId) {
        this(model, apiKey, organizationId, OpenAIWebClient.n7());
        this.n8 = true;
    }

    public OpenAIWebClient(String model, String apiKey, String organizationId, HttpURLConnection httpClient) {
        if (m9.n7(apiKey)) {
            throw new IllegalArgumentException("API key value can't be null or empty");
        }
        if (m9.n7(model)) {
            throw new IllegalArgumentException("Text model value can't be null or empty");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("HttpClient instance is not provided");
        }
        this.m2 = httpClient;
        this.n7 = new l6(apiKey, organizationId);
        this.m5 = model;
    }

    @Override
    public String callChat(String instruction) {
        n7 n72 = this.n7(instruction);
        try {
            m5 m52 = this.n7.n7(n72, this.m2);
            if (m52.n7() == null || m52.n7().isEmpty()) {
                throw new ArgumentException("No choices in response");
            }
            return m52.n7().get(0).n7().m5();
        }
        catch (g4 g42) {
            throw new SlidesAIAgentException(g42.getMessage());
        }
    }

    @Override
    public final IAIConversation createConversation() {
        return new c6m(this.n7, this.m5, this.m2);
    }

    private n7 n7(String string) {
        if (m9.n7(string)) {
            throw new ArgumentException("Open AI chat instruction can't be null or empty");
        }
        n7 n72 = new n7();
        String string2 = this.m5;
        if (string2 == null) {
            string2 = "gpt-4o-mini";
        }
        n72.n7(string2);
        t8 t82 = new t8();
        t82.m5(string);
        t82.n7("user");
        n72.n7().add(t82);
        return n72;
    }

    private static HttpURLConnection n7() {
        try {
            URL uRL = new URL("https://api.openai.com/v1/chat/completions");
            return (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new InvalidOperationException("Failed to create default HttpURLConnection");
        }
    }

    @Override
    public final void close() {
        if (this.n8) {
            this.m2.disconnect();
        }
    }
}

