/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.ColumnCollection;
import com.aspose.slides.DomObject;
import com.aspose.slides.ICell;
import com.aspose.slides.IRow;
import com.aspose.slides.IRowCollection;
import com.aspose.slides.PptxEditException;
import com.aspose.slides.Row;
import com.aspose.slides.Table;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.IndexOutOfRangeException;
import com.aspose.slides.internal.z4u.b8;
import com.aspose.slides.ms.System.m9;
import com.aspose.slides.ms.System.n8;

public final class RowCollection
extends DomObject<Table>
implements IRowCollection {
    private final List<IRow> n8 = new List();
    private boolean s8 = true;
    boolean n7 = true;
    double m5 = 0.0;
    final ColumnCollection m2 = new ColumnCollection(this);

    RowCollection(Table parentImmediate) {
        super(parentImmediate);
    }

    final Table n7() {
        return (Table)this.t8;
    }

    final double m5() {
        this.t8();
        return this.m5;
    }

    @Override
    public final int size() {
        return this.n8.size();
    }

    @Override
    public final IRow get_Item(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IndexOutOfRangeException(m9.n7("value of index = {0} is out of range 0..{1}", new Object[]{index, this.size() - 1}));
        }
        return (Row)this.n8.get_Item(index);
    }

    final Row n7(int n) {
        return (Row)this.n8.get_Item(n);
    }

    final Row n7(double d) {
        return this.n7(-1, d);
    }

    final Row n7(int n, double d) {
        Row row = new Row(this, d);
        if (n < 0 || n >= this.size()) {
            row.m5 = this.n8.size();
            this.n8.addItem(row);
        } else {
            this.n8.insertItem(n, row);
            this.s8 = false;
        }
        this.n7 = false;
        row.m5(this.m2.size());
        return row;
    }

    @Override
    public final IRow[] addClone(IRow templ, boolean withAttachedRows) {
        int n = this.size();
        return this.insertClone(n, templ, withAttachedRows);
    }

    @Override
    public final IRow[] insertClone(int index, IRow templ, boolean withAttachedRows) {
        Row[] rowArray;
        Row row = (Row)templ;
        Table table = row.n7();
        if (this.n7() != table) {
            throw new PptxEditException("Clonning rows between different tables isn't supported.");
        }
        if (index < 0 || index > this.size()) {
            throw new ArgumentOutOfRangeException("index", index, "Wrong index of row");
        }
        if (this.n7(index, true)) {
            throw new PptxEditException("Can't insert rows: target index breaks merged cells.");
        }
        if (withAttachedRows) {
            rowArray = row.t8().m5(row.l6());
        } else {
            if (this.m5(row.l6(), true)) {
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            rowArray = new Row[]{row};
        }
        IRow[] iRowArray = new IRow[rowArray.length];
        int n = rowArray.length;
        while (n > 0) {
            row = rowArray[--n];
            Row row2 = this.n7(index, row.getMinimalHeight());
            iRowArray[n] = row2;
            row2.setMinimalHeight(row.getMinimalHeight());
            int n10 = this.m2.size();
            while (n10 > 0) {
                Cell cell = row.n7(--n10);
                Cell cell2 = row2.n7(n10);
                cell2.m5 = cell.m5;
                cell2.n7 = cell.n7;
                if (cell2.l6()) {
                    row2.m5 = index;
                    this.s8 = true;
                    cell2.m5(false);
                }
                cell2.n7(cell);
            }
        }
        this.s8 = false;
        return iRowArray;
    }

    final void m5(int n, double d) {
        Row row = this.n7(n);
        if (d <= 0.0 || d >= row.getHeight()) {
            throw new ArgumentOutOfRangeException("Splitting height must be in greater than 0 and less than row's minimal height");
        }
        Row row2 = this.n7(n + 1, row.getHeight() - d);
        row.setMinimalHeight(d);
        int n10 = this.m2.size();
        int n11 = 0;
        while (n11 < n10) {
            Cell cell = row.n7(n11);
            if (cell.g4()) {
                cell = cell.s8();
            }
            ++cell.n7;
            int n12 = cell.getColSpan();
            while (n12 > 0) {
                --n12;
                row2.n7((int)n11).m2 = cell;
                ++n11;
            }
        }
    }

    final void m2() {
        this.m5(0, this.size());
        this.s8 = true;
        this.n7 = true;
        this.m5 = 0.0;
    }

    @Override
    public final void removeAt(int firstRowIndex, boolean withAttachedRows) {
        int n = this.size();
        if (withAttachedRows) {
            b8 b82 = this.m2(firstRowIndex).n8();
            this.m5(b82.m5(), b82.m2());
        } else {
            int n10 = this.m2.size();
            Row row = this.n7(firstRowIndex);
            for (int i = 0; i < n10; ++i) {
                ICell iCell = row.get_Item(i);
                if (iCell.getRowSpan() <= 1) continue;
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            this.m5(firstRowIndex, 1);
        }
        if (n != this.size() && this.size() > 0) {
            this.m2.s8();
        }
    }

    private void m5(int n, int n10) {
        if (n10 == 0) {
            return;
        }
        if (n + n10 < this.size()) {
            this.s8 = false;
        }
        this.n7 = false;
        int n11 = n;
        int n12 = this.m2.size();
        for (int i = 0; i < n10; ++i) {
            Row row = this.n7(n11++);
            row.m5(0, n12);
        }
        if (n == 0 && n10 == this.size()) {
            this.n8.clear();
        } else {
            this.n8.removeRange(n, n10);
        }
    }

    final void n8() {
        this.n7(0, this.size());
    }

    final void n7(int n, int n10) {
        boolean bl = this.n7;
        int n11 = n + n10;
        int n12 = this.m2.size();
        while (n11 > n) {
            Cell cell;
            int n13;
            Row row = this.n7(--n11);
            boolean bl2 = true;
            for (n13 = 0; n13 < n12; ++n13) {
                if (row.n7(n13).g4()) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            if (n11 > 0) {
                Row row2 = this.n7(n11 - 1);
                row2.setMinimalHeight(row2.getMinimalHeight() + row.getMinimalHeight());
            }
            for (n13 = 0; n13 < n12; n13 += cell.getColSpan()) {
                cell = row.n7(n13).s8();
                --cell.n7;
            }
            this.m5(n11, 1);
        }
        this.n7 = bl;
    }

    private b8 m2(int n) {
        int n10;
        int n11;
        int n12 = this.m2.size();
        int n13 = n;
        Row row = this.n7(n13);
        if (n > 0) {
            Cell cell;
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.n7(n11).s8();
                if (cell.getFirstRowIndex() >= n13) continue;
                n13 = cell.getFirstRowIndex();
                row = this.n7(n13);
                n11 = 0;
            }
        }
        if ((n10 = n + 1) < this.size()) {
            Cell cell;
            row = this.n7(n);
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.n7(n11).s8();
                if (cell.getFirstRowIndex() + cell.getRowSpan() <= n10) continue;
                n10 = cell.getFirstRowIndex() + cell.getRowSpan();
                row = this.n7(n10 - 1);
                n11 = 0;
            }
        }
        return new b8(n13, n10 - n13);
    }

    final Row[] m5(int n) {
        b8 b82 = this.m2(n).n8();
        Row[] rowArray = new Row[b82.m2()];
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i] = this.n7(b82.m5() + i);
        }
        return rowArray;
    }

    final void s8() {
        if (this.s8) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.n7((int)i).m5 = i;
        }
        this.s8 = true;
    }

    final void t8() {
        if (this.n7) {
            return;
        }
        this.n7().y4().m2();
        double d = 0.0;
        int n = 0;
        while (n < this.size()) {
            Row row = this.n7(n);
            row.m5 = n++;
            row.m2 = d;
            d += row.getHeight();
        }
        this.m5 = d;
        this.n7 = true;
        this.s8 = true;
    }

    final boolean n7(int n, boolean bl) {
        Cell cell;
        if (n < 1 || n == this.size()) {
            return false;
        }
        int n10 = this.m2.size();
        Row row = this.n7(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.n7(i);
            if (cell.g4()) {
                cell = cell.s8();
            }
            if ((n11 = cell.getFirstRowIndex()) >= n) continue;
            if (bl) {
                return true;
            }
            cell.m5(n - n11);
        }
        return false;
    }

    final boolean m5(int n, boolean bl) {
        Cell cell;
        if (n == this.size()) {
            return false;
        }
        int n10 = this.m2.size();
        Row row = this.n7(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.n7(i);
            if (cell.g4() && (n11 = (cell = cell.s8()).getFirstRowIndex()) < n) {
                if (bl) {
                    return true;
                }
                cell = cell.m5(n - n11);
            }
            if (cell.getRowSpan() <= 1) continue;
            if (bl) {
                return true;
            }
            cell.m5(1);
        }
        return false;
    }

    @Override
    public final IGenericEnumerator<IRow> iterator() {
        return this.n8.iterator();
    }

    @Override
    public final IGenericEnumerator<IRow> iteratorJava() {
        return this.n8.iteratorJava();
    }

    @Override
    public final void copyTo(n8 array, int index) {
        this.n8.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

