/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IFindResultCallback;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.ITextSearchOptions;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Presentation;
import com.aspose.slides.Row;
import com.aspose.slides.TextFrame;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.i5l;
import com.aspose.slides.internal.n7y.u8;
import com.aspose.slides.internal.v4a.m2;
import com.aspose.slides.internal.z4u.g4;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.m9;
import com.aspose.slides.n1o;
import com.aspose.slides.v1d;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.n7(slide.getShapes(), altText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IShape[] findShapesByPlaceholderType(IBaseSlide slide, byte placeholderType) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = slide.getShapes().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IShape iShape = (IShape)iGenericEnumerator.next();
                if (iShape.getPlaceholder() == null || iShape.getPlaceholder().getType() != placeholderType) continue;
                list.addItem(iShape);
            }
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list.toArray(new IShape[0]);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.n7(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.n7(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.n7(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.n7(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (m9.n7(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (m9.s8(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.n7(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void n7(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.n7(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void n7(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (m9.s8(string, string2)) {
            return;
        }
        v1d v1d2 = v1d.n7(iParagraph);
        while (v1d2.n7(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        v1d2.m5(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.n7(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getTextBoxesContainsText(IBaseSlide slide, String text, boolean checkPlaceholderText) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.n7(slide.getShapes(), list, true, checkPlaceholderText, text);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (withMasters) {
            for (n = 0; n < pres.getMasters().size(); ++n) {
                SlideUtil.n7(pres.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            SlideUtil.n7(pres.getSlides().get_Item(n).getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] n7(IPresentation iPresentation, int[] nArray, boolean bl) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.n7(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl) continue;
            SlideUtil.n7(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.n7(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> List<T> n7(Class<T> clazz, IPresentation iPresentation) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = iPresentation.getSlides().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ISlide iSlide = (ISlide)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator2 = iSlide.getShapes().iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        IShape iShape = (IShape)iGenericEnumerator2.next();
                        if (!m2.m5((Object)iShape, clazz)) continue;
                        list.addItem(iShape);
                    }
                }
                finally {
                    if (m2.n7(iGenericEnumerator2, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return list;
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    static String n7(IPresentation iPresentation, int[] nArray) {
        u8 u82 = new u8();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                u82.n7(iTextFrame.getText());
            }
        }
        return u82.toString();
    }

    private static void n7(int n, boolean bl, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        n1o.n7(n, bl, list2);
    }

    private static IShape n7(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (m9.t8(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!m2.m5((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.n7(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    private static void n7(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        SlideUtil.n7(iShapeCollection, list, false);
    }

    private static void n7(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl) {
        SlideUtil.n7(iShapeCollection, list, bl, false);
    }

    private static void n7(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl, boolean bl2) {
        SlideUtil.n7(iShapeCollection, list, bl, bl2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void n7(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl, boolean bl2, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            IShape iShape;
            ISlideComponent iSlideComponent;
            if (m2.m5((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.n7(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)m2.n7(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null || bl && !m9.o1(iSlideComponent.getText(), string) && (!iSlideComponent.getText().isEmpty() || !bl2 || (iShape = (IAutoShape)((Object)m2.n7(iAutoShape.getBasePlaceholder(), IAutoShape.class))) == null || iShape.getTextFrame() == null || !m9.o1(iShape.getTextFrame().getText(), string))) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)m2.n7(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).n7(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            iShape = (IChart)((Object)m2.n7(iShapeCollection.get_Item(i), IChart.class));
            if (iShape != null && iShape.getUserShapes() != null) {
                SlideUtil.n7(iShape.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)m2.n7(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    private static i5l n7(Presentation presentation, String string, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        if (m9.n7(string)) {
            throw new ArgumentException("Text to highlight can not be null or empty", "text");
        }
        int n = 0;
        if (iTextSearchOptions != null && !iTextSearchOptions.getCaseSensitive()) {
            n |= 0x42;
        }
        com.aspose.slides.internal.t6l.g4 g42 = new com.aspose.slides.internal.t6l.g4("\\-\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\,\\\\\\^\\$\\|#\\s");
        String string2 = g42.m2(string, "\\$0");
        if (iTextSearchOptions != null && iTextSearchOptions.getWholeWordsOnly()) {
            string2 = m9.n7(new String[]{"\\b", string2, "\\b"});
        }
        com.aspose.slides.internal.t6l.g4 g43 = new com.aspose.slides.internal.t6l.g4(string2, n);
        return SlideUtil.m5(presentation, g43, iFindResultCallback);
    }

    private static i5l n7(Presentation presentation, com.aspose.slides.internal.t6l.g4 g42, IFindResultCallback iFindResultCallback) {
        if (g42 == null) {
            throw new ArgumentException("Regex to highlight can not be null", "regex");
        }
        return SlideUtil.m5(presentation, g42, iFindResultCallback);
    }

    private static i5l m5(Presentation presentation, com.aspose.slides.internal.t6l.g4 g42, IFindResultCallback iFindResultCallback) {
        i5l i5l2 = new i5l(g42);
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, false)) {
            TextFrame textFrame = (TextFrame)iTextFrame;
            textFrame.n7(g42, iFindResultCallback);
            if (textFrame.m2.s8() <= 0) continue;
            i5l2.n7(textFrame);
        }
        return i5l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void n7(Presentation presentation, String string, g4 g42, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        i5l i5l2 = SlideUtil.n7(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = i5l2.m5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.n7(i5l2.n7(), g42.c2());
            }
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void n7(Presentation presentation, com.aspose.slides.internal.t6l.g4 g42, g4 g43, IFindResultCallback iFindResultCallback) {
        i5l i5l2 = SlideUtil.n7(presentation, g42, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = i5l2.m5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.n7(i5l2.n7(), g43.c2());
            }
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void n7(Presentation presentation, String string, String string2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        i5l i5l2 = SlideUtil.n7(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = i5l2.m5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.n7(i5l2.n7(), string2);
            }
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void n7(Presentation presentation, com.aspose.slides.internal.t6l.g4 g42, String string, IFindResultCallback iFindResultCallback) {
        i5l i5l2 = SlideUtil.n7(presentation, g42, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = i5l2.m5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.n7(i5l2.n7(), string);
            }
        }
        finally {
            if (m2.n7(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

