/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.q0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.u8;
import com.aspose.slides.ms.System.z4;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@q2
public class ArrayList
implements IList,
List {
    private Object[] u4;
    private int p5;
    private int w1;
    private static Object[] z4 = new Object[0];

    protected int getVersion() {
        return this.w1;
    }

    public ArrayList() {
        this.u4 = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.u4 = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.u4("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.u4 = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.u4 = null;
    }

    private ArrayList(z4 array, int index, int count) {
        this.u4 = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.z4.u4(array, index, com.aspose.slides.ms.System.z4.u4(this.u4), 0, count);
        this.p5 = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.p5) {
            ArrayList.u4("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.u4[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.p5) {
            ArrayList.u4("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.u4[index] = value;
        ++this.w1;
    }

    @Override
    public int size() {
        return this.p5;
    }

    public int getCapacity() {
        return this.u4.length;
    }

    public void setCapacity(int value) {
        if (value < this.p5) {
            ArrayList.u4("Capacity", (Object)value, "Must be more than count.");
        }
        this.u4 = value > 0 ? Arrays.copyOf(this.u4, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void u4(int n) {
        int n10;
        if (n <= this.u4.length) {
            return;
        }
        int n11 = n10 = this.u4.length == 0 ? 4 : this.u4.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void u4(int n, int n10) {
        if (n10 > 0) {
            if (this.p5 + n10 > this.u4.length) {
                int n11;
                int n12 = n11 = this.u4.length > 0 ? this.u4.length << 1 : 1;
                while (n11 < this.p5 + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.z4.u4(this.u4, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.z4.u4(this.u4, n, objectArray, n + n10, this.p5 - n);
                this.u4 = objectArray;
            } else {
                com.aspose.slides.ms.System.z4.u4(this.u4, n, this.u4, n + n10, this.p5 - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.z4.u4(this.u4, n13, this.u4, n, this.p5 - n13);
            com.aspose.slides.ms.System.z4.u4(this.u4, this.p5 + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.u4.length <= this.p5) {
            this.u4(this.p5 + 1);
        }
        this.u4[this.p5] = value;
        ++this.w1;
        return this.p5++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.z4.u4(this.u4, 0, this.p5);
        this.p5 = 0;
        ++this.w1;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.p5) > -1;
    }

    boolean u4(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.p5 - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.p5) {
            ArrayList.u4("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.u4("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.p5 - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.z4.u4(this.u4, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.p5 - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return b5.u4(this.u4, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.p5) {
            ArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.u4(index, 1);
        this.u4[index] = value;
        ++this.p5;
        ++this.w1;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.p5) {
            ArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.u4.length < this.p5 + n) {
                this.u4(this.p5 + n);
            }
            if (index < this.p5) {
                com.aspose.slides.ms.System.z4.u4(this.u4, index, this.u4, index + n, this.p5 - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.z4.u4(this.u4, 0, this.u4, index, index);
                com.aspose.slides.ms.System.z4.u4(this.u4, index + n, this.u4, index << 1, this.p5 - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.z4.u4(this.u4), index);
            }
            this.p5 += c.size();
            ++this.w1;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.p5) {
            ArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.u4.length < this.p5 + n) {
                this.u4(this.p5 + n);
            }
            if (index < this.p5) {
                com.aspose.slides.ms.System.z4.u4(this.u4, index, this.u4, index + n, this.p5 - index);
            }
            com.aspose.slides.ms.System.z4.u4(c).copyTo(com.aspose.slides.ms.System.z4.u4(this.u4), index);
            this.p5 += c.length;
            ++this.w1;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.w1;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.p5) {
            ArrayList.u4("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.u4(index, -1);
        --this.p5;
        ++this.w1;
    }

    public void removeRange(int index, int count) {
        ArrayList.u4(index, count, this.p5);
        this.u4(index, -count);
        this.p5 -= count;
        ++this.w1;
    }

    public void reverse() {
        b5.u4(this.u4, 0, this.p5);
        ++this.w1;
    }

    public void reverse(int index, int count) {
        ArrayList.u4(index, count, this.p5);
        b5.u4(this.u4, index, count);
        ++this.w1;
    }

    public void copyTo(z4 array) {
        com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4), 0, array, 0, this.p5);
    }

    @Override
    public void copyTo(z4 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.p5);
    }

    public void copyTo(int index, z4 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.z4() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.u4(index, count, this.p5);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.p5, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.p5, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return b5.u4(this.u4, 0, this.p5, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return b5.u4(this.u4, 0, this.p5, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return b5.u4(this.u4, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.u4(index, count, this.p5);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.p5) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.z4.u4(this.u4), index);
        ++this.w1;
    }

    public void trimToSize() {
        this.setCapacity(this.p5);
    }

    public void sort() {
        Arrays.sort(this.u4, 0, this.p5, Comparer.Default);
        ++this.w1;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.u4, 0, this.p5, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.u4(index, count, this.p5);
        Arrays.sort(this.u4, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.p5];
        this.copyTo(com.aspose.slides.ms.System.z4.u4(objectArray));
        return objectArray;
    }

    public z4 toArray(u8 type) {
        z4 z42 = com.aspose.slides.ms.System.z4.u4(type, this.p5);
        this.copyTo(z42);
        return z42;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.z4.u4(this.u4), 0, this.p5);
    }

    static void u4(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.u4("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.u4("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void u4(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.z4.u4(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.p5, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List u4;
        private int p5;

        @Override
        protected int getVersion() {
            return this.u4 instanceof ArrayList ? ((ArrayList)this.u4).getVersion() : this.p5;
        }

        public ArrayListInternalized(List internal) {
            this.u4 = internal;
            if (internal instanceof ArrayList) {
                this.p5 = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.u4.set(index, value);
            ++this.p5;
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.u4.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.u4.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.u4.size(); ++i) {
                this.u4.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.u4.size();
            this.u4.add(value);
            ++this.p5;
            return n;
        }

        @Override
        public void clear() {
            this.u4.clear();
            ++this.p5;
        }

        @Override
        public boolean contains(Object item) {
            return this.u4.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.u4.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.u4.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.u4.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.u4.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.u4.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return b5.u4(this.u4.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.u4.add(index, value);
            ++this.p5;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.u4.add(index++, e);
            }
            ++this.p5;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.u4.add(index++, object);
            }
            ++this.p5;
        }

        @Override
        public void removeItem(Object obj) {
            this.u4.remove(obj);
            ++this.p5;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.u4.remove(index);
            ++this.p5;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.u4.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.u4.remove(index);
            }
            ++this.p5;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.u4.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.u4.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.u4.size() - 1; n < i; ++n, --i) {
                Object e = this.u4.get(n);
                this.u4.set(n, this.u4.get(i));
                this.u4.set(i, e);
            }
            ++this.p5;
        }

        @Override
        public void copyTo(z4 array) {
            com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4.toArray()), 0, array, 0, this.u4.size());
        }

        @Override
        public void copyTo(z4 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.u4.size());
        }

        @Override
        public void copyTo(int index, z4 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.z4() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.u4(index, count, this.u4.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.u4.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return b5.u4(this.u4.toArray(), 0, this.u4.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return b5.u4(this.u4.toArray(), 0, this.u4.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return b5.u4(this.u4.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.u4(index, count, this.u4.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.u4.set(index++, e);
            }
            ++this.p5;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.u4, null);
            ++this.p5;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.u4, comparer);
            ++this.p5;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.u4.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.u4.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.u4.set(i, list.get(i - index));
            }
            ++this.p5;
        }

        @Override
        public Object[] toArray() {
            return this.u4.toArray();
        }

        @Override
        public z4 toArray(u8 type) {
            z4 z42 = com.aspose.slides.ms.System.z4.u4(type, this.u4.size());
            this.copyTo(z42);
            return z42;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.u4.size()];
            com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), 0, objectArray, 0, this.u4.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.u4.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.u4.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.p5;
            return this.u4.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.p5;
            return this.u4.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.u4.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.p5;
            return this.u4.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.p5;
            return this.u4.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.p5;
            return this.u4.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.p5;
            return this.u4.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.u4.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.p5;
            return this.u4.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.u4.add(index, element);
            ++this.p5;
        }

        @Override
        public Object remove(int index) {
            ++this.p5;
            return this.u4.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.u4.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.u4.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.u4.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.u4 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.u4 != 0;
        }

        @Override
        public int nextIndex() {
            return this.u4;
        }

        @Override
        public int previousIndex() {
            return this.u4 - 1;
        }

        public Object previous() {
            int n = this.u4 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.u4;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.u4 = n;
            this.p5 = n;
            return objectArray[this.p5];
        }

        public void set(Object e) {
            if (this.p5 < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).u4[this.p5] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.u4;
                ArrayList.this.add(n, e);
                this.u4 = n + 1;
                this.p5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int u4;
        int p5 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.u4 != ArrayList.this.size();
        }

        public Object next() {
            int n = this.u4;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.u4;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.u4 = n + 1;
            this.p5 = n;
            return objectArray[this.p5];
        }

        @Override
        public void remove() {
            if (this.p5 < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.p5);
                this.u4 = this.p5;
                this.p5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @q2
    private static class ListWrapper
    implements IList {
        protected IList u4;

        public ListWrapper(IList innerList) {
            this.u4 = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.u4.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.u4.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.u4.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.u4.addItem(value);
        }

        @Override
        public void clear() {
            this.u4.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.u4.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.u4.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.u4.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.u4.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.u4.removeAt(index);
        }

        @Override
        public void copyTo(z4 array, int index) {
            this.u4.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.u4.iterator();
        }
    }

    @q2
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String u4() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.u4());
        }
    }

    @q2
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String u4() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.u4());
        }
    }

    @q2
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object p5;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.p5 = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.p5;
            synchronized (object) {
                this.u4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array, int index) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.iterator();
            }
        }
    }

    @q2
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int p5;
        private int w1;
        private int z4;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.p5 = index;
            this.w1 = count;
            this.z4 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.w1) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.u4.get_Item(this.p5 + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.w1) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.u4.set_Item(this.p5 + index, value);
        }

        @Override
        public int size() {
            this.u4();
            return this.w1;
        }

        @Override
        public int getCapacity() {
            return this.u4.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.w1) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void u4() {
            if (this.z4 != this.u4.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.u4();
            this.u4.insertItem(this.p5 + this.w1, value);
            this.z4 = this.u4.getVersion();
            return ++this.w1;
        }

        @Override
        public void clear() {
            this.u4();
            this.u4.removeRange(this.p5, this.w1);
            this.w1 = 0;
            this.z4 = this.u4.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.u4.u4(value, this.p5, this.w1);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.w1 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.w1) {
                RangedArrayList.u4("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.u4("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.w1 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.u4.indexOf(value, this.p5 + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.p5;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.w1 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.u4("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.u4("count", (Object)count, "count is negative.");
            }
            if ((n = this.u4.lastIndexOf(value, this.p5 + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.p5;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.u4();
            if (index < 0 || index > this.w1) {
                RangedArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.u4.insertItem(this.p5 + index, value);
            ++this.w1;
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.u4();
            if (index < 0 || index > this.w1) {
                RangedArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.u4.insertRange(this.p5 + index, c);
            this.w1 += c.size();
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.u4();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.u4();
            if (index < 0 || index > this.w1) {
                RangedArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.u4.removeAt(this.p5 + index);
            --this.w1;
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.u4();
            RangedArrayList.u4(index, count, this.w1);
            this.u4.removeRange(this.p5 + index, count);
            this.w1 -= count;
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.w1);
        }

        @Override
        public void reverse(int index, int count) {
            this.u4();
            RangedArrayList.u4(index, count, this.w1);
            this.u4.reverse(this.p5 + index, count);
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.u4();
            if (index < 0 || index > this.w1) {
                RangedArrayList.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.u4.setRange(this.p5 + index, c);
            this.z4 = this.u4.getVersion();
        }

        @Override
        public void copyTo(z4 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(z4 array, int index) {
            this.copyTo(0, array, index, this.w1);
        }

        @Override
        public void copyTo(int index, z4 array, int arrayIndex, int count) {
            RangedArrayList.u4(index, count, this.w1);
            this.u4.copyTo(this.p5 + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.w1);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.u4(index, count, this.w1);
            return this.u4.iterator(this.p5 + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.u4();
            this.u4.insertRange(this.w1, c);
            this.w1 += c.size();
            this.z4 = this.u4.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.w1, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.w1, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.u4(index, count, this.w1);
            return this.u4.binarySearch(this.p5 + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.u4.deepClone(), this.p5, this.w1);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.u4(index, count, this.w1);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.w1, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.u4();
            RangedArrayList.u4(index, count, this.w1);
            this.u4.sort(this.p5 + index, count, comparer);
            this.z4 = this.u4.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.w1];
            this.u4.copyTo(this.p5, com.aspose.slides.ms.System.z4.u4(objectArray), 0, this.w1);
            return objectArray;
        }

        @Override
        public z4 toArray(u8 elementType) {
            z4 z42 = com.aspose.slides.ms.System.z4.u4(elementType, this.w1);
            this.u4.copyTo(this.p5, z42, 0, this.w1);
            return z42;
        }
    }

    @q2
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String u4() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.u4());
        }
    }

    @q2
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String u4() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.u4());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.u4());
        }
    }

    @q2
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object p5;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.p5 = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.p5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.p5;
            synchronized (object) {
                this.u4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.p5;
            synchronized (object) {
                this.u4.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array, int index) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, z4 array, int arrayIndex, int count) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.p5;
            synchronized (object) {
                this.u4.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.p5;
            synchronized (object) {
                this.u4.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.p5;
            synchronized (object) {
                this.u4.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public z4 toArray(u8 elementType) {
            Object object = this.p5;
            synchronized (object) {
                return this.u4.toArray(elementType);
            }
        }
    }

    @q2
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList u4;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.u4 = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.u4.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public int getCapacity() {
            return this.u4.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.u4.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.u4.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.u4.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.u4.addItem(value);
        }

        @Override
        public void clear() {
            this.u4.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.u4.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.u4.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.u4.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.u4.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.u4.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.u4.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.u4.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.u4.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.u4.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.u4.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.u4.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.u4.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.u4.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.u4.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.u4.setRange(index, c);
        }

        @Override
        public void copyTo(z4 array) {
            this.u4.copyTo(array);
        }

        @Override
        public void copyTo(z4 array, int index) {
            this.u4.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, z4 array, int arrayIndex, int count) {
            this.u4.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.u4.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.u4.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.u4.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.u4.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.u4.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.u4.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.u4.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.u4.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.u4.trimToSize();
        }

        @Override
        public void sort() {
            this.u4.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.u4.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.u4.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.u4.toArray();
        }

        @Override
        public z4 toArray(u8 elementType) {
            return this.u4.toArray(elementType);
        }
    }

    @q2
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList u4;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.u4 = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.u4.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public int getCapacity() {
            return this.u4.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.u4.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.u4.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.u4.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.u4.addItem(value);
        }

        @Override
        public void clear() {
            this.u4.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.u4.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.u4.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.u4.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.u4.size()) {
                ArrayListAdapter.u4("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.u4("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.u4.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.u4.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.u4.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.u4.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.u4("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.u4("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.u4("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.u4.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.u4.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.u4.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.u4.size()) {
                ArrayListAdapter.u4("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.u4.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.u4.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.u4.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.u4(index, count, this.u4.size());
            for (int i = 0; i < count; ++i) {
                this.u4.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.u4.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.u4(index, count, this.u4.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.u4.get_Item(i + index);
                this.u4.set_Item(i + index, this.u4.get_Item(index + count - i + index - 1));
                this.u4.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.u4.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.u4.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(z4 array) {
            this.u4.copyTo(array, 0);
        }

        @Override
        public void copyTo(z4 array, int index) {
            this.u4.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, z4 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.u4("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.u4("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.u4("index", (Object)index, "Can't be less than zero.");
            }
            if (array.z4() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.w7() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.u4.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.w1(this.u4.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.u4.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.u4(index, count, this.u4.size());
            return new EnumeratorWithRange(this.u4.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.u4.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.u4.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.u4(index, count, this.u4.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.u4.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.u4);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.u4(index, count, this.u4.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.u4.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.u4(index, count, this.u4.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.u4(this.u4, index, index + count - 1, comparer);
        }

        private static void u4(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void u4(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.u4(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.u4(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.u4(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.u4(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.u4(iList, n12, n13);
            }
            ArrayListAdapter.u4(iList, n10 - 1, n12);
            ArrayListAdapter.u4(iList, n, n12 - 1, comparator);
            ArrayListAdapter.u4(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.u4.size()];
            this.u4.copyTo(com.aspose.slides.ms.System.z4.u4(objectArray), 0);
            return objectArray;
        }

        @Override
        public z4 toArray(u8 elementType) {
            z4 z42 = com.aspose.slides.ms.System.z4.u4(elementType, this.u4.size());
            this.u4.copyTo(z42, 0);
            return z42;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        q0,
        Cloneable {
            private int u4;
            private int p5;
            private int w1;
            private IEnumerator z4;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.p5 = 0;
                this.u4 = index;
                this.w1 = count;
                this.z4 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.u4();
            }

            @Override
            public Object next() {
                return this.z4.next();
            }

            @Override
            public boolean hasNext() {
                if (this.p5 >= this.w1) {
                    return false;
                }
                ++this.p5;
                return this.z4.hasNext();
            }

            @Override
            public void reset() {
                this.p5 = 0;
                this.z4.reset();
                for (int i = 0; i < this.u4; ++i) {
                    this.z4.hasNext();
                }
            }

            protected Object u4() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.u4 = this.u4;
                enumeratorWithRange.p5 = this.p5;
                enumeratorWithRange.w1 = this.w1;
                enumeratorWithRange.z4 = this.z4;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    q0,
    Cloneable {
        private ArrayList p5;
        private Object w1;
        private int z4;
        private int w7;
        static Object u4 = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.p5 = list;
            this.z4 = -1;
            this.w7 = list.getVersion();
            this.w1 = u4;
        }

        @Override
        public Object deepClone() {
            return this.u4();
        }

        @Override
        public boolean hasNext() {
            if (this.w7 != this.p5.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.z4 < this.p5.size()) {
                this.w1 = this.p5.get_Item(this.z4);
                return true;
            }
            this.w1 = u4;
            return false;
        }

        @Override
        public Object next() {
            if (this.w1 == u4) {
                if (this.z4 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.w1;
        }

        @Override
        public void reset() {
            if (this.w7 != this.p5.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.w1 = u4;
            this.z4 = -1;
        }

        protected Object u4() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.p5 = this.p5;
            simpleEnumerator.w1 = this.w1;
            simpleEnumerator.z4 = this.z4;
            simpleEnumerator.w7 = this.w7;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    q0,
    Cloneable {
        private Object u4;
        private ArrayList p5;
        private int w1;
        private int z4;
        private int w7;
        private int u3;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.u4();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.p5 = list;
            this.z4 = index;
            this.w7 = count;
            this.w1 = this.z4 - 1;
            this.u4 = null;
            this.u3 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.w1 == this.z4 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.u4;
        }

        @Override
        public boolean hasNext() {
            if (this.p5.getVersion() != this.u3) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.w1;
            if (this.w1 - this.z4 < this.w7) {
                this.u4 = this.p5.get_Item(this.w1);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.u4 = null;
            this.w1 = this.z4 - 1;
        }

        protected Object u4() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.u4 = this.u4;
            arrayListEnumerator.p5 = this.p5;
            arrayListEnumerator.w1 = this.w1;
            arrayListEnumerator.z4 = this.z4;
            arrayListEnumerator.w7 = this.w7;
            arrayListEnumerator.u3 = this.u3;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

