/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.q0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.z4;

@q2
public final class BitArray
implements ICollection,
q0 {
    private int[] u4;
    private int p5;
    private int w1 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.p5 = bits.p5;
        this.u4 = new int[(this.p5 + 31) / 32];
        if (this.u4.length == 1) {
            this.u4[0] = bits.u4[0];
        } else {
            z4.u4(bits.u4, 0, this.u4, 0, this.u4.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.p5 = values.length;
        this.u4 = new int[(this.p5 + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.p5 = bytes.length * 8;
        this.u4 = new int[(this.p5 + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.u4(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.p5 = n * 32;
        this.u4 = new int[n];
        z4.u4(values, 0, this.u4, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.p5 = length;
        this.u4 = new int[(this.p5 + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.u4.length; ++i) {
                this.u4[i] = -1;
            }
        }
    }

    private byte u4(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.u4[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void u4(int n, byte by) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.u4[n12] = this.u4[n12] & ~(255 << n11);
        int n13 = n10;
        this.u4[n13] = this.u4[n13] | (by & 0xFF) << n11;
        ++this.w1;
    }

    private void p5(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.p5 != this.p5) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.p5;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.p5;
    }

    public void setLength(int value) {
        if (this.p5 == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.p5) {
            int n = (value + 31) / 32;
            int n10 = (this.p5 + 31) / 32;
            if (n > this.u4.length) {
                int[] nArray = new int[n];
                z4.u4(this.u4, 0, nArray, 0, this.u4.length);
                this.u4 = nArray;
            } else {
                z4.u4(z4.u4((Object)this.u4), n10, n - n10);
            }
            int n11 = this.p5 % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.u4[n12] = this.u4[n12] & (1 << n11) - 1;
            }
        }
        this.p5 = value;
        ++this.w1;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(z4 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.z4() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.w7() && this.p5 > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = z4.u4(array);
        if (object instanceof Boolean[]) {
            if (array.w7() - index < this.p5) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.p5; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.w7() - index < this.p5) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.p5; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.p5 + 7) / 8;
            if (array.w7() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.u4(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.p5 + 7) / 8;
            if (array.w7() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.u4(i);
            }
        } else if (object instanceof Integer[]) {
            z4.u4(z4.u4((Object)this.u4), 0, array, index, (this.p5 + 31) / 32);
        } else if (object instanceof int[]) {
            z4.u4(z4.u4((Object)this.u4), 0, array, index, (this.p5 + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.p5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.u4[i] = ~this.u4[i];
        }
        ++this.w1;
        return this;
    }

    public BitArray and(BitArray value) {
        this.p5(value);
        int n = (this.p5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.u4[n10] = this.u4[n10] & value.u4[i];
        }
        ++this.w1;
        return this;
    }

    public BitArray or(BitArray value) {
        this.p5(value);
        int n = (this.p5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.u4[n10] = this.u4[n10] | value.u4[i];
        }
        ++this.w1;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.p5(value);
        int n = (this.p5 + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.u4[n10] = this.u4[n10] ^ value.u4[i];
        }
        ++this.w1;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.p5) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.u4[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.p5) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.u4[n] = this.u4[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.u4[n] = this.u4[n] & ~(1 << (index & 0x1F));
        }
        ++this.w1;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.u4.length; ++i) {
                this.u4[i] = -1;
            }
        } else {
            z4.u4(z4.u4((Object)this.u4), 0, this.u4.length);
        }
        ++this.w1;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @q2
    private static class BitArrayEnumerator
    implements IEnumerator,
    q0,
    Cloneable {
        private BitArray u4;
        private boolean p5;
        private int w1;
        private int z4;

        @Override
        public Object deepClone() {
            return this.u4();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba) {
            this.w1 = -1;
            this.u4 = ba;
            this.z4 = ba.w1;
        }

        @Override
        public Object next() {
            if (this.w1 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.w1 >= this.u4.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.p5;
        }

        @Override
        public boolean hasNext() {
            this.p5();
            if (this.w1 < this.u4.size() - 1) {
                this.p5 = this.u4.get_Item(++this.w1);
                return true;
            }
            this.w1 = this.u4.size();
            return false;
        }

        @Override
        public void reset() {
            this.p5();
            this.w1 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void p5() {
            if (this.z4 != this.u4.w1) {
                throw new InvalidOperationException();
            }
        }

        protected Object u4() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.u4 = this.u4;
            bitArrayEnumerator.p5 = this.p5;
            bitArrayEnumerator.w1 = this.w1;
            bitArrayEnumerator.z4 = this.z4;
            return bitArrayEnumerator;
        }
    }
}

