/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.h2d.g2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.i8;
import com.aspose.slides.ms.System.l0;
import com.aspose.slides.ms.System.n0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.u4;
import com.aspose.slides.ms.System.y7;
import com.aspose.slides.ms.System.z4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@q2
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] u4;
    private int p5;
    private int w1;
    private final Object z4 = new Object();
    static Object[] u3 = new Object[0];

    public List() {
        this.u4 = u3;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.u4 = u3;
        this.u4(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.u4 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.u4 = data;
        this.p5 = size;
    }

    protected int getVersion() {
        return this.w1;
    }

    @Override
    public void addItem(T item) {
        if (this.p5 == this.u4.length) {
            this.u4(1);
        }
        this.u4[this.p5++] = item;
        ++this.w1;
    }

    private void u4(int n) {
        int n10 = this.p5 + n;
        if (n10 > this.u4.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void u4(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.p5 & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void u4(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.u4(new List<T>(collection));
        ++this.w1;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.w1;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return b5.u4(this.u4, 0, this.p5, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return b5.u4(this.u4, 0, this.p5, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.u4(index, count);
        return b5.u4(this.u4, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.z4.u4(this.u4, 0, this.u4.length);
        this.p5 = 0;
        ++this.w1;
    }

    public <TOutput> List<TOutput> convertAll(i8<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.p5);
        for (int i = 0; i < this.p5; ++i) {
            list.u4[i] = converter.u4(this.u4[i]);
        }
        list.p5 = this.p5;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.z4.u4(this.u4, 0, array, 0, this.p5);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.z4.u4(this.u4, 0, array, arrayIndex, this.p5);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.u4(index, count);
        com.aspose.slides.ms.System.z4.u4(this.u4, index, array, arrayIndex, count);
    }

    public boolean exists(y7<T> match) {
        List.u4(match);
        return this.u4(0, this.p5, match) != -1;
    }

    public T find(y7<T> match) {
        List.u4(match);
        int n = this.u4(0, this.p5, match);
        return (T)(n != -1 ? this.u4[n] : null);
    }

    static <T> void u4(y7<T> y72) {
        if (y72 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(y7<T> match) {
        List.u4(match);
        return this.p5(match);
    }

    private List<T> p5(y7<T> y72) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.p5; ++i) {
            if (!y72.invoke(this.u4[i])) continue;
            list.addItem(this.u4[i]);
        }
        return list;
    }

    public int findIndex(y7<T> match) {
        List.u4(match);
        return this.u4(0, this.p5, match);
    }

    public int findIndex(int startIndex, y7<T> match) {
        List.u4(match);
        this.p5(startIndex);
        return this.u4(startIndex, this.p5 - startIndex, match);
    }

    public int findIndex(int startIndex, int count, y7<T> match) {
        List.u4(match);
        this.u4(startIndex, count);
        return this.u4(startIndex, count, match);
    }

    private int u4(int n, int n10, y7<T> y72) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!y72.invoke(this.u4[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(y7<T> match) {
        List.u4(match);
        int n = this.p5(0, this.p5, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(y7<T> match) {
        List.u4(match);
        return this.p5(0, this.p5, match);
    }

    public int findLastIndex(int startIndex, y7<T> match) {
        List.u4(match);
        this.p5(startIndex);
        return this.p5(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, y7<T> match) {
        List.u4(match);
        int n = startIndex - count + 1;
        this.u4(n, count);
        return this.p5(n, count, match);
    }

    private int p5(int n, int n10, y7<T> y72) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!y72.invoke(this.u4[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(u4<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.p5; ++i) {
            action.invoke(this.u4[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.u4(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.z4.u4(this.u4, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.z4.u4(this.u4, item, 0, this.p5);
    }

    public int indexOf(T item, int index) {
        this.p5(index);
        return com.aspose.slides.ms.System.z4.u4(this.u4, item, index, this.p5 - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.p5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.z4.u4(this.u4, item, index, count);
    }

    private void p5(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.p5) {
            com.aspose.slides.ms.System.z4.u4(this.u4, n, this.u4, n + n10, this.p5 - n);
        }
        this.p5 += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.z4.u4(this.u4, this.p5, -n10);
        }
    }

    private void p5(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.p5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.p5(index);
        if (this.p5 == this.u4.length) {
            this.u4(1);
        }
        this.p5(index, 1);
        this.u4[index] = item;
        ++this.w1;
    }

    void w1(int n) {
        Object[] objectArray = new Object[this.p5];
        this.copyToTArray(objectArray, 0);
        this.u4(this.p5);
        this.p5(n, objectArray.length);
        com.aspose.slides.ms.System.z4.u4(objectArray, 0, this.u4, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.p5(index);
        if (collection == this) {
            this.w1(index);
        } else {
            this.u4(index, collection);
        }
        ++this.w1;
    }

    private void u4(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.p5 == 0) {
            return -1;
        }
        return b5.u4(this.u4, item, this.p5 - 1, this.p5);
    }

    public int lastIndexOf(T item, int index) {
        this.p5(index);
        return b5.u4(this.u4, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return b5.u4(this.u4, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(y7<T> match) {
        List.u4(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.p5 && !match.invoke(this.u4[n]); ++n) {
        }
        if (n == this.p5) {
            return 0;
        }
        ++this.w1;
        for (n10 = n + 1; n10 < this.p5; ++n10) {
            if (match.invoke(this.u4[n10])) continue;
            this.u4[n++] = this.u4[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.z4.u4(this.u4, n, n10 - n);
        }
        this.p5 = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.p5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.p5(index, -1);
        com.aspose.slides.ms.System.z4.u4(this.u4, this.p5, 1);
        ++this.w1;
    }

    public void removeRange(int index, int count) {
        this.u4(index, count);
        if (count > 0) {
            this.p5(index, -count);
            com.aspose.slides.ms.System.z4.u4(this.u4, this.p5, count);
            ++this.w1;
        }
    }

    public void reverse() {
        b5.u4(this.u4, 0, this.p5);
        ++this.w1;
    }

    public void reverse(int index, int count) {
        this.u4(index, count);
        b5.u4(this.u4, index, count);
        ++this.w1;
    }

    public void sort() {
        Arrays.sort(this.u4, 0, this.p5);
        ++this.w1;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.u4, 0, this.p5, comparer);
        ++this.w1;
    }

    @Override
    public void sort(n0<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.u4, 0, this.p5, new b5.u4<T>(comparison));
        ++this.w1;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.u4(index, count);
        Arrays.sort(this.u4, index, index + count, comparer);
        ++this.w1;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.p5) {
            return Arrays.copyOf(this.u4, this.p5, a.getClass());
        }
        System.arraycopy(this.u4, 0, a, 0, this.p5);
        if (a.length > this.p5) {
            a[this.p5] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.p5);
    }

    public boolean trueForAll(y7<T> match) {
        List.u4(match);
        for (int i = 0; i < this.p5; ++i) {
            if (match.invoke(this.u4[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.u4.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.p5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.u4 = Arrays.copyOf(this.u4, value);
    }

    @Override
    public int size() {
        return this.p5;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.p5 & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.u4[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.p5(index);
        if ((long)index == (long)this.p5) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.u4[index] = value;
        ++this.w1;
    }

    public void copyTo(z4 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.z4() > 1 || array.p5(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4), 0, array, arrayIndex, this.p5);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.z4;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.p5 == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.p5; ++i) {
                if (this.u4[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.p5; ++i) {
            if (!this.u4[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.p5; ++i) {
                if (this.u4[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.p5; ++i) {
            if (!this.u4[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.p5];
        System.arraycopy(this.u4, 0, objectArray, 0, this.p5);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.p5;
        this.addItem(t);
        return n != this.p5;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.p5;
        this.removeItem(o);
        return n != this.p5;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.p5; ++i) {
                if (this.u4[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.p5; ++i) {
            if (!o.equals(this.u4[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> u4;
        private int p5;

        public ListInternalized() {
            this.u4 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.u4 = list;
        }

        @Override
        protected int getVersion() {
            return this.p5;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.u4(collection);
            ++this.p5;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.p5;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return b5.u4(this.u4.toArray(), 0, this.u4.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return b5.u4(this.u4.toArray(), 0, this.u4.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.u4(index, count);
            return b5.u4(this.u4.toArray(), index, count, item, comparer);
        }

        @Override
        private void u4(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.u4.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(i8<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.u4.size());
            for (int i = 0; i < this.u4.size(); ++i) {
                list.u4[i] = converter.u4(this.get_Item(i));
            }
            list.p5 = this.u4.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), 0, array, 0, this.u4.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), 0, array, arrayIndex, this.u4.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.u4(index, count);
            com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(y7<T> match) {
            ListInternalized.p5(match);
            return this.u4(0, this.u4.size(), match) != -1;
        }

        @Override
        private int u4(int n, int n10, y7<T> y72) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!y72.invoke(this.u4.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void p5(y7<T> y72) {
            if (y72 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(y7<T> match) {
            ListInternalized.p5(match);
            int n = this.u4(0, this.u4.size(), match);
            return n != -1 ? (T)this.u4.get(n) : null;
        }

        @Override
        public List<T> findAll(y7<T> match) {
            ListInternalized.p5(match);
            return this.w1(match);
        }

        private List<T> w1(y7<T> y72) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!y72.invoke(this.u4.get(i))) continue;
                list.addItem(this.u4.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(y7<T> match) {
            ListInternalized.p5(match);
            return this.u4(0, this.u4.size(), match);
        }

        @Override
        public int findIndex(int startIndex, y7<T> match) {
            ListInternalized.p5(match);
            this.u4(startIndex);
            return this.u4(startIndex, this.u4.size() - startIndex, match);
        }

        @Override
        private void u4(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.u4.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, y7<T> match) {
            ListInternalized.p5(match);
            this.u4(startIndex, count);
            return this.u4(startIndex, count, match);
        }

        @Override
        public T findLast(y7<T> match) {
            ListInternalized.p5(match);
            int n = this.p5(0, this.u4.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int p5(int n, int n10, y7<T> y72) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!y72.invoke(this.u4.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(y7<T> match) {
            ListInternalized.p5(match);
            return this.p5(0, this.u4.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, y7<T> match) {
            ListInternalized.p5(match);
            this.u4(startIndex);
            return this.p5(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, y7<T> match) {
            ListInternalized.p5(match);
            int n = startIndex - count + 1;
            this.u4(n, count);
            return this.p5(n, count, match);
        }

        @Override
        public void forEach(u4<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.u4.size(); ++i) {
                action.invoke(this.u4.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.u4(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.u4.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.u4(index);
            return com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), item, index, this.u4.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.u4.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.z4.u4(this.u4.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.u4.size() == 0) {
                return -1;
            }
            return b5.u4(this.u4.toArray(), item, this.u4.size() - 1, this.u4.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.u4(index);
            return b5.u4(this.u4.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return b5.u4(this.u4.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.u4.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.u4.size());
        }

        @Override
        public boolean trueForAll(y7<T> match) {
            ListInternalized.p5(match);
            for (int i = 0; i < this.u4.size(); ++i) {
                if (match.invoke(this.u4.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.u4.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.u4.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.u4.size(); ++i) {
                this.u4.add(null);
            }
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public T get_Item(int index) {
            return this.u4.get(index);
        }

        @Override
        public void copyTo(z4 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.z4() > 1 || array.p5(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4.toArray()), 0, array, arrayIndex, this.u4.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.u4.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.u4.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.u4.size(); ++i) {
                    if (this.u4.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.u4.size(); ++i) {
                if (!this.u4.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.u4.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.p5;
            return this.u4.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.p5;
            return this.u4.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.u4.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.p5;
            return this.u4.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.p5;
            return this.u4.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.p5;
            return this.u4.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.p5;
            return this.u4.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.u4.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.p5;
            return this.u4.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.p5;
            this.u4.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.p5;
            return this.u4.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.u4.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.u4.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.u4.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.u4.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.u4.add(item);
            ++this.p5;
        }

        @Override
        public void clear() {
            this.u4.clear();
            ++this.p5;
        }

        @Override
        public void insertItem(int index, T item) {
            this.u4.add(index, item);
            ++this.p5;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.u4.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.u4.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.u4.add(n++, e);
                }
            }
            ++this.p5;
        }

        @Override
        public int removeAll(y7<T> match) {
            ListInternalized.p5(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.u4.size() && !match.invoke(this.u4.get(n)); ++n) {
            }
            if (n == this.u4.size()) {
                return 0;
            }
            ++this.p5;
            for (n10 = n + 1; n10 < this.u4.size(); ++n10) {
                if (match.invoke(this.u4.get(n10))) continue;
                this.u4.set(n++, this.u4.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.u4.remove(this.u4.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.u4.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.u4.remove(index);
            ++this.p5;
        }

        @Override
        public void removeRange(int index, int count) {
            this.u4(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.u4.remove(index);
                }
                ++this.p5;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.u4(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.u4.get(n);
                this.u4.set(n, this.u4.get(i));
                this.u4.set(i, t);
            }
            ++this.p5;
        }

        @Override
        public void sort() {
            Collections.sort(this.u4, null);
            ++this.p5;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.u4, comparer);
            ++this.p5;
        }

        @Override
        public void sort(final n0<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.u4, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.u4(o12, o22);
                }
            });
            ++this.p5;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.u4(index, count);
            java.util.List<T> list = this.u4.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.u4.set(index + i, list.get(i));
            }
            ++this.p5;
        }

        @Override
        public void set_Item(int index, T value) {
            this.u4(index);
            if ((long)index == (long)this.u4.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.u4.set(index, value);
            ++this.p5;
        }

        @Override
        private void u4(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @q2
    public static class EnumeratorJava<T>
    extends g2<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> p5 = new List();
        private int w1;
        private int z4;
        private T w7;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.p5 = l;
            this.z4 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void u4() {
            if (this.z4 != this.p5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.w1 < 0 || this.w1 >= this.p5.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.z4 != this.p5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.w7 = this.p5.get_Item(this.w1++);
            return this.w7;
        }

        @Override
        public boolean hasNext() {
            if (this.z4 == this.p5.getVersion()) {
                if (this.w1 < 0) {
                    return false;
                }
                return this.w1 < this.p5.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.u4();
            this.w1 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.p5 = this.p5;
            that.w1 = this.w1;
            that.z4 = this.z4;
            that.w7 = this.w7;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean u4(EnumeratorJava enumeratorJava) {
            return l0.u4(enumeratorJava.p5, this.p5) && enumeratorJava.w1 == this.w1 && enumeratorJava.z4 == this.z4 && l0.u4(enumeratorJava.w7, this.w7);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (l0.p5(null, obj)) {
                return false;
            }
            if (l0.p5(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.u4((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.p5 != null ? this.p5.hashCode() : 0;
            n = 31 * n + this.w1;
            n = 31 * n + this.z4;
            n = 31 * n + (this.w7 != null ? this.w7.hashCode() : 0);
            return n;
        }
    }

    @q2
    public static class Enumerator<T>
    extends g2<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> p5 = new List();
        private int w1;
        private int z4;
        private T w7;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.p5 = l;
            this.z4 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void u4() {
            if (this.z4 != this.p5.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.z4 == this.p5.getVersion()) {
                if (this.w1 < 0) {
                    return false;
                }
                if (this.w1 < this.p5.size()) {
                    this.w7 = this.p5.get_Item(this.w1++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.w1 = this.p5.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.u4();
            this.w1 = 0;
        }

        @Override
        public T next() {
            if (this.w1 < 0 || this.w1 >= this.p5.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.w7;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.p5 = this.p5;
            that.w1 = this.w1;
            that.z4 = this.z4;
            that.w7 = this.w7;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean u4(Enumerator enumerator) {
            return l0.u4(enumerator.p5, this.p5) && enumerator.w1 == this.w1 && enumerator.z4 == this.z4 && l0.u4(enumerator.w7, this.w7);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (l0.p5(null, obj)) {
                return false;
            }
            if (l0.p5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.u4((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.p5 != null ? this.p5.hashCode() : 0;
            n = 31 * n + this.w1;
            n = 31 * n + this.z4;
            n = 31 * n + (this.w7 != null ? this.w7.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.u4 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.u4 != 0;
        }

        @Override
        public int nextIndex() {
            return this.u4;
        }

        @Override
        public int previousIndex() {
            return this.u4 - 1;
        }

        public T previous() {
            int n = this.u4 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.u4;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.u4 = n;
            this.p5 = n;
            return objectArray[this.p5];
        }

        public void set(T e) {
            if (this.p5 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.p5, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.u4;
                List.this.add(n, e);
                this.u4 = n + 1;
                this.p5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int u4;
        int p5 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.u4 != List.this.p5;
        }

        @Override
        public T next() {
            int n = this.u4;
            if (n >= List.this.p5) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.u4;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.u4 = n + 1;
            this.p5 = n;
            return (T)objectArray[this.p5];
        }

        @Override
        public void remove() {
            if (this.p5 < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.p5);
                this.u4 = this.p5;
                this.p5 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

