/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.h2d.g2;
import com.aspose.slides.internal.h2d.w1;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.l0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.z4;
import java.util.Arrays;

@q2
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] u4;
    private int p5;
    private int w1;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.u4 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.p5 = collection.size();
            this.u4 = new Object[this.p5];
            collection.copyToTArray(this.u4, 0);
        }
    }

    public void clear() {
        if (this.u4 != null) {
            z4.u4(this.u4, 0, this.u4.length);
        }
        this.p5 = 0;
        ++this.w1;
    }

    public boolean contains(T item) {
        return this.u4 != null && z4.u4(this.u4, item, 0, this.p5) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.p5 - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.u4 != null) {
            z4.u4(this.u4, 0, array, arrayIndex, this.p5);
            b5.u4(array, arrayIndex, this.p5);
        }
    }

    public T peek() {
        if (this.p5 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.u4[this.p5 - 1];
    }

    public T pop() {
        if (this.p5 == 0) {
            throw new InvalidOperationException();
        }
        ++this.w1;
        Object object = this.u4[--this.p5];
        this.u4[this.p5] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.u4 == null || this.p5 == this.u4.length) {
            if (this.u4 == null) {
                this.u4 = new Object[16];
            }
            this.u4 = Arrays.copyOf(this.u4, this.p5 == 0 ? 16 : 2 * this.p5);
        }
        ++this.w1;
        this.u4[this.p5++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.p5) {
            this.copyTo(z4.u4(array), 0);
            return array;
        }
        z4 z42 = z4.u4(com.aspose.slides.internal.h2d.w1.u4(array.getClass().getComponentType()), this.p5);
        this.copyTo(z42, 0);
        return (Object[])z4.u4(z42);
    }

    public void trimExcess() {
        if (this.u4 != null && (double)this.p5 < (double)this.u4.length * 0.9) {
            this.u4 = Arrays.copyOf(this.u4, this.p5);
        }
        ++this.w1;
    }

    @Override
    public int size() {
        return this.p5;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(z4 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.u4 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.p5) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.p5 - idx > dest.w7()) {
                    throw new ArgumentException("idx");
                }
                z4.u4(z4.u4(this.u4), 0, dest, idx, this.p5);
                z4.p5(dest, idx, this.p5);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @q2
    public static class Enumerator<T>
    extends g2<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> p5;
        private int w1;
        private int z4;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.p5 = t;
            this.w1 = -2;
            this.z4 = ((Stack)t).w1;
        }

        @Override
        public void dispose() {
            this.w1 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.z4 != ((Stack)this.p5).w1) {
                throw new IllegalStateException();
            }
            if (this.w1 == -2) {
                this.w1 = ((Stack)this.p5).p5;
            }
            return this.w1 != -1 && --this.w1 != -1;
        }

        @Override
        public T next() {
            if (this.w1 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.p5).u4[this.w1];
        }

        @Override
        public void reset() {
            if (this.z4 != ((Stack)this.p5).w1) {
                throw new IllegalStateException();
            }
            this.w1 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.p5 = this.p5;
            that.w1 = this.w1;
            that.z4 = this.z4;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean u4(Enumerator enumerator) {
            return l0.u4(enumerator.p5, this.p5) && enumerator.w1 == this.w1 && enumerator.z4 == this.z4;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (l0.p5(null, obj)) {
                return false;
            }
            if (l0.p5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.u4((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.p5 != null ? this.p5.hashCode() : 0;
            n = 31 * n + this.w1;
            n = 31 * n + this.z4;
            return n;
        }
    }
}

