/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.b2j.p5;
import com.aspose.slides.internal.b2j.u4;
import com.aspose.slides.internal.h2d.g2;
import com.aspose.slides.internal.h2d.u3;
import com.aspose.slides.internal.h2d.w1;
import com.aspose.slides.internal.u6i.i4;
import com.aspose.slides.internal.x6i.l4;
import com.aspose.slides.internal.x6i.m7;
import com.aspose.slides.internal.x6i.n5;
import com.aspose.slides.internal.x6i.u2;
import com.aspose.slides.ms.System.d6;
import com.aspose.slides.ms.System.l0;
import com.aspose.slides.ms.System.q0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.z4;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@q2
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
com.aspose.slides.internal.x6i.g2,
u2,
q0,
Map {
    private IGenericEqualityComparer u4;
    private final Object p5 = new Object();
    private Bucket[] w1;
    private int z4;
    private volatile boolean w7;
    private ICollection u3;
    private float g2;
    private int t1;
    private n5 i4;
    private int u2;
    private ICollection i1;
    private volatile int f3;
    private static final u3 x4 = new u3("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", d6.u4("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.g2 = 0.72f * loadFactor;
        double d = (float)capacity / this.g2;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.b2j.u4.u4((int)d) : 11;
        this.w1 = this.p5(n);
        this.t1 = (int)(this.g2 * (float)n);
        this.w7 = false;
    }

    protected Hashtable(n5 info, m7 context) {
        this.i4 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.u4 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.u4 = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.u4(key, value, true);
    }

    @Override
    public void clear() {
        if (this.z4 != 0) {
            this.w7 = true;
            for (int i = 0; i < this.w1.length; ++i) {
                this.w1[i].w1 = 0;
                this.w1[i].u4 = null;
                this.w1[i].p5 = null;
            }
            this.z4 = 0;
            this.u2 = 0;
            this.z4();
            this.w7 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.w1;
        Hashtable hashtable = new Hashtable(this.z4, this.u4);
        hashtable.f3 = this.f3;
        hashtable.g2 = this.g2;
        hashtable.z4 = 0;
        int n = this.w1.length;
        while (n > 0) {
            Object object = bucketArray[--n].u4;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].p5);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.w1;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.u4(key, this.w1.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.w1.length);
        do {
            bucketArray[n10].u4(bucket);
            if (bucket.u4 == null) {
                return false;
            }
            if ((long)(bucket.w1 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.u4, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.w1.length);
        } while (bucket.w1 < 0 && ++n < this.w1.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.w1.length;
            while (--n >= 0) {
                if (this.w1[n].u4 == null || this.w1[n].u4 == this.w1 || this.w1[n].p5 != null) continue;
                return true;
            }
        } else {
            int n = this.w1.length;
            while (--n >= 0) {
                Object object = this.w1[n].p5;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void w1(z4 z42, int n) {
        Bucket[] bucketArray = this.w1;
        int n10 = this.w1.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].u4;
            if (object == null || object == this.w1) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].p5);
            z42.w1(dictionaryEntry.Clone(), n++);
        }
    }

    void u4(z4 z42, int n) {
        Bucket[] bucketArray = this.w1;
        int n10 = this.w1.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].u4;
            if (object == null || object == this.w1) continue;
            z42.w1(object, n++);
        }
    }

    @Override
    public void copyTo(z4 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.z4() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.w7() - arrayIndex < this.z4) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.w1(array, arrayIndex);
    }

    void p5(z4 z42, int n) {
        Bucket[] bucketArray = this.w1;
        int n10 = this.w1.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].u4;
            if (object == null || object == this.w1) continue;
            z42.w1(bucketArray[n10].p5, n++);
        }
    }

    private void p5() {
        int n = com.aspose.slides.internal.b2j.u4.u4(this.w1.length * 2);
        this.u4(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.u4 != null) {
            return this.u4.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(n5 info, m7 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.u4("LoadFactor", this.g2);
        info.u4("Version", this.f3);
        if (this.u4 == null) {
            info.u4("Comparer", null, com.aspose.slides.internal.h2d.w1.u4(Comparator.class));
            info.u4("HashCodeProvider", null, com.aspose.slides.internal.h2d.w1.u4(IHashCodeProvider.class));
        } else if (this.u4 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.h2d.w1.u4(this.u4, CompatibleComparer.class);
            info.u4("Comparer", objectArray.u4(), com.aspose.slides.internal.h2d.w1.u4(Comparator.class));
            info.u4("HashCodeProvider", objectArray.p5(), com.aspose.slides.internal.h2d.w1.u4(IHashCodeProvider.class));
        } else {
            info.u4("KeyComparer", this.u4, com.aspose.slides.internal.h2d.w1.u4(IGenericEqualityComparer.class));
        }
        info.u4("HashSize", this.w1.length);
        objectArray = new Object[this.z4];
        Object[] objectArray2 = new Object[this.z4];
        this.u4(com.aspose.slides.ms.System.z4.u4(objectArray), 0);
        this.p5(com.aspose.slides.ms.System.z4.u4(objectArray2), 0);
        info.u4("Keys", objectArray, com.aspose.slides.internal.h2d.w1.u4(Object[].class));
        info.u4("Values", objectArray2, com.aspose.slides.internal.h2d.w1.u4(Object[].class));
    }

    private long u4(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void u4(Object object, Object object2, boolean bl) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.z4 >= this.t1) {
                this.p5();
            } else if (this.u2 > this.t1 && this.z4 > 100) {
                this.w1();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.u4(object, this.w1.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.w1.length);
            do {
                if (n10 == -1 && this.w1[n11].u4 == this.w1 && this.w1[n11].w1 < 0) {
                    n10 = n11;
                }
                if (this.w1[n11].u4 == null || this.w1[n11].u4 == this.w1 && ((long)this.w1[n11].w1 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.w7 = true;
                    this.w1[n11].p5 = object2;
                    this.w1[n11].u4 = object;
                    this.w1[n11].w1 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.z4;
                    this.z4();
                    this.w7 = false;
                    break block12;
                }
                if ((long)(this.w1[n11].w1 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.w1[n11].u4, object)) {
                    if (bl) {
                        throw new ArgumentException(d6.u4("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.w1[n11].u4, object));
                    }
                    this.w7 = true;
                    this.w1[n11].p5 = object2;
                    this.z4();
                    this.w7 = false;
                    break block12;
                }
                if (n10 == -1 && this.w1[n11].w1 >= 0) {
                    this.w1[n11].w1 = (int)((long)this.w1[n11].w1 | Integer.MIN_VALUE);
                    ++this.u2;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.w1.length);
            } while (++n < this.w1.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.w7 = true;
            this.w1[n10].p5 = object2;
            this.w1[n10].u4 = object;
            this.w1[n10].w1 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.z4;
            this.z4();
            this.w7 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (l0.p5(this.w1, item)) {
            return false;
        }
        if (this.u4 != null) {
            return this.u4.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.w1 == null) {
            if (this.i4 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            l4 l42 = this.i4.z4();
            while (l42.hasNext()) {
                switch (x4.u4(l42.p5())) {
                    case 0: {
                        this.g2 = this.i4.p5("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.i4.u4("HashSize");
                        break;
                    }
                    case 2: {
                        this.u4 = (IGenericEqualityComparer)this.i4.u4("KeyComparer", com.aspose.slides.internal.h2d.w1.u4(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.i4.u4("Comparer", com.aspose.slides.internal.h2d.w1.u4(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.i4.u4("HashCodeProvider", com.aspose.slides.internal.h2d.w1.u4(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.i4.u4("Keys", com.aspose.slides.internal.h2d.w1.u4(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.i4.u4("Values", com.aspose.slides.internal.h2d.w1.u4(Object[].class));
                    }
                }
            }
            this.t1 = (int)(this.g2 * (float)n);
            if (this.u4 == null && (comparator != null || iHashCodeProvider != null)) {
                this.u4 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.w1 = this.p5(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.u4(objectArray[i], objectArray2[i], true);
            }
            this.f3 = this.i4.u4("Version");
            this.i4 = null;
        }
    }

    private void u4(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].u4 == null || bucketArray[n10].u4 == this.w1) {
                bucketArray[n10].p5 = object2;
                bucketArray[n10].u4 = object;
                bucketArray[n10].w1 |= n;
                break;
            }
            if (bucketArray[n10].w1 >= 0) {
                bucketArray[n10].w1 = (int)((long)bucketArray[n10].w1 | Integer.MIN_VALUE);
                ++this.u2;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void w1() {
        this.u4(this.w1.length);
    }

    private void u4(int n) {
        this.u2 = 0;
        Bucket[] bucketArray = this.p5(n);
        for (int i = 0; i < this.w1.length; ++i) {
            Bucket bucket = this.w1[i].u4();
            if (bucket.u4 == null || bucket.u4 == this.w1) continue;
            this.u4(bucketArray, bucket.u4, bucket.p5, bucket.w1 & Integer.MAX_VALUE);
        }
        this.w7 = true;
        this.w1 = bucketArray;
        this.t1 = (int)(this.g2 * (float)n);
        this.z4();
        this.w7 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.u4(key, this.w1.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.w1.length);
        do {
            this.w1[n10].u4(bucket);
            if ((long)(bucket.w1 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.u4, key)) {
                this.w7 = true;
                this.w1[n10].w1 = (int)((long)this.w1[n10].w1 & Integer.MIN_VALUE);
                this.w1[n10].u4 = this.w1[n10].w1 != 0 ? this.w1 : null;
                this.w1[n10].p5 = null;
                --this.z4;
                this.z4();
                this.w7 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.w1.length);
        } while (bucket.w1 < 0 && ++n < this.w1.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] u4() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.z4];
        int n = 0;
        Bucket[] bucketArray = this.w1;
        int n10 = this.w1.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].u4;
            if (object == null || object == this.w1) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].p5);
        }
        return keyValuePairsArray;
    }

    private void z4() {
        ++this.f3;
    }

    private Bucket[] p5(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.z4;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.u4;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.w1;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.u4(key, this.w1.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.w1.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.f3;
                bucketArray[n10].u4(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.u6i.i4.p5(1);
            } while (this.w7 || n11 != this.f3);
            if (bucket.u4 == null) break;
            if ((long)(bucket.w1 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.u4, key)) {
                return bucket.p5;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.w1.length);
        } while (bucket.w1 < 0 && ++n < this.w1.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.u4(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.u3 == null) {
            this.u3 = new KeyCollection(this);
        }
        return this.u3;
    }

    @Override
    public Object getSyncRoot() {
        return this.p5;
    }

    @Override
    public ICollection getValues() {
        if (this.i1 == null) {
            this.i1 = new ValueCollection(this);
        }
        return this.i1;
    }

    @Override
    public boolean isEmpty() {
        return this.z4 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        z4 z42 = com.aspose.slides.ms.System.z4.u4(objectArray);
        this.getKeys().copyTo(z42, 0);
        return new ReadOnlyItemCollection(z42);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        z4 z42 = com.aspose.slides.ms.System.z4.u4(objectArray);
        this.getValues().copyTo(z42, 0);
        return new ReadOnlyItemCollection(z42);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.u4();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].u4(), keyValuePairsArray[i].p5());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.z4.u4(entryArray));
    }

    public int getVersion() {
        return this.f3;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new p5(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private z4 p5;

        ReadOnlyItemCollection(z4 items) {
            this.p5 = items;
        }

        @Override
        public int size() {
            return this.p5.size();
        }

        @Override
        public boolean isEmpty() {
            return this.p5.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.p5.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.p5.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            z4 z42 = com.aspose.slides.ms.System.z4.u4(objectArray);
            this.p5.copyTo(z42, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.p5.copyTo(com.aspose.slides.ms.System.z4.u4(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @q2
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable u4;

        SyncHashtable(Hashtable table) {
            super(false);
            this.u4 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.u4.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.u4.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.u4.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array, int arrayIndex) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.u4.iterator();
        }

        @Override
        public void getObjectData(n5 info, m7 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.u4("ParentTable", this.u4, com.aspose.slides.internal.h2d.w1.u4(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] u4() {
            return this.u4.u4();
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.u4.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.u4.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.u4.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.getValues();
            }
        }
    }

    @q2
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable u4;

        ValueCollection(Hashtable hashtable) {
            this.u4 = hashtable;
        }

        @Override
        public void copyTo(z4 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.z4() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.w7() - arrayIndex < this.u4.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.u4.p5(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.u4, 2);
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }
    }

    @q2
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable u4;

        KeyCollection(Hashtable hashtable) {
            this.u4 = hashtable;
        }

        @Override
        public void copyTo(z4 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.z4() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.w7() - arrayIndex < this.u4.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.u4.u4(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.u4, 1);
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }
    }

    @q2
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int u4;
        private boolean p5;
        private Object w1;
        private Object z4;
        private int w7;
        private Hashtable u3;
        private int g2;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.u3 = hashtable;
            this.u4 = hashtable.w1.length;
            this.g2 = hashtable.f3;
            this.p5 = false;
            this.w7 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.g2 != this.u3.f3) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.u4 > 0) {
                --this.u4;
                Object object = ((Hashtable)this.u3).w1[this.u4].u4;
                if (object == null || object == this.u3.w1) continue;
                this.w1 = object;
                this.z4 = ((Hashtable)this.u3).w1[this.u4].p5;
                this.p5 = true;
                return true;
            }
            this.p5 = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.g2 != this.u3.f3) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.p5 = false;
            this.u4 = this.u3.w1.length;
            this.w1 = null;
            this.z4 = null;
        }

        @Override
        public Object next() {
            if (!this.p5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.w7 == 1) {
                return this.w1;
            }
            if (this.w7 == 2) {
                return this.z4;
            }
            return new DictionaryEntry(this.w1, this.z4);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.p5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.w1, this.z4);
        }

        @Override
        public Object getKey() {
            if (!this.p5) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.w1;
        }

        @Override
        public Object getValue() {
            if (!this.p5) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.z4;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object u4;
        private Object p5;

        public KeyValuePairs(Object key, Object value) {
            this.p5 = value;
            this.u4 = key;
        }

        public Object u4() {
            return this.u4;
        }

        public Object p5() {
            return this.p5;
        }
    }

    private static class Bucket
    extends g2<Bucket> {
        public Object u4;
        public Object p5;
        public int w1;

        public void u4(Bucket bucket) {
            bucket.u4 = this.u4;
            bucket.p5 = this.p5;
            bucket.w1 = this.w1;
        }

        public Bucket u4() {
            Bucket bucket = new Bucket();
            this.u4(bucket);
            return bucket;
        }

        public Object clone() {
            return this.u4();
        }

        private boolean p5(Bucket bucket) {
            return l0.u4(bucket.u4, this.u4) && l0.u4(bucket.p5, this.p5) && bucket.w1 == this.w1;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (l0.p5(null, obj)) {
                return false;
            }
            if (l0.p5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.p5((Bucket)obj);
        }

        public int hashCode() {
            int n = this.u4 != null ? this.u4.hashCode() : 0;
            n = 31 * n + (this.p5 != null ? this.p5.hashCode() : 0);
            n = 31 * n + this.w1;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.u4();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.u4((Bucket)object);
        }
    }

    @q2
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator u4;
        private IHashCodeProvider p5;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.u4 = comparer;
            this.p5 = hashCodeProvider;
        }

        public int u4(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.u4 != null) {
                return this.u4.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.h2d.w1.u4(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.u4(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.p5 != null) {
                return this.p5.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator u4() {
            return this.u4;
        }

        IHashCodeProvider p5() {
            return this.p5;
        }
    }
}

