/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.q0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.z4;
import java.util.Arrays;

@q2
public class Queue
implements ICollection,
IEnumerable,
q0 {
    private Object[] u4;
    private int p5 = 0;
    private int w1 = 0;
    private int z4 = 0;
    private int w7;
    private int u3 = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.u4 = new Object[capacity];
        this.w7 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.w1;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(z4 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.z4() > 1 || index != 0 && index >= array.w7() || this.w1 > array.w7() - index) {
            throw new ArgumentException();
        }
        int n = this.u4.length;
        int n10 = n - this.p5;
        com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4), this.p5, array, index, Math.min(this.w1, n10));
        if (this.w1 > n10) {
            com.aspose.slides.ms.System.z4.u4(com.aspose.slides.ms.System.z4.u4(this.u4), 0, array, index + n10, this.w1 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.u4.length);
        queue.w7 = this.w7;
        com.aspose.slides.ms.System.z4.u4(this.u4, 0, queue.u4, 0, this.u4.length);
        queue.p5 = this.p5;
        queue.w1 = this.w1;
        queue.z4 = this.z4;
        return queue;
    }

    public void clear() {
        ++this.u3;
        this.p5 = 0;
        this.w1 = 0;
        this.z4 = 0;
        for (int i = this.u4.length - 1; i >= 0; --i) {
            this.u4[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.p5 + this.w1;
        if (obj == null) {
            for (int i = this.p5; i < n; ++i) {
                if (this.u4[i % this.u4.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.p5; i < n; ++i) {
                if (!obj.equals(this.u4[i % this.u4.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.u3;
        if (this.w1 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.u4[this.p5];
        this.u4[this.p5] = null;
        this.p5 = (this.p5 + 1) % this.u4.length;
        --this.w1;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.u3;
        if (this.w1 == this.u4.length) {
            this.u4();
        }
        this.u4[this.z4] = obj;
        this.z4 = (this.z4 + 1) % this.u4.length;
        ++this.w1;
    }

    public Object peek() {
        if (this.w1 < 1) {
            throw new InvalidOperationException();
        }
        return this.u4[this.p5];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.w1) {
            return Arrays.copyOf(this.u4, this.w1, a.getClass());
        }
        System.arraycopy(this.u4, 0, a, 0, this.w1);
        if (a.length > this.w1) {
            a[this.w1] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.u3;
        Object[] objectArray = new Object[this.w1];
        this.copyTo(com.aspose.slides.ms.System.z4.u4(objectArray), 0);
        this.u4 = objectArray;
        this.p5 = 0;
        this.z4 = 0;
    }

    private void u4() {
        int n = this.u4.length * this.w7 / 100;
        if (n < this.u4.length + 1) {
            n = this.u4.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.z4.u4(objectArray), 0);
        this.u4 = objectArray;
        this.p5 = 0;
        this.z4 = this.p5 + this.w1;
    }

    @q2
    private static class QueueEnumerator
    implements IEnumerator,
    q0 {
        private Queue u4;
        private int p5;
        private int w1;

        QueueEnumerator(Queue q) {
            this.u4 = q;
            this.p5 = q.u3;
            this.w1 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.u4);
            queueEnumerator.p5 = this.p5;
            queueEnumerator.w1 = this.w1;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.p5 != this.u4.u3 || this.w1 < 0 || this.w1 >= this.u4.w1) {
                throw new InvalidOperationException();
            }
            return this.u4.u4[(this.u4.p5 + this.w1) % this.u4.u4.length];
        }

        @Override
        public boolean hasNext() {
            if (this.p5 != this.u4.u3) {
                throw new InvalidOperationException();
            }
            if (this.w1 >= this.u4.w1 - 1) {
                this.w1 = Integer.MAX_VALUE;
                return false;
            }
            ++this.w1;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.p5 != this.u4.u3) {
                throw new InvalidOperationException();
            }
            this.w1 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue u4;

        SyncQueue(Queue queue) {
            this.u4 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.u4;
            synchronized (queue) {
                return this.u4.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array, int index) {
            Queue queue = this.u4;
            synchronized (queue) {
                this.u4.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.u4;
            synchronized (queue) {
                return this.u4.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.u4;
            synchronized (queue) {
                return new SyncQueue((Queue)this.u4.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.u4;
            synchronized (queue) {
                this.u4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.u4;
            synchronized (queue) {
                this.u4.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.u4;
            synchronized (queue) {
                return this.u4.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.u4;
            synchronized (queue) {
                return this.u4.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.u4;
            synchronized (queue) {
                this.u4.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.u4;
            synchronized (queue) {
                return this.u4.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.u4;
            synchronized (queue) {
                return this.u4.toArray(a);
            }
        }
    }
}

