/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.h2d.g2;
import com.aspose.slides.ms.System.d6;
import com.aspose.slides.ms.System.l0;
import com.aspose.slides.ms.System.q0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.z4;
import java.util.Comparator;

@q2
public class SortedList
implements IDictionary,
q0 {
    private final Object u4 = new Object();
    private Slot[] p5;
    private Comparator w1;
    private int z4;
    private int w7;
    private int u3;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.u3 = capacity == 0 ? 0 : 16;
        this.w1 = comparer;
        this.p5(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.w1 = comparer;
        this.p5(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.p5(d.size(), true);
        this.w1 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.z4;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.u4;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.u4(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.p5(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.u4(key, value, true);
    }

    public int getCapacity() {
        return this.p5.length;
    }

    public void setCapacity(int value) {
        int n = this.p5.length;
        if (this.z4 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.u4(this.u3);
            SortedList.u4(this.p5, 0, slotArray, 0, this.z4);
            this.p5 = slotArray;
        } else if (value > this.z4) {
            Slot[] slotArray = SortedList.u4(value);
            SortedList.u4(this.p5, 0, slotArray, 0, this.z4);
            this.p5 = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.u4(value);
            SortedList.u4(this.p5, 0, slotArray, 0, n);
            this.p5 = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.u4(key, value, false);
    }

    @Override
    public void clear() {
        this.u3 = 16;
        this.p5 = SortedList.u4(this.u3);
        this.z4 = 0;
        ++this.w7;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.p5(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(z4 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.z4() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.w7()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.w7() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.w1(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.w1);
        sortedList.w7 = this.w7;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.p5;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.u4(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].u4 = null;
                slotArray[index].p5 = null;
            }
            --this.z4;
            ++this.w7;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.p5(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.z4 == 0) {
            return -1;
        }
        for (int i = 0; i < this.z4; ++i) {
            Slot slot = this.p5[i].Clone();
            if (!l0.u4(value, slot.p5)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.p5[index].p5;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.p5[index].p5 = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.p5[index].u4;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.u4(this.u3, false);
        } else {
            this.u4(this.size(), true);
        }
    }

    private void u4(int n, boolean bl) {
        Slot[] slotArray = this.p5;
        Slot[] slotArray2 = SortedList.u4(n);
        if (bl) {
            SortedList.u4(slotArray, 0, slotArray2, 0, n);
        }
        this.p5 = slotArray2;
    }

    private void u4(int n, int n10) {
        boolean bl;
        Slot[] slotArray = this.p5;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl2 = bl = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.u4(n << 1);
        }
        if (slotArray2 != null) {
            if (bl) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.u4(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.u4(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.u4(slotArray, 0, slotArray2, 0, this.size());
            }
            this.p5 = slotArray2;
        } else if (bl) {
            SortedList.u4(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void u4(Object object, Object object2, boolean bl) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.p5;
        int n = -1;
        try {
            n = this.p5(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl) {
                String string = d6.u4("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].p5 = object2;
            ++this.w7;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(d6.u4(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.u4(this.size() + 1, n);
        slotArray = this.p5;
        slotArray[n].u4 = object;
        slotArray[n].p5 = object2;
        ++this.z4;
        ++this.w7;
    }

    private Object u4(Object object) {
        int n = this.p5(object);
        if (n >= 0) {
            return this.p5[n].p5;
        }
        return null;
    }

    private void p5(int n, boolean bl) {
        if (!bl && n < this.u3) {
            n = this.u3;
        }
        this.p5 = SortedList.u4(n);
        this.z4 = 0;
        this.w7 = 0;
    }

    private void u4(z4 z42, int n, int n10) {
        if (z42 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > z42.w7()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            z42.w1(enumerator.next(), n++);
        }
    }

    private int p5(Object object) {
        Slot[] slotArray = this.p5;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.w1 == null ? Comparer.Default : this.w1;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].u4, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] u4(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean u4(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void u4(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.u4(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList u4;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.u4 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.u4.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.u4.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                iCollection = this.u4.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                iCollection = this.u4.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.u4(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.u4(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array, int arrayIndex) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.u4(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.p5(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.u4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.u4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                return this.u4.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.u4.getSyncRoot();
            synchronized (object) {
                this.u4.trimToSize();
            }
        }
    }

    @q2
    private static class ListValues
    implements IList {
        private SortedList u4;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.u4 = host;
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        @Override
        public void copyTo(z4 array, int arrayIndex) {
            this.u4.u4(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.u4.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.u4.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.u4, 1);
        }
    }

    @q2
    private static class ListKeys
    implements IList {
        private SortedList u4;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.u4 = host;
        }

        @Override
        public int size() {
            return this.u4.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.u4.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        @Override
        public void copyTo(z4 array, int arrayIndex) {
            this.u4.u4(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.u4.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.u4.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.u4.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.u4, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    q0 {
        private SortedList u4;
        private Object p5;
        private Object w1;
        private int z4;
        private int w7;
        private int u3;
        private int g2;
        private boolean t1 = false;
        private static String i4 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.u4 = host;
            this.z4 = host.w7;
            this.u3 = host.size();
            this.g2 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.u4.w7 != this.z4 || this.t1) {
                throw new IllegalStateException(i4);
            }
            this.w7 = -1;
            this.p5 = null;
            this.w1 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.u4.w7 != this.z4 || this.t1) {
                throw new InvalidOperationException(i4);
            }
            return ++this.w7 < this.u3;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            return new DictionaryEntry(this.p5, this.w1);
        }

        @Override
        public Object getKey() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            return this.p5;
        }

        @Override
        public Object getValue() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            return this.w1;
        }

        @Override
        public Object next() {
            if (this.u4.w7 != this.z4 || this.t1) {
                throw new InvalidOperationException(i4);
            }
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                if (this.w7 >= this.u3) {
                    this.p5 = null;
                    this.w1 = null;
                }
                throw new IllegalStateException(i4);
            }
            Slot[] slotArray = this.u4.p5;
            Slot slot = slotArray[this.w7].Clone();
            this.p5 = slot.u4;
            this.w1 = slot.p5;
            switch (this.g2) {
                case 0: {
                    return this.p5;
                }
                case 1: {
                    return this.w1;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(d6.u4(new String[]{v5.getName(EnumeratorMode.class, this.g2), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.u4, this.g2);
            enumeratorJava.z4 = this.z4;
            enumeratorJava.w7 = this.w7;
            enumeratorJava.u3 = this.u3;
            enumeratorJava.p5 = this.p5;
            enumeratorJava.w1 = this.w1;
            enumeratorJava.t1 = this.t1;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    q0 {
        private SortedList u4;
        private Object p5;
        private Object w1;
        private int z4;
        private int w7;
        private int u3;
        private int g2;
        private boolean t1 = false;
        private static String i4 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.u4 = host;
            this.z4 = host.w7;
            this.u3 = host.size();
            this.g2 = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.u4.w7 != this.z4 || this.t1) {
                throw new IllegalStateException(i4);
            }
            this.w7 = -1;
            this.p5 = null;
            this.w1 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.u4.w7 != this.z4 || this.t1) {
                throw new InvalidOperationException(i4);
            }
            Slot[] slotArray = this.u4.p5;
            if (++this.w7 < this.u3) {
                Slot slot = slotArray[this.w7].Clone();
                this.p5 = slot.u4;
                this.w1 = slot.p5;
                return true;
            }
            this.p5 = null;
            this.w1 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            return new DictionaryEntry(this.p5, this.w1);
        }

        @Override
        public Object getKey() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            return this.p5;
        }

        @Override
        public Object getValue() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            return this.w1;
        }

        @Override
        public Object next() {
            if (this.t1 || this.w7 >= this.u3 || this.w7 == -1) {
                throw new IllegalStateException(i4);
            }
            switch (this.g2) {
                case 0: {
                    return this.p5;
                }
                case 1: {
                    return this.w1;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(d6.u4(new String[]{v5.getName(EnumeratorMode.class, this.g2), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.u4, this.g2);
            enumerator.z4 = this.z4;
            enumerator.w7 = this.w7;
            enumerator.u3 = this.u3;
            enumerator.p5 = this.p5;
            enumerator.w1 = this.w1;
            enumerator.t1 = this.t1;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends v5 {
        private EnumeratorMode() {
        }

        static {
            v5.register(new v5.w7(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @q2
    public static class Slot
    extends g2<Slot> {
        Object u4;
        Object p5;

        @Override
        public void CloneTo(Slot that) {
            that.u4 = this.u4;
            that.p5 = this.p5;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean u4(Slot slot) {
            return l0.u4(slot.u4, this.u4) && l0.u4(slot.p5, this.p5);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (l0.p5(null, obj)) {
                return false;
            }
            if (l0.p5(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.u4((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.u4 != null ? this.u4.hashCode() : 0;
            n = 31 * n + (this.p5 != null ? this.p5.hashCode() : 0);
            return n;
        }
    }
}

