/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.c3d.u9;
import com.aspose.slides.internal.h2d.g2;
import com.aspose.slides.internal.h2d.w1;
import com.aspose.slides.ms.System.e4;
import com.aspose.slides.ms.System.p2;

public class BitVector32
extends g2<BitVector32> {
    private int u4;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.u4 = value.u4;
    }

    public BitVector32(int data) {
        this.u4 = data;
    }

    public int getData() {
        return this.u4;
    }

    public int get_Item(Section section) {
        return this.u4 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.u4 &= ~(section.getMask() << section.getOffset());
        this.u4 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.u4 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.u4 = value ? (this.u4 |= bit) : (this.u4 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.u4(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.u4(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(w1.p5((Object)n10, 9), w1.p5((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return w1.p5(o, BitVector32.class) && this.u4 == w1.z4((Object)o, BitVector32.class).u4;
    }

    public int hashCode() {
        return e4.u4(this.u4);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        u9 u92 = new u9();
        u92.u4("BitVector32{");
        for (long i = w1.u3((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            u92.u4(((long)value.u4 & i) == 0L ? (char)'0' : '1');
        }
        u92.u4('}');
        return u92.toString();
    }

    private static int u4(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.u4 = this.u4;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends g2<Section> {
        private short u4;
        private short p5;

        public Section() {
        }

        Section(short mask, short offset) {
            this.u4 = mask;
            this.p5 = offset;
        }

        public short getMask() {
            return this.u4;
        }

        public short getOffset() {
            return this.p5;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.u4 == b.u4 && a.p5 == b.p5;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.u4 != b.u4 || a.p5 != b.p5;
        }

        public boolean equals(Section obj) {
            return this.u4 == obj.u4 && this.p5 == obj.p5;
        }

        public boolean equals(Object o) {
            if (!w1.p5(o, Section.class)) {
                return false;
            }
            Section section = w1.z4(o, Section.class).Clone();
            return this.u4 == section.u4 && this.p5 == section.p5;
        }

        public int hashCode() {
            return this.u4 << this.p5;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            u9 u92 = new u9();
            u92.u4("Section{0x");
            u92.u4(p2.u4(value.getMask(), 16));
            u92.u4(", 0x");
            u92.u4(p2.u4(value.getOffset(), 16));
            u92.u4("}");
            return u92.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.u4 = this.u4;
            that.p5 = this.p5;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

