/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.b5;
import com.aspose.slides.ms.System.q0;
import com.aspose.slides.ms.System.q2;
import com.aspose.slides.ms.System.z4;
import java.util.Arrays;

@q2
public class Stack
implements ICollection,
IEnumerable,
q0 {
    private Object[] u4;
    private int p5 = -1;
    private int w1;
    private int z4;
    private int w7;

    private void u4(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.z4.u4(this.u4, 0, objectArray, 0, this.w1);
        this.z4 = n;
        this.u4 = objectArray;
    }

    public Stack() {
        this.u4 = new Object[16];
        this.z4 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.z4 = initialCapacity;
        this.u4 = new Object[this.z4];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.w1;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.w7;
        for (int i = 0; i < this.w1; ++i) {
            this.u4[i] = null;
        }
        this.w1 = 0;
        this.p5 = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.z4.u4(this.u4));
        stack.p5 = this.p5;
        stack.w1 = this.w1;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.w1 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.w1; ++i) {
                if (this.u4[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.w1; ++i) {
                if (!obj.equals(this.u4[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(z4 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.z4() > 1 || array.w7() > 0 && index >= array.w7() || this.w1 > array.w7() - index) {
            throw new ArgumentException();
        }
        for (int i = this.p5; i != -1; --i) {
            array.w1(this.u4[i], this.w1 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.p5 == -1) {
            throw new InvalidOperationException();
        }
        return this.u4[this.p5];
    }

    public Object pop() {
        if (this.p5 == -1) {
            throw new InvalidOperationException();
        }
        ++this.w7;
        Object object = this.u4[this.p5];
        this.u4[this.p5] = null;
        --this.w1;
        --this.p5;
        if (this.w1 <= this.z4 / 4 && this.w1 > 16) {
            this.u4(this.z4 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.w7;
        if (this.z4 == this.w1) {
            this.u4(this.z4 * 2);
        }
        ++this.w1;
        ++this.p5;
        this.u4[this.p5] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.w1) {
            a = Arrays.copyOf(this.u4, this.w1, a.getClass());
            b5.u4(a);
            return a;
        }
        System.arraycopy(this.u4, 0, a, 0, this.w1);
        if (a.length > this.w1) {
            a[this.w1] = null;
        }
        b5.u4(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    q0,
    Cloneable {
        private Stack u4;
        private int p5;
        private int w1;

        Enumerator(Stack s) {
            this.u4 = s;
            this.p5 = s.w7;
            this.w1 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.u4();
        }

        @Override
        public Object next() {
            if (this.p5 != this.u4.w7 || this.w1 == -2 || this.w1 == -1 || this.w1 > this.u4.w1) {
                throw new InvalidOperationException();
            }
            return this.u4.u4[this.w1];
        }

        @Override
        public boolean hasNext() {
            if (this.p5 != this.u4.w7) {
                throw new InvalidOperationException();
            }
            switch (this.w1) {
                case -2: {
                    this.w1 = this.u4.p5;
                    return this.w1 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.w1;
            return this.w1 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.p5 != this.u4.w7) {
                throw new InvalidOperationException();
            }
            this.w1 = -2;
        }

        protected Object u4() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.u4 = this.u4;
            enumerator.p5 = this.p5;
            enumerator.w1 = this.w1;
            return enumerator;
        }
    }

    @q2
    private static class SyncStack
    extends Stack {
        private final Stack u4;

        SyncStack(Stack s) {
            this.u4 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.u4;
            synchronized (stack) {
                return this.u4.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.u4.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.u4;
            synchronized (stack) {
                this.u4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.u4;
            synchronized (stack) {
                return Stack.sync((Stack)this.u4.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.u4;
            synchronized (stack) {
                return this.u4.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(z4 array, int index) {
            Stack stack = this.u4;
            synchronized (stack) {
                this.u4.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.u4;
            synchronized (stack) {
                return new Enumerator(this.u4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.u4;
            synchronized (stack) {
                return this.u4.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.u4;
            synchronized (stack) {
                return this.u4.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.u4;
            synchronized (stack) {
                this.u4.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.u4;
            synchronized (stack) {
                return this.u4.toArray(a);
            }
        }
    }
}

