/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.ColumnCollection;
import com.aspose.slides.DomObject;
import com.aspose.slides.ICell;
import com.aspose.slides.IRow;
import com.aspose.slides.IRowCollection;
import com.aspose.slides.PptxEditException;
import com.aspose.slides.Row;
import com.aspose.slides.Table;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.IndexOutOfRangeException;
import com.aspose.slides.internal.u3q.d3;
import com.aspose.slides.ms.System.d6;
import com.aspose.slides.ms.System.z4;

public final class RowCollection
extends DomObject<Table>
implements IRowCollection {
    private final List<IRow> z4 = new List();
    private boolean w7 = true;
    boolean u4 = true;
    double p5 = 0.0;
    final ColumnCollection w1 = new ColumnCollection(this);

    RowCollection(Table parentImmediate) {
        super(parentImmediate);
    }

    final Table u4() {
        return (Table)this.u3;
    }

    final double p5() {
        this.u3();
        return this.p5;
    }

    @Override
    public final int size() {
        return this.z4.size();
    }

    @Override
    public final IRow get_Item(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IndexOutOfRangeException(d6.u4("value of index = {0} is out of range 0..{1}", new Object[]{index, this.size() - 1}));
        }
        return (Row)this.z4.get_Item(index);
    }

    final Row u4(int n) {
        return (Row)this.z4.get_Item(n);
    }

    final Row u4(double d) {
        return this.u4(-1, d);
    }

    final Row u4(int n, double d) {
        Row row = new Row(this, d);
        if (n < 0 || n >= this.size()) {
            row.p5 = this.z4.size();
            this.z4.addItem(row);
        } else {
            this.z4.insertItem(n, row);
            this.w7 = false;
        }
        this.u4 = false;
        row.p5(this.w1.size());
        return row;
    }

    @Override
    public final IRow[] addClone(IRow templ, boolean withAttachedRows) {
        int n = this.size();
        return this.insertClone(n, templ, withAttachedRows);
    }

    @Override
    public final IRow[] insertClone(int index, IRow templ, boolean withAttachedRows) {
        Row[] rowArray;
        Row row = (Row)templ;
        Table table = row.u4();
        if (this.u4() != table) {
            throw new PptxEditException("Clonning rows between different tables isn't supported.");
        }
        if (index < 0 || index > this.size()) {
            throw new ArgumentOutOfRangeException("index", index, "Wrong index of row");
        }
        if (this.u4(index, true)) {
            throw new PptxEditException("Can't insert rows: target index breaks merged cells.");
        }
        if (withAttachedRows) {
            rowArray = row.u3().p5(row.g2());
        } else {
            if (this.p5(row.g2(), true)) {
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            rowArray = new Row[]{row};
        }
        IRow[] iRowArray = new IRow[rowArray.length];
        int n = rowArray.length;
        while (n > 0) {
            row = rowArray[--n];
            Row row2 = this.u4(index, row.getMinimalHeight());
            iRowArray[n] = row2;
            row2.setMinimalHeight(row.getMinimalHeight());
            int n10 = this.w1.size();
            while (n10 > 0) {
                Cell cell = row.u4(--n10);
                Cell cell2 = row2.u4(n10);
                cell2.p5 = cell.p5;
                cell2.u4 = cell.u4;
                if (cell2.g2()) {
                    row2.p5 = index;
                    this.w7 = true;
                    cell2.p5(false);
                }
                cell2.u4(cell);
            }
        }
        this.w7 = false;
        return iRowArray;
    }

    final void p5(int n, double d) {
        Row row = this.u4(n);
        if (d <= 0.0 || d >= row.getHeight()) {
            throw new ArgumentOutOfRangeException("Splitting height must be in greater than 0 and less than row's minimal height");
        }
        Row row2 = this.u4(n + 1, row.getHeight() - d);
        row.setMinimalHeight(d);
        int n10 = this.w1.size();
        int n11 = 0;
        while (n11 < n10) {
            Cell cell = row.u4(n11);
            if (cell.t1()) {
                cell = cell.w7();
            }
            ++cell.u4;
            int n12 = cell.getColSpan();
            while (n12 > 0) {
                --n12;
                row2.u4((int)n11).w1 = cell;
                ++n11;
            }
        }
    }

    final void w1() {
        this.p5(0, this.size());
        this.w7 = true;
        this.u4 = true;
        this.p5 = 0.0;
    }

    @Override
    public final void removeAt(int firstRowIndex, boolean withAttachedRows) {
        int n = this.size();
        if (withAttachedRows) {
            d3 d32 = this.w1(firstRowIndex).z4();
            this.p5(d32.p5(), d32.w1());
        } else {
            int n10 = this.w1.size();
            Row row = this.u4(firstRowIndex);
            for (int i = 0; i < n10; ++i) {
                ICell iCell = row.get_Item(i);
                if (iCell.getRowSpan() <= 1) continue;
                throw new PptxEditException("Some of row's cells lay outside row.");
            }
            this.p5(firstRowIndex, 1);
        }
        if (n != this.size() && this.size() > 0) {
            this.w1.w7();
        }
    }

    private void p5(int n, int n10) {
        if (n10 == 0) {
            return;
        }
        if (n + n10 < this.size()) {
            this.w7 = false;
        }
        this.u4 = false;
        int n11 = n;
        int n12 = this.w1.size();
        for (int i = 0; i < n10; ++i) {
            Row row = this.u4(n11++);
            row.p5(0, n12);
        }
        if (n == 0 && n10 == this.size()) {
            this.z4.clear();
        } else {
            this.z4.removeRange(n, n10);
        }
    }

    final void z4() {
        this.u4(0, this.size());
    }

    final void u4(int n, int n10) {
        boolean bl = this.u4;
        int n11 = n + n10;
        int n12 = this.w1.size();
        while (n11 > n) {
            Cell cell;
            int n13;
            Row row = this.u4(--n11);
            boolean bl2 = true;
            for (n13 = 0; n13 < n12; ++n13) {
                if (row.u4(n13).t1()) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            if (n11 > 0) {
                Row row2 = this.u4(n11 - 1);
                row2.setMinimalHeight(row2.getMinimalHeight() + row.getMinimalHeight());
            }
            for (n13 = 0; n13 < n12; n13 += cell.getColSpan()) {
                cell = row.u4(n13).w7();
                --cell.u4;
            }
            this.p5(n11, 1);
        }
        this.u4 = bl;
    }

    private d3 w1(int n) {
        int n10;
        int n11;
        int n12 = this.w1.size();
        int n13 = n;
        Row row = this.u4(n13);
        if (n > 0) {
            Cell cell;
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.u4(n11).w7();
                if (cell.getFirstRowIndex() >= n13) continue;
                n13 = cell.getFirstRowIndex();
                row = this.u4(n13);
                n11 = 0;
            }
        }
        if ((n10 = n + 1) < this.size()) {
            Cell cell;
            row = this.u4(n);
            for (n11 = 0; n11 < n12; n11 += cell.getColSpan()) {
                cell = row.u4(n11).w7();
                if (cell.getFirstRowIndex() + cell.getRowSpan() <= n10) continue;
                n10 = cell.getFirstRowIndex() + cell.getRowSpan();
                row = this.u4(n10 - 1);
                n11 = 0;
            }
        }
        return new d3(n13, n10 - n13);
    }

    final Row[] p5(int n) {
        d3 d32 = this.w1(n).z4();
        Row[] rowArray = new Row[d32.w1()];
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i] = this.u4(d32.p5() + i);
        }
        return rowArray;
    }

    final void w7() {
        if (this.w7) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.u4((int)i).p5 = i;
        }
        this.w7 = true;
    }

    final void u3() {
        if (this.u4) {
            return;
        }
        this.u4().n4().w1();
        double d = 0.0;
        int n = 0;
        while (n < this.size()) {
            Row row = this.u4(n);
            row.p5 = n++;
            row.w1 = d;
            d += row.getHeight();
        }
        this.p5 = d;
        this.u4 = true;
        this.w7 = true;
    }

    final boolean u4(int n, boolean bl) {
        Cell cell;
        if (n < 1 || n == this.size()) {
            return false;
        }
        int n10 = this.w1.size();
        Row row = this.u4(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.u4(i);
            if (cell.t1()) {
                cell = cell.w7();
            }
            if ((n11 = cell.getFirstRowIndex()) >= n) continue;
            if (bl) {
                return true;
            }
            cell.p5(n - n11);
        }
        return false;
    }

    final boolean p5(int n, boolean bl) {
        Cell cell;
        if (n == this.size()) {
            return false;
        }
        int n10 = this.w1.size();
        Row row = this.u4(n);
        for (int i = 0; i < n10; i += cell.getColSpan()) {
            int n11;
            cell = row.u4(i);
            if (cell.t1() && (n11 = (cell = cell.w7()).getFirstRowIndex()) < n) {
                if (bl) {
                    return true;
                }
                cell = cell.p5(n - n11);
            }
            if (cell.getRowSpan() <= 1) continue;
            if (bl) {
                return true;
            }
            cell.p5(1);
        }
        return false;
    }

    @Override
    public final IGenericEnumerator<IRow> iterator() {
        return this.z4.iterator();
    }

    @Override
    public final IGenericEnumerator<IRow> iteratorJava() {
        return this.z4.iteratorJava();
    }

    @Override
    public final void copyTo(z4 array, int index) {
        this.z4.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

