/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IFindResultCallback;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.ITextSearchOptions;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Presentation;
import com.aspose.slides.Row;
import com.aspose.slides.TextFrame;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.c3d.u9;
import com.aspose.slides.internal.h2d.w1;
import com.aspose.slides.internal.v4w.t1;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.d6;
import com.aspose.slides.o1m;
import com.aspose.slides.p2z;
import com.aspose.slides.z5f;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.u4(slide.getShapes(), altText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IShape[] findShapesByPlaceholderType(IBaseSlide slide, byte placeholderType) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = slide.getShapes().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IShape iShape = (IShape)iGenericEnumerator.next();
                if (iShape.getPlaceholder() == null || iShape.getPlaceholder().getType() != placeholderType) continue;
                list.addItem(iShape);
            }
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list.toArray(new IShape[0]);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.u4(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.u4(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.u4(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.u4(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (d6.u4(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (d6.w7(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.u4(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void u4(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.u4(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void u4(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (d6.w7(string, string2)) {
            return;
        }
        o1m o1m2 = o1m.u4(iParagraph);
        while (o1m2.u4(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        o1m2.p5(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.u4(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getTextBoxesContainsText(IBaseSlide slide, String text, boolean checkPlaceholderText) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.u4(slide.getShapes(), list, true, checkPlaceholderText, text);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        return SlideUtil.u4(pres, withMasters, false);
    }

    static ITextFrame[] u4(IPresentation iPresentation, boolean bl, boolean bl2) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (bl) {
            for (n = 0; n < iPresentation.getMasters().size(); ++n) {
                SlideUtil.u4(iPresentation.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < iPresentation.getSlides().size(); ++n) {
            SlideUtil.u4(iPresentation.getSlides().get_Item(n).getShapes(), list);
            if (!bl2 || iPresentation.getSlides().get_Item(n).getNotesSlideManager().getNotesSlide() == null) continue;
            list.addItem(iPresentation.getSlides().get_Item(n).getNotesSlideManager().getNotesSlide().getNotesTextFrame());
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] u4(IPresentation iPresentation, int[] nArray, boolean bl) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.u4(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl) continue;
            SlideUtil.u4(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.u4(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> List<T> u4(Class<T> clazz, IPresentation iPresentation) {
        List<IShape> list = new List<IShape>();
        IGenericEnumerator iGenericEnumerator = iPresentation.getSlides().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ISlide iSlide = (ISlide)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator2 = iSlide.getShapes().iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        IShape iShape = (IShape)iGenericEnumerator2.next();
                        if (!w1.p5((Object)iShape, clazz)) continue;
                        list.addItem(iShape);
                    }
                }
                finally {
                    if (w1.u4(iGenericEnumerator2, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return list;
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    static String u4(IPresentation iPresentation, int[] nArray) {
        u9 u92 = new u9();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                u92.u4(iTextFrame.getText());
            }
        }
        return u92.toString();
    }

    private static void u4(int n, boolean bl, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        p2z.u4(n, bl, list2);
    }

    private static IShape u4(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (d6.u3(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!w1.p5((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.u4(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    private static void u4(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        SlideUtil.u4(iShapeCollection, list, false);
    }

    private static void u4(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl) {
        SlideUtil.u4(iShapeCollection, list, bl, false);
    }

    private static void u4(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl, boolean bl2) {
        SlideUtil.u4(iShapeCollection, list, bl, bl2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void u4(IShapeCollection iShapeCollection, List<ITextFrame> list, boolean bl, boolean bl2, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            IShape iShape;
            ISlideComponent iSlideComponent;
            if (w1.p5((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.u4(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)w1.u4(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null || bl && !d6.i4(iSlideComponent.getText(), string) && (!iSlideComponent.getText().isEmpty() || !bl2 || (iShape = (IAutoShape)((Object)w1.u4(iAutoShape.getBasePlaceholder(), IAutoShape.class))) == null || iShape.getTextFrame() == null || !d6.i4(iShape.getTextFrame().getText(), string))) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)w1.u4(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).u4(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            iShape = (IChart)((Object)w1.u4(iShapeCollection.get_Item(i), IChart.class));
            if (iShape != null && iShape.getUserShapes() != null) {
                SlideUtil.u4(iShape.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)w1.u4(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    private static z5f u4(Presentation presentation, String string, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        if (d6.u4(string)) {
            throw new ArgumentException("Text to highlight can not be null or empty", "text");
        }
        int n = 0;
        if (iTextSearchOptions != null && !iTextSearchOptions.getCaseSensitive()) {
            n |= 0x42;
        }
        t1 t12 = new t1("\\-\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\,\\\\\\^\\$\\|#\\s");
        String string2 = t12.w1(string, "\\$0");
        if (iTextSearchOptions != null && iTextSearchOptions.getWholeWordsOnly()) {
            string2 = d6.u4(new String[]{"\\b", string2, "\\b"});
        }
        boolean bl = iTextSearchOptions != null && iTextSearchOptions.getIncludeNotes();
        t1 t13 = new t1(string2, n);
        return SlideUtil.u4(presentation, t13, iFindResultCallback, bl);
    }

    private static z5f u4(Presentation presentation, t1 t12, IFindResultCallback iFindResultCallback) {
        if (t12 == null) {
            throw new ArgumentException("Regex to highlight can not be null", "regex");
        }
        return SlideUtil.u4(presentation, t12, iFindResultCallback, false);
    }

    private static z5f u4(Presentation presentation, t1 t12, IFindResultCallback iFindResultCallback, boolean bl) {
        z5f z5f2 = new z5f(t12);
        for (ITextFrame iTextFrame : SlideUtil.u4((IPresentation)presentation, false, bl)) {
            TextFrame textFrame = (TextFrame)iTextFrame;
            textFrame.u4(t12, iFindResultCallback);
            if (textFrame.w1.w7() <= 0) continue;
            z5f2.u4(textFrame);
        }
        return z5f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void u4(Presentation presentation, String string, com.aspose.slides.internal.u3q.t1 t12, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        z5f z5f2 = SlideUtil.u4(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = z5f2.p5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.u4(z5f2.u4(), t12.s1());
            }
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void u4(Presentation presentation, t1 t12, com.aspose.slides.internal.u3q.t1 t13, IFindResultCallback iFindResultCallback) {
        z5f z5f2 = SlideUtil.u4(presentation, t12, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = z5f2.p5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.u4(z5f2.u4(), t13.s1());
            }
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void u4(Presentation presentation, String string, String string2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        z5f z5f2 = SlideUtil.u4(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = z5f2.p5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.u4(z5f2.u4(), string2);
            }
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void u4(Presentation presentation, t1 t12, String string, IFindResultCallback iFindResultCallback) {
        z5f z5f2 = SlideUtil.u4(presentation, t12, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = z5f2.p5().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.u4(z5f2.u4(), string);
            }
        }
        finally {
            if (w1.u4(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

