/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.IAIWebClient;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPortion;
import com.aspose.slides.IPresentation;
import com.aspose.slides.Paragraph;
import com.aspose.slides.Portion;
import com.aspose.slides.Presentation;
import com.aspose.slides.SlideUtil;
import com.aspose.slides.SlidesAIAgentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.DOMResourcesUtils;
import com.aspose.slides.internal.f9.p1;
import com.aspose.slides.internal.f9.x1;
import com.aspose.slides.internal.f9.x4;
import com.aspose.slides.internal.f9.z3;
import com.aspose.slides.internal.k4.w1;
import com.aspose.slides.internal.u1c.t6;

public class SlidesAIAgent {
    private IAIWebClient u4;

    public SlidesAIAgent(IAIWebClient aiClient) {
        if (aiClient == null) {
            throw new ArgumentNullException("aiClient", "AI client instance is not provided.");
        }
        this.u4 = aiClient;
        z3.p5 = new w1<IParagraph>(){

            public IParagraph u4() {
                return new Paragraph();
            }

            @Override
            public /* synthetic */ Object invoke() {
                return this.u4();
            }
        };
        z3.u4 = new w1<IPortion>(){

            public IPortion u4() {
                return new Portion();
            }

            @Override
            public /* synthetic */ Object invoke() {
                return this.u4();
            }
        };
    }

    public void translate(IPresentation presentation, String language) {
        this.u4(presentation, language);
        String string = p1.u4(SlideUtil.getAllTextFrames(presentation, true));
        x1 x12 = new x1(presentation, string, language);
        String[] stringArray = x12.u4();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.u4.callChat(stringArray[i]);
        }
        x12.u4(stringArray2);
    }

    public final IPresentation generatePresentation(String description, int presentationContentAmount) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description can't be null or empty.");
        }
        try {
            t6 t62 = DOMResourcesUtils.getResourceStream("aiTemplate.pptx");
            Presentation presentation = new Presentation(t62);
            return this.generatePresentation(description, presentationContentAmount, presentation);
        }
        catch (RuntimeException runtimeException) {
            throw new SlidesAIAgentException("Failed to load template", runtimeException);
        }
    }

    public final IPresentation generatePresentation(String description, int presentationContentAmount, IPresentation presentationTemplate) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description can't be null or empty.");
        }
        if (presentationTemplate == null) {
            throw new IllegalArgumentException("Presentation template is not provided.");
        }
        return x4.u4(this.u4, description, presentationContentAmount, presentationTemplate);
    }

    private void u4(IPresentation iPresentation, String string) {
        if (iPresentation == null) {
            throw new IllegalArgumentException("Presentation instance is not provided.");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Language value can't be null or empty");
        }
    }
}

