/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.e0;
import com.aspose.slides.ms.System.f1;
import com.aspose.slides.ms.System.j0;
import com.aspose.slides.ms.System.o3;
import com.aspose.slides.ms.System.p8;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@e0
public class ArrayList
implements IList,
List {
    private Object[] p1;
    private int e2;
    private int e9;
    private static Object[] f1 = new Object[0];

    protected int getVersion() {
        return this.e9;
    }

    public ArrayList() {
        this.p1 = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.p1 = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.p1("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.p1 = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.p1 = null;
    }

    private ArrayList(f1 array, int index, int count) {
        this.p1 = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.f1.p1(array, index, com.aspose.slides.ms.System.f1.p1(this.p1), 0, count);
        this.e2 = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.e2) {
            ArrayList.p1("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.p1[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.e2) {
            ArrayList.p1("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.p1[index] = value;
        ++this.e9;
    }

    @Override
    public int size() {
        return this.e2;
    }

    public int getCapacity() {
        return this.p1.length;
    }

    public void setCapacity(int value) {
        if (value < this.e2) {
            ArrayList.p1("Capacity", (Object)value, "Must be more than count.");
        }
        this.p1 = value > 0 ? Arrays.copyOf(this.p1, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void p1(int n) {
        int n10;
        if (n <= this.p1.length) {
            return;
        }
        int n11 = n10 = this.p1.length == 0 ? 4 : this.p1.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void p1(int n, int n10) {
        if (n10 > 0) {
            if (this.e2 + n10 > this.p1.length) {
                int n11;
                int n12 = n11 = this.p1.length > 0 ? this.p1.length << 1 : 1;
                while (n11 < this.e2 + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.f1.p1(this.p1, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.f1.p1(this.p1, n, objectArray, n + n10, this.e2 - n);
                this.p1 = objectArray;
            } else {
                com.aspose.slides.ms.System.f1.p1(this.p1, n, this.p1, n + n10, this.e2 - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.f1.p1(this.p1, n13, this.p1, n, this.e2 - n13);
            com.aspose.slides.ms.System.f1.p1(this.p1, this.e2 + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.p1.length <= this.e2) {
            this.p1(this.e2 + 1);
        }
        this.p1[this.e2] = value;
        ++this.e9;
        return this.e2++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.f1.p1(this.p1, 0, this.e2);
        this.e2 = 0;
        ++this.e9;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.e2) > -1;
    }

    boolean p1(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.e2 - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.e2) {
            ArrayList.p1("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.p1("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.e2 - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.f1.p1(this.p1, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.e2 - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return p8.p1(this.p1, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.e2) {
            ArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.p1(index, 1);
        this.p1[index] = value;
        ++this.e2;
        ++this.e9;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.e2) {
            ArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.p1.length < this.e2 + n) {
                this.p1(this.e2 + n);
            }
            if (index < this.e2) {
                com.aspose.slides.ms.System.f1.p1(this.p1, index, this.p1, index + n, this.e2 - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.f1.p1(this.p1, 0, this.p1, index, index);
                com.aspose.slides.ms.System.f1.p1(this.p1, index + n, this.p1, index << 1, this.e2 - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.f1.p1(this.p1), index);
            }
            this.e2 += c.size();
            ++this.e9;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.e2) {
            ArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.p1.length < this.e2 + n) {
                this.p1(this.e2 + n);
            }
            if (index < this.e2) {
                com.aspose.slides.ms.System.f1.p1(this.p1, index, this.p1, index + n, this.e2 - index);
            }
            com.aspose.slides.ms.System.f1.p1(c).copyTo(com.aspose.slides.ms.System.f1.p1(this.p1), index);
            this.e2 += c.length;
            ++this.e9;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.e9;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.e2) {
            ArrayList.p1("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.p1(index, -1);
        --this.e2;
        ++this.e9;
    }

    public void removeRange(int index, int count) {
        ArrayList.p1(index, count, this.e2);
        this.p1(index, -count);
        this.e2 -= count;
        ++this.e9;
    }

    public void reverse() {
        p8.p1(this.p1, 0, this.e2);
        ++this.e9;
    }

    public void reverse(int index, int count) {
        ArrayList.p1(index, count, this.e2);
        p8.p1(this.p1, index, count);
        ++this.e9;
    }

    public void copyTo(f1 array) {
        com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1), 0, array, 0, this.e2);
    }

    @Override
    public void copyTo(f1 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.e2);
    }

    public void copyTo(int index, f1 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.f1() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.p1(index, count, this.e2);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.e2, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.e2, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return p8.p1(this.p1, 0, this.e2, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return p8.p1(this.p1, 0, this.e2, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return p8.p1(this.p1, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.p1(index, count, this.e2);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.e2) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.f1.p1(this.p1), index);
        ++this.e9;
    }

    public void trimToSize() {
        this.setCapacity(this.e2);
    }

    public void sort() {
        Arrays.sort(this.p1, 0, this.e2, Comparer.Default);
        ++this.e9;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.p1, 0, this.e2, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.p1(index, count, this.e2);
        Arrays.sort(this.p1, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.e2];
        this.copyTo(com.aspose.slides.ms.System.f1.p1(objectArray));
        return objectArray;
    }

    public f1 toArray(j0 type) {
        f1 f12 = com.aspose.slides.ms.System.f1.p1(type, this.e2);
        this.copyTo(f12);
        return f12;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.f1.p1(this.p1), 0, this.e2);
    }

    static void p1(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.p1("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.p1("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void p1(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.f1.p1(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.e2, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List p1;
        private int e2;

        @Override
        protected int getVersion() {
            return this.p1 instanceof ArrayList ? ((ArrayList)this.p1).getVersion() : this.e2;
        }

        public ArrayListInternalized(List internal) {
            this.p1 = internal;
            if (internal instanceof ArrayList) {
                this.e2 = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p1.set(index, value);
            ++this.e2;
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.p1.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.p1.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.p1.size(); ++i) {
                this.p1.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.p1.size();
            this.p1.add(value);
            ++this.e2;
            return n;
        }

        @Override
        public void clear() {
            this.p1.clear();
            ++this.e2;
        }

        @Override
        public boolean contains(Object item) {
            return this.p1.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.p1.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.p1.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.p1.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.p1.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.p1.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return p8.p1(this.p1.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.p1.add(index, value);
            ++this.e2;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.p1.add(index++, e);
            }
            ++this.e2;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.p1.add(index++, object);
            }
            ++this.e2;
        }

        @Override
        public void removeItem(Object obj) {
            this.p1.remove(obj);
            ++this.e2;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.p1.remove(index);
            ++this.e2;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.p1.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.p1.remove(index);
            }
            ++this.e2;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.p1.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.p1.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.p1.size() - 1; n < i; ++n, --i) {
                Object e = this.p1.get(n);
                this.p1.set(n, this.p1.get(i));
                this.p1.set(i, e);
            }
            ++this.e2;
        }

        @Override
        public void copyTo(f1 array) {
            com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1.toArray()), 0, array, 0, this.p1.size());
        }

        @Override
        public void copyTo(f1 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.p1.size());
        }

        @Override
        public void copyTo(int index, f1 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.f1() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.f1.p1(com.aspose.slides.ms.System.f1.p1(this.p1.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.p1(index, count, this.p1.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.p1.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return p8.p1(this.p1.toArray(), 0, this.p1.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return p8.p1(this.p1.toArray(), 0, this.p1.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return p8.p1(this.p1.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.p1(index, count, this.p1.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.p1.set(index++, e);
            }
            ++this.e2;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.p1, null);
            ++this.e2;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.p1, comparer);
            ++this.e2;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.p1.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.p1.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.p1.set(i, list.get(i - index));
            }
            ++this.e2;
        }

        @Override
        public Object[] toArray() {
            return this.p1.toArray();
        }

        @Override
        public f1 toArray(j0 type) {
            f1 f12 = com.aspose.slides.ms.System.f1.p1(type, this.p1.size());
            this.copyTo(f12);
            return f12;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.p1.size()];
            com.aspose.slides.ms.System.f1.p1(this.p1.toArray(), 0, objectArray, 0, this.p1.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.p1.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.p1.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.e2;
            return this.p1.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.e2;
            return this.p1.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.p1.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.e2;
            return this.p1.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.e2;
            return this.p1.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.e2;
            return this.p1.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.e2;
            return this.p1.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.p1.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.e2;
            return this.p1.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.p1.add(index, element);
            ++this.e2;
        }

        @Override
        public Object remove(int index) {
            ++this.e2;
            return this.p1.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.p1.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.p1.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.p1.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.p1 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.p1 != 0;
        }

        @Override
        public int nextIndex() {
            return this.p1;
        }

        @Override
        public int previousIndex() {
            return this.p1 - 1;
        }

        public Object previous() {
            int n = this.p1 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.p1;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p1 = n;
            this.e2 = n;
            return objectArray[this.e2];
        }

        public void set(Object e) {
            if (this.e2 < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).p1[this.e2] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.p1;
                ArrayList.this.add(n, e);
                this.p1 = n + 1;
                this.e2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int p1;
        int e2 = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.p1 != ArrayList.this.size();
        }

        public Object next() {
            int n = this.p1;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.p1;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.p1 = n + 1;
            this.e2 = n;
            return objectArray[this.e2];
        }

        @Override
        public void remove() {
            if (this.e2 < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.e2);
                this.p1 = this.e2;
                this.e2 = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @e0
    private static class ListWrapper
    implements IList {
        protected IList p1;

        public ListWrapper(IList innerList) {
            this.p1 = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p1.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.p1.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p1.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.p1.addItem(value);
        }

        @Override
        public void clear() {
            this.p1.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.p1.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p1.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p1.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.p1.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.p1.removeAt(index);
        }

        @Override
        public void copyTo(f1 array, int index) {
            this.p1.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.p1.iterator();
        }
    }

    @e0
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String p1() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.p1());
        }
    }

    @e0
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String p1() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.p1());
        }
    }

    @e0
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object e2;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.e2 = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.e2;
            synchronized (object) {
                this.p1.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array, int index) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.iterator();
            }
        }
    }

    @e0
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int e2;
        private int e9;
        private int f1;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.e2 = index;
            this.e9 = count;
            this.f1 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.e9) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.p1.get_Item(this.e2 + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.e9) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.p1.set_Item(this.e2 + index, value);
        }

        @Override
        public int size() {
            this.p1();
            return this.e9;
        }

        @Override
        public int getCapacity() {
            return this.p1.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.e9) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void p1() {
            if (this.f1 != this.p1.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.p1();
            this.p1.insertItem(this.e2 + this.e9, value);
            this.f1 = this.p1.getVersion();
            return ++this.e9;
        }

        @Override
        public void clear() {
            this.p1();
            this.p1.removeRange(this.e2, this.e9);
            this.e9 = 0;
            this.f1 = this.p1.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.p1.p1(value, this.e2, this.e9);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.e9 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.e9) {
                RangedArrayList.p1("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.p1("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.e9 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.p1.indexOf(value, this.e2 + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.e2;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.e9 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.p1("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.p1("count", (Object)count, "count is negative.");
            }
            if ((n = this.p1.lastIndexOf(value, this.e2 + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.e2;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p1();
            if (index < 0 || index > this.e9) {
                RangedArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p1.insertItem(this.e2 + index, value);
            ++this.e9;
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.p1();
            if (index < 0 || index > this.e9) {
                RangedArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p1.insertRange(this.e2 + index, c);
            this.e9 += c.size();
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.p1();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.p1();
            if (index < 0 || index > this.e9) {
                RangedArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p1.removeAt(this.e2 + index);
            --this.e9;
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.p1();
            RangedArrayList.p1(index, count, this.e9);
            this.p1.removeRange(this.e2 + index, count);
            this.e9 -= count;
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.e9);
        }

        @Override
        public void reverse(int index, int count) {
            this.p1();
            RangedArrayList.p1(index, count, this.e9);
            this.p1.reverse(this.e2 + index, count);
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.p1();
            if (index < 0 || index > this.e9) {
                RangedArrayList.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.p1.setRange(this.e2 + index, c);
            this.f1 = this.p1.getVersion();
        }

        @Override
        public void copyTo(f1 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(f1 array, int index) {
            this.copyTo(0, array, index, this.e9);
        }

        @Override
        public void copyTo(int index, f1 array, int arrayIndex, int count) {
            RangedArrayList.p1(index, count, this.e9);
            this.p1.copyTo(this.e2 + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.e9);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.p1(index, count, this.e9);
            return this.p1.iterator(this.e2 + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.p1();
            this.p1.insertRange(this.e9, c);
            this.e9 += c.size();
            this.f1 = this.p1.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.e9, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.e9, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.p1(index, count, this.e9);
            return this.p1.binarySearch(this.e2 + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.p1.deepClone(), this.e2, this.e9);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.p1(index, count, this.e9);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.e9, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.p1();
            RangedArrayList.p1(index, count, this.e9);
            this.p1.sort(this.e2 + index, count, comparer);
            this.f1 = this.p1.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.e9];
            this.p1.copyTo(this.e2, com.aspose.slides.ms.System.f1.p1(objectArray), 0, this.e9);
            return objectArray;
        }

        @Override
        public f1 toArray(j0 elementType) {
            f1 f12 = com.aspose.slides.ms.System.f1.p1(elementType, this.e9);
            this.p1.copyTo(this.e2, f12, 0, this.e9);
            return f12;
        }
    }

    @e0
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String p1() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.p1());
        }
    }

    @e0
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String p1() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.p1());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.p1());
        }
    }

    @e0
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object e2;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.e2 = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.e2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.e2;
            synchronized (object) {
                this.p1.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.e2;
            synchronized (object) {
                this.p1.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(f1 array, int index) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, f1 array, int arrayIndex, int count) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.e2;
            synchronized (object) {
                this.p1.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.e2;
            synchronized (object) {
                this.p1.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.e2;
            synchronized (object) {
                this.p1.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public f1 toArray(j0 elementType) {
            Object object = this.e2;
            synchronized (object) {
                return this.p1.toArray(elementType);
            }
        }
    }

    @e0
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList p1;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.p1 = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p1.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public int getCapacity() {
            return this.p1.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.p1.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.p1.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p1.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.p1.addItem(value);
        }

        @Override
        public void clear() {
            this.p1.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.p1.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p1.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.p1.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.p1.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.p1.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.p1.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.p1.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p1.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.p1.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.p1.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.p1.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.p1.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.p1.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.p1.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.p1.setRange(index, c);
        }

        @Override
        public void copyTo(f1 array) {
            this.p1.copyTo(array);
        }

        @Override
        public void copyTo(f1 array, int index) {
            this.p1.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, f1 array, int arrayIndex, int count) {
            this.p1.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.p1.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.p1.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.p1.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.p1.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.p1.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.p1.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.p1.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.p1.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.p1.trimToSize();
        }

        @Override
        public void sort() {
            this.p1.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.p1.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.p1.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.p1.toArray();
        }

        @Override
        public f1 toArray(j0 elementType) {
            return this.p1.toArray(elementType);
        }
    }

    @e0
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList p1;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.p1 = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.p1.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.p1.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.p1.size();
        }

        @Override
        public int getCapacity() {
            return this.p1.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.p1.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.p1.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.p1.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.p1.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.p1.addItem(value);
        }

        @Override
        public void clear() {
            this.p1.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.p1.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.p1.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.p1.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.p1.size()) {
                ArrayListAdapter.p1("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.p1("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.p1.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.p1.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.p1.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.p1.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.p1("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.p1("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.p1("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.p1.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.p1.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.p1.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.p1.size()) {
                ArrayListAdapter.p1("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.p1.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.p1.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.p1.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.p1(index, count, this.p1.size());
            for (int i = 0; i < count; ++i) {
                this.p1.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.p1.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.p1(index, count, this.p1.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.p1.get_Item(i + index);
                this.p1.set_Item(i + index, this.p1.get_Item(index + count - i + index - 1));
                this.p1.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.p1.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.p1.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(f1 array) {
            this.p1.copyTo(array, 0);
        }

        @Override
        public void copyTo(f1 array, int index) {
            this.p1.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, f1 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.p1("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.p1("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.p1("index", (Object)index, "Can't be less than zero.");
            }
            if (array.f1() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.d7() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.p1.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.e9(this.p1.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.p1.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.p1.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.p1(index, count, this.p1.size());
            return new EnumeratorWithRange(this.p1.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.p1.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.p1.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.p1(index, count, this.p1.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.p1.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.p1);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.p1(index, count, this.p1.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.p1.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.p1(index, count, this.p1.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.p1(this.p1, index, index + count - 1, comparer);
        }

        private static void p1(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void p1(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.p1(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.p1(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.p1(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.p1(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.p1(iList, n12, n13);
            }
            ArrayListAdapter.p1(iList, n10 - 1, n12);
            ArrayListAdapter.p1(iList, n, n12 - 1, comparator);
            ArrayListAdapter.p1(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.p1.size()];
            this.p1.copyTo(com.aspose.slides.ms.System.f1.p1(objectArray), 0);
            return objectArray;
        }

        @Override
        public f1 toArray(j0 elementType) {
            f1 f12 = com.aspose.slides.ms.System.f1.p1(elementType, this.p1.size());
            this.p1.copyTo(f12, 0);
            return f12;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        o3,
        Cloneable {
            private int p1;
            private int e2;
            private int e9;
            private IEnumerator f1;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.e2 = 0;
                this.p1 = index;
                this.e9 = count;
                this.f1 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.p1();
            }

            @Override
            public Object next() {
                return this.f1.next();
            }

            @Override
            public boolean hasNext() {
                if (this.e2 >= this.e9) {
                    return false;
                }
                ++this.e2;
                return this.f1.hasNext();
            }

            @Override
            public void reset() {
                this.e2 = 0;
                this.f1.reset();
                for (int i = 0; i < this.p1; ++i) {
                    this.f1.hasNext();
                }
            }

            protected Object p1() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.p1 = this.p1;
                enumeratorWithRange.e2 = this.e2;
                enumeratorWithRange.e9 = this.e9;
                enumeratorWithRange.f1 = this.f1;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    o3,
    Cloneable {
        private ArrayList e2;
        private Object e9;
        private int f1;
        private int d7;
        static Object p1 = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.e2 = list;
            this.f1 = -1;
            this.d7 = list.getVersion();
            this.e9 = p1;
        }

        @Override
        public Object deepClone() {
            return this.p1();
        }

        @Override
        public boolean hasNext() {
            if (this.d7 != this.e2.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.f1 < this.e2.size()) {
                this.e9 = this.e2.get_Item(this.f1);
                return true;
            }
            this.e9 = p1;
            return false;
        }

        @Override
        public Object next() {
            if (this.e9 == p1) {
                if (this.f1 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.e9;
        }

        @Override
        public void reset() {
            if (this.d7 != this.e2.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.e9 = p1;
            this.f1 = -1;
        }

        protected Object p1() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.e2 = this.e2;
            simpleEnumerator.e9 = this.e9;
            simpleEnumerator.f1 = this.f1;
            simpleEnumerator.d7 = this.d7;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    o3,
    Cloneable {
        private Object p1;
        private ArrayList e2;
        private int e9;
        private int f1;
        private int d7;
        private int m6;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.p1();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.e2 = list;
            this.f1 = index;
            this.d7 = count;
            this.e9 = this.f1 - 1;
            this.p1 = null;
            this.m6 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.e9 == this.f1 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.p1;
        }

        @Override
        public boolean hasNext() {
            if (this.e2.getVersion() != this.m6) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.e9;
            if (this.e9 - this.f1 < this.d7) {
                this.p1 = this.e2.get_Item(this.e9);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.p1 = null;
            this.e9 = this.f1 - 1;
        }

        protected Object p1() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.p1 = this.p1;
            arrayListEnumerator.e2 = this.e2;
            arrayListEnumerator.e9 = this.e9;
            arrayListEnumerator.f1 = this.f1;
            arrayListEnumerator.d7 = this.d7;
            arrayListEnumerator.m6 = this.m6;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

